from __future__ import nested_scopes
from javax.swing import *
from java.awt import *

import ut_modules
from posh_agent import *
from jarray import *

#import os
#import string

from MultiAgentInstanceFrame_POSH_UT import *
from board_frame import *

class Posh_UT_Pane(JPanel):
    "The Posh_UT_Pane of the initial GUI screen"
    
    def __init__(self):
	JFrame.__init__
	
	self.jComboBox = None
	self.jComboBox1 = None
	self.jTextField = None         # option name
	self.jTextField1 = None        # option text
	self.jButton = None            # load behavior
	self.jButton1 = None           # add option
	self.jButton2 = None           # start agent instance
	self.jButtonEditOption = None  # edit option		
	self.jButtonDelOption = None   # delete option
	self.jButtonShowOptions = None # show option

	self.optionsList = None
        self.behavior = None
    
        self.options = {}
    
        self.be_module = None

        self.multiAgentFrame = None
        
	self.initialize()
    	
    def initialize(self):
        self.init_pane()
	self.add_option("ip", "127.0.0.1")
	self.add_option("port", "3000")
	self.add_option("botname", "BODbot")
	self.add_option("agent_debug_file", "_logs/agent_debug.log")
        # self.add_option("gamebot_debug_file", "_logs/gb_debug.log") # I don't encourge you to use it as a default, because the file grows so fast
                                                                      # it can cause a problem

    def closing(self):
        if self.multiAgentFrame != None:
            self.multiAgentFrame.killAllAgents()    
        
    def load_behavior(self, event):
        
        try:
            global behavior
            modname = str(self.jComboBox.getSelectedItem())
            behavior = __import__("ut_modules."+modname, globals(), {}, modname)
	    self.behavior = behavior
            self.be_module = str(modname)

            self.jComboBox.setEnabled(0)
            self.jButton.setEnabled(0)

            plans = ut_modules.get_module_plans(modname) # plans = [(x,x) for x in plans]
            for x in plans:
                self.jComboBox1.addItem(x)

            self.jButton2.setEnabled(1)
        except:
            print "Error: Unable to load or start behavior"
            raise
        
        self.be_loaded = 1
        return	
	        
    def add_option(self, name, option):
        names = name.split()
        name = names[0]
        if self.options.has_key(name):
            return 0
        option_list = option.split()
        self.options[name] = option_list[0]
        self.optionsList.add(names[0] + " = " + option_list[0])
        return 1

    def del_option(self, name):

        if not self.options.has_key(name):
            return 0
        
        del self.options[name]
        for index in range(self.optionsList.getItemCount()):
            if name == (self.parse_option_string(self.optionsList.getItem(index)))["name"]:
                self.optionsList.remove(index)
                return 1            
        return 0

    def edit_option(self, name, option):
        self.del_option(self.get_name_from_option_list())
        return self.add_option(name, option)

    # returns dictionary with "name" / "value" ... in optionsList we stored options "name" = "value" (== 3 items)
    def parse_option_string(self, string):
        values = string.split()
        dict = {}
        if (len(values) > 0):
            dict["name"] = values[0]
        if (len(values) > 2):
            dict["value"] = values[2]
        return dict            

    # returns splited string (list) of the actual selected item in optionsList
    def get_values_from_option_list(self):
        index = self.optionsList.getSelectedIndex()
        if (index == -1):
            return []
        value = self.optionsList.getItem(index)
        return value.split()

    def get_name_from_option_list(self):
         values = self.get_values_from_option_list()
         if (len(values) > 0):
             return values[0]
         else:
             return ""            

    def get_value_from_option_list(self):
         values = self.get_values_from_option_list()
         if (len(values) > 1):
             return values[2]
         else:
             return ""

    def multiAgentFrameClosed(self):
        self.multiAgentFrame = None

    def start_agent(self, event = None):

        if self.multiAgentFrame == None:
            self.multiAgentFrame = MultiAgentInstanceFrame_POSH_UT()
            self.multiAgentFrame.setVisible(1)

	agent = Agent() # creating the agent ... posh_agent.py ... contains whole Action Selection Engine (ASE) as well as posh_plan parser
	
	self.multiAgentFrame.add_new_agent_instance(agent, self.options, self.jComboBox1.getSelectedItem(), self.be_module, self.behavior )
	self.multiAgentFrame.setVisible(1)
	self.multiAgentFrame.toFront()

    def init_pane(self):
        self.jLabel = JLabel()
        self.jLabel1 = JLabel()
        self.jLabel2 = JLabel()
        self.jLabel3 = JLabel()
        self.jLabel4 = JLabel()
        self.setLayout(None)
        self.jLabel.setText("Select Behaviour Library")
        self.jLabel.setLocation(20, 0)
        self.jLabel.setSize(300, 20)
        self.jLabel1.setText("Select Plan File")
        self.jLabel1.setLocation(20, 80)
        self.jLabel1.setSize(300, 20)
        self.jLabel2.setText("Option Name")
        self.jLabel2.setLocation(20, 140)
        self.jLabel2.setSize(180, 20)
        self.jLabel3.setText("Value")
        self.jLabel3.setLocation(20, 180)
        self.jLabel3.setSize(180, 20)
        self.jLabel4.setText("Options:")
        self.jLabel4.setLocation(20, 220)
        self.jLabel4.setSize(180, 20)            
        self.add(self.jLabel, None);
        self.add(self.getJComboBox(), None);
        self.add(self.getJButton(), None);
        self.add(self.jLabel1, None);
        self.add(self.getJComboBox1(), None);
        self.add(self.jLabel2, None);
        self.add(self.jLabel3, None);
        self.add(self.jLabel4, None);            
        self.add(self.getJTextField(), None);
        self.add(self.getJTextField1(), None);
        self.add(self.getJButton1(), None);
        self.add(self.getJButtonDelOption(), None);
        self.add(self.getJButtonEditOption(), None);
        self.add(self.getJButtonShowOptions(), None);
        self.add(self.getJButton2(), None);
        self.add(self.getOptionsList(), None);
    
    def getJComboBox(self):
	if (self.jComboBox == None):
		self.jComboBox = JComboBox()
		self.jComboBox.setLocation(20, 20)
		self.jComboBox.setSize(300, 20)
		for m in ut_modules.get_module_list():
                    self.jComboBox.addItem(m)
	
	return self.jComboBox
	

    def getJButton(self):
	if (self.jButton == None):
		self.jButton =  JButton()
		self.jButton.setText("Load Behaviour")
		self.jButton.setActionCommand("")
		self.jButton.setLocation(20, 40)
		self.jButton.setSize(300, 20)
		self.jButton.actionPerformed = self.load_behavior
	
	return self.jButton
	
	
    def getJComboBox1(self):
	if (self.jComboBox1 == None):
		self.jComboBox1 = JComboBox()
		self.jComboBox1.setLocation(20, 100)
		self.jComboBox1.setSize(300, 20)
	
	return self.jComboBox1
	
    def getJTextField(self):
	if (self.jTextField == None):
		self.jTextField =  JTextField()
		self.jTextField.setLocation(20, 160)
		self.jTextField.setSize(180, 20)
	
	return self.jTextField

    def getJTextField1(self):
	if (self.jTextField1 == None):
		self.jTextField1 =  JTextField()
		self.jTextField1.setLocation(20, 200)
		self.jTextField1.setSize(180, 20)

	return self.jTextField1

	
    def getJButton1(self):
	if (self.jButton1 == None):
		self.jButton1 =  JButton()
		self.jButton1.setBounds(210, 145, 111, 20)
		self.jButton1.setText("Add Option")
		
                def add_option(event):
		    name = self.jTextField.getText()
		    option = self.jTextField1.getText()
		    if (name != "") and (option != ""):
                        names = name.split()
                        name = names[0]
                        option_list = option.split()
                        option = option_list[0]
                        self.add_option(name, option)

	
                self.jButton1.actionPerformed = add_option
		
	return self.jButton1

    def getJButtonEditOption(self):
	if (self.jButtonEditOption == None):
		self.jButtonEditOption = JButton()
		self.jButtonEditOption.setBounds(210, 165, 111, 20)
		self.jButtonEditOption.setText("Edit Option")

                def edit_opt(event):
                    name = self.jTextField.getText()
		    option = self.jTextField1.getText()
		    if (name != "") and (option != ""):
                        names = name.split()
                        name = names[0]
                        option_list = option.split()
                        option = option_list[0]
                        self.edit_option(name, option)                                            
		
		self.jButtonEditOption.actionPerformed = edit_opt
	
	return self.jButtonEditOption

    def getJButtonDelOption(self):
	if (self.jButtonDelOption == None):
		self.jButtonDelOption = JButton()
		self.jButtonDelOption.setBounds(210, 185, 111, 20)
		self.jButtonDelOption.setText("Delete Option")

                def del_opt(event):
                    index = self.optionsList.getSelectedIndex()
                    if index == -1:
                        return
                    self.del_option( (self.parse_option_string(self.optionsList.getItem(index)))["name"] )                    
		
		self.jButtonDelOption.actionPerformed = del_opt
	
	return self.jButtonDelOption

    def getJButtonShowOptions(self):
	if (self.jButtonShowOptions == None):
		self.jButtonShowOptions = JButton()
		self.jButtonShowOptions.setBounds(210, 205, 111, 20)
		self.jButtonShowOptions.setText("Show Options")

                def show_opt(event):
                    board = BoardFrame("Agent options:",
                                       "Options' names are Case-Sensitive!\n"
                                       "Option name - explanation\n\n"+
                                       "ip - IP adress of the GameBot server\n"+
                                       "port - port of the GameBot server\n"+
                                       "botname - should set the name of the bot in UT, don't work for now, working on it ;)\n"+
                                       "gamebot_debug_file - if specified, whole communication with GameBot will be loged to a file, value of this option is a filename\n"+
                                       "\t           Beware, this file grows fast, 1 minute can mean 1 MB\n"+
                                       "agent_debug_file - if specified, debug messages will be loged to a file, value of this option is a filename\n"+
                                       "\t           NOTE 1: to the filename will be added strng '_' + number of the agent\n")
                    board.initialize(700, 200)
                    board.setVisible(1)
		
		self.jButtonShowOptions.actionPerformed = show_opt
	
	return self.jButtonShowOptions
	
    def getJButton2(self):
	if (self.jButton2 == None):
		self.jButton2 =  JButton()
		self.jButton2.setLocation(20, 340)
		self.jButton2.setSize(300, 40)
		self.jButton2.setText("Start New Agent Instance")
		self.jButton2.setEnabled(0)
		self.jButton2.actionPerformed=self.start_agent
	
	return self.jButton2
		
    def getOptionsList(self):
	if (self.optionsList == None):
            self.optionsList = List()
            self.optionsList.setLocation(20, 240)
            self.optionsList.setSize(300, 80)

            def selection_changed(event):
                values = self.get_values_from_option_list()
                self.jTextField.setText(values[0])
                self.jTextField1.setText(values[2])                        

            
            self.optionsList.itemStateChanged = selection_changed

	return self.optionsList
