from __future__ import nested_scopes
from javax.swing import *
from java.awt import *
from java import *

class MyJToggleButton(JToggleButton):

    def __init__(self):
        self.my_width = 50
        self.my_height = 20

    def getPreferredSize(self):
        return Dimension(self.my_width,self.my_height)

    def setMySize(self, width, height):
        self.my_width = width
        self.my_height = height

class MyJLabel(JLabel):

    def __init__(self):
        self.my_width = 50
        self.my_height = 20

    def getPreferredSize(self):
        return Dimension(self.my_width,self.my_height)

    def setMySize(self, width, height):
        self.my_width = width
        self.my_height = height

class MyJScrollPane(JScrollPane):

    def __init__(self):
        self.my_width = 100
        self.my_height = 100

    def getPreferredSize(self):
        return Dimension(self.my_width,self.my_height)

    def setMySize(self, width, height):
        self.my_width = width
        self.my_height = height
        
class GameBotMonitor:

    def __init__(self):

        # these are cmds which can be reveived from GameBot Server
        self.existing_msg = ["ALIVE", "CMD", "ATR", "PLS", "TES", "BEG", "SLF", "GAM", "PLR", "NAV", "MOV", "DOM", "FLG", "IPK","INV", "END", "NFO", "AIN", "VMS", "VMT", "VMG",
                             "ZCF", "ZCH", "ZCB", "CWP", "WAL", "FAL", "BMP", "HRP", "HRN", "SEE", "PRJ", "KIL", "DIE", "DAM", "HIT", "PTH",
                             "RCH", "FIN", "PONG"]
        self.existing_msg.sort()

        # these are cmds which can be sent to GameBot Server
        self.existing_cmd = ["INIT", "CMOVE", "RESPAWN","STOP", "JUMP", "RUNTO", "STRAFE", "TURNTO", "ROTATE", "SHOOT", "CHANGEWEAPON", "STOPSHOOT", "GETPATH", "MESSAGE", "PING"]
        self.existing_cmd.sort()

        self.msg_on = {}
        self.cmd_on = {}

        self.bot = None

        self.x = 0
        self.y = 0
        self.width = 0

        self.L_gb_msg = None  # Label for msgs
        self.L_gb_cmd = None  # Label for cmds
        self.JTA_gb_log = None # JTextArea for log for GameBot
        self.JSP_gb_log = None # JScrollPane for log for GameBot
        
        self.msg_buttons = {} # dictionary for existing msg buttons ... keys are self.existing_msg
        self.cmd_buttons = {} # dictionary for existing cmd buttons ... keys are self.existing_cmd

        self.quiet = 0 # if true ... no output is written

        self.caret_pos = 0


    # bot is reference to Bot_Agent
    # creating new monitor on existing frame (jAdd ... something, which can add Swing objects) at x, y with widht, height
    # cmd_off / cmd_off are sequences which specify which cmd / cmd should not be reported
    def initialize(self, jAdd, x, y, width, msg_off = ["BEG", "END", "SLF", "GAM", "INV", "SEE", "PLR", "ATR", "MOV", "PLS", "TES", "FLG","NAV", "PONG"], cmd_off = ["PING"]):

        self.x = x
        self.y = y
        self.width = width

        # MSG
        self.JL_gb_msg = MyJLabel()
        self.JL_gb_msg.setLocation(x, y)
        self.JL_gb_msg.setMySize(width, 14)
        self.JL_gb_msg.setSize(width, 14)        
        self.JL_gb_msg.setText("Received GameBot messages:")
        jAdd.add(self.JL_gb_msg)
        
        y += 15

        add_x = 38    
        
        tempx = x-add_x
        for a in self.existing_msg:
            self.msg_on[a] = 1
            
            if tempx + add_x + add_x - x > width:
                tempx = x - add_x
                y += 14

            tempx += add_x

            button = MyJToggleButton()
            button.setText(a)
            button.setSelected(not (a in msg_off) )
            button.setMargin( Insets(0, 0, 0, 0) )
            button.setFont(button.getFont().deriveFont( 9.0 ) )
            button.setMySize(add_x-1, 14)
            button.setSize(add_x-1, 14)
            
            button.setLocation(tempx, y)
            self.msg_buttons[a] = button
            button.actionPerformed = self.button_pressed_msg
            jAdd.add(button)

        y += 15    

        for a in msg_off:
            self.msg_on[a] = 0

        # CMD
        self.JL_gb_cmd = JLabel()
        self.JL_gb_cmd.setSize(width, 14)
        self.JL_gb_cmd.setText("Sent commands to GameBot:")
        self.JL_gb_cmd.setLocation(x, y)
        jAdd.add(self.JL_gb_cmd)
        
        y += 15

        add_x = 49
        
        tempx = x-add_x
        for a in self.existing_cmd:
            self.cmd_on[a] = 1
            
            if tempx + add_x + add_x - x > width:
                tempx = x-add_x
                y += 14

            tempx += add_x
 
            button = MyJToggleButton()
            button.setText(a)
            button.setSelected(not (a in cmd_off))
            button.setMargin( Insets(0, 0, 0, 0) )
            button.setFont(button.getFont().deriveFont( 9.0 ) )
            button.setMySize(add_x-1, 14)
            button.setSize(add_x-1, 14)            
            button.setLocation(tempx, y)

            self.cmd_buttons[a] = button
            button.actionPerformed = self.button_pressed_cmd
            jAdd.add(button)


        for a in cmd_off:
            self.cmd_on[a] = 0

        y += 15    

        self.JTA_gb_log = JTextArea()
        self.JTA_gb_log.setFont(self.JTA_gb_log.getFont().deriveFont(10.0))        
        self.JSP_gb_log = JScrollPane()
        self.JSP_gb_log.setViewportView(self.JTA_gb_log)
        self.JSP_gb_log.setSize(self.width, 124)
        self.JSP_gb_log.setLocation(x, y)
        jAdd.add(self.JSP_gb_log)

    # MSG handling methods

    def is_msg_on(self, msg):
        if not self.msg_on.has_key(msg):
            return 0
        return self.msg_on[msg]

    def disable_msg(self, msg):
        self.msg_on[msg] = 0

    def enable_msg(self, msg):
        self.msg_on[msg] = 1

    def button_pressed_msg(self, event):
        msg = event.getSource().getText()
        if not msg in self.existing_msg:
            return
        if self.is_msg_on(msg):
            self.disable_msg(msg)
        else:
            self.enable_msg(msg)

    # CMD handling methods

    def is_cmd_on(self, cmd):
        if not self.cmd_on.has_key(cmd):
            return 0
        return self.cmd_on[cmd]

    def disable_cmd(self, cmd):
        self.cmd_on[cmd] = 0


    def enable_cmd(self, cmd):
        self.cmd_on[cmd] = 1

    def button_pressed_cmd(self, event):
        cmd = event.getSource().getText()
        if not cmd in self.existing_cmd:
            return
        if self.is_cmd_on(cmd):
            self.disable_cmd(cmd)
        else:
            self.enable_cmd(cmd)

    # routines for adding new msgs
    # variables ... type_of_msg == "received" or "sent", msg == type of command (received / send), string == full message / command

    def new_msg(self, type_of_msg, cmd, string):
        
        if self.quiet:
            return

        if type_of_msg == "received":
            if self.is_msg_on(cmd) or not cmd in self.existing_msg:
                string = "<- " + string
                self.JTA_gb_log.append(string)
                self.caret_pos += len(string)
                self.JTA_gb_log.setCaretPosition(self.caret_pos)
        else:
            if self.is_cmd_on(cmd) or not cmd in self.existing_cmd:
                string = "-> " + string
                self.JTA_gb_log.append(string)
                self.caret_pos += len(string)
                self.JTA_gb_log.setCaretPosition(self.caret_pos)
            
