from __future__ import nested_scopes
from javax.swing import *
from java.awt import *
from java import *

import thread
import time

from board_frame import *
from utils.unreal_utils import *
        
class BotControl:

    def __init__(self): 

        self.bot = None

        self.x = 0 # where BC is drawn
        self.y = 0

        self.lblBotStatus = None
        self.lblBotName = None
        self.lblLocation = None
        self.lblRotation = None
        self.lblVelocity = None
        self.lblTeam = None
        self.lblHealth = None
        self.lblCurrWeapon = None
        self.lblCurrAmmo = None
        self.lblArmor = None

        self.teams = { "-1": "Unknown", "0": "Red", "1": "Blue", "2": "Green", "3": "Gold", "255":"None" } # num -> readable name

        self.lblBotQuery = None
        self.jtfBotQuery = None
        self.btnBotQuery = None
        self.btnBotQueryHelp = None
        self.btnBotQueryClear = None

        self.jtaBotQueryResults = None # result from exec commands ... performed on self.bot
        self.queryCaretPosition = 0
        self.jspBotQueryResults = None

        # this is configuration dictionary ... key is a command, value is a sequence of parametrs
        self.commands = { "ACT": ["Name", "List0", "List1", "List2", "List3", "List4", "List5", "List6", "List7"],
                          "ADDRAY": ["Id", "Direction", "Length", "FastTrace", "TraceActors", "FloorCorrection"],
                          "INIT": ["Name", "AutoTrace","Team", "Location","Rotation","Skill","ClassName","Skin"],  
                          "RESPAWN": ["StartLocation","StartRotation"],                 
                          "ADDINV": ["Type"], 
                          "CONF": ["AutoTrace","ShowFocalPoint","DrawTraceLines","Invulnerable","Name","ShowDebug","VisionTime"],
                          "DODGE": ["Direction"],
                          "JUMP": ["DoubleJump"],  
                          "MOVE": ["FocusTarget","FirstLocation", "SecondLocation","FocusLocation"],
                          "DRIVETO": ["Target"], 
                          "TURNTO": ["Rotation", "Location","Target"], 
                          "SHOOT": ["Target","Location", "Alt"],
                          "CHANGEWEAPON": ["Id"],      
                          "STOPSHOOT": (),
			"SPAWNACTOR":["Type","Location","Rotation"],        
                          "GETPATH": ("Id", "Location"),    
                          "MESSAGE": ["Id","Text", "Global","FadeOut"] }

        self.lblCommands = None

        # dictionary where objects of each command will be saved ... [command_name_string][lbl_ / jtf_ parametr_name_string] -> object,
        # special parametr "button" for button and "label" for label
        self.objects = {} # filled in self.initialize()

        self.active_command = None

        self.btnSendCommand = None

        self.btnGo = None
        self.btnBack = None
        self.btnTurnLeft = None
        self.btnTurnRight = None

        # has thread which scans self.bot for information
        self.thread_id = 0
        self.thread_active = 0
        self.thread_exec = 0 # set to false -> close thread

        


    # bot is reference to Bot_Agent
    # creating new monitor on existing frame (jAdd ... something, which can add Swing objects) at x, y with widht, height
    # cmd_off / cmd_off are sequences which specify which cmd / cmd should not be reported
    def initialize(self, jAdd, x, y):

        self.x = x
        self.y = y

        label_width = 200

        self.lblBotStatus = JLabel()
        self.lblBotStatus.setText("--- Bot's status ---")
        self.lblBotStatus.setSize(label_width, 19)
        self.lblBotStatus.setLocation(x, y)
        y += 20
        jAdd.add(self.lblBotStatus)

        label_length = 40
        self.lblBotIdLabel = JLabel()
        self.lblBotIdLabel.setText("Bot Id:")
        self.lblBotIdLabel.setSize(label_length, 19)
        self.lblBotIdLabel.setLocation(x, y)
        jAdd.add(self.lblBotIdLabel)
        
        self.lblBotId = JTextField()
        self.lblBotId.setText("")
        self.lblBotId.setSize(label_width - label_length, 19)
        self.lblBotId.setLocation(x + label_length, y)
        y += 20
        jAdd.add(self.lblBotId)

        self.lblBotName = JLabel()
        self.lblBotName.setText("Bot name:")
        self.lblBotName.setSize(label_width, 19)
        self.lblBotName.setLocation(x, y)
        y += 20
        jAdd.add(self.lblBotName)


        label_length = 60
        self.lblLocationLabel = JLabel()
        self.lblLocationLabel.setText("Location:")
        self.lblLocationLabel.setSize(label_length, 19)
        self.lblLocationLabel.setLocation(x, y)
        jAdd.add(self.lblLocationLabel)
        
        self.lblLocation = JTextField()
        self.lblLocation.setText("")
        self.lblLocation.setSize(label_width - label_length, 19)
        self.lblLocation.setLocation(x + label_length, y)
        #self.lblLocation.setEnabled(0)
        y += 20
        jAdd.add(self.lblLocation)

               

        label_length = 60
        self.lblRotationLabel = JLabel()
        self.lblRotationLabel.setText("Rotation:")
        self.lblRotationLabel.setSize(label_length, 19)
        self.lblRotationLabel.setLocation(x, y)
        jAdd.add(self.lblRotationLabel)

        self.lblRotation = JTextField()
        self.lblRotation.setText("")
        self.lblRotation.setSize(label_width - label_length, 19)
        self.lblRotation.setLocation(x + label_length, y)
        y += 20
        jAdd.add(self.lblRotation)
        
        label_length = 60
        self.lblVelocityLabel = JLabel()
        self.lblVelocityLabel.setText("Velocity:")
        self.lblVelocityLabel.setSize(label_length, 19)
        self.lblVelocityLabel.setLocation(x, y)
        jAdd.add(self.lblVelocityLabel)        
        
        self.lblVelocity = JTextField()
        self.lblVelocity.setText("")
        self.lblVelocity.setSize(label_width - label_length, 19)
        self.lblVelocity.setLocation(x + label_length, y)
        y += 20
        jAdd.add(self.lblVelocity)

        self.lblTeam = JLabel()
        self.lblTeam.setText("Team:")
        self.lblTeam.setSize(label_width, 19)
        self.lblTeam.setLocation(x, y)
        y += 20
        jAdd.add(self.lblTeam)

        self.lblHealth = JLabel()
        self.lblHealth.setText("Health:")
        self.lblHealth.setSize(label_width, 19)
        self.lblHealth.setLocation(x, y)
        y += 20
        jAdd.add(self.lblHealth)

        label_length = 55
        self.lblWeaponLabel = JLabel()
        self.lblWeaponLabel.setText("Weapon:")
        self.lblWeaponLabel.setSize(label_length, 19)
        self.lblWeaponLabel.setLocation(x, y)
        jAdd.add(self.lblWeaponLabel) 

        self.lblCurrWeapon = JTextField()
        self.lblCurrWeapon.setText("")
        self.lblCurrWeapon.setSize(label_width - label_length, 19)
        self.lblCurrWeapon.setLocation(x + label_length, y)
        y += 20
        jAdd.add(self.lblCurrWeapon)

        self.lblCurrAmmo = JLabel()
        self.lblCurrAmmo.setText("Ammo:")
        self.lblCurrAmmo.setSize(label_width, 19)
        self.lblCurrAmmo.setLocation(x, y)
        y += 20
        jAdd.add(self.lblCurrAmmo)

        self.lblArmor = JLabel()
        self.lblArmor.setText("Armor:")
        self.lblArmor.setSize(label_width, 19)
        self.lblArmor.setLocation(x, y)
        y += 20
        jAdd.add(self.lblArmor)
        
        self.lblAdrenaline = JLabel()
        self.lblAdrenaline.setText("Adrenaline:")
        self.lblAdrenaline.setSize(label_width, 19)
        self.lblAdrenaline.setLocation(x, y)
        y += 20
        jAdd.add(self.lblAdrenaline)

        x = self.x + label_width + 5
        y = self.y        
        
        # next column

        label_width_2 = 40
        width_2 = 260

        self.lblBotQuery = JLabel()
        self.lblBotQuery.setText("Query:")
        self.lblBotQuery.setSize(label_width_2, 19)
        self.lblBotQuery.setLocation(x, y)
        x += label_width_2 + 5       
        jAdd.add(self.lblBotQuery)
        
        self.jtfBotQuery = JTextField()
        self.jtfBotQuery.setFont(self.jtfBotQuery.getFont().deriveFont( 9.5 ))
        self.jtfBotQuery.setSize(width_2 - 5 - label_width_2, 19)
        self.jtfBotQuery.setLocation(x, y)
        jAdd.add(self.jtfBotQuery)
        x = self.x + label_width + 5
        y += 20
        
        self.btnBotQuery = self.initBtnBotQuery(x, y, int(width_2 / 3)-2)
        x += int(width_2 / 3) - 2 + 4
        jAdd.add(self.btnBotQuery)

        self.btnBotQueryClear = self.initBtnBotQueryClear(x, y, int(width_2 / 3)-2)
        x += int(width_2 / 3) - 2 + 4
        jAdd.add(self.btnBotQueryClear)

        self.btnBotQueryHelp = self.initBtnBotQueryHelp(x, y, int(width_2 / 3)-2)
        x += int(width_2 / 3) - 2 + 4
        jAdd.add(self.btnBotQueryHelp)



        x = self.x + label_width + 5
        y += 20


        self.jtaBotQueryResults = self.initJtaBotQueryResults()
        self.jspBotQueryResults = self.initJspBotQueryResults(x, y, width_2)
        jAdd.add(self.jspBotQueryResults)


        x_start = x + 10       
        y_start = y + 60
        width_4 = 200
        b_width = int((width_4 - 20 - 10) / 3)
        
        self.btnGo = self.initBtnGo( x_start + b_width + 2, y_start, b_width, 30)
        self.btnRun = self.initBtnRun( x_start, y_start, b_width, 30)
        self.btnJump = self.initBtnJump( x_start + b_width + 2 + b_width + 2, y_start, b_width, 30)
        self.btnStop = self.initBtnStop( x_start + b_width + 2, y_start + 32, b_width, 30)
        self.btnBack = self.initBtnBack( x_start + b_width + 2, y_start + 32 + 32, b_width, 30)
        self.btnTurnLeft = self.initBtnTurnLeft( x_start, y_start + 32 + 32, b_width, 30)
        self.btnTurnRight = self.initBtnTurnRight( x_start + b_width + 2 + b_width + 2, y_start + 32 + 32, b_width, 30)
        self.btnStrafeLeft = self.initBtnStrafeLeft( x_start, y_start + 32, b_width, 30)
        self.btnStrafeRight = self.initBtnStrafeRight( x_start + b_width + 2 + b_width + 2, y_start + 32, b_width, 30)        

        jAdd.add(self.btnGo)
        jAdd.add(self.btnRun)
        jAdd.add(self.btnJump)
        jAdd.add(self.btnStop)
        jAdd.add(self.btnBack)
        jAdd.add(self.btnTurnLeft)
        jAdd.add(self.btnTurnRight)
        jAdd.add(self.btnStrafeLeft)
        jAdd.add(self.btnStrafeRight)
        
        x = self.x + label_width + 5 + width_2 + 5
        y = self.y

        # next column

        width_3 = 80 # command buttons width 

        self.lblCommands = JLabel()
        self.lblCommands.setText("Commands:")
        self.lblCommands.setSize(width_3, 19)
        self.lblCommands.setLocation(x, y)
        y += 20
        jAdd.add(self.lblCommands)

        
        
        label_width_4 = 60
        cmd_keys = self.commands.keys()
        cmd_keys.sort()
        for cmd in cmd_keys:
            x_2 = x + width_3 + 5
            y_2 = self.y

            self.objects[cmd] = {} # creating 
            self.objects[cmd]["button"] = self.initButton(cmd, x, y, width_3, 13)
            y += 15
            jAdd.add(self.objects[cmd]["button"])

            self.objects[cmd]["label"] = JLabel()
            self.objects[cmd]["label"].setText("Command " + cmd)
            self.objects[cmd]["label"].setSize(width_4, 19)
            self.objects[cmd]["label"].setLocation(x_2, y_2)
            self.objects[cmd]["label"].setVisible(0)
            jAdd.add(self.objects[cmd]["label"])
            y_2 += 20

            for param in self.commands[cmd]:
                self.objects[cmd]["lbl_"+param] = JLabel()
                self.objects[cmd]["lbl_"+param].setText(param + ":")
                self.objects[cmd]["lbl_"+param].setSize(label_width_4, 19)
                self.objects[cmd]["lbl_"+param].setLocation(x_2, y_2)
                self.objects[cmd]["lbl_"+param].setVisible(0)
                jAdd.add(self.objects[cmd]["lbl_"+param])

                self.objects[cmd]["jtf_"+param] = JTextField()
                self.objects[cmd]["jtf_"+param].setText(param + ":")
                self.objects[cmd]["jtf_"+param].setSize(width_4 - 5 - label_width_4, 19)
                self.objects[cmd]["jtf_"+param].setLocation(x_2 + 5 + label_width_4, y_2)
                self.objects[cmd]["jtf_"+param].setVisible(0)
                self.objects[cmd]["jtf_"+param].setEnabled(0)
                jAdd.add(self.objects[cmd]["jtf_"+param])


                y_2 += 20

            self.objects[cmd]["button_send"] = self.initBtnSendCommand(x + width_3 + 5, y_2)
            jAdd.add(self.objects[cmd]["button_send"])

        

 

        self.thread_id = thread.start_new_thread( self.bot_status_monitor, () )

    def bot_status_monitor(self):

        self.thread_active = 1
        self.thread_exec = 1

        while self.thread_exec:
            if self.bot == None:
                time.sleep(1)
            else:
                self.lblBotId.setText(str(self.bot.get_bot_id()))
                self.lblBotName.setText("Bot name: " + str(self.bot.get_bot_name()))
                loc = self.bot.get_bot_location_tuple()
                location = str(int(loc[0]))+", "+str(int(loc[1]))+", "+str(int(loc[2]))
                self.lblLocation.setText(location)
                rotation = self.bot.get_bot_rotation_tuple()
                rot = []
                for a in rotation:
                    angle = ut_angle_to_angle(a)
                    rot.append( str(int(angle)) )
                self.lblRotation.setText( str(rotation_tuple_to_string(rot)) )
                vel = location_string_to_tuple(self.bot.get_bot_velocity())
                velocity = str(int(vel[0]))+", "+str(int(vel[1]))+", "+str(int(vel[2]))
                self.lblVelocity.setText( velocity )
                self.lblTeam.setText("Team: " + self.bot.get_bot_team())
                self.lblHealth.setText("Health: " + str(self.bot.get_bot_health()) )
                self.lblCurrWeapon.setText( str(self.bot.get_bot_current_weapon()) )
                self.lblCurrAmmo.setText("Ammo: " + str(self.bot.get_bot_current_ammo()) + " / " + str(self.bot.get_bot_current_alt_ammo()) )
                self.lblArmor.setText("Armor: " + str(self.bot.get_bot_armor()) )
                self.lblAdrenaline.setText("Adrenaline: " + str(self.bot.get_bot_adrenaline()) )
                time.sleep(0.3)

        self.thread_active = 0
        self.thread_id = 0

    def close_thread(self):
        self.thread_exec = 0

    def addToQueryTextArea(self, string):
        self.jtaBotQueryResults.append(string+"\n")
        self.queryCaretPosition += len(string)+1
        self.jtaBotQueryResults.setCaretPosition(self.queryCaretPosition)

    def botQueryAction(self, event):
        if self.bot == None:
            return
        
        text = self.jtfBotQuery.getText()
        command = "result = self.bot." + text
        self.addToQueryTextArea("Executing: " + command)

        try:
            exec(command)
        except Exception, error:
            self.addToQueryTextArea("Execute error." )
        else:
            self.addToQueryTextArea("Result:")
            self.addToQueryTextArea(str(result))
            
    def initBtnBotQuery(self, x, y, width):
        self.btnBotQuery = JButton()
        self.btnBotQuery.setSize(width, 20)
        self.btnBotQuery.setLocation(x, y)
        self.btnBotQuery.setText("Exec")
        self.btnBotQuery.actionPerformed = self.botQueryAction
        return self.btnBotQuery

    def botQueryClearAction(self, event):
        self.jtaBotQueryResults.setText("")
        self.queryCaretPosition = 0

    def initBtnBotQueryClear(self, x, y, width):
        self.btnBotQueryClear = JButton()
        self.btnBotQueryClear.setSize(width, 20)
        self.btnBotQueryClear.setLocation(x, y)
        self.btnBotQueryClear.setText("Clear")
        self.btnBotQueryClear.actionPerformed = self.botQueryClearAction        
        return self.btnBotQueryClear

    def initBtnBotQueryHelp(self, x, y, width):
        self.btnBotQueryHelp = JButton()
        self.btnBotQueryHelp.setSize(width, 20)
        self.btnBotQueryHelp.setLocation(x, y)
        self.btnBotQueryHelp.setText("Help")

        def botQueryHelpAction(eveny):
            board = BoardFrame("Bot Query Help", "Allows you to query instance of Bot class.\nString you type will be executed this way:\n"+
                                                 "exec( 'self.bot.string_you_provide' )\nResults will be printed to the box.\n"+
                                                 "See bot.py for useful get_xxx commands.")
            board.initialize(300, 200)
            board.setVisible(1)

        self.btnBotQueryHelp.actionPerformed = botQueryHelpAction
        return self.btnBotQueryHelp

    def initJtaBotQueryResults(self):
        self.jtaBotQueryResults = JTextArea()
        self.jtaBotQueryResults.setFont(self.jtaBotQueryResults.getFont().deriveFont(10.0))

        return self.jtaBotQueryResults

    def initJspBotQueryResults(self, x, y, width):
        self.jspBotQueryResults = JScrollPane()
        self.jspBotQueryResults.setViewportView(self.jtaBotQueryResults)
        self.jspBotQueryResults.setSize(width, 50)
        self.jspBotQueryResults.setLocation(x, y)
        return self.jspBotQueryResults

    def buttonAction(self, command, event):
        if self.active_command != None:
            self.objects[self.active_command]["button"].setSelected(0)
            for a in self.objects[self.active_command].keys():
                if a != "button":
                    self.objects[self.active_command][a].setVisible(0)
                    if isinstance(self.objects[self.active_command][a], JTextField):
                        self.objects[self.active_command][a].setEnabled(0)

        self.active_command = command
        for a in self.objects[command].keys():
            self.objects[command][a].setVisible(1)
            self.objects[command][a].setEnabled(1)
            if isinstance(self.objects[command][a], JTextField):
                self.objects[command][a].setText("")
                
                
    def initButton(self, cmd, x, y, width, height):
        button = JToggleButton()
        button.setText(cmd)
        button.setSize(width, height)
        button.setLocation(x, y)
        button.setFont(button.getFont().deriveFont(10.0))
        button.setMargin( Insets(0, 0, 0, 0) )        
        button.actionPerformed = lambda event: self.buttonAction(cmd, event)

        return button

    def sendCommandAction(self, event):
        cmd = self.active_command

        options = {}
        for option in self.commands[cmd]:
            value = self.objects[cmd]["jtf_"+option].getText()
            if value != "":
                options[option] = value
                
        self.bot.send_message(cmd, options)   

    def initBtnSendCommand(self, x, y):
        self.btnSendCommand = JButton()
        self.btnSendCommand.setText("Send command")
        self.btnSendCommand.setSize(200, 20)
        self.btnSendCommand.setLocation(x, y)
        self.btnSendCommand.actionPerformed = self.sendCommandAction
        self.btnSendCommand.setVisible(0)
        self.btnSendCommand.setEnabled(0)
        
        return self.btnSendCommand

    def sendGo(self, event):
        if self.bot == None:
            return

        rot = self.bot.get_bot_rotation_tuple()
        loc = calculate_move_vector(rot, 200)

        result = sum_location( self.bot.get_bot_location_tuple(), loc )
        self.bot.send_message("MOVE", { "FirstLocation": location_tuple_to_string(result) } )

        #self.bot.send_message("CMOVE")


    def initBtnGo(self, x, y, width, height):
        self.btnGo = JButton()
        self.btnGo.setText("Forward")
        self.btnGo.setSize(width, height)
        self.btnGo.setLocation(x, y)
        self.btnGo.actionPerformed = self.sendGo
        self.btnGo.setVisible(1)
        self.btnGo.setEnabled(1)
        self.btnGo.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnGo
        
    def sendRun(self, event):
        if self.bot == None:
            return

        self.bot.send_message("CMOVE")

    def initBtnRun(self, x, y, width, height):
        self.btnRun = JButton()
        self.btnRun.setText("Run")
        self.btnRun.setSize(width, height)
        self.btnRun.setLocation(x, y)
        self.btnRun.actionPerformed = self.sendRun
        self.btnRun.setVisible(1)
        self.btnRun.setEnabled(1)
        self.btnRun.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnRun    

    def sendStop(self, event):
        if self.bot == None:
            return

        self.bot.send_message("STOP")

    def initBtnStop(self, x, y, width, height):
        self.btnStop = JButton()
        self.btnStop.setText("Stop")
        self.btnStop.setSize(width, height)
        self.btnStop.setLocation(x, y)
        self.btnStop.actionPerformed = self.sendStop
        self.btnStop.setVisible(1)
        self.btnStop.setEnabled(1)
        self.btnStop.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnStop           
        
    def sendJump(self, event):
        if self.bot == None:
            return

        self.bot.send_message("JUMP")

    def initBtnJump(self, x, y, width, height):
        self.btnJump = JButton()
        self.btnJump.setText("Jump")
        self.btnJump.setSize(width, height)
        self.btnJump.setLocation(x, y)
        self.btnJump.actionPerformed = self.sendJump
        self.btnJump.setVisible(1)
        self.btnJump.setEnabled(1)
        self.btnJump.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnJump              

    def sendBack(self, event):
        if self.bot == None:
            return
        
        rot = self.bot.get_bot_rotation_tuple()
        loc = calculate_move_vector(rot, 200)
        new_loc = ( 0-loc[0], 0-loc[1], 0-loc[2] )

        result_focus = sum_location( self.bot.get_bot_location_tuple(), loc )
        result_location = sum_location( self.bot.get_bot_location_tuple(), new_loc )

        self.bot.send_message("MOVE", { "FirstLocation": location_tuple_to_string(result_location), "FocusLocation": location_tuple_to_string(result_focus)  } )



    def initBtnBack(self, x, y, width, height):
        self.btnBack = JButton()
        self.btnBack.setText("Back")
        self.btnBack.setSize(width, height)
        self.btnBack.setLocation(x, y)
        self.btnBack.actionPerformed = self.sendBack
        self.btnBack.setVisible(1)
        self.btnBack.setEnabled(1)
        self.btnBack.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnBack

    def sendLeft(self, event):
        if self.bot == None:
            return
        self.bot.send_message("ROTATE", { "Amount": "-4000" } )

    def initBtnTurnLeft(self, x, y, width, height):
        self.btnTurnLeft = JButton()
        self.btnTurnLeft.setText("TurnL")
        self.btnTurnLeft.setSize(width, height)
        self.btnTurnLeft.setLocation(x, y)
        self.btnTurnLeft.actionPerformed = self.sendLeft
        self.btnTurnLeft.setVisible(1)
        self.btnTurnLeft.setEnabled(1)
        self.btnTurnLeft.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnTurnLeft

    def sendRight(self, event):
        if self.bot == None:
            return
        self.bot.send_message("ROTATE", { "Amount": "4000" } )

    def initBtnTurnRight(self, x, y, width, height):
        self.btnTurnRight = JButton()
        self.btnTurnRight.setText("TurnR")
        self.btnTurnRight.setSize(width, height)
        self.btnTurnRight.setLocation(x, y)
        self.btnTurnRight.actionPerformed = self.sendRight
        self.btnTurnRight.setVisible(1)
        self.btnTurnRight.setEnabled(1)
        self.btnTurnRight.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnTurnRight     
        
    def sendStrafeRight(self, event):
        if self.bot == None:
            return
            
        rot = self.bot.get_bot_rotation_tuple()
        loc = calculate_move_vector(rot, 100)

        new_vect = (-loc[1], loc[0], loc[2])

        temp_focus = sum_location( self.bot.get_bot_location_tuple(), loc )
        result_focus = sum_location( temp_focus, new_vect)
        result_location = sum_location( self.bot.get_bot_location_tuple(), new_vect)

        self.bot.send_message("MOVE", { "FirstLocation": location_tuple_to_string(result_location), "FocusLocation": location_tuple_to_string(result_focus)  } )

    def initBtnStrafeRight(self, x, y, width, height):
        self.btnStrafeRight = JButton()
        self.btnStrafeRight.setText("StrafeR")
        self.btnStrafeRight.setSize(width, height)
        self.btnStrafeRight.setLocation(x, y)
        self.btnStrafeRight.actionPerformed = self.sendStrafeRight
        self.btnStrafeRight.setVisible(1)
        self.btnStrafeRight.setEnabled(1)
        self.btnStrafeRight.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnStrafeRight  
        
    def sendStrafeLeft(self, event):
        if self.bot == None:
            return
            
        rot = self.bot.get_bot_rotation_tuple()
        loc = calculate_move_vector(rot, 100)

        new_vect = (loc[1], -loc[0], loc[2])

        temp_focus = sum_location( self.bot.get_bot_location_tuple(), loc )
        result_focus = sum_location( temp_focus, new_vect)
        result_location = sum_location( self.bot.get_bot_location_tuple(), new_vect)

        self.bot.send_message("MOVE", { "FirstLocation": location_tuple_to_string(result_location), "FocusLocation": location_tuple_to_string(result_focus)  } )            

    def initBtnStrafeLeft(self, x, y, width, height):
        self.btnStrafeLeft = JButton()
        self.btnStrafeLeft.setText("StrafeL")
        self.btnStrafeLeft.setSize(width, height)
        self.btnStrafeLeft.setLocation(x, y)
        self.btnStrafeLeft.actionPerformed = self.sendStrafeLeft
        self.btnStrafeLeft.setVisible(1)
        self.btnStrafeLeft.setEnabled(1)
        self.btnStrafeLeft.setMargin( Insets(0, 0, 0, 0) )        
        
        return self.btnStrafeLeft                 
