from __future__ import nested_scopes
from javax.swing import *
from java.awt import *
from java import *

from posh_bits import *
from posh_agent import *

from AgentInstancePanel_POSH_UT import *

class MultiAgentInstanceFrame_POSH_UT(JFrame):
    
	def __init__(self):
            JFrame.__init__

            self.jContentPane = None

            self.jMultiAgentPanel = None # first pane of the frame, will contain buttons for global actions like kill all agents

            self.agent_instance_panels = {} # we will index them with Agent-1, Agent-2, etc.
                                            # to add new agent instance call self.add_new_agent_instance()
            self.agent_number_available = 0 # number we will give to the new instance

            self.btnStartAllAgents = None
            self.btnKillAllAgents = None
            self.btnCloseAllAgents = None
            self.btnPauseAllAgents = None
            self.btnResumeAllAgents = None
            
            self.initialize()
	
	def initialize(self):	
	    self.setTitle("GB Debugger - Multiple Agent Instances - UT")
	    self.setContentPane(self.getJContentPane())
	    self.setSize(800, 720)
	    self.setLocation(20, 20)

	def getJContentPane(self):
            if (self.jContentPane == None):
                self.jContentPane = JTabbedPane()
                self.jContentPane.add("-- All --", self.getJMultiAgentPanel())
            return self.jContentPane

        def getJMultiAgentPanel(self):
            if self.jMultiAgentPanel == None:
                self.jMultiAgentPanel = JPanel()
                self.jMultiAgentPanel.setLayout(None)
                self.jMultiAgentPanel.add(self.getBtnStartAllAgents())                
                self.jMultiAgentPanel.add(self.getBtnKillAllAgents())
                self.jMultiAgentPanel.add(self.getBtnCloseAllAgents())                
                self.jMultiAgentPanel.add(self.getBtnPauseAllAgents())
                self.jMultiAgentPanel.add(self.getBtnResumeAllAgents())                                

            return self.jMultiAgentPanel

        def startAllAgentsAction(self, event):
            for agent in self.agent_instance_panels.keys():
                self.agent_instance_panels[agent].start_agent()

        def getBtnStartAllAgents(self):
            if self.btnStartAllAgents == None:
                btn = JButton()
                btn.setSize(200, 20)
                btn.setText("Start all agents")
                btn.setLocation(20,20)
                btn.actionPerformed = self.startAllAgentsAction
                self.btnStartAllAgents = btn

            return self.btnStartAllAgents 

        def killAllAgentsAction(self, event):
            self.killAllAgents()

        def killAllAgents(self):
            for agent in self.agent_instance_panels.keys():
                self.agent_instance_panels[agent].killAgent()           

        def getBtnKillAllAgents(self):
            if self.btnKillAllAgents == None:
                btn = JButton()
                btn.setSize(200, 20)
                btn.setText("Kill all agents")
                btn.setLocation(20,45)
                btn.actionPerformed = self.killAllAgentsAction
                self.btnKillAllAgents = btn

            return self.btnKillAllAgents

        def deleteAgentPanel(self, agent_id):
            if self.agent_instance_panels.has_key(agent_id):
                comp = self.agent_instance_panels[agent_id]
                self.jContentPane.remove(comp)
                del self.agent_instance_panels[agent_id]                       

        def closeAllAgentsAction(self, event):
            for agent in self.agent_instance_panels.keys():
                self.agent_instance_panels[agent].closeAgent()

        def getBtnCloseAllAgents(self):
            if self.btnCloseAllAgents == None:
                btn = JButton()
                btn.setSize(200, 20)
                btn.setText("Close all agent panels")
                btn.setLocation(20,70)
                btn.actionPerformed = self.closeAllAgentsAction
                self.btnCloseAllAgents = btn

            return self.btnCloseAllAgents

        def pauseAllAgentsAction(self, event):
            for agent in self.agent_instance_panels.keys():
                self.agent_instance_panels[agent].pauseAgent()

        def getBtnPauseAllAgents(self):
            if self.btnPauseAllAgents == None:
                btn = JButton()
                btn.setSize(200, 20)
                btn.setText("Pause all agents")
                btn.setLocation(20,95)
                btn.actionPerformed = self.pauseAllAgentsAction
                self.btnPauseAllAgents = btn

            return self.btnPauseAllAgents

        def resumeAllAgentsAction(self, event):
            for agent in self.agent_instance_panels.keys():
                self.agent_instance_panels[agent].resumeAgent()

        def getBtnResumeAllAgents(self):
            if self.btnResumeAllAgents == None:
                btn = JButton()
                btn.setSize(200, 20)
                btn.setText("Resume all agents")
                btn.setLocation(20, 120)
                btn.actionPerformed = self.resumeAllAgentsAction
                self.btnResumeAllAgents = btn

            return self.btnResumeAllAgents

        def add_number_to_filename(self, name, number):
            length = len(name)
            if length == 0:
                return str(number) + ".log"
            index = length - 1
            while index >= 0 and name[index] != ".":
                index = index - 1

            if name[index] == ".":
                suffix = name[index+1 : length]
                name = name[0 : index]
                return name + "_" + str(number) + "." + suffix
            else:
                return name + "_" + str(number)
            

        def add_new_agent_instance(self, agent, options, planfile, module, behavior):

  	    if options.has_key("agent_debug_file"):
                options["agent_debug_file"] = self.add_number_to_filename(options["agent_debug_file"], self.agent_number_available)
            
            new_name = "Agent - " + str(self.agent_number_available)
            self.agent_number_available += 1
            new_component = AgentInstancePanel_POSH_UT(agent, options, planfile, module, behavior, self, new_name)
            
            self.agent_instance_panels[new_name] = new_component
            
            self.jContentPane.add(new_name, new_component)
            self.jContentPane.setSelectedComponent(new_component)

