from __future__ import nested_scopes
from javax.swing import *
from java.awt import *
from java import *

from posh_bits import *
from posh_agent import *

from board_frame import *
from gamebot_monitor import *
from bot_control import *

import ut_modules

class AgentInstancePanel_POSH_UT(JPanel):
    
	def __init__(self, agent, options, planfile, module, behavior, owner, agent_id):
            JPanel.__init__

            self.owner = owner
            self.agent_id = agent_id
                    
            self.agent = agent
	    self.agent_options = options
	    self.planfile = planfile
	    self.module = module
	    self.behavior = behavior
            
            self.showDebug = 1
            self.debugRTBBSched = 0
            self.debugRTExecute = 0            
        
            self.debug_buffer = ""

            self.btnCloseAgent = None
        
	    self.btnStartAgent = None
            self.btnPauseAgent = None
	    
	    self.btnViewDebug = None
	    self.jToggleButton = None
	    self.btnMoveCaret = None
	    self.btnRTBBSchedDebug = None
	    self.btnRTExecuteDebug = None
	    self.btnChangeDebugLevel = None	    

            
	    self.btnQuietGB = None
	    self.btnChangeDelay = None	    
	    self.btnViewBlackboard = None
	    self.btnViewSchedule = None
	    self.btnKillAgent = None	    
	    self.jScrollPane = None
	    self.txtScrollPane = None
	    self.txtDebugMessages = None
	    self.tblOptions = None

	    self.moveCaret = 1 # determines if we move caret in debug
	    self.caretPosition = 0 # we'll store caret position because debug text can be a big one and with habit of Java to copy every string to a new object
                                   # it's quite delay to do gettext().length()

	    self.gb_monitor = None
	    self.bot_control = None
	    
            self.initialize()
	
	
	def initialize(self):	
	    self.fillPanel()
	    self.setSize(800, 700)
        
        def dbcall(self,msg): # this methos writes Debug Messages into Debug part of the GUI ... all what goes through debugboard (means it's filtered according to debug level)
                              # also depends whetver writing the debug is on
            self.txtDebugMessages.append("\n" + msg, )
            self.caretPosition += len(msg) + 1
            if self.moveCaret:
                self.txtDebugMessages.setCaretPosition(self.caretPosition - len(msg))

        def startAgentAction(self, event):
            self.start_agent()
        
        def start_agent(self): # button start_agent ... init behaviors + parsing plan, then executes agent in a new thread

            if not self.btnStartAgent.isEnabled():
                return # agent was already started
            
            global behavior
            # Sets the debugboard callback
            if self.showDebug:
                self.agent.debugboard.on_add = self.dbcall

            # as it is written in disertation work, first we create behaviors, to init acts and senses
            self.agent.bind_behavior_instance(self.behavior.make_behavior, self.agent_options)
                                              # make_behavior is a function which set the behavior up - it's called from posh_agent.py ... see agent.bind_behavior_instance

            if hasattr(self.agent, "bot"):
                self.bot_control.bot = self.agent.bot
                if hasattr(self.agent.bot, "call_gb_monitor"):
                    self.agent.bot.call_gb_monitor = self.gb_monitor.new_msg
                else:
                    print "no bot.call_gb_monitor found"
            else:
                print "no bot found"
            
                                              
            self.agent.read_file(ut_modules.get_plan_path(self.module)+self.planfile)
            # creates hierarchy of drives and competences, also attaches senses and acts to drives, etc.
            self.agent.create_tree()
            
            self.agent.execute_thread() # let the game begin! :-)
            
            self.btnStartAgent.setEnabled(0)
            self.btnKillAgent.setEnabled(1)
            self.btnPauseAgent.setEnabled(1)            
            
        def fillPanel(self):
	    self.setLayout(None)
	    
            self.lblModule =  JLabel()
	    self.lblPlanFile =  JLabel()
	    self.lblDebugMessages =  JLabel()
            self.lblOptions = JLabel()		
	    self.lblModule.setText("Module: " + self.module)
	    self.lblModule.setLocation(200, 20)
	    self.lblModule.setSize(180, 20)
	    self.lblPlanFile.setText("Plan File: " + self.planfile)
	    self.lblPlanFile.setLocation(200, 40)
	    self.lblPlanFile.setSize(260, 20)
	    self.lblDebugMessages.setText("Debug Messages:")
	    self.lblDebugMessages.setLocation(20, 180)
	    self.lblDebugMessages.setSize(160, 20)
            self.lblOptions.setText("Specified options:")
            self.lblOptions.setLocation(380, 20)
            self.lblOptions.setSize(160, 20)

            self.add(self.getBtnCloseAgent(), None)
                
	    self.add(self.getBtnStartAgent(), None)
	    self.add(self.getBtnKillAgent(), None)
	    self.add(self.getBtnPauseAgent(), None)
		
	    self.add(self.getJToggleButton(), None)
	    self.add(self.getBtnMoveCaret(), None)		
	    self.add(self.getBtnRTBBSchedDebug(), None)
	    self.add(self.getBtnRTExecuteDebug(), None)

	    self.lblDebugLevel = JLabel()
	    self.lblDebugLevel.setFont(self.lblDebugLevel.getFont().deriveFont( 11.0 ) )		
	    self.lblDebugLevel.setText("Debug level:")
	    self.lblDebugLevel.setSize(80, 20)
	    self.lblDebugLevel.setLocation(20, 160)
            self.add(self.lblDebugLevel)

            self.jtfDebugLevel = JTextField()
            self.jtfDebugLevel.setSize(25, 20)
            self.jtfDebugLevel.setLocation(90, 160)
            self.jtfDebugLevel.setText( str(DEFAULT_DEBUG) )
            self.add(self.jtfDebugLevel)

            self.add(self.getBtnChangeDebugLevel(), None)		

            # next column
	    self.add(self.lblModule, None)
	    self.add(self.lblPlanFile, None)

            self.add(self.getBtnQuietGB(), None)
            self.add(self.getBtnViewDebug(), None)
	    self.add(self.getBtnViewBlackboard(), None)
	    self.add(self.getBtnViewSchedule(), None)


	    self.lblDelay = JLabel()
	    self.lblDelay.setFont(self.lblDebugLevel.getFont().deriveFont( 11.0 ) )		
	    self.lblDelay.setText("Freq. (Hz):")
	    self.lblDelay.setSize(80, 20)
	    self.lblDelay.setLocation(200, 160)
            self.add(self.lblDelay)

            self.jtfDelay = JTextField()
            self.jtfDelay.setSize(30, 20)
            self.jtfDelay.setLocation(265, 160)
            self.jtfDelay.setText( str( int( 1/self.agent.driver_delay * self.agent.delay_multiplier ) ) )
            self.add(self.jtfDelay)
            self.add(self.getBtnChangeDelay(), None)		

            # next column           	
	    self.add(self.lblOptions, None)
	    self.add(self.getJScrollPane(), None)
                
	    # next "row"
	    self.add(self.lblDebugMessages, None)
	    self.add(self.getTxtScrollPane(), None)

	    # now for the GameBot monitor
	    self.gb_monitor = GameBotMonitor()
	    self.gb_monitor.initialize(self, 380, 140, 395)

	    # and now for the Bot Control
	    self.bot_control = BotControl()
	    self.bot_control.initialize(self, 20, 390)

	def getBtnStartAgent(self):
		if (self.btnStartAgent == None):
			self.btnStartAgent =  JButton()
			self.btnStartAgent.setText("Start Agent")
			self.btnStartAgent.setLocation(20, 20)
			self.btnStartAgent.setSize(160, 20)
			self.btnStartAgent.setName("")
			self.btnStartAgent.actionPerformed = self.startAgentAction
				
		return self.btnStartAgent

	def closeAgentAction(self, event):
            self.closeAgent()

        def closeAgent(self):
            if not self.btnStartAgent.isEnabled():
                self.killAgent()
            self.owner.deleteAgentPanel(self.agent_id)

	def getBtnCloseAgent(self):
	    if (self.btnCloseAgent == None):
   	        self.btnCloseAgent =  JButton()
		self.btnCloseAgent.setLocation(760, 10)
		self.btnCloseAgent.setSize(20, 20)
		self.btnCloseAgent.setText("X")
                self.btnCloseAgent.setMargin( Insets(0, 0, 0, 0) )
                self.btnCloseAgent.actionPerformed = self.closeAgentAction
		
            return self.btnCloseAgent    

	def killAgentAction(self, event):
            self.killAgent()

        def killAgent(self):
            if self.btnStartAgent.isEnabled():
                return # if agent wasn't started, we can't kill it
            self.bot_control.close_thread()                            
            self.agent.exit()
            self.agent.stop_debug_to_file()
            self.btnKillAgent.setEnabled(0)
            self.btnPauseAgent.setEnabled(0)            

	def getBtnKillAgent(self):
	    if (self.btnKillAgent == None):
   	        self.btnKillAgent =  JButton()
		self.btnKillAgent.setEnabled(0)
		self.btnKillAgent.setLocation(20, 40)
		self.btnKillAgent.setSize(160, 20)
		self.btnKillAgent.setText("Kill Agent")
                self.btnKillAgent.actionPerformed = self.killAgentAction
		
            return self.btnKillAgent

	def pauseAgentAction(self, event):
            if self.btnPauseAgent.getText() == "Pause Agent":
                self.pauseAgent()
            else:
                self.resumeAgent()

        def pauseAgent(self):
            if self.btnStartAgent.isEnabled() or self.btnPauseAgent.getText() != "Pause Agent":                
                 return # if agent wasn't started / wasn't resumed, we can't pause it
            
            self.agent.pause_execute()
            self.btnPauseAgent.setText("Resume Agent")

        def resumeAgent(self):
            if self.btnStartAgent.isEnabled() or self.btnPauseAgent.getText() != "Resume Agent":                
                 return # if agent wasn't started / wasn't paused, we can't resume it

            self.agent.resume_execute()
            self.btnPauseAgent.setText("Pause Agent")

	def getBtnPauseAgent(self):
            if (self.btnPauseAgent == None):
        	self.btnPauseAgent =  JButton()
		self.btnPauseAgent.setEnabled(0)
		self.btnPauseAgent.setLocation(20, 60)
		self.btnPauseAgent.setSize(160, 20)
		self.btnPauseAgent.setText("Pause Agent")			
                self.btnPauseAgent.actionPerformed = self.pauseAgentAction
		
            return self.btnPauseAgent	
	
	def getJToggleButton(self):
            if (self.jToggleButton == None):
		self.jToggleButton =  JToggleButton()
		self.jToggleButton.setLocation(20, 80)
		self.jToggleButton.setSize(160, 20)
		self.jToggleButton.setText("Hide Debug Output")
		self.agent.debugboard.on_add = self.dbcall
                
                def ChangeToggle(event):
		    self.showDebug = not self.showDebug
		    if self.showDebug: # let's say to agent it does or doesn't have to write debug msgs
                        self.agent.debugboard.on_add = self.dbcall
            		self.jToggleButton.setText("Hide Debug Output")                        
                    else:
                        self.agent.debugboard.on_add = None;
          		self.jToggleButton.setText("Show Debug Output")                        
		    
                self.jToggleButton.actionPerformed = ChangeToggle
                return self.jToggleButton

        def getBtnMoveCaret(self):
            if (self.btnMoveCaret == None):
  		self.btnMoveCaret =  JToggleButton()
		self.btnMoveCaret.setLocation(20, 100)		
		self.btnMoveCaret.setSize(160, 20)
		self.btnMoveCaret.setText("Stop moving debug list")
                
                def ChangeCaretBtn(event):
		    self.moveCaret = not self.moveCaret
		    if self.btnMoveCaret: 
                        self.btnMoveCaret.setText("Stop moving debug list")  
                    else:
                        self.btnMoveCaret.setText("Start moving debug list")                         
		    
                self.btnMoveCaret.actionPerformed = ChangeCaretBtn
                return self.btnMoveCaret    

        def getBtnRTBBSchedDebug(self):
            if (self.btnRTBBSchedDebug == None):
  		self.btnRTBBSchedDebug =  JToggleButton()
		self.btnRTBBSchedDebug.setLocation(20, 120)
		self.btnRTBBSchedDebug.setSize(160, 20)
		self.btnRTBBSchedDebug.setText("RT, BB, Sched debug - enable")
                
                def ChangeBtn(event):
		    self.debugRTBBSched = not self.debugRTBBSched
		    self.agent.rt_bb_sched_debug = self.debugRTBBSched
		    if self.debugRTBBSched: 
                        self.btnRTBBSchedDebug.setText("RT, BB, Sched debug - disable")  
                    else:
                        self.btnRTBBSchedDebug.setText("RT, BB, Sched debug - enable")                         
		    
                self.btnRTBBSchedDebug.actionPerformed = ChangeBtn
                return self.btnRTBBSchedDebug

        def getBtnRTExecuteDebug(self):
            if (self.btnRTExecuteDebug == None):
  		self.btnRTExecuteDebug =  JToggleButton()
		self.btnRTExecuteDebug.setLocation(20, 140)
		self.btnRTExecuteDebug.setSize(160, 20)
		self.btnRTExecuteDebug.setText("RT New Cycle msg - enable")
                
                def ChangeBtnRT(event):
		    self.debugRTExecute = not self.debugRTExecute
		    self.agent.rt_execute_debug = self.debugRTExecute
		    if self.debugRTBBSched: 
                        self.btnRTExecuteDebug.setText("RT New Cycle msg - disable")  
                    else:
                        self.btnRTExecuteDebug.setText("RT New Cycle msg - enable")                         
		    
                self.btnRTExecuteDebug.actionPerformed = ChangeBtnRT
                return self.btnRTExecuteDebug

        def getBtnChangeDebugLevel(self):
		if (self.btnChangeDebugLevel == None):
			self.btnChangeDebugLevel = JButton()
			self.btnChangeDebugLevel.setLocation(115, 160)
			self.btnChangeDebugLevel.setSize(65, 20)
			self.btnChangeDebugLevel.setText("Set")
			
                        def change_debug(event):
                            self.agent.debugboard.debuglevel = int(self.jtfDebugLevel.getText())
			    
                        self.btnChangeDebugLevel.actionPerformed=change_debug
		
		return self.btnChangeDebugLevel    


        # next column

        def getBtnQuietGB(self):
            if (self.btnQuietGB == None):
  		self.btnQuietGB =  JToggleButton()
		self.btnQuietGB.setLocation(200, 80)
		self.btnQuietGB.setSize(160, 20)
		self.btnQuietGB.setText("Hide GameBot messages")
                
                def ChangeBtnQuiet(event):
		    self.gb_monitor.quiet = not self.gb_monitor.quiet
		    if self.gb_monitor.quiet: 
                        self.btnQuietGB.setText("Show GameBot messages")  
                    else:
                        self.btnQuietGB.setText("Hide GameBot messages")                         
		    
                self.btnQuietGB.actionPerformed = ChangeBtnQuiet
                return self.btnQuietGB 
        
        def getBtnViewDebug(self):
		if (self.btnViewDebug == None):
			self.btnViewDebug =  JButton()
			self.btnViewDebug.setText("View Debug Board")
			self.btnViewDebug.setPreferredSize( awt.Dimension(160,20))
			self.btnViewDebug.setLocation(200, 100)
			self.btnViewDebug.setSize(160, 20)
			
                        def show_db(event = None):
                            tmpstr = ""
                            for x in self.agent.debugboard.copy_debugboard():
                                tmpstr += x + "\n"
                            dbframe = BoardFrame("Debugboard",tmpstr)
                            dbframe.setVisible(1)
			    
                        self.btnViewDebug.actionPerformed=show_db
		
		return self.btnViewDebug
		
	def getBtnViewBlackboard(self):
		if (self.btnViewBlackboard == None):
			self.btnViewBlackboard =  JButton()
			self.btnViewBlackboard.setLocation(200, 120)
			self.btnViewBlackboard.setSize(160, 20)
			self.btnViewBlackboard.setText("View Blackboard")
			
		        def show_bb(event = None):
				tmpstr = "Cmd\tTag\t\t\t\t\t\tDrive Name\tValue\n"
                                for x in self.agent.blackboard.copy_bb():
                                    to, item = x
                                    tmpstr += repr(item.command)+"\t"+repr(item.tag)+"\t"+repr(item.drive_name)+"\t"+repr(item.value)+"\n"
          
				bbframe = BoardFrame("Blackboard", tmpstr)
				bbframe.setVisible(1)
		
                        self.btnViewBlackboard.actionPerformed = show_bb
			
		return self.btnViewBlackboard
	
	def getBtnViewSchedule(self):
		if (self.btnViewSchedule == None):
			self.btnViewSchedule =  JButton()
			self.btnViewSchedule.setLocation(200, 140)
			self.btnViewSchedule.setSize(160, 20)
			self.btnViewSchedule.setText("View Schedule")
			
                        def show_sched(event = None):
                            tmpstr = ""
                            for x in self.agent.schedule.copy_schedule():
                                tmpstr += repr(x.name)+"\t"+repr(x.drive_name)+"\t"+repr(x.action)+"\t"+repr(x)+"\n"
                            schedframe = BoardFrame("Schedule", tmpstr)
                            schedframe.setVisible(1)
			
                        self.btnViewSchedule.actionPerformed=show_sched    
                            
                        
		
		return self.btnViewSchedule

        def getBtnChangeDelay(self):
		if (self.btnChangeDelay == None):
			self.btnChangeDelay =  JButton()
			self.btnChangeDelay.setLocation(295, 160)
			self.btnChangeDelay.setSize(65, 20)
			self.btnChangeDelay.setText("Set")
                        
			def change_delay(event):
                            num = int(self.jtfDelay.getText())
                            if num != None and num != 0:
                                self.agent.driver_delay = float( self.agent.delay_multiplier / num )
                            else:
                                self.jtfDelay.setText( str( int( 1/self.agent.driver_delay * self.agent.delay_multiplier ) ) )
			    
                        self.btnChangeDelay.actionPerformed=change_delay
		
		return self.btnChangeDelay	    
	
	def getTblOptions(self):
		if (self.tblOptions == None):
			self.tblOptions =  List()			
			for a in self.agent_options.keys():
                            self.tblOptions.add(a + " = " + self.agent_options[a])
		
		return self.tblOptions
	
	
	def getJScrollPane(self):
		if (self.jScrollPane == None):
			self.jScrollPane =  JScrollPane()
			self.jScrollPane.setViewportView(self.getTblOptions())
			self.jScrollPane.setLocation(380, 40)
			self.jScrollPane.setSize(300, 80)
		
		return self.jScrollPane
		
        def getTxtScrollPane(self):
		if (self.txtScrollPane == None):
			self.txtScrollPane =  JScrollPane()
			self.txtScrollPane.setViewportView(self.getTxtDebugMessages())
			self.txtScrollPane.setLocation(20, 200)
			self.txtScrollPane.setSize(340, 180)
		
		return self.txtScrollPane
	
	
	def getTxtDebugMessages(self):
		if (self.txtDebugMessages == None):
			self.txtDebugMessages =  JTextArea()
			
		return self.txtDebugMessages
	

