/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


class GBxPawn extends xPawn;
//	dependsOn(xUtil);

#exec OBJ LOAD FILE=PlayerSkins.utx
#exec OBJ LOAD FILE=HumanMaleA.ukx

#exec OBJ LOAD FILE=SkaarjPackSkins.utx


var string DesiredSkin;

//last command received by GB
var string LastGBCommand;

//text bubble that appears above the bot
var string TextBubble;
var bool bDrawTextBubble;

var vector CustomRoute[16];


replication
{
	reliable if (Role == ROLE_Authority)
		DesiredSkin, TextBubble, LastGBCommand, bDrawTextBubble;
	reliable if (ROLE == ROLE_Authority )
		CustomRoute;
	reliable if (ROLE < ROLE_Authority )
		ServerSetup;
}

simulated function SetCustomRoute(vector v, int i)
{
	CustomRoute[i] = v;
}

simulated function vector GetCustomRoute(int i)
{
	return CustomRoute[i];
}

//Make bot dodge
function RemoteDoDodge(vector Dir)
{
	if (Physics != PHYS_Falling)
		Velocity = BotDodge(Dir);
	SetPhysics(PHYS_Falling);
}

// called if bScriptPostRender is true, overrides native team beacon drawing code
simulated event PostRender2D(Canvas C, float ScreenLocX, float ScreenLocY)
{
	local PlayerController PC;

	PC = Level.GetLocalPlayerController();

	if ( (PC != None) && (PC.myHUD != None) )
	{
		GBxPlayer(PC).GBHUD.NotifySeePawn(C,self,ScreenLocX, ScreenLocY);
	}
}


//We override this function so we can set bot skins

simulated function Setup(xUtil.PlayerRecord rec, optional bool bLoadNow)
{
	local string meshName, temp;
	local xUtil.PlayerRecord PRE;

	PRE = class'xUtil'.static.FindPlayerRecord(DesiredSkin);

	if (PRE.Species != none)
	{
		//We've found record - that means valid player record supported
		//Setup it and end
		super.Setup(PRE, true);

		return;
	}

	//Player record not found
	LinkMesh(Mesh(DynamicLoadObject(DesiredSkin, class'Mesh')),false);
	//bScriptPostRender = true;
	if (DesiredSkin == "ThunderCrash.JakobM")
	{
		//Default character for GB (histrical reasons)
		//It is stored elsewhere then other skins
		Skins[0]=Texture(DynamicLoadObject("DemoPlayerSkins.Jakob_Body", class'Texture'));
		Skins[1]=Texture(DynamicLoadObject("DemoPlayerSkins.Jakob_NewHead", class'Texture'));
	}
	else
	{
	    Divide(DesiredSkin, ".", temp, meshName);

		// This should make most of default built-in UT2004 player meshes work with
		// good textures.
		// TODO: allow to set also these two variables?
		Skins[0]=Texture(DynamicLoadObject("PlayerSkins."$meshName$"BodyA", class'Texture'));
		Skins[1]=Texture(DynamicLoadObject("PlayerSkins."$meshName$"HeadA", class'Texture'));
	}

	ResetPhysicsBasedAnim();
	//set the skins on the server
	ServerSetup();

}

//Same code as the function above. We need this, so the skins are set also on ther
//server. Otherwise ppl running server through UT2004 wouldn't see changed skins
//on the server instance
function ServerSetup()
{
	local string meshName, temp;
	local xUtil.PlayerRecord PRE;

	PRE = class'xUtil'.static.FindPlayerRecord(DesiredSkin);

	if (PRE.Species != none)
	{
		//We've found record - that means valid player record supported
		//Setup it and end
		super.Setup(PRE, true);
		return;
	}

	//Player record not found
	LinkMesh(Mesh(DynamicLoadObject(DesiredSkin, class'Mesh')),false);
	//bScriptPostRender = true;
	if (DesiredSkin == "ThunderCrash.JakobM")
	{
		//Default character for GB (histrical reasons)
		//It is stored elsewhere then other skins
		Skins[0]=Texture(DynamicLoadObject("DemoPlayerSkins.Jakob_Body", class'Texture'));
		Skins[1]=Texture(DynamicLoadObject("DemoPlayerSkins.Jakob_NewHead", class'Texture'));
	}
	else
	{
	    Divide(DesiredSkin, ".", temp, meshName);

		// This should make most of default built-in UT2004 player meshes work with
		// good textures.
		// TODO: allow to set also these two variables?
		Skins[0]=Texture(DynamicLoadObject("PlayerSkins."$meshName$"BodyA", class'Texture'));
		Skins[1]=Texture(DynamicLoadObject("PlayerSkins."$meshName$"HeadA", class'Texture'));
	}

	ResetPhysicsBasedAnim();
}


function CreateInventory(string InventoryClassName)
{
	local class<Inventory> curInvClass;

	super.CreateInventory(InventoryClassName);
	curInvClass = Level.Game.BaseMutator.GetInventoryClass(InventoryClassName);
	RemoteBot(Controller).HandleStartPickup(curInvClass.default.PickupClass);

}

function RemoteRespawnDied()
{
	local NavigationPoint N;
	local Trigger T;

	// make sure to untrigger any triggers requiring player touch
	if ( Controller != none )
	{
		PhysicsVolume.PlayerPawnDiedInVolume(self);
		ForEach TouchingActors(class'Trigger',T)
			T.PlayerToucherDied(self);

		// event for HoldObjectives
		//for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		//	if ( N.bStatic && N.bReceivePlayerToucherDiedNotify )
		foreach TouchingActors(class'NavigationPoint', N)
			if ( N.bReceivePlayerToucherDiedNotify )
				N.PlayerToucherDied( Self );
	}

	// remove powerup effects, etc.
	RemovePowerups();

}

simulated function SetTextBubble(string Id, string Msg, bool bGlobal, optional float FadeOut)
{
	bDrawTextBubble = true;
	SetTimer(FadeOut,false);
	if (Id == "")
		TextBubble = Msg;
	else
		TextBubble = "To "$Id$":"$Msg;
}

simulated function Timer()
{
	bDrawTextBubble = false;
}

simulated function SetLastGBCommand(string command)
{
	LastGBCommand = command;
}

simulated function SetSkin(string skin, optional xUtil.PlayerRecord rec)
{
	DesiredSkin = skin;
}

simulated function Test()
{
	log("Weve been in test");
	LinkMesh(Mesh(DynamicLoadObject("SkaarjPack_rc.Brute1", class'Mesh')),false);
	Skins[0]=Texture(DynamicLoadObject("Skaarjpackskins.jbrute1", class'Texture'));
	Skins[1]=Texture(DynamicLoadObject("Skaarjpackskins.RedShell", class'Texture'));


      Health=500;
      bCanFly=true;
      bCanStrafe=True;



      MeleeRange=+00080.000000;
      GroundSpeed=+00400.000000;
      AirSpeed=+00500.000000;

      Mass=+0300.000000;

    //default.CollisionRadius=+00047.000000;
      //default.CollisionHeight=+00078.000000;

   /*
     HitSound[0]='injur1WL';
     HitSound[1]=injur2WL;
     HitSound[2]=injur1WL;
     HitSound[3]=injur2WL;
     FireSound=Sound'WeaponSounds.RocketLauncherFire';
     DeathSound[0]=DeathCry1WL;
     DeathSound[1]=DeathCry1WL;
     DeathSound[2]=DeathCry1WL;
     DeathSound[3]=DeathCry1WL;
     ChallengeSound[0]=acquire1WL;
     ChallengeSound[1]=roam1WL;
     ChallengeSound[2]=threat1WL;
     ChallengeSound[3]=breath1WL;
	 */


	     SwimAnims[0]='WalkF';
    SwimAnims[1]='WalkF';
    SwimAnims[2]='WalkF';
    SwimAnims[3]='WalkF';
    IdleSwimAnim='WalkF';

    WalkAnims[0]='WalkF';
    WalkAnims[1]='WalkF';
    WalkAnims[2]='WalkF';
    WalkAnims[3]='WalkF';

    MovementAnims[0]='WalkF';
    MovementAnims[1]='WalkF';
    MovementAnims[2]='WalkF';
    MovementAnims[3]='WalkF';


    IdleWeaponAnim='CockGun';
    IdleHeavyAnim='Idle_Rest';
    IdleRifleAnim='Idle_Rest';

    AirStillAnim='Jump';
    AirAnims[0]='Jump';
    AirAnims[1]='Jump';
    AirAnims[2]='Jump';
    AirAnims[3]='Jump';
    TakeoffStillAnim='Jump';
    TakeoffAnims[0]='Jump';
    TakeoffAnims[1]='Jump';
    TakeoffAnims[2]='Jump';
    TakeoffAnims[3]='Jump';
    LandAnims[0]='Land';
    LandAnims[1]='Land';
    LandAnims[2]='Land';
    LandAnims[3]='Land';
    DodgeAnims[0]='Jump';
    DodgeAnims[1]='Jump';
    DodgeAnims[2]='Jump';
    DodgeAnims[3]='Jump';



	 /*For Warlord

   AirStillAnim='Fly';
    AirAnims[0]='Fly';
    AirAnims[1]='Fly';
    AirAnims[2]='Fly';
    AirAnims[3]='Fly';
    TakeoffStillAnim='Fly';
    TakeoffAnims[0]='Fly';
    TakeoffAnims[1]='Fly';
    TakeoffAnims[2]='Fly';
    TakeoffAnims[3]='Fly';
    MovementAnims[0]='RunF';
    MovementAnims[1]='RunF';
    MovementAnims[2]='RunF';
    MovementAnims[3]='RunF';
    TurnRightAnim='Idle_Rest';
    TurnLeftAnim='Idle_Rest';

    WalkAnims[0]='WalkF';
    WalkAnims[1]='WalkF';
    WalkAnims[2]='WalkF';
    WalkAnims[3]='WalkF';

    TransientSoundVolume=1.0;
    TransientSoundRadius=1500.0;
				  */

}


simulated function DrawLine(vector Start,vector End)
{
	DrawStayingDebugLine(Start,End,255,0,0);
}

defaultproperties
{
	bScriptPostRender=True
	TextBubble="Testing bubble"
}
