/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/

//We've got this class here to allow specators to go through walls
class ScenarioxPlayer extends GBxPlayer;

//this has nothing to do with DialogId, DialogBotName etc...
var DGUIDialog Dialog;


var bool bHasControl;

var bool bShouldWalk;


simulated event Destroyed()
{

	local LinkedReplicationInfo PRI;

    //Destroying all linked replication infos - just on client
    if (ROLE < ROLE_AUTHORITY)
		for (PRI = PlayerReplicationInfo.CustomReplicationInfo; PRI != none; PRI = PRI.NextReplicationInfo)
		{
			PRI.Destroy();
		}

	Super.Destroyed();

    if (FocusActor != none)
    {
        FocusActor.Destroy();
    }

	if (GBHUD != none)
	{
		log("Detroying hud");
		GBHUD.Destroy();
	}

}

simulated function PlayDynamicSound(string soundName)
{
    local Sound s;

    s = Sound(DynamicLoadObject(soundName, class'Sound'));
    if (s != none)
    {
        PlaySound(s, , , , , , );
    }
}

function SetFocus(vector location)
{
    if (FocusActor == none)
    {
        FocusActor = Spawn(class'FocusActorClass',,,,);
        FocusActor.bHidden = true;
    }
    FocalPoint = location;
    FocusActor.SetLocation(location);
    Focus = FocusActor;
}

function ReleaseFocus()
{
    Focus = none;
}

state PlayerHasNotControl {

MoveToPoint:
    SetRotation(rotator(FocalPoint - Pawn.Location));
    MoveTo(Destination, FocusActor, bShouldWalk);
    ReleaseFocus();
}

state PlayerInDialog {


	exec function Fire(float f)
	{
        //GBHUDInteraction handles this self
    }

	function PlayerMove(float DeltaTime)
	{
        HandleMouseMovement(DeltaTime);
    }

}

function HandleMouseMovement(float DeltaTime)
{
    local vector MouseV, ScreenV;

    // get the new mouse position offset
    MouseV.X = DeltaTime * aMouseX / (InputClass.default.MouseSensitivity * DesiredFOV * 0.01111);
    MouseV.Y = DeltaTime * aMouseY / (InputClass.default.MouseSensitivity * DesiredFOV * -0.01111);

    // update mouse position
    PlayerMouse += MouseV;

    // convert mouse position to screen coords, but only if we have good screen sizes
    if ((LastHUDSizeX > 0) && (LastHUDSizeY > 0))
    {
        ScreenV.X = PlayerMouse.X + LastHUDSizeX * 0.5;
        ScreenV.Y = PlayerMouse.Y + LastHUDSizeY * 0.5;
        // here is where you would use the screen coords to do a trace or check HUD elements
    }
}

//When we are using mouse cursor to select objects
state PlayerMousing
{
	simulated function EndState()
	{
		SelectedActor = None;
		SelectActorOnServer(None);
		ClearDialogOnClient();
		ClearDialogOnServer();
	}

	//Select actor we have cursor over
	exec function Fire(float f)
	{
      // do stuff here for when players click their fire/select button

		local vector TraceEnd, HitLocation, HitNormal, Dir, CameraLoc;
		local rotator CameraRot;
		local actor ViewActor;
		local float Fov, FovDist;
		local float MouseX, MouseY;
		local actor Other, A;

		MouseX = PlayerMouse.X + LastHUDSizeX * 0.5;

		MouseY = PlayerMouse.Y + LastHUDSizeY * 0.5;

		CameraRot = GetViewRotation();
		CameraLoc = vect(0,0,0);

		PlayerCalcView(ViewActor, CameraLoc, CameraRot);

		Fov = (FovAngle/2) * Pi / 180.00;
		FovDist = (LastHUDSizeX/2) / Tan(Fov);

		Dir.X = FovDist;
		Dir.Y = MouseX - LastHUDSizeX / 2;
		Dir.Z = -(MouseY - LastHUDSizeY / 2);

		Dir = Dir >> CameraRot;

		TraceEnd = (CameraLoc) + 2000 * Normal(Dir);
		//TODO: this is client side trace - we should do it on server and send result to client
		// wasnt able to trace medkits, adrenaline, etc. this way

		DrawStayingDebugLine(CameraLoc,TraceEnd,255,0,0);

		foreach TraceActors(class'Actor', A, HitLocation, HitNormal, TraceEnd, CameraLoc,)
		{
			// Prevent tracing my own Pawn by accident or PhysicsVolumes (this happened when testing)
			if ((A != none) && (A != Pawn) && !A.IsA('Volume'))
			{
				Other = A;
				break;
			}
		}

		//Other = Trace(HitLocation, HitNormal, TraceEnd, CameraLoc, true);

		if( Other != None)
		{
			SelectedActor = Other;
			SelectActorOnServer(SelectedActor);
		}

		return;

	}

    //Deselect actor.
    exec function AltFire( optional float F )
    {
		SelectedActor = None;
		SelectActorOnServer(None);
    }

    simulated function PlayerMove(float DeltaTime)
    {
       HandleMouseMovement(DeltaTime);
    }
}

defaultproperties
{
    bHasControl = true;
}
