/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


// Interaction class creates custom GB Hud and handles keyInput
// The reachability grid is drawn here
class ScenarioHudInteraction extends GBHUDInteraction;

var array<ScenarioControlConnection> KeyListeners;

//Here we will spawn our GBHUD and set it also to the Player
function InitHud()
{
    MyHUD = ViewportOwner.Actor.Spawn(class'GBScenario.ScenarioHUD', ViewportOwner.Actor);
    //ViewportOwner.Actor.myHUD = MyHUD;


    if (ViewportOwner.Actor.isA('GBxPlayer'))
    {
		GBxPlayer(ViewportOwner.Actor).GBHUD = MyHUD;
		//GBxPlayer(ViewportOwner.Actor).GBHUDInter = self;
	}
}

function AddKeyListener(ScenarioControlConnection listener) {
    local int i;

    for( i = 0; i < KeyListeners.Length; ++i) {
        if (KeyListeners[i] == listener)
        {
            return;
        }
    }
    KeyListeners.Length = KeyListeners.Length + 1;
    KeyListeners[KeyListeners.Length - 1] = listener;
}

function RemoveKeyListener(ScenarioControlConnection listener) {
    local int i;

    for (i = 0; i < KeyListeners.Length; ++i)
    {
        if (KeyListeners[i] == listener)
        {
            break;
        }
    }
    while (i < KeyListeners.Length - 1)
    {
        KeyListeners[i] = KeyListeners[i + 1];
        ++i;
    }
    KeyListeners.Length = i;
}

function SendKeyEvent(EInputKey key, EInputAction action)
{
    local int i;

    for (i = 0; i < KeyListeners.Length; ++i)
    {
        KeyListeners[i].SendKeyEvent(GBxPlayer(ViewportOwner.Actor), key, action);
    }
}

//Here we handle our GB key presses
function bool KeyEvent(EInputKey InputKey, EInputAction InputAction, FLOAT Delta )
{

    // don't send mouse events
	if (InStr(GetEnum(enum'EInputKey', InputKey), "Mouse") != -1)
	{
        SendKeyEvent(InputKey, InputAction);
	}

	if (InputKey == IK_LeftMouse && InputAction == IST_Release)
	{
        if (ViewportOwner.Actor.IsInState('PlayerInDialog'))
        {
            ScenarioHUD(MyHUD).DialogMousePress();
        }
	}

	return super.KeyEvent(INputKey, InputAction, Delta);
}

defaultproperties
{
	bDrawNavPointsGrid=false
    bVisible=true
    bActive=true
}
