/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


// This is the class, where we add additional functionality to Player HUD.
// We draw on the HUD additional debug information about bots and player/s.
class ScenarioHud extends GBHUD
	config(GBScenario);

//Mouse cursor texture
var texture MouseCursorTexture2;
var array<string> TextsDisplayed;
var array<float> TextsExpiration;
var array<color> TextsColors;

var array<DGUIDialog> DialogStack;
var float LastMousePress;

/* This is our entry point function. This function is called periodically (from
interaction class).
*/
simulated function PostRender(Canvas C)
{
	super.PostRender(C);

	DrawTexts(C);
	DrawDialogs(C);
	if (DialogStack.Length != 0)
	{
	    DrawCursorForDialog(C);
	}
}

simulated function DrawTexts(Canvas C)
{
    local int i;
    local float x, y;
    local float w, h;

    UpdateTexts();
    C.font = C.MedFont;

    y = 0.1*C.SizeX; x = C.SizeX/2;
    for (i = TextsDisplayed.Length - 1; i >= 0; --i)
    {
       	C.TextSize(TextsDisplayed[i], w, h);
        C.SetPos(x - w/2, y);
        C.DrawColor = TextsColors[i];
        C.DrawTextClipped(TextsDisplayed[i]);
        y += h*1.2;
    }

}

function AddText(string text, float time, color col)
{
    TextsDisplayed[TextsDisplayed.Length] = text;
    TextsColors[TextsColors.Length] = col;
    if (time > 0)
    {
        TextsExpiration[TextsExpiration.Length] = PlayerOwner.Level.TimeSeconds + time;
    }
    else //The text should persist until manually removed
    {
        TextsExpiration[TextsExpiration.Length] = 0;
    }
}

function RemoveText(string text)
{
    local int i;

    for (i = 0; i < TextsDisplayed.Length; ++i)
    {
        if (TextsDisplayed[i] == text)
        {
            break;
        }
    }
    while (i < TextsDisplayed.Length - 1)
    {
        TextsDisplayed[i] = TextsDisplayed[i + 1];
        TextsExpiration[i] = TextsExpiration[i + 1];
        TextsColors[i] = TextsColors[i + 1];
        ++i;
    }
    TextsDisplayed.Length = i;
    TextsExpiration.Length = i;
    TextsColors.Length = i;
}

function UpdateTexts()
{
    local int i;
    local int j;

    j = 0;
    for (i = 0; i < TextsDisplayed.Length; ++i)
    {
        if (j != i)
        {
            TextsDisplayed[j] = TextsDisplayed[i];
            TextsExpiration[j] = TextsExpiration[i];
            TextsColors[j] = TextsColors[i];
        }
        if (TextsExpiration[i] ~= 0 || TextsExpiration[i] > PlayerOwner.Level.TimeSeconds)
        {
            ++j;
        }
    }
    TextsDisplayed.Length = TextsDisplayed.Length - i + j;
    TextsExpiration.Length = TextsExpiration.Length - i + j;
    TextsColors.Length = TextsColors.Length - i + j;
}

function PushDialog(DGUIDialog Dialog)
{
    DialogStack[DialogStack.Length] = Dialog;
}

function PopDialog()
{
    DialogStack[DialogStack.Length - 1] = none;
    DialogStack.Length = DialogStack.Length - 1;
}

function PopDialogUntil(DGUIDialog Dialog)
{
    local int i;

    for (i = DialogStack.Length - 1; i >= 0; --i)
    {
        if (DialogStack[i] == Dialog)
        {
            DialogStack[i] = none;
            DialogStack.Length = i;
            return;
        }
        else
        {
            DialogStack[i] = none;
        }
    }
}

function DrawDialogs(Canvas C)
{
    local int i;
    for (i = 0; i < DialogStack.Length; ++i)
    {
        DialogStack[i].Draw(C);
    }
}

function DialogMousePress()
{
    local int i;
    local DGUIDialog d;

    if (PlayerOwner.Level.TimeSeconds - LastMousePress < 0.1)
    {
        return;
    }
    else
    {
        LastMousePress = PlayerOwner.Level.TimeSeconds;
    }

    for (i = DialogStack.Length - 1; i >= 0; --i)
    {
        d = DialogStack[i];
        if (d.OnClick(d.Player.PlayerMouse.X/d.Player.LastHUDSizeX + 0.5,
                      d.Player.PlayerMouse.Y/d.Player.LastHUDSizeY + 0.5))
        {
            return;
        }
    }
}

simulated function GetMouseCursorPos(Canvas C, out float XPos, out float YPos)
{
    // find position of cursor, and clamp it to screen
	XPos = GBxPlayer(PlayerOwner).PlayerMouse.X + C.SizeX / 2.0;
	//TODO: Weird, if here is 0 we cannot move cursor to upperleft corner
	if (XPos < -50)
	{
    	GBxPlayer(PlayerOwner).PlayerMouse.X -= (XPos + 50);
    	XPos = -50;
	}
	else if (XPos >= C.SizeX)
	{
    	GBxPlayer(PlayerOwner).PlayerMouse.X -= (XPos - C.SizeX);
    	XPos = C.SizeX - 1;
	}
	YPos = GBxPlayer(PlayerOwner).PlayerMouse.Y + C.SizeY / 2.0;
	//TODO: Weird, if here is 0 we cannot move cursor to upperleft corner
	if (YPos < -50)
	{
    	GBxPlayer(PlayerOwner).PlayerMouse.Y -= (YPos + 50);
    	YPos = -50;
	}
	else if (YPos >= C.SizeY)
	{
    	GBxPlayer(PlayerOwner).PlayerMouse.Y -= (YPos - C.SizeY);
    	YPos = C.SizeY - 1;
	}
}

simulated function DrawMouseCursor(Canvas C)
{
	local float XPos, YPos;
	local int i;

	C.SetDrawColor(255, 255, 255);
	C.Style = ERenderStyle.STY_Alpha;

    GetMouseCursorPos(C, XPos, YPos);

	// render mouse cursor
	C.SetPos(XPos, YPos);
	C.DrawIcon(MouseCursorTexture,1);

	// Draw Selected actor
	C.SetPos(XPos , YPos);
	C.DrawText(GBxPlayer(PlayerOwner).SelectedActor);

	// Draw Dialog
	C.DrawText(GBxPlayer(PlayerOwner).DialogBotName $ ": " $ GBxPlayer(PlayerOwner).DialogText);
	for (i=0;i<10;i++)
		C.DrawText(GBxPlayer(PlayerOwner).DialogOptions[i]);

	return;
}

simulated function DrawCursorForDialog(Canvas C)
{
    local float XPos, YPos;

    GetMouseCursorPos(C, XPos, YPos);
    C.SetDrawColor(255, 255, 255);
    C.SetPos(XPos, YPos);
    C.DrawIcon(MouseCursorTexture2, 1);
}

defaultproperties
{
	bDrawNavPointsNames = true;
	bDisplayPlayerList = true;
	bDisplayHelp = true;
	bDisplayHealthBar = false;
	bDisplayTextbubble = true;
	bDisplayMyLocation = true;
	NavPointBeaconDrawDistance = 500;
	MouseCursorTexture=Texture'Crosshairs.HUD.Crosshair_Cross1';
	MouseCursorTexture2=Texture'2K4Menus.Cursors.Pointer';
}
