/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


class ScenarioControlConnection extends ControlConnection;

var bool tempBool;

//Handles commands for ControlServer
function ProcessAction(string cmdType)
{

	super.ProcessAction(cmdType);


	switch(cmdType)
	{
		case "COMPLR":
			ReceivedCommandPlayer();
		break;
		case "DLGBEGIN":
	  		ReceivedDialogBegin();
	  	break;
		case "DLGCANCEL":
			ReceivedDialogCancel();
		break;
		case "DLGEND":
			ReceivedDialogEnd();
		break;
		case "DLGITEM":
			ReceivedDialogItem();
		break;
		case "FORCECAM":
			ReceivedForceCam();
		break;
		case "FORCECAMMOVE":
			ReceivedForceCamMove();
		break;
		case "PLSND":
			ReceivedPlaySound();
		break;
		case "SETPLRCTRL":
			ReceivedSetPlayerControl();
		break;
		case "SETSENDKEYS":
			ReceivedSetSendKeys();
		break;
		case "SHTXT":
			ReceivedShowText();
		break;

	}//end switch
}


function ReceivedCommandPlayer()
{
    local string command;
    local ScenarioxPlayer player;

    player = FindPlayer(GetArgVal("Player"));
    command = GetArgVal("Command");

    if (player != none && !player.bHasControl && command != "")
    {
        if (player.GetStateName() != 'PlayerHasNotControl')
        {
            player.GotoState('PlayerHasNotControl');
        }
        switch (Caps(command))
        {
            case "MOVE":
                ReceivedCommandPlayerMove(player);
            break;
            case "TURNTO":
                ReceivedCommandPlayerTurnTo(player);
            break;
        }
    }
}

function ReceivedCommandPlayerMove(ScenarioxPlayer player)
{
    local vector destination, focusLocation;

    ParseVector(destination, "Location");
    if (GetArgVal("FocusLocation") != "")
    {
        ParseVector(focusLocation, "FocusLocation");
    }
    else
    {
        focusLocation = destination;
    }
    player.Destination = destination;
    player.SetFocus(focusLocation);
    player.bShouldWalk = bool(GetArgVal("Walk"));
    player.GotoState('PlayerHasNotControl', 'MoveToPoint');
}

function ReceivedCommandPlayerTurnTo(GBxPlayer player)
{
    local rotator r;
    local vector vec;

    if (GetArgVal("Rotation") != "")
    {
        ParseRot(r, "Rotation");
        if (player.Pawn != none)
        {
            //should do some tracing
            player.FocalPoint = player.Pawn.Location + (vector(r) * 500);
            player.SetRotation(r);
        }
    }
    else if (GetArgVal("Location") != "")
    {
        ParseVector(vec, "Location");
        player.FocalPoint = vec;
        player.SetRotation(rotator(vec - player.Pawn.Location));
    }
}

function ReceivedDialogBegin()
{
    local ScenarioxPlayer player;

    player = FindPlayer(GetArgVal("Player"));
    if (player != none)
    {
        player.Dialog = new class'DGUIDialog';
        player.Dialog.SetGBHUD(ScenarioHUD(FindGBHUDInteraction(player).MyHUD));
        player.Dialog.SetConnection(Self);
        player.Dialog.SetPlayer(player);
        player.Dialog.SetId(GetArgVal("Id"));
    }
}

function ReceivedDialogCancel()
{
    local ScenarioHUDInteraction interaction;
    local ScenarioxPlayer player;
    local int i;
    local string dialogId;

    player = FindPlayer(GetArgVal("Player"));
    dialogId = GetArgVal("Id");
    interaction = FindGBHUDInteraction(player);
    for (i = 0; i < ScenarioHUD(interaction.MyHUD).DialogStack.Length; ++i)
    {
        if (dialogId == ScenarioHUD(interaction.MyHUD).DialogStack[i].Id)
        {
            DialogFinished(ScenarioHUD(interaction.MyHUD).DialogStack[i]);
        }
    }
}

function ReceivedDialogEnd()
{
    local ScenarioxPlayer player;
    local ScenarioHUDInteraction interaction;

    player = FindPlayer(GetArgVal("Player"));
    if (player != none)
    {
        if (player.Dialog != none)
        {
            interaction = FindGBHUDInteraction(player);
            if (!player.IsInState('PlayerInDialog')) {
                interaction.LastPlayerState = player.GetStateName();
                player.GotoState('PlayerInDialog');
            }
            player.Dialog.Show();
            player.Dialog = none;
        }
    }
}

function DialogFinished(DGUIDialog dialog)
{
    local ScenarioHUDInteraction interaction;

    interaction = FindGBHUDInteraction(dialog.Player);
    dialog.Hide();
    if (ScenarioHUD(interaction.MyHUD).DialogStack.Length == 0)
    {
        dialog.Player.GotoState(interaction.LastPlayerState);
    }
}

function ReceivedDialogItem()
{
    local ScenarioxPlayer player;
    local ScenarioHUD HUD;
    local int i;
    local string temp;

    player = FindPlayer(GetArgVal("Player"));
    if (player != none)
    {
        if (player.Dialog != none && GetArgVal("Effect") ~= "ADD")
        {
            // params will the Dialog get from Connection
            // it is not nice, but I don't want to parse all params here
            player.Dialog.AddItem();
        } else {
            HUD = ScenarioHUD(FindGBHUDInteraction(player).MyHUD);
            temp = GetArgVal("DialogId");
            for (i = 0; i < HUD.DialogStack.Length; ++i)
            {
                if (HUD.DialogStack[i].Id == temp)
                {
                    temp = GetArgVal("Effect");
                    if (temp ~= "ADD")
                    {
                        HUD.DialogStack[i].AddItem();
                    }
                    else if (temp ~= "EDIT")
                    {
                        HUD.DialogStack[i].EditItem();
                    }
                    return;
                }
            }
        }
    }
}

function ReceivedForceCam()
{
	local string target;
	local vector spawnLocation;
	local rotator spawnRotation;
	local Controller C;

	target = GetArgVal("Id");

	if (target == "")
		return;

	ParseVector(spawnLocation,"Location");
	ParseRot(spawnRotation,"Rotation");

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{

		if( C.IsA('ScenarioxPlayer') && (GetUniqueId(C) == target) )
		{
        	if (!ScenarioxPlayer(C).bStoryCamera)
			{
				ScenarioxPlayer(C).BecomeStoryCamera();
			}

			if (GetArgVal("Location") != "")
				ScenarioxPlayer(C).SetLocation(spawnLocation);
			if (GetArgVal("Rotation") != "")
				ScenarioxPlayer(C).ClientSetRotation(spawnRotation);

			return;
		}

	}
}

function ReceivedForceCamMove()
{
	local string target;
	local vector camDirection;
	local rotator camRotation;
	local float time, camSpeed, horizontalTurn, verticalTurn, rollTurn;
	local Controller C;

	target = GetArgVal("Id");

	if (target == "")
		return;

	ParseVector(camDirection,"Direction");
	ParseRot(camRotation,"Rotation");

	horizontalTurn = 0;
	horizontalTurn = float(GetArgVal("HTurn"));

	verticalTurn = 0;
	verticalTurn = float(GetArgVal("VTurn"));

	rollTurn = 0;
	rollTurn = float(GetArgVal("RTurn"));

	camSpeed = 0;
	camSpeed = float(GetArgVal("Speed"));

	time = 0;
	time = float(GetArgVal("Time"));

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{

		if( C.IsA('ScenarioxPlayer') && (GetUniqueId(C) == target) )
		{
        	if (ScenarioxPlayer(C).bStoryCamera)
			{
				//GBxPlayer(C).MoveSmooth(camVelocity * time);
				//Multiply by 1000 so we don't loose numbers behind . due to replication
				ScenarioxPlayer(C).myCamDirX = camDirection.x * 1000;
				ScenarioxPlayer(C).myCamDirY = camDirection.y * 1000;
				ScenarioxPlayer(C).myCamDirZ = camDirection.z * 1000;

				//Set speed of the camera (ut units per second)
				//On the server
				ScenarioxPlayer(C).SpectateSpeed = camSpeed;
				//This will set camera on the client (in GBxPlayer state Spectating fc. PlayerMove())
				ScenarioxPlayer(C).myCamSpeed = camSpeed;

				//These vars represent rotating speed in ut units per sec. support larger numbers
				//will start rotation from 100 and up
				ScenarioxPlayer(C).camHorizontalTurn = horizontalTurn;
				ScenarioxPlayer(C).camVerticalTurn = verticalTurn;
				ScenarioxPlayer(C).camRollTurn = rollTurn;

				//the camera will move/rotate just for the specified amount of time
				//if not set, then it will move forever - until changed or stopped
				if (time > 0)
					ScenarioxPlayer(C).SetTimer(time, false);

				ScenarioxPlayer(C).myCamTurnRot = camRotation;
			}
			return;
		}

	}
}

// plays some sound
function ReceivedPlaySound()
{
    local ScenarioxPlayer player;

    player = FindPlayer(GetArgVal("Player"));
    player.PlayDynamicSound(GetArgVal("Sound"));
}

function ScenarioHUDInteraction FindGBHUDInteraction(ScenarioxPlayer player)
{
    local array<Interaction> interactions;
    local int i;

    interactions = player.Player.LocalInteractions;
    for (i = 0; i < interactions.Length; ++i)
    {
        if (interactions[i].IsA('GBHudInteraction'))
        {
            return ScenarioHudInteraction(interactions[i]);
        }
    }
    return none;
}

// prints some text onscreen
function ReceivedShowText()
{
    local ScenarioxPlayer player;
    local string text;
    local float time;
    local string stringShow;
    local ScenarioHUD hud;
    local color col;


    player = FindPlayer(GetArgVal("Player"));
    text = GetArgVal("Text");
    time = float(GetArgVal("Time"));
    if (player != none && text != "")
    {
        hud = ScenarioHUD(FindGBHUDInteraction(player).MyHUD);
        stringShow = GetArgVal("Show");
        if (stringShow == "" || bool(stringShow))
        {
            ParseColor(col, "Color");
            hud.AddText(text, time, col);
        }
        else
        {
            hud.RemoveText(text);
        }
        return;
    }
}

// whether should GB send unprocessed keypresses
function ReceivedSetSendKeys()
{
    local ScenarioxPlayer player;
    local ScenarioHUDInteraction interaction;

    player = FindPlayer(GetArgVal("Player"));
    interaction = FindGBHUDInteraction(player);
    if (interaction != none)
    {
        if (bool(GetArgVal("Send")))
        {
            interaction.addKeyListener(self);
        }
        else
        {
            interaction.RemoveKeyListener(self);
        }
    }
}

function ScenarioxPlayer FindPlayer(string playerName)
{
    local Controller C;

    if (playerName != "")
    {
        for (C = Level.ControllerList; C != None; C = C.NextController )
        {
            if (C.isA('ScenarioxPlayer'))
            {
                if (C.PlayerReplicationInfo.PlayerName == playerName)
                {
                    return ScenarioxPlayer(C);
                }
            }
        }
    }
    return none;
}

// Whether the player can control movement, shooting etc.
// TODO: currently uncontrolled shooting (as when PlayerMousing)
function ReceivedSetPlayerControl()
{
    local ScenarioxPlayer player;
    local string control;

    player = FindPlayer(GetArgVal("Player"));
    control = GetArgVal("Control");

    if (player != none && control != "")
    {
        player.bHasControl = bool(control);
        if(player.bHasControl)
        {
            player.GotoState('PlayerWalking');
        }
        else
        {
            player.GotoState('PlayerHasNoControl');
        }
    }
}

function SendKeyEvent(GBxPlayer player, Interactions.EInputKey key, Interactions.EInputAction action)
{
    local string outstring;

    outstring = "KEYEVENT {Player " $ player.PlayerReplicationInfo.PlayerName $
        "} {Key " $ Mid( GetEnum(enum'EInputKey', key), 3 ) $
        "} {Action " $ Caps(Mid( GetEnum(enum'EInputAction', action), 3)) $ "}";

    SendLine(outstring);

}

function ParseColor(out color C, string colName)
{
	local int i;
	local string colorString;
	local string delim;

	colorString = GetArgVal(colName);
	delim = ",";

	if (colorString == "")
	{
		C.R = 0;
		C.G = 0;
		C.B = 0;
		C.A = 255;
		return;
	}

	i = InStr(colorString, delim);
	C.R = int(left(colorString,i));
	colorString = Mid(colorString,i+1);
	i = InStr(colorString, delim);
	C.G = int(left(colorString,i));
	colorString = Mid(colorString,i+1);
	i = InStr(colorString, delim);
	C.B = int(left(colorString,i));
	i = InStr(colorString, delim);
	if (i != -1)
		C.A = int(Mid(colorString,i+1));
	else
		C.A = 255;
	}

function ParsePoint(out float X, out float Y, string pointName)
{
	local int i;
	local string point;
	local string delim;

	point = GetArgVal(pointName);
	delim = ",";

	if (point == "")
	{
		X = 0;
		Y = 0;
		return;
	}

	i = InStr(point, delim);
	X = float(left(point, i));
	Y = float(mid(point, i + 1));
}

function ParseDimension(out float Width, out float Height, string dimensionName)
{
	local int i;
	local string dimension;
	local string delim;

	dimension = GetArgVal(dimensionName);
	delim = ",";

	if (dimension == "")
	{
		Width = 1;
		Height = 1;
		return;
	}

	i = InStr(dimension, delim);
	Width = float(left(dimension, i));
	Height = float(mid(dimension, i + 1));
}

defaultproperties
{
	UpdateTime=0.300000
    bAllowPause=True
}
