/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


class ScenarioBotConnection extends BotConnection;


//Handles commands for ControlServer
function ProcessAction(string cmdType)
{

	super.ProcessAction(cmdType);


	switch(cmdType)
	{
		case "GETPLRS":  //HACK: this is terrible hack for scenario
		//problem is that GETPLRS command in not hanled yet... :-/
			ScenarioBot(theBot).bExportAllPlayers = true;
		break;
		case "GIVE":
			ReceivedGive();
		break;
		case "SETEMIT":
			ReceivedSetEmitter();
		break;

	}//end switch
}

//Gives item to target bot and notifies all the bots that can see us about it
function ReceivedGive()
{
	local Controller C;
    local string target, itemType;
    local class<Pickup> tempPickup;
    local RemoteBot receiver;

	target = GetArgVal("Id");
	itemType = GetArgVal("ItemType");

 	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( (C$C.PlayerReplicationInfo.PlayerID) == target )
		{
			if (C.IsA('ScenarioBot') && (C.Pawn != none))
			{
				tempPickup = class<Pickup>(DynamicLoadObject(itemType, class'Class'));
				RemoteBot(C).SpawnInventory(tempPickup);
				ScenarioBot(C).NotifyGotInventory(theBot,RemoteBot(C),tempPickup);
				receiver = RemoteBot(C);
				break;
			}
       	}
	}
	if (receiver != none){
 		for(C = Level.ControllerList; C != None; C = C.NextController )
		{
			if (C.IsA('ScenarioBot') && (C != receiver) && (theBot.Pawn != none))
			{
				if (C.CanSee(theBot.Pawn)){
					ScenarioBot(C).NotifyGotInventory(theBot,receiver,tempPickup);
				}
			}
		}
	}

}

//sets emotion emotional emitter
function ReceivedSetEmitter()
{
    local string temp;
    local float floatNumber;
	local vector colorVec, vel, sizeRange, fade;
	local range realRange;
	local rangeVector realSizeRange;

	if ((thebot == none) || (theBot.Pawn == none))
		return;

	temp = GetArgVal("Disable");
	if (temp != "")
	{
    	if (bool(temp))
    	{
    		if (ScenarioBot(theBot).EmotionEmit != none)
			{
				ScenarioBot(theBot).EmotionEmit.Kill();
				ScenarioBot(theBot).EmotionEmit.Destroy();
				return;
			}
    	}
	}

	if (ScenarioBot(theBot).EmotionEmit == none)
	{
		ScenarioBot(theBot).EmotionEmit = Spawn(class'EmotionEmitter', theBot.Pawn,, theBot.Pawn.Location, theBot.Pawn.Rotation);
	}
	ScenarioBot(theBot).EmotionEmit.SetLocation(theBot.Pawn.Location);
	if (theBot.Pawn.IsA('GBCivilPawn') || theBot.Pawn.IsA('ExamplePawn'))
		theBot.Pawn.AttachToBone(ScenarioBot(theBot).EmotionEmit,'HeadBone');
	else
		theBot.Pawn.AttachToBone(ScenarioBot(theBot).EmotionEmit,'head');


	temp = GetArgVal("Pause");
	if (temp != "")
	{
    	if (bool(temp))
    		ScenarioBot(theBot).EmotionEmit.PauseParticles();
    	else
        	ScenarioBot(theBot).EmotionEmit.ResumeParticles();
	}

	if (GetArgVal("FirstC") != "")
	{
		parseVector(colorVec, "FirstC");

		ScenarioBot(theBot).EmotionEmit.SetFirstColor(class'Canvas'.Static.MakeColor(int(colorVec.x),int(colorVec.y),int(colorVec.z)));
	}

	if (GetArgVal("SecondC") != "")
	{
		parseVector(colorVec, "SecondC");

		ScenarioBot(theBot).EmotionEmit.SetSecondColor(class'Canvas'.Static.MakeColor(int(colorVec.x),int(colorVec.y),int(colorVec.z)));
	}

	if (GetArgVal("StartVelocity") != "")
	{
		parseVector(vel, "StartVelocity");
		ScenarioBot(theBot).EmotionEmit.SetStartRelativeVelocity(vel);
	}

	if (GetArgVal("EndVelocity") != "")
	{
		parseVector(vel, "EndVelocity");
		ScenarioBot(theBot).EmotionEmit.SetEndRelativeVelocity(vel);
	}

	if (GetArgVal("VelocityRange") != "")
	{
		floatNumber = float(GetArgVal("VelocityRange"));
		realRange.Max = floatNumber;
		realRange.Min = floatNumber;
		ScenarioBot(theBot).EmotionEmit.SetVelocityRange(realRange);
	}

	if (GetArgVal("Size") != "")
	{
		parseVector(sizeRange, "Size");
		realSizeRange.X.Max = sizeRange.X;
		realSizeRange.X.Min = sizeRange.X;
		realSizeRange.Y.Max = sizeRange.Y;
		realSizeRange.Y.Min = sizeRange.Y;
		realSizeRange.Z.Max = sizeRange.Z;
		realSizeRange.Z.Min = sizeRange.Z;
		ScenarioBot(theBot).EmotionEmit.SetStartSize(realSizeRange);
	}

	if (GetArgVal("LifeTime") != "")
	{
		floatNumber = float(GetArgVal("LifeTime"));
		realRange.Max = floatNumber;
		realRange.Min = floatNumber;
		ScenarioBot(theBot).EmotionEmit.SetLifeTime(realRange);
	}

	if (GetArgVal("FadeTime") != "")
	{
		parseVector(fade, "FadeTime");
		ScenarioBot(theBot).EmotionEmit.SetFadeTime(fade.X, fade.Y);
	}
}

defaultproperties
{
    bAllowPause=True
}
