//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ScenarioBot extends RemoteBot;

var EmotionEmitter EmotionEmit;

var bool bExportAllPlayers;

//Notifies us when we got inventory from other bot
function NotifyGotInventory(RemoteBot giver, RemoteBot receiver, class<Pickup> tempPickup){

	local string outstring;

	outstring = "GOT {From " $ myConnection.GetUniqueId(giver) $
		"} {To " $ myConnection.GetUniqueId(receiver) $
		"} {ItemType " $ tempPickup $ "}";

	myConnection.SendLine(outstring);
}

event Destroyed()
{
	//destroy emotional emitter
	if (EmotionEmit != none)
		EmotionEmit.Destroy();
	super.Destroyed();
}

//Modified this, so our bot can fall even with walking on
event MayFall()
{
	super.MayFall();
	//Modified this, so our bot can fall even with walking on
	Pawn.bCanJump = true;
}

function checkVision()
{
	local Pickup Pickup; //Respawned Inventory on the map is now Pickup;
	local Mover M;
	local Controller C;
	local CTFFlag F;
	local NavigationPoint N;
	local xBombFlag B;
	local Vehicle Veh;
//	local vector HitL, HitN;
	local int temp;
	local string outstring, TeamIndex, WeaponClass;
	local bool flagVisible;

	//for PRJ
	local Projectile Proj;
	local vector FireDir;
	local float projDistance;

	if( Pawn == none )
	{
		log("In CheckVision() - Pawn is none ");
		return;
	}

	//!!! view rotation sometimes falls out of synch with rotation? wtf?

	for ( C=Level.ControllerList; C!=None; C=C.NextController )
	{
		//hack with bExportAllPlayers used so we can actually get all the players on the server for our Scenario
		if( (bExportAllPlayers && (C != self) ) || ((C != self && C.Pawn != none && CanSee(C.Pawn)) ||
			(C != self && C.Pawn != none && (VSize(C.Pawn.Location - Pawn.Location) < 300)))
			)//to match peripheral vision + if the bot is close enough
		{

			if(Level.Game.isA('BotTeamGame'))
			{
				TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
			}
			else
			{
    			TeamIndex = "255";
			}
			if (C.Pawn.Weapon != none)
			{
				WeaponClass = string(C.Pawn.Weapon.Class);
			}
			else
			{
				WeaponClass = "None";
			}
			outstring = "PLR {Id " $ myConnection.GetUniqueId(C) $
				"} {Rotation " $ C.Pawn.Rotation $
				"} {Location " $ C.Pawn.Location $
				"} {Velocity " $ C.Pawn.Velocity $
				"} {Name " $ C.PlayerReplicationInfo.PlayerName $
				"} {Team " $ TeamIndex $
				"} {Reachable " $ actorReachable(C.Pawn) $
				"} {Weapon " $ WeaponClass $
				"}";

			if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(0).IsFiring() )
				outstring = outstring $" {Firing 1}";
			else if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(1).IsFiring() )
				outstring = outstring $" {Firing 2}";
			else
				outstring = outstring $" {Firing 0}";

			myConnection.sendLine(outstring);

        }//end if
	}//end for P=Level.ControllerList
	bExportAllPlayers = false;

	foreach DynamicActors(class'Pickup',Pickup)
	{
		if( (Pickup.GetStateName() == 'Pickup') && !Pickup.bHidden && inFront(Pickup.Location) && LineOfSightTo(Pickup) )
		{
			myConnection.SendLine("INV {Id " $ myConnection.GetUniqueId(Pickup) $
				"} {Location " $ Pickup.Location $
				"} {Amount " $ myConnection.GetItemAmount(Pickup) $
				"} {Reachable " $ actorReachable(Pickup) $
				"} {Visible True" $ //for compatibility reasons, we know its true due to the check up in if statement
				"} {Dropped " $ Pickup.bDropped $
				"} {Type " $ Pickup.Class $
				"}");

		}
	}

	foreach AllActors(class'Mover',M)
	{
		if( !M.bHidden && inFront(M.Location) && LineOfSightTo(M) )//&& Pawn.FastTrace(M.Location) )
		{
			outstring = "MOV {Id " $ M $
				"} {Location " $ M.Location $
				"} {Reachable " $ actorReachable(M) $ //not sure if this works for lifts(bots may be forced to wait for lift)
				"} {Visible True" $ //for compatibility reasons, we know its true due to the check up in if statement
				"} {DamageTrig " $ M.bDamageTriggered $
				"} {Type " $ M.Class $
				"} {IsMoving " $ M.bInterpolating $
				"} {Velocity " $ M.Velocity $
				"}";

			myConnection.SendLine(outstring);
		}
	}

	foreach DynamicActors(class'Projectile',Proj)
	{

		if (Proj.IsA('FlakChunk'))
			FireDir = Normal(Proj.Velocity);
		else
			FireDir = vector(Proj.Rotation);

		if ( LineOfSightTo(Proj) && inFront(Proj.Location))
		{
			projDistance = VSize(Pawn.Location - Proj.Location);

			myConnection.SendLine("PRJ {Id " $ myConnection.GetUniqueId(Proj) $
				"} {Time " $ (projDistance/Proj.Speed) $
				"} {Direction " $ FireDir $
				"} {Speed " $ Proj.Speed $
				"} {Velocity " $ Proj.Velocity $
				"} {Location " $ Proj.Location $
				"} {Origin " $ Proj.Instigator.Location $
				"} {DamageRadius " $ Proj.DamageRadius $
				"} {Type " $ Proj.Class $
				"}");
		}

	}//end PRJ

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		//Added attribute Visible, so inFront is not here anymore
		if( LineOfSightTo(N))//FastTrace(N.Location) )
		{
			//ControlPoint is now xDomPoint
			if(N.IsA('xDomPoint'))
			{
				if( xDomPoint(N).ControllingTeam == none )
					temp = 255;
				else
					temp = xDomPoint(N).ControllingTeam.TeamIndex;

				myConnection.SendLine("DOM {Id " $ N $
					"} {Visible " $ inFront( N.Location ) $
					"} {Reachable " $ actorReachable(N) $
					"} {Controller " $ temp $
					"}");

			}
			else
			{
				outstring = "NAV {Id " $ N $
					"} {Location " $ N.Location $
					"} {Visible " $ inFront( N.Location ) $
					"} {Reachable " $ actorReachable(N) $
					"}";
			/*	Location returned to all NavPoints for now
			if (N.IsA('LiftCenter'))
   				{
   					outstring = outstring $ " {Location "$ N.Location $"}";
   				}*/
				myConnection.SendLine(outstring);
			}
		}
	}//end for N=Level.NavigationPointList
}

DefaultProperties
{

}
