//-----------------------------------------------------------
//
//-----------------------------------------------------------
class GBCivilPawn extends GBxPawn;

var bool bKarmaDisabled;

// overridden to allow disabling of Karma
function PlayDyingAnimation(class<DamageType> DamageType, vector HitLoc)
{
	if ( !bKarmaDisabled )
	   super.PlayDyingAnimation(DamageType, HitLoc);
	else  {
	   // non-ragdoll death fallback
    	Velocity += TearOffMomentum;
        BaseEyeHeight = Default.BaseEyeHeight;
        SetTwistLook(0, 0);
        SetInvisibility(0.0);
        PlayDirectionalDeath(HitLoc);
        SetPhysics(PHYS_Falling);
    }
}

DefaultProperties
{
    bKarmaDisabled=False
}