class ExamplePawn extends GBxPawn;

const LANDINGCHANNEL = 12;

var name DanceAnim;

var name JumpStandingAnim;
var name JumpMovingAnim;
var name LandAnim;
var name FallingAnim;

var bool bStartBehindView;

var bool bPlayedAnimAction;

event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType)
{
	// Never take damage or die
}

//Called when this pawn is possessed by the controller to see how the view should be
simulated function bool PointOfView()
{
	return bStartBehindView;
}

//Called to have all clients play a single animation in the idle animation channel
simulated event SetAnimAction(name NewAction)
{
	AnimAction = NewAction;
	PlayAnim(NewAction, 1.0, 0.2); //Play on base channel, which is the idle channel
	bPlayedAnimAction = true;
}

// Sets up Physics correctly for Scripted Sequences
function SetMovementPhysics()
{
	if (Physics == PHYS_Falling)
		return;
	if ( PhysicsVolume.bWaterVolume )
		SetPhysics(PHYS_Swimming);
	else
		SetPhysics(PHYS_Walking);
}

simulated function Setup(xUtil.PlayerRecord rec, bool bLoadNow)
{

}

defaultproperties
{
	//These need to be defined or else it will not animate in net play
	MovementAnims[0]="RunF"
	MovementAnims[1]="RunB"
	MovementAnims[2]="RunL"
	MovementAnims[3]="RunR"

    WalkAnims[0]="WalkF"
	WalkAnims[1]="WalkB"
	WalkAnims[2]="WalkL"
	WalkAnims[3]="WalkR"
	CrouchAnims[0]="CrouchF"
	CrouchAnims[1]="CrouchB"
	CrouchAnims[2]="CrouchL"
	CrouchAnims[3]="CrouchR"
	AirAnims[0]="FlyF"
	AirAnims[1]="FlyB"
	AirAnims[2]="FlyL"
	AirAnims[3]="FlyR"
	SwimAnims[0]="Swim"
	SwimAnims[1]="SwimB"
	SwimAnims[2]="SwimL"
	SwimAnims[3]="SwimR"

	TurnLeftAnim="WalkL"
	TurnRightAnim="WalkR"
	CrouchTurnLeftAnim="CrouchL"
	CrouchTurnRightAnim="CrouchR"

	IdleRestAnim="IdleLong"
	IdleCrouchAnim="CrouchIdle"
	AirStillAnim="FlyIdle"
	IdleSwimAnim="SwimTread"

    IdleWeaponAnim="IdleBreathe"
    IdleHeavyAnim="IdleBreathe"
    IdleRifleAnim="IdleBreathe"
    IdleChatAnim="IdleBreathe"

	JumpStandingAnim="JumpUp"
	JumpMovingAnim="JumpF"
	LandAnim="JumpFLand"
	FallingAnim="Falling"

    TakeoffAnims[0]="JumpFTakeoff"
    TakeoffAnims[1]="JumpFTakeoff"
    TakeoffAnims[2]="JumpFTakeoff"
    TakeoffAnims[3]="JumpFTakeoff"
    TakeoffStillAnim=

    LandAnims[0]="JumpLand"
    LandAnims[1]="JumpLand"
    LandAnims[2]="JumpLand"
    LandAnims[3]="JumpLand"

	bPhysicsAnimUpdate=true
	bSimulateGravity=true
	bCanCrouch=true
	bActorShadows=true
	BaseEyeHeight=100
	CollisionRadius=+00040.000000
	CollisionHeight=+00100.000000
	bStartBehindView=true
	JumpZ=500
	LODBias=5
}
