//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIPanel extends DGUIFramedComponent;

var array<DGUIComponent> Components;

function AddChild(DGUIComponent child)
{
    Components[Components.Length] = child;
}

simulated function Draw(Canvas C)
{
    local int i;

    super.Draw(C);

    for (i = 0; i < Components.Length; ++i) {
        Components[i].Draw(C);
    }
}

function string GetData()
{
    local string data, temp;
    local bool one;
    local int i;

    one = true;

    for (i = 0; i < Components.Length; ++i)
    {
        temp = Components[i].GetData();
        if (temp != "" && one)
        {
            data = data $ temp;
            one = false;
        }
        else if (temp != "")
        {
            data = data $ "&" $ temp;
        }
    }
    return data;
}

function OnClick(float X, float Y)
{
    local int i;
    local float X2, Y2;

    for (i = 0; i < Components.Length; ++i)
    {
        X2 = (X - Components[i].WinLeft)/Components[i].WinWidth;
        Y2 = (Y - Components[i].WinTop)/Components[i].WinHeight;
        if (X2 >= 0 && X2 < 1 && Y2 >= 0 && Y2 < 1)
        {
            Components[i].OnClick(X2, Y2);
            return;
        }
    }
}

DefaultProperties
{

}
