//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIOptionList extends DGUIComponent;

enum EOptionListMode {
    OLM_SINGLE,
    OLM_MULTI
};

var EOptionListMode Mode;
var array<DGUIOption> Options;

function AddChild(DGUIComponent child)
{
    if (child.IsA('DGUIOption'))
    {
        Options[Options.Length] = DGUIOption(child);
    }
}

simulated function DrawOn(Canvas C, float x, float y, float w, float h)
{
    local int i;
    local float ow, oh;
    local float oy;

    oy = y;
    for (i = 0; i < Options.Length; ++i)
    {
         Options[i].GetNeededSize(C, ow, oh);
         Options[i].SetSize(ow/w, oh/h);
         Options[i].SetPosition(0, (oy - y)/h);
         Options[i].DrawOn(C, x, oy, ow, oh);
         oy += oh;
    }
}

function string GetData() {
    local int i;
    local string data;
    local bool one;

    data = Id $ "=";
    one = true;
    for (i = 0; i < Options.Length; ++i)
    {
        if (Options[i].bChecked)
        {
            if (one)
            {
                data $= Options[i].Id;
            }
            else
            {
                data $= "," $ Options[i].Id;
            }
            one = false;
        }
    }
    return data;
}

function OnClick(float X, float Y)
{
    local int i;
    local float X2, Y2;

    for (i = 0; i < Options.Length; ++i)
    {
        X2 = (X - Options[i].WinLeft)/Options[i].WinWidth;
        Y2 = (Y - Options[i].WinTop)/Options[i].WinHeight;
        if (X2 >= 0 && X2 < 1 && Y2 >= 0 && Y2 < 1)
        {
            Options[i].OnClick(X, Y);
            return;
        }
    }
}

function OptionClicked(DGUIOption opt)
{
    local int i;

    switch (Mode)
    {
    case OLM_SINGLE:
        for (i = 0; i < Options.Length; ++i)
        {
            Options[i].bChecked = (Options[i] == opt);
        }
        break;
    case OLM_MULTI:
        for (i = 0; i < Options.Length; ++i)
        {
            if (Options[i] == opt)
            {
                Options[i].bChecked = !Options[i].bChecked;
            }
        }
        break;
    }
}

function SetMode(string m)
{
    m = Caps(m);
    switch (m)
    {
    case "SINGLE":
        Mode = OLM_SINGLE;
        break;
    case "MULTI":
        Mode = OLM_MULTI;
        break;
    }
}

defaultproperties
{
    Mode = OLM_SINGLE;
}
