//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIOption extends DGUIComponent;

var texture CheckedTexture;
var texture NotCheckedTexture;
var string Text;
var color TextColor;
var bool bChecked;

function DrawOn(Canvas C, float x, float y, float w, float h)
{
    local texture actTexture;
    local float tw, th;

    C.SetDrawColor(255, 255, 255);
    if (bChecked)
        actTexture = CheckedTexture;
    else
        actTexture = NotCheckedTexture;
    C.CurX = x;
    C.CurY = y + (h - actTexture.VSize)/2;
    C.DrawIcon(actTexture, 1);
    C.CurX = x + float(actTexture.USize)*1.5;
    C.TextSize(Text, tw, th);
    C.CurY = y + (h - th)/2;
    C.DrawColor = TextColor;
    C.DrawTextClipped(Text);
}

function GetNeededSize(Canvas C, out float w, out float h)
{
    local float tw, th;
    if (bChecked)
    {
        w = CheckedTexture.USize;
        h = CheckedTexture.VSize;
    }
    else
    {
        w = NotCheckedTexture.USize;
        h = NotCheckedTexture.VSize;
    }
    C.TextSize(Text, tw, th);
    if (th > h)
        h = th;
    w = w*1.5 + tw;
}

function OnClick(float X, float Y)
{
    DGUIOptionList(Parent).OptionClicked(self);
}

function SetCheckedTexture(string tex)
{
    if (tex != "")
        CheckedTexture = texture(DynamicLoadObject(tex, class'Texture'));
}

function SetNotCheckedTexture(string tex)
{
    if (tex != "")
        NotCheckedTexture = texture(DynamicLoadObject(tex, class'Texture'));
}

function SetText(string t)
{
    Text = t;
}

function SetTextColor(color c)
{
    TextColor = c;
}

DefaultProperties
{
    TextColor=(R=0,G=0,B=0,A=255);
    NotCheckedTexture = texture'2K4Menus.Controls.checkBoxBall_b';
    CheckedTexture = texture'2K4Menus.Controls.checkBoxBall_p';
}
