//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIImage extends DGUIComponent;

var texture Image;
var float OriginX, OriginY;
var float ScaleX, ScaleY;
var string Action;
var float LastX, LastY;
var float RealWidth, RealHeight;

function string GetData()
{
    local string data;

    data = Id $ ".ClickX=" $ LastX $ "&" $ Id $ ".ClickY=" $ LastY $ "&";
    data $= Id $ ".Width=" $ Image.USize $ "&" $ Id $ ".Height=" $ Image.VSize;
    data $= "&" $ Id $ ".DisplayedWidth=" $ RealWidth $ "&" $ Id;
    data $= ".DisplayedHeight=" $ RealHeight;
    return data;
}

function OnClick(float X, float Y) {

    LastX = RealWidth*X;
    LastY = RealHeight*Y;
    Action = Caps(Action);
    switch (Action)
    {
    case "":
        //do nothing
        break;
    case "CANCEL":
        GetDialog().Cancel(Id);
        break;
    case "RESET":
        GetDialog().MainPanel.Reset();
        break;
    case "SUBMIT":
        GetDialog().Submit(Id);
        break;
    default:
        GetDialog().Command(Action, Id);
    }
}

simulated function DrawOn(Canvas C, float x, float y, float w, float h)
{
    RealWidth = w;
    RealHeight = h;
    C.SetPos(x, y);
    C.SetDrawColor(255, 255, 255, 255);
    C.DrawTile(Image, w, h, OriginX, OriginY, w*ScaleX, h*ScaleY);
}

function SetAction(String a)
{
    Action = a;
}

function SetImage(String img)
{
    Image = Texture(DynamicLoadObject(img, class'Texture'));
}

function SetOrigin(float x, float y)
{
    OriginX = x;
    OriginY = y;
}

function SetScale(float sx, float sy)
{
    ScaleX = sx;
    ScaleY = sy;
}

DefaultProperties
{
    LastX = -1;
    LastY = -1;
    ScaleX = 1;
    ScaleY = 1;
    OriginX = 0;
    OriginY = 0;
}
