//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIFramedComponent extends DGUIComponent
    abstract;

var color BgColor;
var texture Background;
var color Border;

simulated function DrawOn(Canvas C, float x, float y, float w, float h)
{
    DrawBackgroundOn(C, x, y, w, h);
    DrawBorderOn(C, x, y, w, h);
}

simulated function DrawBackgroundOn(Canvas C, float x, float y, float w, float h) {
    C.SetPos(x, y);
    C.DrawColor = BgColor;
    C.DrawRect(Background, w, h);
}

simulated function DrawBorderOn(Canvas C, float x, float y, float w, float h) {
    C.SetPos(x, y);
    C.DrawColor = Border;
    C.DrawBox(C, w, h);
}

function SetBackground(string bg)
{
    if (bg != "")
    {
        Background = Texture(DynamicLoadObject(bg, class'Texture'));
    }
}

function SetBgColor(color bgc)
{
    BgColor = bgc;
}

function SetBorder(color b)
{
    Border = b;
}

DefaultProperties
{
    Background = Texture'engine.WhiteSquareTexture';
    BgColor=(R=255,G=255,B=255,A=255);
    Border=(R=0,G=0,B=0,A=255);
}
