//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIDialog extends DynamicGUI;

var ScenarioHUD HUD;
var bool bShown;
var ScenarioControlConnection Connection;
var ScenarioxPlayer Player;
var DGUIPanel MainPanel;
var string Id;

var array<DGUIComponent> Items;

function AddItem()
{
    local DGUIComponent NewItem;
    local DGUIComponent ItemParent;
    local string temp;
    local float x, y, w, h;
    local color col;

    temp = Connection.GetArgVal("Parent");
    if (temp != "")
    {
        ItemParent = FindItem(temp);
    }
    if (ItemParent == none)
    {
        ItemParent = MainPanel;
    }

    switch (Caps(Connection.GetArgVal("Type")))
    {
    case "PANEL":
        NewItem = new(Self) class'DGUIPanel';
        DGUIPanel(NewItem).SetBackground(Connection.GetArgVal("Background"));
        Connection.ParseColor(col, "BgColor");
        DGUIPanel(NewItem).SetBgColor(col);
        Connection.ParseColor(col, "Border");
        DGUIPanel(NewItem).SetBorder(col);
        if (MainPanel == none)
        {
            MainPanel = DGUIPanel(NewItem);
        }
        break;
    case "BUTTON":
        NewItem = new(Self) class'DGUIButton';
        DGUIButton(NewItem).SetText(Connection.GetArgVal("Text"));
        Connection.ParseColor(col, "TextColor");
        DGUIButton(NewItem).SetTextColor(col);
        DGUIButton(NewItem).SetAction(Connection.GetArgVal("Action"));
        DGUIButton(NewItem).SetBackground(Connection.GetArgVal("Background"));
        Connection.ParseColor(col, "BgColor");
        DGUIButton(NewItem).SetBgColor(col);
        Connection.ParseColor(col, "Border");
        DGUIButton(NewItem).SetBorder(col);
        break;
    case "TEXT":
        NewItem = new(Self) class'DGUIText';
        DGUIText(NewItem).SetText(Connection.GetArgVal("Text"));
        Connection.ParseColor(col, "TextColor");
        DGUIText(NewItem).SetTextColor(col);
        break;
    case "OPTIONLIST":
        NewItem = new (Self) class'DGUIOptionList';
        DGUIOptionList(NewItem).SetMode(Connection.GetArgVal("Mode"));
        break;
    case "OPTION":
        NewItem = new (Self) class'DGUIOption';
        DGUIOption(NewItem).SetText(Connection.GetArgVal("Text"));
        Connection.ParseColor(col, "TextColor");
        DGUIOption(NewItem).SetTextColor(col);
        DGUIOption(NewItem).SetNotCheckedTexture(Connection.GetArgVal("NotChecked"));
        DGUIOption(NewItem).SetCheckedTexture(Connection.GetArgVal("Checked"));
        break;
    case "IMAGE":
        NewItem = new(Self) class'DGUIImage';
        DGUIImage(NewItem).SetImage(Connection.GetArgVal("Image"));
        DGUIImage(NewItem).SetAction(Connection.GetArgVal("Action"));
        Connection.ParseDimension(w, h, "Scale");
        DGUIImage(NewItem).SetScale(w, h);
        Connection.ParsePoint(x, y, "Origin");
        DGUIImage(NewItem).SetOrigin(x, y);
        break;
    default:
        return;
    }

    NewItem.SetId(Connection.GetArgVal("Id"));
    Connection.ParsePoint(x, y, "Position");
    NewItem.SetPosition(x, y);
    Connection.ParseDimension(w, h, "Size");
    NewItem.SetSize(w, h);


    NewItem.Parent = ItemParent;
    if (ItemParent != none)
    { //this happens only for MainPanel
        ItemParent.AddChild(NewItem);
    }
    NewItem.Dialog = self;
    Items[Items.Length] = NewItem;
}

function EditItem() {
    local DGUIComponent Item;
    local string temp;
    local color col;
    local float x, y, w, h;

    Item = FindItem(Connection.GetArgVal("Id"));
    if (Item != none)
    {
        // GENERAL
        if (Connection.GetArgVal("Position") != "")
        {
            Connection.ParsePoint(x, y, "Position");
            Item.SetPosition(x, y);
        }
        if (Connection.GetArgVal("Size") != "")
        {
            Connection.ParseDimension(w, h, "Size");
            Item.SetSize(w, h);
        }
        // FRAMED
        if (Item.IsA('DGUIFramedComponent'))
        {
            temp = Connection.GetArgVal("Background");
            if (temp != "")
            {
                DGUIFramedComponent(Item).SetBackground(temp);
            }
            if (Connection.GetArgVal("BgColor") != "")
            {
                Connection.ParseColor(col, "BgColor");
                DGUIFramedComponent(Item).SetBgColor(col);
            }
            if (Connection.GetArgVal("Border") != "")
            {
                Connection.ParseColor(col, "Border");
                DGUIFramedComponent(Item).SetBorder(col);
            }
        }
        // BUTTON
        if (Item.IsA('DGUIButton'))
        {
            temp = Connection.GetArgVal("Text");
            if (temp != "")
            {
                DGUIButton(Item).SetText(temp);
            }
            if (Connection.GetArgVal("TextColor") != "")
            {
                Connection.ParseColor(col, "TextColor");
                DGUIButton(Item).SetTextColor(col);
            }
            temp = Connection.GetArgVal("Action");
            if (temp != "")
                DGUIButton(Item).SetAction(temp);
        }
        else if (Item.IsA('DGUIText'))
        {
            temp = Connection.GetArgVal("Text");
            if (temp != "")
                DGUIText(Item).SetText(temp);
            if (Connection.GetArgVal("TextColor") != "")
            {
                Connection.ParseColor(col, "TextColor");
                DGUIText(Item).SetTextColor(col);
            }
        }
        else if (Item.IsA('DGUIOptionList'))
        {
            temp = Connection.GetArgVal("Mode");
            if (temp != "")
                DGUIOptionList(Item).SetMode(temp);
        }
        else if (Item.IsA('DGUIOption'))
        {
            temp = Connection.GetArgVal("Text");
            if (temp != "")
                DGUIOption(Item).SetText(temp);
            if (Connection.GetArgVal("TextColor") != "")
            {
                Connection.ParseColor(col, "TextColor");
                DGUIOption(Item).SetTextColor(col);
            }
            temp = Connection.GetArgVal("NotChecked");
            if (temp != "")
                DGUIOption(Item).SetNotCheckedTexture(temp);
            temp = Connection.GetArgVal("Checked");
            if (temp != "")
                DGUIOption(Item).SetCheckedTexture(temp);
        }
        else if (Item.IsA('DGUIImage'))
        {
            temp = Connection.GetArgVal("Image");
            if (temp != "")
                DGUIImage(Item).SetImage(temp);
            temp = Connection.GetArgVal("Action");
            if (temp != "")
                DGUIImage(Item).SetAction(temp);
            if (Connection.GetArgVal("Scale") != "")
            {
                Connection.ParseDimension(w, h, "Scale");
                DGUIImage(Item).SetScale(w, h);
            }
            if (Connection.GetArgVal("Origin") != "")
            {
                Connection.ParsePoint(x, y, "Origin");
                DGUIImage(Item).SetOrigin(x, y);
            }
        }
    }
}

function DGUIComponent FindItem(string itemId)
{
    local int i;

    for (i = 0; i < Items.Length; ++i)
    {
        if (Items[i].Id ~= itemId)
        {
            return Items[i];
        }
    }
    return none;
}

function Cancel(string sourceId)
{
    Connection.SendLine("DLGCMD {Id " $ Id $ "} {SourceId " $ sourceId $ "} {Command CANCEL} {Data " $ MainPanel.GetData() $ "}");
    Connection.DialogFinished(self);
}

function Command(string c, string sourceId)
{
    Connection.SendLine("DLGCMD {Id " $ Id $ "} {SourceId " $ sourceId $ "} {Command " $ c $ "} {Data " $ MainPanel.GetData() $ "}");
}

simulated function Draw(Canvas C)
{
    if (MainPanel != none)
    {
        MainPanel.Draw(C);
    }
}

function bool OnClick(float X, float Y)
{
    if (MainPanel != none)
    {
        X = (X - MainPanel.WinLeft)/MainPanel.WinWidth;
        Y = (Y - MainPanel.WinTop)/MainPanel.WinHeight;
        if (X >= 0 && X < 1 && Y >= 0 && Y < 1)
        {
            MainPanel.OnClick(X, Y);
            return true;
        }
    }
    return false;
}

function Reset()
{
    local int i;

    for (i = 0; i < Items.Length; ++i)
    {
        Items[i].Reset();
    }
}

function SetConnection(ScenarioControlConnection c)
{
    Connection = c;
}

function SetGBHUD(ScenarioHUD h)
{
    HUD = h;
}

function SetPlayer(ScenarioxPlayer p)
{
    Player = p;
}

function SetId(string i)
{
    Id = i;
}

function Submit(string sourceId)
{
    Connection.SendLine("DLGCMD {Id " $ Id $ "} {SourceId " $ sourceId $ "} {Command SUBMIT} {Data " $ MainPanel.GetData() $ "}");
    Connection.DialogFinished(Self);
}

function Hide()
{
    if (bShown)
    {
        HUD.PopDialogUntil(Self);
    }
    bShown = false;
}

function Show()
{
    if (!bShown)
    {
        HUD.PushDialog(Self);
    }
    bShown = true;
}

defaultproperties
{

}
