//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIComponent extends DynamicGUI
    abstract;

var float WinLeft, WinTop;
var float WinWidth, WinHeight;
var DGUIComponent Parent;
var DGUIDialog Dialog;
var string Id;

function AddChild(DGUIComponent child);
simulated function DrawOn(Canvas C, float x, float y, float w, float h);
function OnClick(float X, float Y);
function Reset();

simulated function Draw(Canvas C)
{
    local float x, y, w, h;

    GetRealCoords(C, x, y, w, h);
    DrawOn(C, x, y, w, h);
}

function string GetData()
{
    return "";
}

function DGUIDialog GetDialog()
{
    return Dialog;
}

function GetRealCoords(Canvas C, out float X, out float Y, out float W, out float H)
{
    if (Parent == None)
    {
        X = WinLeft*C.SizeX;
        Y = WinTop*C.SizeY;
        W = WinWidth*C.SizeX;
        H = WinHeight*C.SizeY;
    }
    else
    {
        Parent.GetRealCoords(C, X, Y, W, H);
        X = X + WinLeft*W;
        Y = Y + WinTop*H;
        W = WinWidth*W;
        H = WinHeight*H;
    }
}

function SetId(string i)
{
    Id = i;
}

function SetPosition(float x, float y)
{
    WinLeft = x;
    WinTop = y;
}

function SetSize(float w, float h)
{
    WinWidth = w;
    WinHeight = h;
}

DefaultProperties
{
    WinLeft = 0;
    WinTop = 0;
    WinWidth = 0.5;
    WinHeight = 0.5;
    Parent = none;
}
