//-----------------------------------------------------------
//
//-----------------------------------------------------------
class DGUIButton extends DGUIFramedComponent;

var string Text;
var color TextColor;
var string Action;

function OnClick(float X, float Y) {
    Action = Caps(Action);
    switch (Action)
    {
    case "CANCEL":
        GetDialog().Cancel(Id);
        break;
    case "RESET":
        GetDialog().MainPanel.Reset();
        break;
    case "SUBMIT":
        GetDialog().Submit(Id);
        break;
    default:
        GetDialog().Command(Action, Id);
    }
}

simulated function DrawOn(Canvas C, float x, float y, float w, float h)
{
    local float tw, th;

    super.DrawOn(C, x, y, w, h);

    C.DrawColor = TextColor;
    C.Font = C.MedFont;
    C.TextSize (Text, tw, th);
    C.SetPos (x + (w - tw)/2, y + (h - th)/2);
    C.DrawTextClipped(Text);
}

function SetText(string t)
{
    Text = t;
}

function SetTextColor(color c)
{
    TextColor = c;
}

function SetAction(string a)
{
    if (a != "")
    {
        Action = a;
    }
}

DefaultProperties
{
    TextColor=(R=0,G=0,B=0,A=255);
    Text="No text";
    Action="SUBMIT";
}
