/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import java.io.Serializable;

/**
 * Used for rotation logging - rotation is not serializable.
 * 
 * @author Knight
 */
public class RotationLog implements Serializable {
    
    /**
     * Rotation pitch (up and down).
     */
    public double pitch = -1;
    /**
     * Rotation roll - similiar of doing a cartwheel.
     */
    public double roll = -1;
    /**
     * Rotation yaw (left or right)
     */
    public double yaw = -1;

    /**
     * Constructor.
     * 
     * @param rot
     */
    public RotationLog(Rotation rot) {
        if (rot != null){
            this.pitch = rot.getPitch();
            this.roll = rot.getRoll();
            this.yaw = rot.getYaw();
        }
    }
}
