/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import almabasedmodel.AMood;
import java.io.Serializable;

/**
 * Here we store the mood snapshot of the agent taken at certain time in the scenario.
 *
 * @author Knight
 */
public class MoodLog implements Serializable {

    /** Time of the mood snapshot. */
    public double time = 0;
    /** Pleasure mood dimension */
    public double pleasure = 0;
    /** Arousal mood dimension */
    public double arousal = 0;
    /** Dominance mood dimension */
    public double dominance = 0;

    /**
     * Constructor.
     *
     * @param time
     * @param pleasure
     * @param arousal
     * @param dominance
     */
    public MoodLog(double time, double pleasure, double arousal, double dominance) {
        this.time = time;
        this.pleasure = pleasure;
        this.arousal = arousal;
        this.dominance = dominance;
    }
    /**
     * Constructor. Takes ALMA mood object as an input.
     *
     * @param time
     * @param mood
     */
    public MoodLog(double time, AMood mood){
        this.time = time;
        pleasure = mood.getPleasure();
        arousal = mood.getArousal();
        dominance = mood.getDominance();
    }

}
