/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import info.ScenarioItemType;
import java.io.Serializable;

/**
 * Here we log items we have given to someone or received from someone.
 *
 * @author Knight
 */
public class ItemLog implements Serializable {

    /** Type of the item */
    public ScenarioItemType itemType;
    /** Agent we have received item from or agent we have given item to */
    public int agentId;
    /** Name of the agent */
    public String agentName;
    /** true if we have received the item */
    public boolean bReceived;
    /** Feeling toward the agent at the time of receiving/giving of the item */
    public double feeling;
    /** Time we have given or received the item */
    public double time;

    /**
     * Constructor for this class.
     *
     * @param itemType
     * @param agentId
     * @param agentName
     * @param bReceived
     * @param feeling
     * @param time
     */
    public ItemLog(ScenarioItemType itemType, int agentId, String agentName, boolean bReceived, double feeling, double time) {
        this.itemType = itemType;
        this.agentId = agentId;
        this.agentName = agentName;
        this.bReceived = bReceived;
        this.feeling = feeling;
        this.time = time;
    }
}