/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import org.jfree.data.Range;

/**
 * Object used for analyzing our scenario. Here we hold a feeling development for
 * one sub-scene in the scenario.
 * 
 * @author Knight
 */
public class FeelingSceneResult {

    /**
     * Id of the agent the feeling attitude here is connected to.
     */
    public int agentID;

    /**
     * Name of the agent the feeling attitude here is connected to.
     */
    public String agentName;

    /**
     * Feeling intensity at the beginning of the sub-scene.
     */
    public double startFeeling;

    /**
     * Feeling intensity at the end of the sub-scene.
     */
    public double endFeeling;

    /**
     * endFeeling - startFeeling
     */
    public double differenceFeeling;

    /**
     * Range of maximum and minimum feeling intensity during the sub-scene.
     */
    public Range feelingRange;

    /**
     * Constructor.
     *
     * @param agentID
     * @param agentName
     */
    public FeelingSceneResult(int agentID, String agentName) {
        this.agentID = agentID;
        this.agentName = agentName;
    }
}

