/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import java.io.Serializable;

/**
 * Used to store a feeling value of our agent toward other agent at certain time 
 * in our scenario.
 *
 * @author Knight
 */
public class FeelingLog implements Serializable {

    /**
     * The time the feeling value was captured.
     */
    public double time;

    /**
     * Id of the target agent.
     */
    public int agentId;

    /**
     * Name of the target agent.
     */
    public String agentName = "";

    /**
     * The feeling intensity.
     */
    public double intensity;

    /**
     * Limited constructor - we do not know agent's name.
     *
     * @param time
     * @param agentId
     * @param intensity
     */
    public FeelingLog(double time, int agentId, double intensity) {
        this.time = time;
        this.agentId = agentId;
        this.intensity = intensity;
    }

    /**
     * Complete constructor - we have all the infromation.
     *
     * @param time
     * @param agentId
     * @param agentName
     * @param intensity
     */
    public FeelingLog(double time, int agentId, String agentName, double intensity) {
        this.time = time;
        this.agentId = agentId;
        this.agentName = agentName;
        this.intensity = intensity;
    }        
}
