/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import info.EventId;
import java.io.Serializable;

/**
 * Here we sote one emotion event that we triggered in the scenario and send to ALMA
 * as an input.
 * 
 * @author Knight
 */
public class EmotionEventLog implements Serializable {

    /** Event id */
    public EventId eventId;
    /** The cause of the event */
    public String elicitor;
    /** If the cause is agent, here will be his name. */
    public String elicitorName;
    /** If the cause is agent, here will be his id. */
    public int elicitorId;
    /** Time when was this event triggered */
    public double time;
    /** Desirability variable */
    public double desirability;
    /** Praiseworthiness variable */
    public double praiseworthiness;
    /** Appealingness variable */
    public double appealingness;
    /** Likelihood variable */
    public double likelihood;
    /** Liking variable */
    public double liking;
    /** Realization variable */
    public double realization;
    /** Agency variable */
    public String agency;

    /**
     * Complete constructor.
     *
     * @param eventId
     * @param elicitor
     * @param elicitorName
     * @param elicitorId
     * @param time
     * @param desirability
     * @param praiseworthiness
     * @param appealingness
     * @param likelihood
     * @param liking
     * @param realization
     * @param agency
     */
    public EmotionEventLog(EventId eventId, String elicitor, String elicitorName, int elicitorId, double time, double desirability, double praiseworthiness, double appealingness, double likelihood, double liking, double realization, String agency) {
        this.eventId = eventId;
        this.elicitor = elicitor;
        this.elicitorName = elicitorName;
        this.elicitorId = elicitorId;
        this.time = time;
        this.desirability = desirability;
        this.praiseworthiness = praiseworthiness;
        this.appealingness = appealingness;
        this.likelihood = likelihood;
        this.liking = liking;
        this.realization = realization;
        this.agency = agency;
    }
}
