/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import info.PlaceType;
import info.StateType;
import java.io.Serializable;
import java.util.ArrayList;

/**
 * This class holds a snapshot of agent internal state at certain time in the
 * scenario.
 *
 * @author Knight
 */
public class AgentStateLog implements Serializable {

    /**
     * Time of the snapshot.
     */
    public double time;

    /**
     * Name of agentWith - may be empty (no agentWith at the time).
     */
    public String agentWithName;

    /**
     * Place our agent wanted to go at the time.
     */
    public PlaceType agentGoalPlace;

    /**
     * Location our agent wanted to go at the time.
     */
    public LocationLog agentGoalTarget;

    /**
     * State our agent was in at the time.
     */
    public StateType agentState;

    /**
     * Location our agent was at at the time.
     */
    public LocationLog agentLocation;

    /**
     * Rotation our agent had at the time.
     */
    public RotationLog agentRotation;

    /**
     * List of all the agent interruptes name - may be empty if no interrupters.
     */
    public ArrayList<String> interruptersNames;

    /**
     * Complete constructor.
     *
     * @param time
     * @param agentWithName
     * @param agentGoalPlace
     * @param agentGoalTarget
     * @param agentState
     * @param agentLocation
     * @param agentRotation
     * @param interruptersNames
     */
    public AgentStateLog(double time, String agentWithName, PlaceType agentGoalPlace, LocationLog agentGoalTarget, StateType agentState, LocationLog agentLocation, RotationLog agentRotation, ArrayList<String> interruptersNames) {
        this.time = time;
        this.agentWithName = agentWithName;
        this.agentGoalPlace = agentGoalPlace;
        this.agentGoalTarget = agentGoalTarget;
        this.agentState = agentState;
        this.agentLocation = agentLocation;
        this.agentRotation = agentRotation;
        this.interruptersNames = interruptersNames;
    }
}
