/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import almabasedmodel.AEmotion;
import almabasedmodel.AMood;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import info.*;
import info.EventId;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class provides a storage of all events, action, proposals and etc. occured
 * for one agent during the scenario. These information will be stored to Java binary
 * file for future analysis.
 *
 * @author Knight
 */
public class AgentLogging implements Serializable {

    /**
     * This was used so we can load the object even if we have done minor implementation
     * changes to some methods here
     */
    static final long serialVersionUID = -6548122598387696297L;

    /**
     * Name of the agent this storage is for.
     */
    public String agentName;

    /**
     * Filename of this storage.
     */
    public String fileName;

    /**
     * Id of the agent this storage is for.
     */
    public int agentId;

    /**
     * Agents action history.
     */
    public ArrayList<ActionLog> actionsHistory = new ArrayList<ActionLog>();

    /**
     * Agents proposal history.
     */
    public ArrayList<ProposalInfo> proposalsHistory = new ArrayList<ProposalInfo>();

    /**
     * Agents emotion history.
     */
    public ArrayList<EmotionsLog> emotionsHistory = new ArrayList<EmotionsLog>();

    /**
     * Agent emotion events history.
     */
    public ArrayList<EmotionEventLog> emotionEventsHistory = new ArrayList<EmotionEventLog>();

    /**
     * Agent feelings history.
     */
    public ArrayList<ArrayList<FeelingLog>> feelingsHistory = new ArrayList<ArrayList<FeelingLog>>();

    /**
     * Agent state history.
     */
    public ArrayList<AgentStateLog> agentStateHistory = new ArrayList<AgentStateLog>();

    /**
     * Agent item history.
     */
    public ArrayList<ItemLog> itemsHistory = new ArrayList<ItemLog>();

    /**
     * Agent mood history.
     */
    public ArrayList<MoodLog> moodHistory = new ArrayList<MoodLog>();

    /**
     * Method invoked at the end of the scenario - this class will be stored to
     * Java binary file.
     */
    public void finish() {
        // Create output stream.
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(fileName);

            //Binary object storing
            try {
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                // Write object.
                oos.writeObject(this);
                oos.close();
            } catch (IOException ex) {
                Logger.getLogger(AgentLogging.class.getName()).log(Level.SEVERE, null, ex);
            }

        } catch (FileNotFoundException ex) {
            Logger.getLogger(AgentLogging.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /**
     * Constructor.
     *
     * @param myName
     * @param fileName
     */
    public AgentLogging(String myName, String fileName) {
        this.agentName = myName;
        this.fileName = fileName;
    }

    /**
     * Constructor.
     *
     * @param agentName
     * @param fileName
     * @param agentId
     */
    public AgentLogging(String agentName, String fileName, int agentId) {
        this.agentName = agentName;
        this.fileName = fileName;
        this.agentId = agentId;
    }

    /**
     * This method is used to insert action in the actionsHistory.
     *
     * @param type
     * @param id
     * @param feeling
     * @param name
     * @param time
     * @param duration
     */
    public void insertAction(ActionType type, int id, double feeling, String name, double time, double duration) {
        ActionLog acLog = new ActionLog(type, id, feeling, name, time, duration);
        actionsHistory.add(acLog);
    }

    /**
     * This method is used to insert agent state to agentStateHistory.
     *
     * @param currentTime
     * @param agWithName
     * @param agentWith
     * @param myGoalPlace
     * @param myGoalTarget
     * @param state
     * @param location
     * @param rotation
     * @param interNames
     * @param inters
     */
    public void insertAgentState(double currentTime, String agWithName, Player agentWith, PlaceType myGoalPlace, Location myGoalTarget, StateType state, Location location, Rotation rotation, ArrayList<String> interNames, ArrayList<Player> inters) {
        //TODO: Player class is not serializable!!!
        AgentStateLog agStLog = new AgentStateLog(currentTime, agWithName, myGoalPlace, new LocationLog(myGoalTarget), state, new LocationLog(location), new RotationLog(rotation), interNames);
        agentStateHistory.add(agStLog);
    }

    /**
     * This method is used to emotion event into emotionEventsHistory.
     *
     * @param eventId
     * @param elicitor
     * @param elicitorName
     * @param elicitorId
     * @param time
     * @param desirability
     * @param praiseworthiness
     * @param appealingness
     * @param likelihood
     * @param liking
     * @param realization
     * @param agency
     */
    public void insertEmotionEvent(
            EventId eventId, String elicitor, String elicitorName,
            int elicitorId, double time, double desirability, double praiseworthiness,
            double appealingness, double likelihood, double liking, double realization,
            String agency) {

        EmotionEventLog emEvLog = new EmotionEventLog(eventId, elicitor, elicitorName,
                elicitorId, time, desirability, praiseworthiness, appealingness,
                likelihood, liking, realization, agency);
        emotionEventsHistory.add(emEvLog);
    }

    /**
     * Used for inserting emotion list into emotionsHistory.
     *
     * @param currentTime
     * @param currentEmotions
     */
    public void insertEmotions(double currentTime, ArrayList<AEmotion> currentEmotions) {
        EmotionsLog emLog = new EmotionsLog(currentTime, currentEmotions);
        emotionsHistory.add(emLog);
    }

    /**
     * Used for inserting feeling into feelingsHistory.
     *
     * @param feelLog
     */
    public void insertFeelings(ArrayList<FeelingLog> feelLog) {
        feelingsHistory.add(feelLog);
    }

    /**
     * Used for inserting item into itemsHistory.
     *
     * @param item
     * @param id
     * @param name
     * @param bReceived
     * @param feeling
     * @param time
     */
    public void insertItem(ScenarioItemType item, int id, String name, boolean bReceived, double feeling, double time) {
        ItemLog itLog = new ItemLog(item, id, name, bReceived, feeling, time);
        itemsHistory.add(itLog);
    }

    /**
     * Used for inserting the mood into moodHistory.
     *
     * @param currentTime
     * @param currentMood
     */
    public void insertMood(double currentTime, AMood currentMood) {
        MoodLog moodLog = new MoodLog(currentTime, currentMood);
        moodHistory.add(moodLog);
    }

    /**
     * Used for inserting proposal into proposalsHistory.
     *
     * @param agent
     * @param newProp
     */
    public void insertProposal(Player agent, ProposalInfo newProp) {
        proposalsHistory.add(newProp);
    }

    /**
     * Used for setting the agents Id (may not be known at the time this object
     * is created).
     *
     * @param id
     */
    public void setAgentId(int id) {
        this.agentId = id;
    }

}
