/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package logging;

import almabasedmodel.AEmotion;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import info.ActionType;
import info.PlaceType;
import info.ProposalInfo;
import info.StateType;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.String;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.ScatterRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultMultiValueCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * This class holds all the methods that are used to process AgentLogging objects
 * and create output graphs and files showing the scenario progress. A simple analysis
 * is conducted by the methods here to evaluate the believability and emergence of
 * the scenario.
 * For graph plotting we used free Java library JFreeChart.
 *
 * @author Knight
 */
public class AgentLogProcessor {

    //TODO: This should be in AgentLogging object :-/
    /** Cinema location */
    public Location cinemaLocation = new Location(922, 2200, -4556);////TrainingDay: new Location(2000,-900,-80);
    /** This should point in front of the cinema*/
    public Location meetingCinemaLocation = new Location(1400, 3000, -4556);
    /** Boy home location */
    public Location boyHomeLocation = new Location(7066, 2707, -4552); //TrainingDay: new Location(2000,-2200,-80);
    /** First girl home location - for Anne. */
    public Location firstGirlHomeLocation = new Location(6091, -437, -4552); //for anne
    /** First girl home location - for Clementine. */
    public Location secondGirlHomeLocation = new Location(-2173, 1134, -4556); //for clementine
    /** Park location */
    public Location parkLocation = new Location(1833, 168, -4558);

    //public static String fileName = "Scenario_Clementine2009.06.15_08.55.06.log";    
    public Object obj = null;
    final static boolean bAllowFrames = false;
    /**
     * Used in analyzeScenario method.
     * first string - who this is for anne/bruno/clem, second string - sceneId, third
     * string - targetAgent - name of the agent the feelings are
     */
    HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>> subsceneFeelingDifferences = new HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>>();
    /**
     * Filled in analyse scenario.
     * Stores the subscene end feeling.
     */
    HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>> subsceneFeelingEndValue = new HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>>();
    /**
     * same as above, except the first key is actual fileLog name
     */
    HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>> subsceneFeelingsFileLog = new HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>>();
    /**
     * Used in analyzeScenario method.
     */
    HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>> subsceneFeelingRanges = new HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>>();
    HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>> eventsFeelingDifferences = new HashMap<String, HashMap<String, HashMap<String, ArrayList<Double>>>>();

    /**
     * We will use this for proposals plotting, filled with makeAgenProposal method
     * required for complex emotions plot
     */
    HashMap<Integer, String> agentNamesMap = new HashMap<Integer, String>();
    /**
     * This is for mapping subscene Ids to int so we can manipulate with it better
     */
    HashMap<String, Integer> subsceneIdIntMap = new HashMap<String, Integer>();
    /**
     * Here we store all subscene strings for all agLog files. identifier is the name
     * of agLog file, the value is subscene string
     */
    HashMap<String, ArrayList<Integer>> subsceneStrings = new HashMap<String, ArrayList<Integer>>();
    public int subsceneIntId = 0;
    /**
     * Here we store two succesive actions (double actions) of one character to another character.
     */
    HashMap<String, HashMap<String, HashMap<String, HashMap<String, Integer>>>> agentSubscenesDoubleActions = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, Integer>>>>();
    HashMap<String, HashMap<String, HashMap<String, Integer>>> agentDoubleActions = new HashMap<String, HashMap<String, HashMap<String, Integer>>>();
    HashMap<String, HashMap<String, HashMap<String, HashMap<String, Integer>>>> agentSubscenesActionCounts = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, Integer>>>>();
    HashMap<String, HashMap<String, HashMap<String, Integer>>> agentActionCounts = new HashMap<String, HashMap<String, HashMap<String, Integer>>>();
    
    /**
     * Here we store the durations of subscens for each log file (first hash map key).
     * The sceneId(complete - also with time) is the second HashMap key.
     */
    HashMap<String, HashMap<String, Double>> subscenesDurations = new HashMap<String, HashMap<String, Double>>();
    /**
     * Idexed by pre-defined suspicious double actions ID, the list contains the filenames of
     * agentLog files that contains these suspicous doubleactions...
     */
    HashMap<String, ArrayList<String>> suspiciousDoubleActions = new HashMap<String, ArrayList<String>>();
    /**
     * Indexed by suspicious double subscenes. Store info about which double subscenes
     * are suspicious.
     */
    HashMap<String, Boolean> suspiciousDoubleSubscenes = new HashMap<String, Boolean>();
    /**
     * This is indexed by agentLog filename, then there is a list of either subscens id
     * with suspicious value and/or event id with suspicious value.
     * These suspicous values are predefined in one method here. 
     */
    HashMap<String, HashMap<String, Double>> suspiciousFeelingDifference = new HashMap<String, HashMap<String, Double>>();
    /**
     * Here we store feeling information from all of the experiments.
     */
    HashMap<String, HashMap<String, ArrayList<ArrayList<FeelingLog>>>> agLogFeelings = new HashMap<String, HashMap<String, ArrayList<ArrayList<FeelingLog>>>>();
    /**
     * Here we store all three agLog files containing the complete info for one experiment.
     * Indexed by agLogIndex, than agentName.
     *
     */
    HashMap<String, HashMap<String, AgentLogging>> agLogCache = new HashMap<String, HashMap<String, AgentLogging>>();
    /**
     * Here we store global statistcis for each agent about number of actions he missed - did not
     * perceived.
     */
    HashMap<String, HashMap<String, Integer>> missedActionsCount = new HashMap<String, HashMap<String, Integer>>();

    /**
     * Creates category chart.
     *
     * @param chartTitle chart title
     * @param xAxisName x axis name
     * @param yAxisName y axis name
     * @param dataset dataset
     * @return new bar JFreeChart
     */
    private static JFreeChart createCategoryChart(String chartTitle, String xAxisName,
            String yAxisName, CategoryDataset dataset, double lowerRange, double upperRange) {

        // create the chart...
        JFreeChart chart = ChartFactory.createBarChart(
                chartTitle, // chart title
                xAxisName, // domain axis label
                yAxisName, // range axis label
                dataset, // data
                PlotOrientation.HORIZONTAL, // orientation
                true, // include legend
                true, // tooltips?
                false // URLs?
                );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...

        // set the background color for the chart...
        chart.setBackgroundPaint(Color.white);

        // get a reference to the plot for further customisation...
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer(new ScatterRenderer());
        plot.setBackgroundPaint(Color.white);
        plot.setDomainGridlinePaint(Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint(Color.lightGray);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);


        // set the range axis to display integers only...
        final NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        //rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setRange(lowerRange, upperRange);

        //TODELETE
        //rangeAxis.setTickLabelFont(new Font("SansSerif", Font.BOLD, 14));
        //((CategoryAxis)plot.getDomainAxis()).setTickLabelFont(new Font("SansSerif", Font.BOLD, 14));

        //rangeAxis.zoomRange(0, 0);
        //rangeAxis.setRange(0, 5000);
        //new NumberTickUnit().
        //rangeAxis.setTickUnit(, notify, turnOffAutoSelect)
        //rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());

        // disable bar outlines...

        // set up gradient paints for series...
        GradientPaint gp0 = new GradientPaint(
                0.0f, 0.0f, Color.blue,
                0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(
                0.0f, 0.0f, Color.green,
                0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(
                0.0f, 0.0f, Color.red,
                0.0f, 0.0f, new Color(64, 0, 0));
        GradientPaint gp3 = new GradientPaint(
                0.0f, 0.0f, Color.yellow,
                0.0f, 0.0f, new Color(64, 64, 0));
        ScatterRenderer renderer = (ScatterRenderer) plot.getRenderer();

        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        renderer.setSeriesPaint(2, gp2);
        renderer.setSeriesPaint(3, gp3);

        //CategoryAxis domainAxis = plot.getDomainAxis();

        //domainAxis.setCategoryLabelPositions(
        //      CategoryLabelPositions.createUpRotationLabelPositions(Math.PI / 6.0));
        // OPTIONAL CUSTOMISATION COMPLETED.

        return chart;

    }

    /**
     * Analyze scenario regarding feelings, double actions strings, subscenes string
     * and feeling development. Store the outcomes into internal variables.
     *
     * (we use here getSubcenes method).
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void analyzeScenario(AgentLogging agLog, String directory) throws IOException {

        HashMap<String, Range> subscenes = null;
        Collection<FeelingSceneResult> sceneAnalyze = null;
        String sceneId = "";

        String newFileName = agLog.fileName.split(".log")[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + newFileName + "_ANALYZE_FEEL.txt"));

        subscenes = getSubscenes(agLog, 5);

        for (String sceneName : subscenes.keySet()) {
            sceneAnalyze = analyzeSubsceneFeelings(agLog, subscenes.get(sceneName).getLowerBound(), subscenes.get(sceneName).getUpperBound());
            //log to file
            out.append(sceneName + ";From:" + subscenes.get(sceneName).getLowerBound() +
                    ";To:" + subscenes.get(sceneName).getUpperBound() + ";");
            //fill our object for analysis
            sceneId = sceneName.split(":")[0]; //get the first part of sceneName (identifier without time)

            if (!subsceneFeelingDifferences.containsKey(agLog.agentName)) {
                subsceneFeelingDifferences.put(agLog.agentName, new HashMap<String, HashMap<String, ArrayList<Double>>>());
            }
            if (!subsceneFeelingDifferences.get(agLog.agentName).containsKey(sceneId)) {
                subsceneFeelingDifferences.get(agLog.agentName).put(sceneId, new HashMap<String, ArrayList<Double>>());
            }

            if (!subsceneFeelingEndValue.containsKey(agLog.agentName)) {
                subsceneFeelingEndValue.put(agLog.agentName, new HashMap<String, HashMap<String, ArrayList<Double>>>());
            }
            if (!subsceneFeelingEndValue.get(agLog.agentName).containsKey(sceneId)) {
                subsceneFeelingEndValue.get(agLog.agentName).put(sceneId, new HashMap<String, ArrayList<Double>>());
            }

            if (!subsceneFeelingRanges.containsKey(agLog.agentName)) {
                subsceneFeelingRanges.put(agLog.agentName, new HashMap<String, HashMap<String, ArrayList<Double>>>());
            }
            if (!subsceneFeelingRanges.get(agLog.agentName).containsKey(sceneId)) {
                subsceneFeelingRanges.get(agLog.agentName).put(sceneId, new HashMap<String, ArrayList<Double>>());
            }

            if (!subsceneFeelingsFileLog.containsKey(agLog.fileName)) {
                subsceneFeelingsFileLog.put(agLog.fileName, new HashMap<String, HashMap<String, ArrayList<Double>>>());
            }
            if (!subsceneFeelingsFileLog.get(agLog.fileName).containsKey(sceneId)) {
                subsceneFeelingsFileLog.get(agLog.fileName).put(sceneId, new HashMap<String, ArrayList<Double>>());
            }

            for (FeelingSceneResult feelResult : sceneAnalyze) {
                //log to file
                out.append(feelResult.agentName + ";StartFeel:" + feelResult.startFeeling +
                        ";EndFeel:" + feelResult.endFeeling + ";Difference:" + feelResult.differenceFeeling +
                        ";MaxFeel:" + feelResult.feelingRange.getUpperBound() +
                        ";LowFeel:" + feelResult.feelingRange.getLowerBound() + ";");
                if (checkSuspiciousFeelingResults(sceneName, feelResult)) {
                    out.append("SUSPICIOUS;");
                }
                //fill our object for analysis
                HashMap<String, ArrayList<Double>> agentFeelings = subsceneFeelingDifferences.get(agLog.agentName).get(sceneId);
                HashMap<String, ArrayList<Double>> agentEndFeelings = subsceneFeelingEndValue.get(agLog.agentName).get(sceneId);
                HashMap<String, ArrayList<Double>> agentFeelingRanges = subsceneFeelingRanges.get(agLog.agentName).get(sceneId);
                HashMap<String, ArrayList<Double>> agLogFeels = subsceneFeelingsFileLog.get(agLog.fileName).get(sceneId);

                if (!agentFeelings.containsKey(feelResult.agentName)) {
                    agentFeelings.put(feelResult.agentName, new ArrayList<Double>());
                }
                agentFeelings.get(feelResult.agentName).add(feelResult.differenceFeeling);

                if (!agentEndFeelings.containsKey(feelResult.agentName)) {
                    agentEndFeelings.put(feelResult.agentName, new ArrayList<Double>());
                }
                agentEndFeelings.get(feelResult.agentName).add(feelResult.endFeeling);

                if (!agentFeelingRanges.containsKey(feelResult.agentName)) {
                    agentFeelingRanges.put(feelResult.agentName, new ArrayList<Double>());
                }
                agentFeelingRanges.get(feelResult.agentName).add(feelResult.feelingRange.getLength());

                if (!agLogFeels.containsKey(feelResult.agentName)) {
                    agLogFeels.put(feelResult.agentName, new ArrayList<Double>());
                }
                agLogFeels.get(feelResult.agentName).add(feelResult.endFeeling);

            }
            out.append("\n \n");
        }
        out.close();

        //DOUBLE ACTION SUBSCENE ANALYSIS
        processSubscenesDoubleActions(subscenes, agLog);

        //DOUBLE ACTIONS WHOLE ANALYSIS
        processDoubleActions(agLog);

        //SUBSCENE DURATION ANALYSIS - storing info
        subscenesDurations.put(agLog.fileName, new HashMap<String, Double>());
        for (String sceneName : subscenes.keySet()) {
            subscenesDurations.get(agLog.fileName).put(sceneName, subscenes.get(sceneName).getLength());
        }

        //adding to agLogCache - we will cache all three agent logging files that form
        //one experiment.
        String agLogIndex = "";
        agLogIndex = agLog.fileName.split("2009")[1];
        if (!agLogCache.containsKey(agLogIndex)) {
            agLogCache.put(agLogIndex, new HashMap<String, AgentLogging>());
        }
        agLogCache.get(agLogIndex).put(agLog.agentName, agLog);
        //if we have already whole experiment for agLog index make further analysis..
        if (agLogCache.get(agLogIndex).size() == 3) {

            //analyze actions + perceived emotion events.
            analyzeMissedActions(agLogCache.get(agLogIndex), agLogIndex, directory);

            //analyze actions + feeling shifts

            agLogCache.clear();
        }

    }

    /**
     * Creates line chart. Force auto range of range axis, if bAutoRange true, if not
     * will use lowerRange and upperRange parameters for setting up the range.
     *
     * @param chartTitle
     * @param xAxisName
     * @param yAxisName
     * @param dataset
     * @param bAutoRange
     * @param lowerRange
     * @param upperRange
     * @return
     */
    private static JFreeChart createLineChart(String chartTitle, String xAxisName,
            String yAxisName, XYDataset dataset, boolean bAutoRange, double lowerRange,
            double upperRange) {

        // create the chart...
        JFreeChart chart = ChartFactory.createXYLineChart(
                chartTitle, // chart title
                xAxisName, // domain axis label
                yAxisName, // range axis label
                dataset, // data
                PlotOrientation.VERTICAL, // orientation
                true, // include legend
                true, // tooltips?
                false // URLs?
                );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...

        // set the background color for the chart...
        chart.setBackgroundPaint(Color.white);

        // get a reference to the plot for further customisation...
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.white);
        plot.setDomainGridlinePaint(Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint(Color.white);

        // set the range axis to display integers only...
        final NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        //rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (!bAutoRange) {
            rangeAxis.setRange(lowerRange, upperRange);
        }

        //TODELETE
        //rangeAxis.setTickLabelFont(new Font("SansSerif", Font.BOLD, 14));
        //((NumberAxis)plot.getDomainAxis()).setTickLabelFont(new Font("SansSerif", Font.BOLD, 14));

        // disable bar outlines...
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) plot.getRenderer();


        // set up gradient paints for series...
        GradientPaint gp0 = new GradientPaint(
                0.0f, 0.0f, Color.blue,
                0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(
                0.0f, 0.0f, Color.green,
                0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(
                0.0f, 0.0f, Color.red,
                0.0f, 0.0f, new Color(64, 0, 0));

        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        renderer.setSeriesPaint(2, gp2);


        //TODELETE
        /*
        renderer.setSeriesShapesFilled(1, true);
        renderer.setSeriesShape(1, new Ellipse2D.Double(-0.5,-0.5,1.5,1.5));
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesShapesFilled(2, true);        
        renderer.setSeriesLinesVisible(0, true);
         */
        //ValueAxis domainAxis = plot.getDomainAxis();


        // OPTIONAL CUSTOMISATION COMPLETED.

        return chart;
    }

    /**
     * Here we will log missed actions for the experiment in a log file and we will
     * store the numbers into global statistics file.
     *
     * @param inputAgLogs
     * @param agLogIndex
     * @param directory
     */
    private void analyzeMissedActions(HashMap<String, AgentLogging> inputAgLogs, String agLogIndex, String directory) throws IOException {


        BufferedWriter out = new BufferedWriter(new FileWriter(directory + "2009" + agLogIndex + "_MISSED_ACTIONS.txt"));

        for (AgentLogging agLog : inputAgLogs.values()) {

            if (!missedActionsCount.containsKey(agLog.agentName)){
                missedActionsCount.put(agLog.agentName, new HashMap<String,Integer>());
            }
            out.append(agLog.agentName + " missed actions: \n");
            out.append("------------- \n");

            int actionsCount = 0;
            int missedActionsCounts = 0;
            for (ActionLog actionLog : agLog.actionsHistory) {

                String eventString = "";
                if (!actionLog.targetName.contains("Emohawk")) {
                    actionsCount++;

                    if (actionLog.actionType == ActionType.TALK)
                        eventString = "MESSAGE";
                    else
                        eventString = actionLog.actionType.toString();

                    for (EmotionEventLog eventLog : inputAgLogs.get(actionLog.targetName).emotionEventsHistory)  {

                        if (eventLog.time >= actionLog.time) {
                            if ((eventLog.time - actionLog.time) > 2.5){

                                if (!missedActionsCount.get(agLog.agentName).containsKey(actionLog.actionType.toString())){
                                    missedActionsCount.get(agLog.agentName).put(actionLog.actionType.toString(), 1);
                                } else {
                                    missedActionsCount.get(agLog.agentName).put(actionLog.actionType.toString(), 1 + missedActionsCount.get(agLog.agentName).get(actionLog.actionType.toString()));
                                }
                                out.append(actionLog.time + ";" + actionLog.actionType.toString() + ";" + actionLog.targetName + ";" + actionLog.feeling + ";\n");
                                missedActionsCounts++;

                                break;
                            }

                            if (eventLog.eventId.toString().contains(eventString)){
                                break;
                            }
                        }

                    }
                }

            }
            out.append("Number of actions: " + actionsCount + "; Number of missed actions: " + missedActionsCounts + "; \n");
            out.append("\n");
        }

        out.close();



    }

    /**
     * Analyze one subscene feelings - how they were developing.
     *
     * @param agLog
     * @param lowerBound
     * @param upperBound
     * @return
     */
    private Collection<FeelingSceneResult> analyzeSubsceneFeelings(AgentLogging agLog, double lowerBound, double upperBound) {
        HashMap<String, FeelingSceneResult> result = new HashMap<String, FeelingSceneResult>();

        boolean monitoring = false;

        FeelingSceneResult feelResult = null;

        for (ArrayList<FeelingLog> feelLogList : agLog.feelingsHistory) {

            if (!feelLogList.isEmpty() && feelLogList.get(0).time >= lowerBound) {
                if (!monitoring) {
                    monitoring = true;
                }
            }
            if (!feelLogList.isEmpty() && feelLogList.get(0).time >= upperBound) {
                break;
            }
            if (monitoring) {
                for (FeelingLog feelLog : feelLogList) {
                    if (!result.containsKey(feelLog.agentName)) {
                        feelResult = new FeelingSceneResult(feelLog.agentId, feelLog.agentName);
                        feelResult.startFeeling = feelLog.intensity;
                        feelResult.endFeeling = feelLog.intensity;
                        feelResult.differenceFeeling = 0;
                        feelResult.feelingRange = new Range(feelLog.intensity, feelLog.intensity);
                        result.put(feelLog.agentName, feelResult);
                    }
                    feelResult = result.get(feelLog.agentName);
                    feelResult.endFeeling = feelLog.intensity;
                    feelResult.differenceFeeling = feelLog.intensity - feelResult.startFeeling;
                    feelResult.feelingRange = Range.expandToInclude(feelResult.feelingRange, feelLog.intensity);
                }
            }
        }

        return result.values();
    }

    /**
     * This method check if id of the double action is suspicious one and if yes, it
     * will be logged in the object, so we know which log contained the susp. double action.
     *
     * @param doubleActionId id of the double action
     * @param fileName log that contained it
     */
    private void checkSuspiciousDoubleAction(String doubleActionId, String fileName) {

        if (suspiciousDoubleActions.containsKey(doubleActionId)) {
            suspiciousDoubleActions.get(doubleActionId).add(fileName);
        }

    }

    /**
     * Returns true if double subscene is considered suspicious.
     *
     * @param previousSceneId
     * @param sceneId
     * @return
     */
    private boolean checkSuspiciousDoubleSubscene(String previousSceneId, String sceneId) {

        if (suspiciousDoubleSubscenes.containsKey(previousSceneId + " " + sceneId)) {
            return true;
        }

        return false;
    }

    /**
     * If the feeling result or subscene is consideres suspicious true will be returned.
     *
     * @param sceneName
     * @param feelResult
     * @return
     */
    private boolean checkSuspiciousFeelingResults(String sceneName, FeelingSceneResult feelResult) {
        if (sceneName.toLowerCase().contains("with_bruno") && !sceneName.toLowerCase().contains("interrupted")) {

            if ((feelResult.agentName.toLowerCase().contains("bruno")) && ((feelResult.endFeeling < 0) || (feelResult.differenceFeeling < -1))) {
                return true;
            }

            if (((feelResult.agentName.toLowerCase().contains("anne")) || (feelResult.agentName.toLowerCase().contains("clementine"))) && ((feelResult.endFeeling > 0.5) || (feelResult.differenceFeeling > 0.9))) {
                return true;
            }

        } else if (sceneName.toLowerCase().contains("interrupted_with")) {

            if (feelResult.differenceFeeling > 1) {
                return true;
            }

        }

        return false;
    }

    /**
     * Creates box plot graph.
     *
     * @param xAxisName
     * @param yAxisName
     * @param dataset
     * @return
     */
    private CategoryPlot createBoxAndWhiskerCategoryPlot(String xAxisName, String yAxisName, BoxAndWhiskerCategoryDataset dataset) {

        final CategoryAxis xAxis = new CategoryAxis(xAxisName);

        //xAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);

        xAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);

        final NumberAxis yAxis = new NumberAxis(yAxisName);
        yAxis.setAutoRangeIncludesZero(false);
        final BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(true);

        //TODELETE
        /*
        GradientPaint gp0 = new GradientPaint(
        0.0f, 0.0f, Color.blue,
        0.0f, 0.0f, new Color(0, 0, 64));
        renderer.setSeriesFillPaint(1,gp0);
        xAxis.setMaximumCategoryLabelLines(5);
         */

        //yAxis.setTickLabelFont(new Font("SansSerif", Font.BOLD, 12));
        //xAxis.setTickLabelFont(new Font("SansSerif", Font.BOLD, 12));


        final CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);


        return plot;
    }

    /**
     * Creates combined category chart - two graphs in one.
     *
     * @param chartTitle
     * @param firstXAxisName
     * @param firstDataset
     * @param lowerRange
     * @param upperRange
     * @param secondXAxisName
     * @param secondDataset
     * @param domainAxisName
     * @param leftOffset
     * @return
     */
    private JFreeChart createCombinedCategoryChart(String chartTitle, String firstXAxisName,
            CategoryDataset firstDataset, double lowerRange,
            double upperRange, String secondXAxisName,
            CategoryDataset secondDataset, String domainAxisName, double leftOffset) {

        GradientPaint gp0 = new GradientPaint(
                0.0f, 0.0f, Color.blue,
                0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(
                0.0f, 0.0f, Color.green,
                0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(
                0.0f, 0.0f, Color.red,
                0.0f, 0.0f, new Color(64, 0, 0));
        GradientPaint gp3 = new GradientPaint(
                0.0f, 0.0f, Color.yellow,
                0.0f, 0.0f, new Color(64, 64, 0));

        final NumberAxis rangeAxis1 = new NumberAxis(domainAxisName);
        rangeAxis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis1.setAutoRangeIncludesZero(false);
        rangeAxis1.setRange(lowerRange, upperRange);

        final ScatterRenderer renderer1 = new ScatterRenderer();
        //renderer1.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        renderer1.setSeriesPaint(0, gp0);
        renderer1.setSeriesPaint(1, gp1);
        renderer1.setSeriesPaint(2, gp2);
        renderer1.setSeriesPaint(3, gp3);
        final CategoryPlot subplot1 = new CategoryPlot(firstDataset, null, rangeAxis1,
                renderer1);
        subplot1.setDomainGridlinesVisible(true);
        //subplot1.setOrientation(PlotOrientation.HORIZONTAL);
        subplot1.setBackgroundPaint(Color.white);
        subplot1.setDomainGridlinePaint(Color.lightGray);
        subplot1.setRangeGridlinesVisible(true);
        subplot1.setRangeGridlinePaint(Color.lightGray);
        subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);

        final NumberAxis rangeAxis2 = new NumberAxis(domainAxisName);
        rangeAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis2.setAutoRangeIncludesZero(false);
        rangeAxis2.setRange(lowerRange, upperRange);
        final ScatterRenderer renderer2 = new ScatterRenderer();
        // renderer2.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        renderer2.setSeriesPaint(0, gp0);
        renderer2.setSeriesPaint(1, gp1);
        renderer2.setSeriesPaint(2, gp2);
        renderer2.setSeriesPaint(3, gp3);

        final CategoryPlot subplot2 = new CategoryPlot(secondDataset, null, rangeAxis2,
                renderer2);
        subplot2.setDomainGridlinesVisible(true);
        // subplot2.setOrientation(PlotOrientation.HORIZONTAL);
        subplot2.setBackgroundPaint(Color.white);
        subplot2.setDomainGridlinePaint(Color.lightGray);
        subplot2.setRangeGridlinePaint(Color.lightGray);
        subplot2.setRangeGridlinesVisible(true);
        subplot2.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);

        //sets this so both plots begins at the same spot
        AxisSpace space = new AxisSpace();
        space.setLeft(leftOffset);

        subplot1.setFixedDomainAxisSpace(space);
        subplot2.setFixedDomainAxisSpace(space);

        //final CategoryAxis domainAxis = new CategoryAxis("Time (seconds)");
        final CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot();

        plot.setBackgroundPaint(Color.white);
        plot.add(subplot1, 1);
        plot.add(subplot2, 1);
        plot.getDomainAxis().setVisible(false);

        subplot1.setOrientation(PlotOrientation.HORIZONTAL);
        subplot2.setOrientation(PlotOrientation.HORIZONTAL);
        final CategoryAxis domainAxis1 = new CategoryAxis(firstXAxisName);
        subplot1.setDomainAxis(domainAxis1);
        final CategoryAxis domainAxis2 = new CategoryAxis(secondXAxisName);
        subplot2.setDomainAxis(domainAxis2);

        final JFreeChart chart = new JFreeChart(
                chartTitle,
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                false);

        return chart;
    }

    /**
     * Creates one Category plot - used when creating multigraphs.
     *
     * @param rangeAxisName
     * @param domainAxisName
     * @param lowerRange
     * @param upperRange
     * @param dataset
     * @return
     */
    private CategoryPlot createCategoryPlot(String plotName, String rangeAxisName, String domainAxisName,
            double lowerRange, double upperRange, CategoryDataset dataset, double leftOffset) {

        GradientPaint gp0 = new GradientPaint(
                0.0f, 0.0f, Color.blue,
                0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(
                0.0f, 0.0f, Color.green,
                0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(
                0.0f, 0.0f, Color.red,
                0.0f, 0.0f, new Color(64, 0, 0));
        GradientPaint gp3 = new GradientPaint(
                0.0f, 0.0f, Color.yellow,
                0.0f, 0.0f, new Color(64, 64, 0));

        final NumberAxis rangeAxis1 = new NumberAxis(rangeAxisName);
        //rangeAxis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis1.setRange(lowerRange, upperRange);

        final ScatterRenderer renderer1 = new ScatterRenderer();

        //renderer1.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        renderer1.setSeriesPaint(0, gp0);
        renderer1.setSeriesPaint(1, gp1);
        renderer1.setSeriesPaint(2, gp2);
        renderer1.setSeriesPaint(3, gp3);
        renderer1.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());

        final CategoryPlot subplot1 = new CategoryPlot(dataset, null, rangeAxis1,
                renderer1);

        subplot1.setDomainGridlinesVisible(true);
        //subplot1.setOrientation(PlotOrientation.HORIZONTAL);
        subplot1.setBackgroundPaint(Color.white);
        subplot1.setDomainGridlinePaint(Color.lightGray);
        subplot1.setRangeGridlinesVisible(true);
        subplot1.setRangeGridlinePaint(Color.lightGray);
        subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);

        final CategoryAxis domainAxis1 = new CategoryAxis(domainAxisName);
        subplot1.setDomainAxis(domainAxis1);
        AxisSpace space = new AxisSpace();
        space.setLeft(leftOffset);

        //rangeAxis1.setTickLabelFont(new Font("SansSerif", Font.BOLD, 12));
        //domainAxis1.setTickLabelFont(new Font("SansSerif", Font.BOLD, 12));

        subplot1.setFixedDomainAxisSpace(space);
        subplot1.setOrientation(PlotOrientation.HORIZONTAL);

        return subplot1;
    }

    /**
     * Creates one XYPlot.
     *
     * @param rangeAxisName
     * @param domainAxisName
     * @param lowerRange
     * @param upperRange
     * @param dataset
     * @return
     */
    private XYPlot createXYPlot(String plotName, String rangeAxisName, String domainAxisName,
            double lowerRange, double upperRange, XYDataset dataset) {

        GradientPaint gp0 = new GradientPaint(
                0.0f, 0.0f, Color.blue,
                0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(
                0.0f, 0.0f, Color.green,
                0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(
                0.0f, 0.0f, Color.red,
                0.0f, 0.0f, new Color(64, 0, 0));
        GradientPaint gp3 = new GradientPaint(
                0.0f, 0.0f, Color.yellow,
                0.0f, 0.0f, new Color(64, 64, 0));

        final NumberAxis rangeAxis1 = new NumberAxis(rangeAxisName);
        //rangeAxis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis1.setRange(lowerRange, upperRange);

        final StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();

        //renderer1.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        renderer1.setSeriesPaint(0, gp0);
        renderer1.setSeriesPaint(1, gp1);
        renderer1.setSeriesPaint(2, gp2);
        renderer1.setSeriesPaint(3, gp3);

        final XYPlot subplot1 = new XYPlot(dataset, null, rangeAxis1,
                renderer1);

        subplot1.setDomainGridlinesVisible(true);
        //subplot1.setOrientation(PlotOrientation.HORIZONTAL);
        subplot1.setBackgroundPaint(Color.white);
        subplot1.setDomainGridlinePaint(Color.lightGray);
        subplot1.setRangeGridlinesVisible(true);
        subplot1.setRangeGridlinePaint(Color.lightGray);
        subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);

        final NumberAxis domainAxis1 = new NumberAxis(domainAxisName);
        subplot1.setDomainAxis(domainAxis1);

        return subplot1;
    }

    /**
     * Makes emotion events txt log file from input AgentLogging object. Also logs
     * the feelings to the object used for all scenarios statisctical analysis.
     *
     * @param agLog input agent logging object
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void makeEmotionEventsLog(AgentLogging agLog, String directory) throws IOException {

        String newFileName = agLog.fileName.split(".log")[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + newFileName + "_EVENTS.txt"));

        for (EmotionEventLog eventLog : agLog.emotionEventsHistory) {
            out.append(eventLog.time + ";" + eventLog.eventId + ";" + eventLog.desirability + ";" + eventLog.praiseworthiness + ";" + eventLog.appealingness + ";" + eventLog.elicitorName + ";" + "\n");

            if (!eventsFeelingDifferences.containsKey(agLog.agentName)) {
                eventsFeelingDifferences.put(agLog.agentName, new HashMap<String, HashMap<String, ArrayList<Double>>>());
            }
            if (!eventsFeelingDifferences.get(agLog.agentName).containsKey(eventLog.eventId.toString())) {
                eventsFeelingDifferences.get(agLog.agentName).put(eventLog.eventId.toString(), new HashMap<String, ArrayList<Double>>());
            }

            for (FeelingSceneResult feelResult : analyzeSubsceneFeelings(agLog, eventLog.time, eventLog.time + 1)) {

                //fill our object for analysis
                HashMap<String, ArrayList<Double>> agentFeelings = eventsFeelingDifferences.get(agLog.agentName).get(eventLog.eventId.toString());

                if (!agentFeelings.containsKey(feelResult.agentName)) {
                    agentFeelings.put(feelResult.agentName, new ArrayList<Double>());
                }
                agentFeelings.get(feelResult.agentName).add(feelResult.differenceFeeling);

                // analyzing feeling change 1 sec. from the time of event
                out.append(feelResult.agentName + ";StartFeel:" + feelResult.startFeeling +
                        ";EndFeel:" + feelResult.endFeeling + ";Difference:" + feelResult.differenceFeeling +
                        ";MaxFeel:" + feelResult.feelingRange.getUpperBound() +
                        ";LowFeel:" + feelResult.feelingRange.getLowerBound() + ";");
            }
            out.append("\n \n");
        }

        out.close();
    }

    /**
     * Makes emotion events plot for input AgentLogging object.
     *
     * @param agLog input agent logging object
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void makeEmotionEventsPlot(AgentLogging agLog, String directory) throws IOException {

        DefaultMultiValueCategoryDataset dataset = new DefaultMultiValueCategoryDataset();

        HashMap<String, ArrayList<EmotionEventLog>> eventMap = new HashMap<String, ArrayList<EmotionEventLog>>();

        EmotionEventLog eventLog = null;
        Iterator<EmotionEventLog> it = agLog.emotionEventsHistory.iterator();
        while (it.hasNext()) {
            eventLog = it.next();
            if (!eventMap.containsKey(eventLog.eventId.toString())) {
                eventMap.put(eventLog.eventId.toString(), new ArrayList<EmotionEventLog>());
            }
            eventMap.get(eventLog.eventId.toString()).add(eventLog);
        }

        HashMap<String, ArrayList<EmotionEventLog>> elicitorNameMap = null;
        ArrayList<Double> valueList = null;
        String myId = "";
        String eventStringId = "";
        String eventId = "";
        EmotionEventLog eventLogTwo = null;
        Object[] key = eventMap.keySet().toArray();
        Arrays.sort(key);

        for (int i = 0; i < key.length; i++) {
            eventId = (String) key[i];
            elicitorNameMap = new HashMap<String, ArrayList<EmotionEventLog>>();
            Iterator<EmotionEventLog> itThree = eventMap.get(eventId).iterator();
            while (itThree.hasNext()) {
                eventLogTwo = itThree.next();
                myId = eventLogTwo.elicitorName;
                if (myId.isEmpty()) {
                    myId = "None";
                }
                if (!elicitorNameMap.containsKey(myId)) {
                    elicitorNameMap.put(myId, new ArrayList<EmotionEventLog>());
                }
                elicitorNameMap.get(myId).add(eventLogTwo);
            }
            for (String elicName : elicitorNameMap.keySet()) {
                eventStringId = elicitorNameMap.get(elicName).get(0).eventId.toString();
                valueList = new ArrayList<Double>();
                for (EmotionEventLog evL : elicitorNameMap.get(elicName)) {
                    if (evL.time != 0) {
                        valueList.add(evL.time);
                    }
                }
                dataset.add(valueList, elicName, eventStringId);
            }
        }

        String newFileName = agLog.fileName.split(".log")[0];

        final JFreeChart chart = createCategoryChart(newFileName + " events log", "Event Id", "Time (seconds)",
                dataset, dataset.getRangeLowerBound(false), dataset.getRangeUpperBound(false));
        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);
            frame1.setVisible(true);
            frame1.setSize(1480, 900);
        }

        saveChartToFile(chart, directory + newFileName + "_EVENTS", 1480, 900);
    }

    /**
     * Logs all agent actions toward someone to the file.
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void makeAgentActionsLog(AgentLogging agLog, String directory) throws IOException {

        String newFileName = agLog.fileName.split(".log")[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + newFileName + "_ACTIONS.txt"));

        for (ActionLog actionLog : agLog.actionsHistory) {
            out.append(actionLog.time + ";" + actionLog.actionType.toString() + ";" + actionLog.targetName + ";" + actionLog.feeling + ";" + "\n");
        }

        out.close();
    }

    /**
     * Logs all proposals to the file.
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void makeAgentProposalsLog(AgentLogging agLog, String directory) throws IOException {
        String newFileName = agLog.fileName.split(".log")[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + newFileName + "_PROPOSALS.txt"));

        for (ProposalInfo propInfo : agLog.proposalsHistory) {
            out.append(propInfo.getTime() + ";" + propInfo.getType().toString() + ";" + propInfo.getTarget() + ";" + propInfo.getProposalResponseTime() + ";" +
                    "Accepted:" + propInfo.isProposalAccepted() + ";" +
                    "Ignored:" + propInfo.isProposalIgnored() + ";\n");
        }

        out.close();
    }

    /**
     * Creates plot containing actions and proposals agent made to someone also with
     * subscenes.
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void makeAgentActionsProposalsSubscenesPlot(AgentLogging agLog, String directory) throws IOException {

        DefaultMultiValueCategoryDataset dataset = new DefaultMultiValueCategoryDataset();

        HashMap<String, ArrayList<ActionLog>> actionMap = new HashMap<String, ArrayList<ActionLog>>();
        HashMap<String, ArrayList<ProposalInfo>> proposalsMap = new HashMap<String, ArrayList<ProposalInfo>>();

        //reset agentNames map
        agentNamesMap = new HashMap<Integer, String>();

        for (ActionLog actionLog : agLog.actionsHistory) {
            if (!actionMap.containsKey(actionLog.actionType.toString())) {
                actionMap.put(actionLog.actionType.toString(), new ArrayList<ActionLog>());
            }
            actionMap.get(actionLog.actionType.toString()).add(actionLog);
            if (!agentNamesMap.containsKey(actionLog.targetId)) {
                agentNamesMap.put(actionLog.targetId, actionLog.targetName);
            }
        }

        for (ProposalInfo propInfo : agLog.proposalsHistory) {
            if (!proposalsMap.containsKey("P_" + propInfo.getType().toString())) {
                proposalsMap.put("P_" + propInfo.getType().toString(), new ArrayList<ProposalInfo>());
            }
            proposalsMap.get("P_" + propInfo.getType().toString()).add(propInfo);
        }

        //add actions to data set
        HashMap<String, ArrayList<ActionLog>> targetNameMap = null;
        ArrayList<Double> valueList = null;
        String myId = "";
        String actionStringType = "";
        for (String eventId : actionMap.keySet()) {
            targetNameMap = new HashMap<String, ArrayList<ActionLog>>();

            for (ActionLog actionLogTwo : actionMap.get(eventId)) {
                myId = actionLogTwo.targetName;
                if (myId.isEmpty()) {
                    myId = "None";
                }
                if (!targetNameMap.containsKey(myId)) {
                    targetNameMap.put(myId, new ArrayList<ActionLog>());
                }
                targetNameMap.get(myId).add(actionLogTwo);
            }

            for (String targetName : targetNameMap.keySet()) {
                actionStringType = targetNameMap.get(targetName).get(0).actionType.toString();
                valueList = new ArrayList<Double>();
                for (ActionLog acL : targetNameMap.get(targetName)) {
                    if (acL.time != 0) {
                        valueList.add(acL.time);
                    }
                }
                dataset.add(valueList, targetName, actionStringType);
            }
        }

        //Add proposals to data set
        HashMap<String, ArrayList<ProposalInfo>> targetProposalNameMap = null;
        for (String proposalType : proposalsMap.keySet()) {
            targetProposalNameMap = new HashMap<String, ArrayList<ProposalInfo>>();

            for (ProposalInfo propInf : proposalsMap.get(proposalType)) {
                if (agentNamesMap.containsKey(propInf.getTarget())) {
                    myId = agentNamesMap.get(propInf.getTarget());
                } else {
                    myId = "None";
                }
                if (!targetProposalNameMap.containsKey(myId)) {
                    targetProposalNameMap.put(myId, new ArrayList<ProposalInfo>());
                }
                targetProposalNameMap.get(myId).add(propInf);
            }

            for (String targetName : targetProposalNameMap.keySet()) {
                actionStringType = targetProposalNameMap.get(targetName).get(0).getType().toString();
                valueList = new ArrayList<Double>();
                for (ProposalInfo pInf : targetProposalNameMap.get(targetName)) {
                    if (pInf.getTime() != 0) {
                        valueList.add(pInf.getTime());
                    }
                }
                dataset.add(valueList, targetName, "P_" + actionStringType);
            }
        }

        //fill dataset for subscenes
        HashMap<String, Range> subscenes = getSubscenes(agLog, 5);
        HashMap<String, ArrayList<Double>> subscenesForDataset = new HashMap<String, ArrayList<Double>>();
        String sceneId = "";

        DefaultMultiValueCategoryDataset subscenesDataset = new DefaultMultiValueCategoryDataset();
        for (String sceneName : subscenes.keySet()) {
            sceneId = sceneName.split(":")[0];
            if (!subscenesForDataset.containsKey(sceneId)) {
                subscenesForDataset.put(sceneId, new ArrayList<Double>());
            }
            subscenesForDataset.get(sceneId).addAll(generateOneByOneList(subscenes.get(sceneName)));
        }
        for (String sceneName : subscenesForDataset.keySet()) {
            subscenesDataset.add(subscenesForDataset.get(sceneName), agLog.agentName, sceneName);
        }

        double lowerRange = subscenesDataset.getRangeLowerBound(false);
        double upperRange = subscenesDataset.getRangeUpperBound(false);


        final NumberAxis rangeAxis1 = new NumberAxis("Time (seconds)");
        final CombinedRangeCategoryPlot plot = new CombinedRangeCategoryPlot(rangeAxis1);

        CategoryPlot subplot1 = createCategoryPlot("Actions/Proposals", "Time (seconds)", "Actions/Proposals Types", lowerRange, upperRange, dataset, 200);
        plot.add(subplot1, 1);
        //we put 700 as upperRange due to some problems
        plot.add(createCategoryPlot("Subscenes", "Time (seconds)", "Subscenes", lowerRange, 700, subscenesDataset, 200), 1);

        plot.setOrientation(PlotOrientation.HORIZONTAL);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.getRangeAxis().setRange(lowerRange, upperRange);
        //plot.getLegendItems().addAll(subplot1.getLegendItems());
        //plot.setRenderer(new ScatterRenderer());
        //plot.getRenderer().setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());

        String newFileName = agLog.fileName.split(".log")[0];
        final JFreeChart chart = new JFreeChart(
                newFileName + " actions/proposals/subscenes plot",
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                true);




        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);
            frame1.setVisible(true);
            frame1.setSize(1480, 900);
        }

        saveChartToFile(chart, directory + newFileName + "_ACT_PROP_SUBSCENES", 1480, 900);
    }

    /**
     * Makes subscene string analyze and double subscenes analyze. Also suspicous
     * double subscenes and suspicious subscenes durations will be logged. More log
     * files will be output of this method.
     *
     * @param directory
     * @throws IOException
     */
    public void makeSubsceneSeriesAnalyzeLogs(String directory) throws IOException {

        HashMap<ArrayList<Integer>, Integer> result = new HashMap<ArrayList<Integer>, Integer>();
        boolean bFound = false;

        for (ArrayList<Integer> subsceneSerie : subsceneStrings.values()) {

            bFound = false;
            for (ArrayList<Integer> setId : result.keySet()) {
                if (listsEquals(subsceneSerie, setId)) {
                    bFound = true;
                    result.put(setId, result.get(setId) + 1);
                    break;
                }
            }
            if (!bFound) {
                result.put(subsceneSerie, 1);
            }
        }

        BufferedWriter out = new BufferedWriter(new FileWriter(directory + "SUBSCENE_SERIES_ANALYZE.txt"));

        for (ArrayList<Integer> list : result.keySet()) {

            for (Integer i : list) {
                out.append(getSceneId(i) + ";");
            }
            out.append("\n Count:" + result.get(list) + "; \n \n");
        }

        out.close();

        //DOUBLE SUBSCENE ANALYZE
        HashMap<String, Integer> doubleSubscenesCount = new HashMap<String, Integer>();

        BufferedWriter outThree = new BufferedWriter(new FileWriter(directory + "SUBSCENE_DOUBLES_SUSPICIOUS.txt"));

        ArrayList<Integer> subsceneSerie = null;
        Object[] key = subsceneStrings.keySet().toArray();
        Arrays.sort(key);
        String logName = "";

        for (int i = 0; i < key.length; i++) {
            logName = (String) key[i];
            subsceneSerie = subsceneStrings.get(logName);
            String previousSceneId = "";
            String sceneId = "";
            for (Integer sceneIntId : subsceneSerie) {
                sceneId = getSceneId(sceneIntId);

                if (!previousSceneId.isEmpty()) {

                    if (checkSuspiciousDoubleSubscene(previousSceneId, sceneId)) {
                        outThree.append(logName + ": " + previousSceneId + " " + sceneId + "; \n");
                    }

                    if (!doubleSubscenesCount.containsKey(previousSceneId + " " + sceneId)) {
                        doubleSubscenesCount.put(previousSceneId + " " + sceneId, 1);
                    } else {
                        doubleSubscenesCount.put(previousSceneId + " " + sceneId, doubleSubscenesCount.get(previousSceneId + " " + sceneId) + 1);
                    }

                }

                previousSceneId = getSceneId(sceneIntId);
            }
        }

        outThree.close();

        BufferedWriter outTwo = new BufferedWriter(new FileWriter(directory + "SUBSCENE_DOUBLES_ANALYZE.txt"));


        Object[] keyTwo = doubleSubscenesCount.keySet().toArray();
        Arrays.sort(keyTwo);
        for (int i = 0; i < keyTwo.length; i++) {
            outTwo.append((String) keyTwo[i] + " Count:" + doubleSubscenesCount.get((String) keyTwo[i]) + ";");
            outTwo.append("\n");
        }

        outTwo.close();
    }

    /**
     * Makes basic emotions plot for input AgentLogging object.
     *
     * @param agLog input AgentLogging object
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void makeBasicEmotionsPlot(AgentLogging agLog, String directory) throws IOException {

        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        HashMap<String, XYSeries> seriesList = new HashMap<String, XYSeries>();

        for (EmotionsLog emLog : agLog.emotionsHistory) {
            for (AEmotion em : emLog.emotions) {
                if (!seriesList.containsKey(em.getType().toString())) {
                    seriesList.put(em.getType().toString(), new XYSeries(em.getType().toString()));
                }
                seriesList.get(em.getType().toString()).add(emLog.time, em.getIntensity());
            }
        }

        for (XYSeries series : seriesList.values()) {
            xySeriesCollection.addSeries(series);
        }

        XYDataset xyDataset = xySeriesCollection;

        String newFileName = agLog.fileName.split(".log")[0];
        final JFreeChart chart = createLineChart(newFileName + " emotions log",
                "Time (seconds)", "Intensity", xyDataset, false, 0, 1);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 600);
        }


        saveChartToFile(chart, directory + newFileName + "_EMOTIONS_BASIC", 1480, 600);
    }

    /**
     * Makes complex emotions plot for input AgentLogging object.
     *
     * @param agLog input AgentLogging object
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void makeComplexEmotionsPlot(AgentLogging agLog, String directory) throws IOException {

        HashMap<String, XYSeriesCollection> xySeriesCollectionMap = new HashMap<String, XYSeriesCollection>();
        HashMap<String, HashMap<String, XYSeries>> emotionsSeriesList = new HashMap<String, HashMap<String, XYSeries>>();

        String elName = "";
        HashMap<String, XYSeries> elicitorSeriesList = null;
        for (EmotionsLog emLog : agLog.emotionsHistory) {
            for (AEmotion em : emLog.emotions) {
                if (!emotionsSeriesList.containsKey(em.getType().toString())) {
                    emotionsSeriesList.put(em.getType().toString(), new HashMap<String, XYSeries>());
                }
                elicitorSeriesList = emotionsSeriesList.get(em.getType().toString());
                if (agentNamesMap.containsKey(em.getElicitorId())) {
                    elName = agentNamesMap.get(em.getElicitorId());
                } else {
                    elName = "None";
                }
                if (!elicitorSeriesList.containsKey(elName)) {
                    elicitorSeriesList.put(elName, new XYSeries(elName));
                }
                //to prevent logs where we haven't got time from environment yet
                if (emLog.time != 0) {
                    elicitorSeriesList.get(elName).add(emLog.time, em.getIntensity());
                }
            }
        }

        XYSeriesCollection xyCollect = null;
        for (String emType : emotionsSeriesList.keySet()) {
            xyCollect = new XYSeriesCollection();
            for (XYSeries series : emotionsSeriesList.get(emType).values()) {
                xyCollect.addSeries(series);
            }
            if (!xySeriesCollectionMap.containsKey(emType)) {
                xySeriesCollectionMap.put(emType, xyCollect);
            }
        }

        //ArrayList<XYDataset> xyDatasets = new ArrayList<XYDataset>();
        ArrayList<XYPlot> plots = new ArrayList<XYPlot>();
        for (String emName : xySeriesCollectionMap.keySet()) {
            if (emName.toLowerCase().contains("anger") || emName.toLowerCase().contains("disliking") ||
                    emName.toLowerCase().contains("liking") || emName.toLowerCase().contains("joy") ||
                    emName.toLowerCase().contains("distress") || emName.toLowerCase().contains("love") ||
                    emName.toLowerCase().contains("hate")) {
                plots.add(createXYPlot(emName, "Intensity " + emName, "Time", 0, 1, xySeriesCollectionMap.get(emName)));
            }
        }

        final CombinedDomainXYPlot plot = new CombinedDomainXYPlot();
        final XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer();
        plot.setRenderer(renderer1);

        for (XYPlot xyPlot : plots) {
            plot.add(xyPlot, 1);
        }

        final NumberAxis domainAxis1 = new NumberAxis("Time (Seconds)");
        plot.setDomainAxis(domainAxis1);

        String newFileName = agLog.fileName.split(".log")[0];
        final JFreeChart chart = new JFreeChart(
                newFileName + " complex emotions log",
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 900);
        }

        saveChartToFile(chart, directory + newFileName + "_EMOTIONS_COMPLEX", 1480, 900);
    }

    /**
     * Makes double action txt log file for all the experiments. Double actions in
     * subscenes will be logged, also with double actions in whole scenario. Moreover
     * suspicious double actions will be logged as well. Three text files will be
     * the output of this method.
     *
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void makeAgentDoubleActionLogs(String directory) throws IOException {

        BufferedWriter out = new BufferedWriter(new FileWriter(directory + "DOUBLEACTIONS_SUBSCENES_ANALYZE.txt"));

        for (String agentName : agentSubscenesDoubleActions.keySet()) {
            out.append(agentName + " SUBSCENE DOUBLE ACTIONS: \n");
            out.append("======================================= \n");

            for (String sceneId : agentSubscenesDoubleActions.get(agentName).keySet()) {
                out.append(sceneId + " SUBSCENE \n");
                out.append("---------------------------------- \n");

                for (String targetName : agentSubscenesDoubleActions.get(agentName).get(sceneId).keySet()) {
                    out.append("TARGET: " + targetName + " \n");
                    out.append("++++++++++++++++++++++++++++ \n");

                    for (String doubleActionId : agentSubscenesDoubleActions.get(agentName).get(sceneId).get(targetName).keySet()) {
                        out.append(doubleActionId + " : " + agentSubscenesDoubleActions.get(agentName).get(sceneId).get(targetName).get(doubleActionId) + "\n");
                    }
                    out.append("\n");
                }
                out.append("\n");
            }

            out.append("\n");
        }

        out.close();

        BufferedWriter outTwo = new BufferedWriter(new FileWriter(directory + "DOUBLEACTIONS_ANALYZE_NOPROP_NOTARG.txt"));

        for (String agentName : agentDoubleActions.keySet()) {
            outTwo.append(agentName + " SCENARIO DOUBLE ACTIONS: \n");
            outTwo.append("======================================= \n");

            HashMap<String, Integer> actionsGlobal = new HashMap<String, Integer>();

            for (HashMap<String, Integer> actionsForTarget : agentDoubleActions.get(agentName).values()) {

                for (String actionId : actionsForTarget.keySet()) {

                    if (!actionsGlobal.containsKey(actionId)) {
                        actionsGlobal.put(actionId, actionsForTarget.get(actionId));
                    } else {
                        actionsGlobal.put(actionId, actionsGlobal.get(actionId) + actionsForTarget.get(actionId));
                    }
                }
            }

            Object[] key = actionsGlobal.keySet().toArray();
            Arrays.sort(key);
            String doubleActionId = "";
            for (int i = 0; i < key.length; i++) {
                doubleActionId = (String) key[i];
                outTwo.append(doubleActionId + " : " + actionsGlobal.get(doubleActionId) + "\n");
            }

            outTwo.append("\n");
        }

        outTwo.close();

        //LOGS SUSPICOUS DOUBLE ACTION CONTAINING AGENT LOGS
        BufferedWriter outThree = new BufferedWriter(new FileWriter(directory + "DOUBLEACTIONS_SUSPICIOUS_LIST.txt"));

        for (String suspDoubleActionId : suspiciousDoubleActions.keySet()) {
            outThree.append(suspDoubleActionId + ": \n");
            outThree.append("============================== \n");

            for (String logName : suspiciousDoubleActions.get(suspDoubleActionId)) {
                outThree.append(logName + "; ");
            }

            outThree.append("\n");
        }

        outThree.close();

        BufferedWriter outFour = new BufferedWriter(new FileWriter(directory + "ACTION_SCENARIO_COUNTS.txt"));

        for (String agentName : agentActionCounts.keySet()) {
            outFour.append(agentName + " SCENARIO ACTION COUNTS: \n");
            outFour.append("======================================= \n");

            for (String targName : agentActionCounts.get(agentName).keySet()) {
                outFour.append("Target: " + targName + " \n");
                outFour.append("---------------------------------- \n");


                Object[] key = agentActionCounts.get(agentName).get(targName).keySet().toArray();
                Arrays.sort(key);
                String actionId = "";
                for (int i = 0; i < key.length; i++) {
                    actionId = (String) key[i];
                    outFour.append(actionId + " : " + agentActionCounts.get(agentName).get(targName).get(actionId) + "\n");
                }
                outFour.append("\n");
            }

            outFour.append("\n");
        }

        outFour.close();


        BufferedWriter outFive = new BufferedWriter(new FileWriter(directory + "ACTIONS_SUBSCENES_COUNT.txt"));

        for (String agentName : agentSubscenesActionCounts.keySet()) {
            outFive.append(agentName + " SUBSCENE ACTION COUNTS: \n");
            outFive.append("======================================= \n");

            for (String sceneId : agentSubscenesActionCounts.get(agentName).keySet()) {
                outFive.append(sceneId + " SUBSCENE \n");
                outFive.append("---------------------------------- \n");

                for (String targetName : agentSubscenesActionCounts.get(agentName).get(sceneId).keySet()) {
                    outFive.append("TARGET: " + targetName + " \n");
                    outFive.append("++++++++++++++++++++++++++++ \n");

                    for (String doubleActionId : agentSubscenesActionCounts.get(agentName).get(sceneId).get(targetName).keySet()) {
                        outFive.append(doubleActionId + " : " + agentSubscenesActionCounts.get(agentName).get(sceneId).get(targetName).get(doubleActionId) + "\n");
                    }
                    outFive.append("\n");
                }
                outFive.append("\n");
            }

            outFive.append("\n");
        }

        outFive.close();
    }

    /**
     * Makes feeling txt log file for input AgentLogging object. Also looks if we
     * have all necessary vars for generating combined plot. If yes, we will make the
     * combined plot for all the three experiments.
     *
     * @param agLog input AgentLogging object
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void analyzeFeeling(AgentLogging agLog, String directory) throws IOException {
        boolean firstColumnWritten = false;

        String agLogIndex = "";
        agLogIndex = agLog.fileName.split("2009")[1];

        if (!agLogFeelings.containsKey(agLogIndex)) {
            agLogFeelings.put(agLogIndex, new HashMap<String, ArrayList<ArrayList<FeelingLog>>>());
        }

        String agentName = agLog.agentName;

        agLogFeelings.get(agLogIndex).put(agentName, new ArrayList<ArrayList<FeelingLog>>());
        agLogFeelings.get(agLogIndex).get(agentName).addAll(agLog.feelingsHistory);

        String newFileName = agLog.fileName.split(".log")[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + newFileName + "_FEELING.txt"));

        for (ArrayList<FeelingLog> feelLogArray : agLog.feelingsHistory) {
            firstColumnWritten = false;
            for (FeelingLog feelLog : feelLogArray) {
                if (!firstColumnWritten) {
                    out.append(feelLog.time + ";");
                    firstColumnWritten = true;
                }
                out.append(feelLog.agentName + ";" + feelLog.intensity + ";");
                if (feelLog.intensity < -2) {
                    out.append(feelLog.agentName + "BIG_CONFLICT;");
                } else if (feelLog.intensity < -1) {
                    out.append(feelLog.agentName + "SMALL_CONFLICT;");
                } else if (feelLog.intensity > 2) {
                    out.append(feelLog.agentName + "LOVERS;");
                } else if (feelLog.intensity > 1) {
                    out.append(feelLog.agentName + "FRIENDS;");
                }
            }
            out.append("\n");
        }
        out.close();

        if (agLogFeelings.get(agLogIndex).size() == 3) {
            makeCombinedFeelingPlot(agLogFeelings.get(agLogIndex), directory + "2009" + agLogIndex);
            makeEndFeelingsAnalyzeLog(agLogFeelings.get(agLogIndex), directory + "2009" + agLogIndex);
            agLogFeelings.remove(agLogIndex);
        }
    }

    /**
     * Makes feeling plot for input AgentLogging object.
     *
     * @param agLog input AgentLogging object
     * @param directory output directory
     * @throws java.io.IOException
     */
    public void makeFeelingMoodPlot(AgentLogging agLog, String directory) throws IOException {

        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        HashMap<String, XYSeries> seriesList = new HashMap<String, XYSeries>();

        /*
        DefaultMultiValueCategoryDataset subscenesDataset = new DefaultMultiValueCategoryDataset();
        HashMap<String,Range> subscenes = new HashMap<String,Range>();
        String sceneId = "";
         */

        for (ArrayList<FeelingLog> feelLogArray : agLog.feelingsHistory) {
            for (FeelingLog feelLog : feelLogArray) {
                if (!feelLog.agentName.isEmpty()) {// && !feelLog.agentName.toLowerCase().contains("emohawk")) {
                    if (!seriesList.containsKey(feelLog.agentName)) {
                        seriesList.put(feelLog.agentName, new XYSeries(feelLog.agentName));
                    }
                    seriesList.get(feelLog.agentName).add(feelLog.time, feelLog.intensity);
                }
            }
        }

        for (XYSeries series : seriesList.values()) {

            xySeriesCollection.addSeries(series);
        }

        /*
        subscenes = getSubscenes(agLog);
        for (String sceneName : subscenes.keySet()){
        sceneId = sceneName.split(":")[0];
        ArrayList<Double> newList = new ArrayList();
        newList.add(subscenes.get(sceneName).getLowerBound());
        newList.add(subscenes.get(sceneName).getUpperBound());
        subscenesDataset.add(newList, agLog.agentName, sceneId);
        }*/
        XYSeries pleasure = new XYSeries("Pleasure");
        XYSeries arousal = new XYSeries("Arousal");
        XYSeries dominance = new XYSeries("Dominance");

        for (MoodLog moodLog : agLog.moodHistory) {
            pleasure.add(moodLog.time, moodLog.pleasure);
            arousal.add(moodLog.time, moodLog.arousal);
            dominance.add(moodLog.time, moodLog.dominance);
        }



        XYSeriesCollection xyMoodSeriesCollection = new XYSeriesCollection();
        xyMoodSeriesCollection.addSeries(pleasure);
        xyMoodSeriesCollection.addSeries(arousal);
        xyMoodSeriesCollection.addSeries(dominance);

        XYDataset xyDataset = xySeriesCollection;
        XYDataset moodDataset = xyMoodSeriesCollection;


        XYPlot subplot1 = createXYPlot("FeelingPlot", "Feeling", "Time (seconds)", -5, 4, xyDataset);
        XYPlot subplot2 = createXYPlot("ModdPlot", "Mood", "Time (seconds)", -1.1, 1.1, moodDataset);

        NumberAxis domainAxis = new NumberAxis("Time (seconds)");
        domainAxis.setRange(pleasure.getMinX(), pleasure.getMaxX());

        CombinedDomainXYPlot plot = new CombinedDomainXYPlot(domainAxis);
        plot.add(subplot1, 1);
        plot.add(subplot2, 1);

        //    final JFreeChart chart = createLineChart(newFileName + " feeling log",
        //          "Time (seconds)", "Feeling", xyDataset, false, -5, 4);
        String newFileName = agLog.fileName.split(".log")[0];
        final JFreeChart chart = new JFreeChart(
                newFileName + " feeling/mood plot",
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 700);
        }


        saveChartToFile(chart, directory + newFileName + "_FEELING_MOOD", 1480, 700);
    }

    /**
     * Makes combined feeling plot showing the feeling value development for all
     * agents in one scenario.
     *
     * @param inputFeelings
     * @param outputFile
     * @throws java.io.IOException
     */
    public void makeCombinedFeelingPlot(HashMap<String, ArrayList<ArrayList<FeelingLog>>> inputFeelings, String outputFile) throws IOException {

        XYSeriesCollection xyBrunoSeriesCollection = new XYSeriesCollection();
        XYSeriesCollection xyAnneSeriesCollection = new XYSeriesCollection();
        XYSeriesCollection xyClementineSeriesCollection = new XYSeriesCollection();
        HashMap<String, XYSeries> seriesBruno = new HashMap<String, XYSeries>();
        HashMap<String, XYSeries> seriesAnne = new HashMap<String, XYSeries>();
        HashMap<String, XYSeries> seriesClementine = new HashMap<String, XYSeries>();

        for (ArrayList<FeelingLog> feelLogArray : inputFeelings.get("Bruno")) {
            for (FeelingLog feelLog : feelLogArray) {
                if (!feelLog.agentName.isEmpty()) {// && !feelLog.agentName.toLowerCase().contains("emohawk")) {
                    if (!seriesBruno.containsKey(feelLog.agentName)) {
                        seriesBruno.put(feelLog.agentName, new XYSeries(feelLog.agentName));
                    }
                    seriesBruno.get(feelLog.agentName).add(feelLog.time, feelLog.intensity);
                }
            }
        }

        for (XYSeries series : seriesBruno.values()) {
            xyBrunoSeriesCollection.addSeries(series);
        }

        for (ArrayList<FeelingLog> feelLogArray : inputFeelings.get("Anne")) {
            for (FeelingLog feelLog : feelLogArray) {
                if (!feelLog.agentName.isEmpty()) {// && !feelLog.agentName.toLowerCase().contains("emohawk")) {
                    if (!seriesAnne.containsKey(feelLog.agentName)) {
                        seriesAnne.put(feelLog.agentName, new XYSeries(feelLog.agentName));
                    }
                    seriesAnne.get(feelLog.agentName).add(feelLog.time, feelLog.intensity);
                }
            }
        }

        for (XYSeries series : seriesAnne.values()) {
            xyAnneSeriesCollection.addSeries(series);
        }

        for (ArrayList<FeelingLog> feelLogArray : inputFeelings.get("Clementine")) {
            for (FeelingLog feelLog : feelLogArray) {
                if (!feelLog.agentName.isEmpty()) {// && !feelLog.agentName.toLowerCase().contains("emohawk")) {
                    if (!seriesClementine.containsKey(feelLog.agentName)) {
                        seriesClementine.put(feelLog.agentName, new XYSeries(feelLog.agentName));
                    }
                    seriesClementine.get(feelLog.agentName).add(feelLog.time, feelLog.intensity);
                }
            }
        }

        for (XYSeries series : seriesClementine.values()) {
            xyClementineSeriesCollection.addSeries(series);
        }

        XYDataset xyBrunoDataset = xyBrunoSeriesCollection;
        XYPlot subplot1 = createXYPlot("FeelingPlot", "Feeling (Bruno)", "Time (seconds)", -5, 4, xyBrunoDataset);

        XYDataset xyAnneDataset = xyAnneSeriesCollection;
        XYPlot subplot2 = createXYPlot("FeelingPlot", "Feeling (Anne)", "Time (seconds)", -5, 4, xyAnneDataset);

        XYDataset xyClementineDataset = xyClementineSeriesCollection;
        XYPlot subplot3 = createXYPlot("FeelingPlot", "Feeling (Clementine)", "Time (seconds)", -5, 4, xyClementineDataset);


        NumberAxis domainAxis = new NumberAxis("Time (seconds)");
        domainAxis.setRange(0, 700);

        CombinedDomainXYPlot plot = new CombinedDomainXYPlot(domainAxis);
        plot.add(subplot1, 1);
        plot.add(subplot2, 1);
        plot.add(subplot3, 1);

        //    final JFreeChart chart = createLineChart(newFileName + " feeling log",
        //          "Time (seconds)", "Feeling", xyDataset, false, -5, 4);
        String[] splitResult = outputFile.split("2009");
        String chartName = splitResult[splitResult.length - 1];
        chartName = "2009" + chartName.split(".log")[0];

        final JFreeChart chart = new JFreeChart(
                chartName + " experiment combined feeling plot",
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 900);
        }


        saveChartToFile(chart, outputFile + "_FEELINGS_COMBINED", 1480, 900);
    }

    /**
     * Logs agent location and rotation in time.
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void makeAgentPositionLog(AgentLogging agLog, String directory) throws IOException {
        String newFileName = agLog.fileName.split(".log")[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + newFileName + "_POSITIONS.txt"));

        for (AgentStateLog stateLog : agLog.agentStateHistory) {
            out.append(stateLog.time + ";" + stateLog.agentLocation.x + "," + stateLog.agentLocation.y + "," + stateLog.agentLocation.z + ";" + stateLog.agentRotation.pitch + "," + stateLog.agentRotation.yaw +","+ stateLog.agentRotation.roll + "; \n");
        }

        out.close();
    }

    /**
     * Makes basic traversed positions plot.
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void makePositionPlot(AgentLogging agLog, String directory) throws IOException {
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        XYSeries series = new XYSeries(agLog.agentName);

        for (AgentStateLog stateLog : agLog.agentStateHistory) {
            series.add(stateLog.agentLocation.x, stateLog.agentLocation.y);
        }

        xySeriesCollection.addSeries(series);

        XYDataset xyDataset = xySeriesCollection;

        final XYPlot plot = createXYPlot("Positions", "x", "y", xySeriesCollection.getRangeLowerBound(true), xySeriesCollection.getRangeUpperBound(true), xyDataset);
        final XYDotRenderer renderer = new XYDotRenderer();
        plot.setRenderer(renderer);

        //add annotations
        final XYTextAnnotation cinemaAnnotation = new XYTextAnnotation("Cinema", cinemaLocation.x, cinemaLocation.y);
        cinemaAnnotation.setFont(new Font("SansSerif", Font.PLAIN, 9));
        cinemaAnnotation.setRotationAngle(Math.PI / 4.0);
        plot.addAnnotation(cinemaAnnotation);

        final XYTextAnnotation anneHomeAnnotation = new XYTextAnnotation("AnneHome", firstGirlHomeLocation.x, firstGirlHomeLocation.y);
        anneHomeAnnotation.setFont(new Font("SansSerif", Font.PLAIN, 9));
        anneHomeAnnotation.setRotationAngle(Math.PI / 4.0);
        plot.addAnnotation(anneHomeAnnotation);

        final XYTextAnnotation clemHomeAnnotation = new XYTextAnnotation("ClemHome", secondGirlHomeLocation.x, secondGirlHomeLocation.y);
        clemHomeAnnotation.setFont(new Font("SansSerif", Font.PLAIN, 9));
        clemHomeAnnotation.setRotationAngle(Math.PI / 4.0);
        plot.addAnnotation(clemHomeAnnotation);

        final XYTextAnnotation parkAnnotation = new XYTextAnnotation("Park", parkLocation.x, parkLocation.y);
        parkAnnotation.setFont(new Font("SansSerif", Font.PLAIN, 9));
        parkAnnotation.setRotationAngle(Math.PI / 4.0);
        plot.addAnnotation(parkAnnotation);

        String newFileName = agLog.fileName.split(".log")[0];
        final JFreeChart chart = new JFreeChart(
                newFileName + " agent positions log",
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                false);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1000, 1000);
        }

        saveChartToFile(chart, directory + newFileName + "_POSITIONS", 1000, 1000);
    }

    /**
     * Generate list of values for scatter plot.
     * 
     * @param range
     * @return
     */
    private List generateOneByOneList(Range range) {

        ArrayList<Double> result = new ArrayList<Double>();
        double d = range.getLowerBound();

        while (d <= range.getUpperBound()) {
            result.add(d);
            d = d + 1;
        }

        return result;
    }

    /**
     * Returns the scenario place our agent is at.
     *
     * @todo add this information to Agentlogging object
     * @param loc
     * @return
     */
    private String getPosition(LocationLog locLog) {

        Location loc = new Location(locLog.x, locLog.y, locLog.z);

        if (loc.equals(boyHomeLocation, 150)) {
            return "BRUNO_HOME";
        } else if (loc.equals(cinemaLocation, 150)) {
            return "CINEMA";
        } else if (loc.equals(parkLocation, 150)) {
            return "PARK";
        } else if (loc.equals(firstGirlHomeLocation, 150)) {
            return "ANNE_HOME";
        } else if (loc.equals(secondGirlHomeLocation, 150)) {
            return "CLEMENTINE_HOME";
        } else if (loc.equals(meetingCinemaLocation, 150)) {
            return "MEET_CINEMA";
        }

        return "ELSEWHERE";
    }

    /**
     * Makes state transition plot, agent positions plot, agentWith plot and agent
     * interrupters plot all-in-one.
     *
     * @param agLog
     * @param directory
     * @throws java.io.IOException
     */
    public void makeAgentStatePlot(AgentLogging agLog, String directory) throws IOException {

        DefaultMultiValueCategoryDataset thirdDataset = new DefaultMultiValueCategoryDataset();
        DefaultMultiValueCategoryDataset fourthDataset = new DefaultMultiValueCategoryDataset();

        HashMap<String, ArrayList<Double>> agentWithMap = new HashMap<String, ArrayList<Double>>();
        HashMap<String, ArrayList<Double>> interruptersMap = new HashMap<String, ArrayList<Double>>();

        String agentName = "";
        for (AgentStateLog stateLog : agLog.agentStateHistory) {
            if (!stateLog.agentWithName.isEmpty()) {
                agentName = stateLog.agentWithName;
            } else {
                agentName = "None";
            }
            if (!agentWithMap.containsKey(agentName)) {
                agentWithMap.put(agentName, new ArrayList<Double>());
            }
            agentWithMap.get(agentName).add(stateLog.time);

            if (!stateLog.interruptersNames.isEmpty()) {
                for (String interName : stateLog.interruptersNames) {
                    if (!interruptersMap.containsKey(interName)) {
                        interruptersMap.put(interName, new ArrayList<Double>());
                    }
                    interruptersMap.get(interName).add(stateLog.time);
                }
            } else {
                if (!interruptersMap.containsKey("None")) {
                    interruptersMap.put("None", new ArrayList<Double>());
                }
                interruptersMap.get("None").add(stateLog.time);
            }
        }


        for (String agName : agentWithMap.keySet()) {
            thirdDataset.add(agentWithMap.get(agName), agLog.agentName, agName);
        }

        for (String intName : interruptersMap.keySet()) {
            fourthDataset.add(interruptersMap.get(intName), agLog.agentName, intName);
        }

        DefaultMultiValueCategoryDataset firstDataset = new DefaultMultiValueCategoryDataset();
        DefaultMultiValueCategoryDataset secondDataset = new DefaultMultiValueCategoryDataset();

        HashMap<String, ArrayList<Double>> stateMap = new HashMap<String, ArrayList<Double>>();
        HashMap<String, ArrayList<Double>> positionMap = new HashMap<String, ArrayList<Double>>();

        for (AgentStateLog stateLog : agLog.agentStateHistory) {
            if (!stateMap.containsKey(stateLog.agentState.toString())) {
                stateMap.put(stateLog.agentState.toString(), new ArrayList<Double>());
            }

            stateMap.get(stateLog.agentState.toString()).add(stateLog.time);

            if (!positionMap.containsKey(getPosition(stateLog.agentLocation))) {
                positionMap.put(getPosition(stateLog.agentLocation), new ArrayList<Double>());
            }

            positionMap.get(getPosition(stateLog.agentLocation)).add(stateLog.time);
        }

        for (String stateId : stateMap.keySet()) {
            firstDataset.add(stateMap.get(stateId), agLog.agentName, stateId);
        }

        for (String positionId : positionMap.keySet()) {
            secondDataset.add(positionMap.get(positionId), agLog.agentName, positionId);
        }

        ArrayList<CategoryPlot> plots = new ArrayList<CategoryPlot>();

        double lowerRange = firstDataset.getRangeLowerBound(true);
        double upperRange = firstDataset.getRangeUpperBound(true);
        plots.add(createCategoryPlot("States", "Time (seconds)", "States", lowerRange, upperRange, firstDataset, 150));
        plots.add(createCategoryPlot("Positions", "Time (seconds)", "Positions", lowerRange, upperRange, secondDataset, 150));
        plots.add(createCategoryPlot("AgentWith", "Time (seconds)", "AgentWith", lowerRange, upperRange, thirdDataset, 150));
        plots.add(createCategoryPlot("Interrupters", "Time (seconds)", "Interrupters", lowerRange, upperRange, fourthDataset, 150));

        final CombinedRangeCategoryPlot plot = new CombinedRangeCategoryPlot();

        for (CategoryPlot categPlot : plots) {
            plot.add(categPlot, 1);
        }
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.getRangeAxis().setRange(lowerRange, upperRange);

        String newFileName = agLog.fileName.split(".log")[0];
        final JFreeChart chart = new JFreeChart(
                newFileName + " states/positions/agentWith/interrupters log",
                new Font("SansSerif", Font.BOLD, 16),
                plot,
                false);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);
            frame1.setVisible(true);
            frame1.setSize(1480, 900);
        }

        saveChartToFile(chart, directory + newFileName + "_STATE", 1480, 900);
    }

    /**
     * Loads AgentLogging object from file and calls all desired file/graph exporting methods.
     *
     * @param fileName
     */
    public void processLogFile(String fileName) {

        AgentLogging agentLog = null;
        // Read object.
        FileInputStream fis = null;
        {

            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(fileName);
                ois =
                        new ObjectInputStream(fis);
                // Read object.
                agentLog = (AgentLogging) ois.readObject();
            } catch (ClassNotFoundException ex) {
                Logger.getLogger(AgentLogProcessor.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(AgentLogProcessor.class.getName()).log(Level.SEVERE, null, ex);
            } finally {
                try {
                    fis.close();
                } catch (IOException ex) {
                    Logger.getLogger(AgentLogProcessor.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    ois.close();
                } catch (IOException ex) {
                    Logger.getLogger(AgentLogProcessor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

        }
        if (agentLog != null) {
            try {
                makeFeelingMoodPlot(agentLog, ".\\graphs\\");
                makeEmotionEventsPlot(agentLog, ".\\graphs\\");
                // -> next one should be on
                makeAgentActionsProposalsSubscenesPlot(agentLog, ".\\graphs\\");
                makeAgentProposalsLog(agentLog, ".\\output\\");
                makeAgentActionsLog(agentLog, ".\\output\\");
                makeAgentStatePlot(agentLog, ".\\graphs\\");
                makeComplexEmotionsPlot(agentLog, ".\\graphs\\");
                makePositionPlot(agentLog, ".\\graphs\\");
                analyzeScenario(agentLog, ".\\output\\");
                makeAgentPositionLog(agentLog, ".\\output\\");
                analyzeFeeling(agentLog, ".\\output\\");
                makeEmotionEventsLog(agentLog, ".\\output\\");
            } catch (IOException ex) {
                Logger.getLogger(AgentLogProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }

    /**
     * Save chart to file in PNG format.
     *
     * @param chart JFreeChart.
     * @param fileName Name of PNG file.
     * @param width Width of PNG image.
     * @param height Height of PNG image.
     * @return Final file name used.
     * @throws IOException on error.
     */
    static public final String saveChartToFile(
            final JFreeChart chart,
            String fileName, final int width, final int height) throws IOException {
        String result = null;

        if (chart != null) {
            if (fileName == null) {
                final String chartTitle = chart.getTitle().getText();
                if (chartTitle != null) {
                    fileName = chartTitle;
                } else {
                    fileName = "chart";
                }

            }
            result = fileName + ".png";
            ChartUtilities.saveChartAsPNG(new File(result), chart, width, height);
        //ChartUtilities.saveChartAsJPEG(new File(result), chart, width, height);
        }//else: input unavailable

        return result;
    }



    /**
     * Main method - can be executed. Construct this objects and process the
     * agentLogging log files at given destination.
     *
     * @param args
     */
    public static void main(String args[]) {
        AgentLogProcessor logProcess = new AgentLogProcessor();

        HashMap<String, ArrayList<String>> experimentMap = new HashMap<String, ArrayList<String>>();

        //String curDir = ".";
        String curDir = "F:\\Temp\\Experiments";

        File dir = new File(curDir);
        //Creating output directories
        (new File(curDir + "\\output")).mkdir();
        (new File(curDir + "\\graphs")).mkdir();

        String[] list = dir.list();

        logProcess.setSuspiciousDoubleActionsAndSubscenes();

        String experimentIndex = "";

        for (int i = 0; i < list.length; i++) {
            if (list[i].contains(".log") && list[i].contains("Scenario")) {
                experimentIndex = list[i].split("2009")[1];

                if (!experimentMap.containsKey(experimentIndex)) {
                    experimentMap.put(experimentIndex, new ArrayList<String>());
                }
                experimentMap.get(experimentIndex).add(curDir + "\\" + list[i]);
            }
        }

        
        String curDirTwo = "F:\\Temp\\Experiments_new";
        File dirTwo = new File(curDirTwo);
        String[] listTwo = dirTwo.list();
        
        for (int i = 0; i < listTwo.length; i++) {
        if (listTwo[i].contains(".log") && listTwo[i].contains("Scenario")) {
        experimentIndex = listTwo[i].split("2009")[1];

        if (!experimentMap.containsKey(experimentIndex)) {
        experimentMap.put(experimentIndex, new ArrayList<String>());
        }
        experimentMap.get(experimentIndex).add(curDirTwo + "\\" + listTwo[i]);
        }
        }

        for (String exId : experimentMap.keySet()) {
            System.out.println("Start processing: " + exId);
            for (String filePath : experimentMap.get(exId)) {
                logProcess.processLogFile(filePath);
                System.out.println(filePath + " processed!");
            }
        }



        try {
            
            logProcess.makeAgentSubscenesFeelingEndValueAnalysis(".\\graphs\\", "Bruno");
            logProcess.makeAgentSubscenesFeelingEndValueAnalysis(".\\graphs\\", "Anne");
            logProcess.makeAgentSubscenesFeelingEndValueAnalysis(".\\graphs\\", "Clementine");

            logProcess.makeAgentSubscenesFeelingDifferencesAnalysis(".\\graphs\\", "Bruno");
            logProcess.makeAgentSubscenesFeelingDifferencesAnalysis(".\\graphs\\", "Anne");
            logProcess.makeAgentSubscenesFeelingDifferencesAnalysis(".\\graphs\\", "Clementine");
            logProcess.makeAgentSubscenesFeelingRangesAnalysis(".\\graphs\\", "Bruno");
            logProcess.makeAgentSubscenesFeelingRangesAnalysis(".\\graphs\\", "Anne");
            logProcess.makeAgentSubscenesFeelingRangesAnalysis(".\\graphs\\", "Clementine");
            logProcess.makeAgentEventsFeelingDifferencePlot(".\\graphs\\", "Bruno");
            logProcess.makeAgentEventsFeelingDifferencePlot(".\\graphs\\", "Anne");
            logProcess.makeAgentEventsFeelingDifferencePlot(".\\graphs\\", "Clementine");

            logProcess.makeSubsceneSeriesAnalyzeLogs(".\\output\\");
            logProcess.makeSubscenesDurationBoxPlot(".\\graphs\\");

            logProcess.makeAgentDoubleActionLogs(".\\output\\");
            logProcess.makeMissedActionsLog(".\\output\\");


        } catch (IOException ex) {
            Logger.getLogger(AgentLogProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Finished!");

    }

    /**
     * Gets the sceneName from integer, uses subsceneIdIntMap.
     *
     * @param i input scene
     * @return scene name
     */
    private String getSceneId(Integer i) {

        for (String sceneId : subsceneIdIntMap.keySet()) {
            if (subsceneIdIntMap.get(sceneId).equals(i)) {
                return sceneId;
            }
        }

        return i.toString();
    }

    /**
     * Returns name of the subscene the agentState corresponds to.
     *
     * @param stateLog
     * @return
     */
    private String getSubscene(AgentStateLog stateLog) {

        if (!stateLog.agentWithName.isEmpty()) {
            if (!stateLog.interruptersNames.isEmpty() && stateLog.agentGoalPlace != PlaceType.NONE) {
                return "INTERRUPTED_WITH_" + stateLog.agentWithName.toUpperCase() + "_ON_WAY_TO_" + stateLog.agentGoalPlace.toString();
            } else if (!stateLog.interruptersNames.isEmpty()) {
                return "INTERRUPTED_WITH_" + stateLog.agentWithName.toUpperCase() + "_AT_" + getPosition(stateLog.agentLocation);
            }
            if ((stateLog.agentState == StateType.FOLLOW_AGENT_WITH) || (stateLog.agentState == StateType.GOING_SOMEWHERE_WITH)) {
                return "WITH_" + stateLog.agentWithName.toUpperCase() + "_ON_WAY_TO_" + stateLog.agentGoalPlace.toString();
            }
            return "WITH_" + stateLog.agentWithName.toUpperCase() + "_AT_" + getPosition(stateLog.agentLocation);
        } else if (!stateLog.interruptersNames.isEmpty()) {
            return "INTERRUPTED_ALONE_AT_" + getPosition(stateLog.agentLocation);
        } else {
            return stateLog.agentState.toString() + "_AT_" + getPosition(stateLog.agentLocation);
        }
    }

    /**
     * Gets list of actions during one supported agent subscene.
     *
     *
     * @param range
     * @param agLog
     * @return list of actions
     */
    private HashMap<String, ArrayList<ActionLog>> getSubsceneActions(Range range, AgentLogging agLog) {

        HashMap<String, ArrayList<ActionLog>> result = new HashMap<String, ArrayList<ActionLog>>();

        for (ActionLog actionLog : agLog.actionsHistory) {

            if (actionLog.time >= range.getLowerBound()) {
                if (actionLog.time <= range.getUpperBound()) {

                        if (!result.containsKey(actionLog.targetName)) {
                            result.put(actionLog.targetName, new ArrayList<ActionLog>());
                        }
                        result.get(actionLog.targetName).add(actionLog);

                } else {
                    return result;
                }
            }

        }

        return result;
    }

    /**
     * Returns hashmap containing information about starts and stops of subscenes
     * in the scenario. Also it stores the information about subscene string for
     * this log file into global object for further analysis!
     *
     * @param agLog
     * @return
     */
    private HashMap<String, Range> getSubscenes(AgentLogging agLog, double minimalLength) {
        HashMap<String, Range> scenes = new HashMap<String, Range>();
        ArrayList<Integer> scenesString = new ArrayList<Integer>();

        String sceneId = "";
        double start = 0, stop = 0;
        boolean inScene = false;

        for (AgentStateLog stateLog : agLog.agentStateHistory) {

            if (inScene) {
                //detecting end of the scene
                if (!sceneId.toLowerCase().equals(getSubscene(stateLog).toLowerCase())) {
                    stop = stateLog.time;
                    if ((stop - start) > minimalLength) {
                        //only consider scenes longer than 5 seconds
                        scenes.put(sceneId + ":" + start, new Range(start, stop));
                        //add to our sceneString object
                        if (!subsceneIdIntMap.containsKey(sceneId)) {
                            subsceneIdIntMap.put(sceneId, subsceneIntId);
                            subsceneIntId++;
                        }
                        scenesString.add(subsceneIdIntMap.get(sceneId));

                    }
                    inScene = false;

                    sceneId = getSubscene(stateLog);
                    inScene = true;
                    start = stateLog.time;
                }
            } else {
                sceneId = getSubscene(stateLog);
                inScene = true;
                start = stateLog.time;
            }
        }
        //add to our scenesString object
        subsceneStrings.put(agLog.fileName, scenesString);

        return scenes;
    }

    private boolean isAlowed(String sceneId) {

        if (sceneId.toLowerCase().contains("interrupted_with") && sceneId.toLowerCase().contains("at") && (sceneId.toLowerCase().contains("elsewhere") || sceneId.toLowerCase().contains("cinema"))) {
            return true;
        } else if (sceneId.toLowerCase().contains("with_") && (sceneId.toLowerCase().contains("anne") && sceneId.toLowerCase().contains("bruno")) && sceneId.toLowerCase().contains("at") && (sceneId.toLowerCase().contains("cinema") || sceneId.toLowerCase().contains("home"))) {
            return true;
        }

        return false;
    }

    /**
     * Used to match two subScene series lists if they are the same or not.
     *
     * @param subsceneSerie
     * @param setId
     * @return
     */
    private boolean listsEquals(ArrayList<Integer> subsceneSerie, ArrayList<Integer> setId) {

        int length = 0;

        if (subsceneSerie.isEmpty() && setId.isEmpty()) {
            return true;
        } else if (subsceneSerie.isEmpty() && !setId.isEmpty()) {
            return false;
        } else if (!subsceneSerie.isEmpty() && setId.isEmpty()) {
            return false;
        }

        if (subsceneSerie.size() >= setId.size()) {
            length = setId.size();
        } else {
            length = subsceneSerie.size();
        }

        //if one of the lists is short we wont compare them
        for (int i = 0; i < length; i++) {
            if (!subsceneSerie.get(i).equals(setId.get(i))) {
                return false;
            }
        }
        if (Math.abs(subsceneSerie.size() - setId.size()) > 2) {
            return false;
        }

        return true;
    }

    /**
     * Plots feeling differences for each sub-scene in the scenario in a box plot
     * graph.
     * 
     */
    private void makeAgentSubscenesFeelingDifferencesAnalysis(String directory, String agentName) throws IOException {

        BufferedWriter out = new BufferedWriter(new FileWriter(directory + agentName + "_SUBSCENES_FEELING_ANALYSIS.txt"));

        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();

        if (!subsceneFeelingDifferences.containsKey(agentName)) {
            return;
        }

        HashMap<String, HashMap<String, ArrayList<Double>>> agentScenes = subsceneFeelingDifferences.get(agentName);

        Object[] key = agentScenes.keySet().toArray();
        Arrays.sort(key);
        String sceneId = "";

        for (int i = 0; i < key.length; i++) {
            sceneId = (String) key[i];
            for (String targetAgent : agentScenes.get(sceneId).keySet()) {
                //if (!targetAgent.equals("Emohawk") && isAlowed(sceneId))
                dataset.add(agentScenes.get(sceneId).get(targetAgent), targetAgent, sceneId);
                out.append("SceneId:" + sceneId + "; AgentName:" + targetAgent + "; Size:" + agentScenes.get(sceneId).get(targetAgent).size() + "; \n");
            }
        }
        out.close();

        CategoryPlot plot = createBoxAndWhiskerCategoryPlot("Scene Type", "Feeling Differences", dataset);

        //plot.getDataset().
        //plot.setOrientation(PlotOrientation.HORIZONTAL);

        JFreeChart chart = new JFreeChart(
                agentName + " subscene feelings analysis (difference between feelings at the beginning and the end of the subscene)",
                new Font("SansSerif", Font.BOLD, 14),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 800);
        }

        saveChartToFile(chart, directory + agentName + "_FEELINGS_DIFFERENCE_ANALYSIS", 1480, 800);
    }


    /**
     * Plots feeling end values for each sub-scene in the scenario in a box plot
     * graph.
     *
     */
    private void makeAgentSubscenesFeelingEndValueAnalysis(String directory, String agentName) throws IOException {

        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();

        if (!subsceneFeelingEndValue.containsKey(agentName)) {
            return;
        }

        HashMap<String, HashMap<String, ArrayList<Double>>> agentScenes = subsceneFeelingEndValue.get(agentName);

        Object[] key = agentScenes.keySet().toArray();
        Arrays.sort(key);
        String sceneId = "";

        for (int i = 0; i < key.length; i++) {
            sceneId = (String) key[i];
            for (String targetAgent : agentScenes.get(sceneId).keySet()) {
                dataset.add(agentScenes.get(sceneId).get(targetAgent), targetAgent, sceneId);
            }
        }

        CategoryPlot plot = createBoxAndWhiskerCategoryPlot("Scene Type", "Feeling end value", dataset);
        //plot.setOrientation(PlotOrientation.HORIZONTAL);

        JFreeChart chart = new JFreeChart(
                agentName + " subscene feeling end value analysis (feeling value at the end of subscene)",
                new Font("SansSerif", Font.BOLD, 14),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 800);
        }

        saveChartToFile(chart, directory + agentName + "_FEELINGS_END_VALUE_ANALYSIS", 1480, 800);
    }


    /**
     * Plots feeling ranges (max differences between min and max values during sub-scene)
     * for each sub-scene in the scenario in a box plot graph.
     *
     */
    private void makeAgentSubscenesFeelingRangesAnalysis(String directory, String agentName) throws IOException {

        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();

        if (!subsceneFeelingRanges.containsKey(agentName)) {
            return;
        }

        HashMap<String, HashMap<String, ArrayList<Double>>> agentScenes = subsceneFeelingRanges.get(agentName);

        Object[] key = agentScenes.keySet().toArray();
        Arrays.sort(key);
        String sceneId = "";

        for (int i = 0; i < key.length; i++) {
            sceneId = (String) key[i];
            for (String targetAgent : agentScenes.get(sceneId).keySet()) {
                dataset.add(agentScenes.get(sceneId).get(targetAgent), targetAgent, sceneId);
            }
        }

        CategoryPlot plot = createBoxAndWhiskerCategoryPlot("Scene Type", "Feelings Range", dataset);
        //plot.setOrientation(PlotOrientation.HORIZONTAL);

        JFreeChart chart = new JFreeChart(
                agentName + " subscene feeling ranges analysis (difference between max and min feeling during the subscene)",
                new Font("SansSerif", Font.BOLD, 14),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 800);
        }

        saveChartToFile(chart, directory + agentName + "_FEELINGS_RANGE_ANALYSIS", 1480, 800);
    }

    /**
     * Some analysis of feeling difference for all emotion events. Feeling difference
     * between feeling values at the time of the event and at one second after the
     * event.
     *
     */
    private void makeAgentEventsFeelingDifferencePlot(String directory, String agentName) throws IOException {

        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        BufferedWriter out = new BufferedWriter(new FileWriter(directory + agentName + "_EMOTION_EVENTS_FEELING_ANALYSIS.txt"));

        if (!eventsFeelingDifferences.containsKey(agentName)) {
            return;
        }

        HashMap<String, HashMap<String, ArrayList<Double>>> agentEvents = eventsFeelingDifferences.get(agentName);

        Object[] key = agentEvents.keySet().toArray();
        Arrays.sort(key);
        String eventId = "";

        for (int i = 0; i < key.length; i++) {
            eventId = (String) key[i];
            for (String targetAgent : agentEvents.get(eventId).keySet()) {
                dataset.add(agentEvents.get(eventId).get(targetAgent), targetAgent, eventId);
                out.append("EventId:" + eventId + "; AgentName:" + targetAgent + "; Size:" + agentEvents.get(eventId).get(targetAgent).size() + "; \n");
            }
        }
        out.close();

        CategoryPlot plot = createBoxAndWhiskerCategoryPlot("Event Type", "Feelings Difference", dataset);
        //plot.setOrientation(PlotOrientation.HORIZONTAL);

        JFreeChart chart = new JFreeChart(
                agentName + " emotion events feeling difference analysis (feelings watched until 1 second after event)",
                new Font("SansSerif", Font.BOLD, 14),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(3000, 800);
        }

        saveChartToFile(chart, directory + agentName + "_EVENTS_FEELINGS_ANALYSIS", 3000, 800);
    }

    /**
     * Process feelings at the end of the scenario.
     *
     * @param inputFeelings
     * @param fileName
     */
    private void makeEndFeelingsAnalyzeLog(HashMap<String, ArrayList<ArrayList<FeelingLog>>> inputFeelings, String fileName) throws IOException {

        BufferedWriter out = new BufferedWriter(new FileWriter(fileName + "_END_FEELINGS.txt"));

        double anneToBruno = 0, anneToClem = 0, brunoToAnne = 0, brunoToClem = 0, clemToBruno = 0, clemToAnne = 0;

        int BA = 0, BC = 0, AB = 0, AC = 0, CB = 0, CA = 0;
        int BA2 = 0, BC2 = 0, AB2 = 0, AC2 = 0, CB2 = 0, CA2 = 0;
        int BA3 = 0, BC3 = 0, AB3 = 0, AC3 = 0, CB3 = 0, CA3 = 0;
        int BA4 = 0, BC4 = 0, AB4 = 0, AC4 = 0, CB4 = 0, CA4 = 0;


        for (FeelingLog feelLog : inputFeelings.get("Anne").get(inputFeelings.get("Anne").size() - 1)) {

            if (feelLog.agentName.toLowerCase().contains("bruno")) {
                anneToBruno = feelLog.intensity;
            }
            if (feelLog.agentName.toLowerCase().contains("clementine")) {
                anneToClem = feelLog.intensity;
            }
        }

        for (FeelingLog feelLog : inputFeelings.get("Bruno").get(inputFeelings.get("Bruno").size() - 1)) {

            if (feelLog.agentName.toLowerCase().contains("anne")) {
                brunoToAnne = feelLog.intensity;
            }
            if (feelLog.agentName.toLowerCase().contains("clementine")) {
                brunoToClem = feelLog.intensity;
            }
        }

        for (FeelingLog feelLog : inputFeelings.get("Clementine").get(inputFeelings.get("Clementine").size() - 1)) {

            if (feelLog.agentName.toLowerCase().contains("bruno")) {
                clemToBruno = feelLog.intensity;
            }
            if (feelLog.agentName.toLowerCase().contains("anne")) {
                clemToAnne = feelLog.intensity;
            }
        }

        if (brunoToAnne > 2) {
            BA = 1;
        }
        if (brunoToAnne > 1) {
            BA2 = 2;
        }
        if (brunoToAnne > 0) {
            BA3 = 3;
        }
        if (brunoToAnne < -1) {
            BA4 = 4;
        }

        if (brunoToClem > 2) {
            BC = 1;
        }
        if (brunoToClem > 1) {
            BC2 = 2;
        }
        if (brunoToClem > 0) {
            BC3 = 3;
        }
        if (brunoToClem < -1) {
            BC4 = 4;
        }

        if (anneToBruno > 2) {
            AB = 1;
        }
        if (anneToBruno > 1) {
            AB2 = 2;
        }
        if (anneToBruno > 0) {
            AB3 = 3;
        }
        if (anneToBruno < -1) {
            AB4 = 4;
        }

        if (anneToClem > 2) {
            AC = 1;
        }
        if (anneToClem > 1) {
            AC2 = 2;
        }
        if (anneToClem > 0) {
            AC3 = 3;
        }
        if (anneToClem < -1) {
            AC4 = 4;
        }

        if (clemToBruno > 2) {
            CB = 1;
        }
        if (clemToBruno > 1) {
            CB2 = 2;
        }
        if (clemToBruno > 0) {
            CB3 = 3;
        }
        if (clemToBruno < -1) {
            CB4 = 4;
        }

        if (clemToAnne > 2) {
            CA = 1;
        }
        if (clemToAnne > 1) {
            CA2 = 2;
        }
        if (clemToAnne > 0) {
            CA3 = 3;
        }
        if (clemToAnne < -1) {
            CA4 = 4;
        }

        out.append("Lovers:" + BA + BC + AB + AC + CB + CA + "; ");
        out.append("Friends:" + BA2 + BC2 + AB2 + AC2 + CB2 + CA2 + "; ");
        out.append("Positive:" + BA3 + BC3 + AB3 + AC3 + CB3 + CA3 + "; ");
        out.append("Hate:" + BA4 + BC4 + AB4 + AC4 + CB4 + CA4 + "; \n");

        out.append("BrunoToAnne:" + brunoToAnne + "; \n");
        out.append("BrunoToClem:" + brunoToClem + "; \n");
        out.append("AnneToBruno:" + anneToBruno + "; \n");
        out.append("AnneToClem:" + anneToClem + "; \n");
        out.append("ClemToBruno:" + clemToBruno + "; \n");
        out.append("ClemToAnne:" + clemToAnne + "; \n");

        out.close();
    }

    /**
     * Logs all missed actions during all of experiments.
     *
     * @param string
     */
    private void makeMissedActionsLog(String directory) throws IOException {

        BufferedWriter out = new BufferedWriter(new FileWriter(directory + "MISSED_ACTIONS_COUNT.txt"));

        for (String agentName : missedActionsCount.keySet()) {
            out.append(agentName + " missed actions: \n");
            out.append("------------- \n");

            for (String actionId : missedActionsCount.get(agentName).keySet()){

                out.append(actionId + ":" + missedActionsCount.get(agentName).get(actionId) + "\n");
            }
            out.append("\n");
        }

        out.close();

    }

    /**
     * Creates boxplot with subscenes durations. 
     *
     * @param agLog
     * @param directory
     */
    private void makeSubscenesDurationBoxPlot(String directory) throws IOException {
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();

        HashMap<String, HashMap<String, ArrayList<Double>>> agentSubsceneDurations = new HashMap<String, HashMap<String, ArrayList<Double>>>();

        agentSubsceneDurations.put("Anne", new HashMap<String, ArrayList<Double>>());
        agentSubsceneDurations.put("Bruno", new HashMap<String, ArrayList<Double>>());
        agentSubsceneDurations.put("Clementine", new HashMap<String, ArrayList<Double>>());

        for (String logId : subscenesDurations.keySet()) {
            String sceneId = "";
            String agentName = "";
            for (String sceneName : subscenesDurations.get(logId).keySet()) {

                sceneId = sceneName.split(":")[0];

                if (logId.toLowerCase().contains("anne")) {
                    agentName = "Anne";
                } else if (logId.toLowerCase().contains("bruno")) {
                    agentName = "Bruno";
                } else if (logId.toLowerCase().contains("clementine")) {
                    agentName = "Clementine";
                } else {
                    agentName = "None";
                    if (!agentSubsceneDurations.containsKey("None")) {
                        agentSubsceneDurations.put("None", new HashMap<String, ArrayList<Double>>());
                    }
                }

                if (!agentSubsceneDurations.get(agentName).containsKey(sceneId)) {
                    agentSubsceneDurations.get(agentName).put(sceneId, new ArrayList<Double>());
                }
                agentSubsceneDurations.get(agentName).get(sceneId).add(subscenesDurations.get(logId).get(sceneName));
            }

        }

        //filling the dataset
        for (String agName : agentSubsceneDurations.keySet()) {
            for (String subsceneId : agentSubsceneDurations.get(agName).keySet()) {
                dataset.add(agentSubsceneDurations.get(agName).get(subsceneId), agName, subsceneId);
            }
        }

        CategoryPlot plot = createBoxAndWhiskerCategoryPlot("Scene Type", "Duration (seconds)", dataset);

        //plot.getDataset().
        //plot.setOrientation(PlotOrientation.HORIZONTAL);

        JFreeChart chart = new JFreeChart(
                "Subscenes durations analysis",
                new Font("SansSerif", Font.BOLD, 14),
                plot,
                true);

        if (bAllowFrames) {
            ChartFrame frame1 = new ChartFrame("XYLine Chart", chart);

            frame1.setVisible(true);
            frame1.setSize(1480, 800);
        }

        saveChartToFile(chart, directory + "SUBSCENES_DURATIONS_ANALYSIS", 1480, 800);

    }

   /**
     * Makes double actions analysis for whole scenario. The maximum delay
     * between double action is 15 seconds.
     *
     * @param agLog
     */
    private void processDoubleActions(AgentLogging agLog) {
        HashMap<String, ArrayList<ActionLog>> actions = null;
        double lowerBound, upperBound;

        if (!agLog.actionsHistory.isEmpty()) {
            lowerBound = agLog.actionsHistory.get(0).time;
            upperBound = agLog.actionsHistory.get(agLog.actionsHistory.size() - 1).time;
        } else {
            lowerBound = 0;
            upperBound = 0;
        }

        actions = getSubsceneActions(new Range(lowerBound, upperBound), agLog);

        /*
        agentSubscenesActionCounts = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, Integer>>>>();
        HashMap<String, HashMap<String, HashMap<String, Integer>>> agentActionCounts
         */

        if (!agentDoubleActions.containsKey(agLog.agentName)) {
            agentDoubleActions.put(agLog.agentName, new HashMap<String, HashMap<String, Integer>>());
        }

        if (!agentActionCounts.containsKey(agLog.agentName)) {
            agentActionCounts.put(agLog.agentName, new HashMap<String, HashMap<String, Integer>>());
        }

        for (String targetName : actions.keySet()) {

            ActionLog previousActionLog = null;
            ArrayList<ActionLog> oneTargetActions = actions.get(targetName);

            for (ActionLog actionLog : oneTargetActions) {
                if (!agentActionCounts.get(agLog.agentName).containsKey(targetName)) {
                    agentActionCounts.get(agLog.agentName).put(targetName, new HashMap<String, Integer>());
                }
                HashMap<String, Integer> actionsCount = agentActionCounts.get(agLog.agentName).get(targetName);
                if (!actionsCount.containsKey(actionLog.actionType.toString())) {
                    actionsCount.put(actionLog.actionType.toString(), 1);
                } else {
                    actionsCount.put(actionLog.actionType.toString(), actionsCount.get(actionLog.actionType.toString()) + 1);
                }

                if ((actionLog.actionType == ActionType.TALK) || (actionLog.actionType == ActionType.PROPOSAL))
                    continue;

                if (previousActionLog != null) {

                    if (actionLog.time - previousActionLog.time <= 15) {
                        if (!agentDoubleActions.get(agLog.agentName).containsKey(targetName)) {
                            agentDoubleActions.get(agLog.agentName).put(targetName, new HashMap<String, Integer>());
                        }
                        HashMap<String, Integer> doubleActionsCount = agentDoubleActions.get(agLog.agentName).get(targetName);

                        String doubleActionId = previousActionLog.actionType.toString() + actionLog.actionType.toString();
                        checkSuspiciousDoubleAction(doubleActionId, agLog.fileName);
                        if (!doubleActionsCount.containsKey(doubleActionId)) {
                            doubleActionsCount.put(doubleActionId, 1);
                        } else {
                            doubleActionsCount.put(doubleActionId, doubleActionsCount.get(doubleActionId) + 1);
                        }
                    }
                }

                previousActionLog = actionLog;
            }
        }

    }

    /**
     * Will store double actions in subscenes into agentSubscenesDoubleActions variable
     * for supported input.
     *
     * @param subscenes
     * @param agLog
     */
    private void processSubscenesDoubleActions(HashMap<String, Range> subscenes, AgentLogging agLog) {
        HashMap<String, ArrayList<ActionLog>> subsceneActions = null;

        for (String sceneName : subscenes.keySet()) {
            String sceneId = sceneName.split(":")[0];

            subsceneActions = getSubsceneActions(subscenes.get(sceneName), agLog);

            if (!agentSubscenesDoubleActions.containsKey(agLog.agentName)) {
                agentSubscenesDoubleActions.put(agLog.agentName, new HashMap<String, HashMap<String, HashMap<String, Integer>>>());
            }
            if (!agentSubscenesDoubleActions.get(agLog.agentName).containsKey(sceneId)) {
                agentSubscenesDoubleActions.get(agLog.agentName).put(sceneId, new HashMap<String, HashMap<String, Integer>>());
            }

            if (!agentSubscenesActionCounts.containsKey(agLog.agentName)) {
                agentSubscenesActionCounts.put(agLog.agentName, new HashMap<String, HashMap<String, HashMap<String, Integer>>>());
            }
            if (!agentSubscenesActionCounts.get(agLog.agentName).containsKey(sceneId)) {
                agentSubscenesActionCounts.get(agLog.agentName).put(sceneId, new HashMap<String, HashMap<String, Integer>>());
            }

            for (String targetName : subsceneActions.keySet()) {

                ActionType previousAction = null;
                ArrayList<ActionLog> oneTargetActions = subsceneActions.get(targetName);

                for (ActionLog actionLog : oneTargetActions) {
                    if (!agentSubscenesActionCounts.get(agLog.agentName).get(sceneId).containsKey(targetName)) {
                        agentSubscenesActionCounts.get(agLog.agentName).get(sceneId).put(targetName, new HashMap<String, Integer>());
                    }
                    HashMap<String, Integer> actionsCount = agentSubscenesActionCounts.get(agLog.agentName).get(sceneId).get(targetName);
                    if (!actionsCount.containsKey(actionLog.actionType.toString())) {
                        actionsCount.put(actionLog.actionType.toString(), 1);
                    } else {
                        actionsCount.put(actionLog.actionType.toString(), actionsCount.get(actionLog.actionType.toString()) + 1);
                    }
                    
                    if ((actionLog.actionType == ActionType.TALK) || (actionLog.actionType == ActionType.PROPOSAL))
                        continue;

                    if (previousAction != null) {
                        if (!agentSubscenesDoubleActions.get(agLog.agentName).get(sceneId).containsKey(targetName)) {
                            agentSubscenesDoubleActions.get(agLog.agentName).get(sceneId).put(targetName, new HashMap<String, Integer>());
                        }
                        HashMap<String, Integer> doubleActionsCount = agentSubscenesDoubleActions.get(agLog.agentName).get(sceneId).get(targetName);

                        String doubleActionId = previousAction.toString() + actionLog.actionType.toString();
                        //checkSuspiciousDoubleAction(doubleActionId, agLog.fileName);
                        if (!doubleActionsCount.containsKey(doubleActionId)) {
                            doubleActionsCount.put(doubleActionId, 1);
                        } else {
                            doubleActionsCount.put(doubleActionId, doubleActionsCount.get(doubleActionId) + 1);
                        }
                    }

                    previousAction = actionLog.actionType;
                }
            }
        }
    }

    /**
     * Sets suspicious double actions and store it into suspiciousDoubleActions HashMap.
     * Also sets suspicious double subcenes and store them in suspiciousDoubleSubscenes.
     * 
     */
    private void setSuspiciousDoubleActionsAndSubscenes() {
        //double actions
        suspiciousDoubleActions.put("COMPLIMENTSLAP", new ArrayList<String>());
        suspiciousDoubleActions.put("COMPLIMENTINSULT", new ArrayList<String>());
        suspiciousDoubleActions.put("KISSSLAP", new ArrayList<String>());
        suspiciousDoubleActions.put("KISSINSULT", new ArrayList<String>());
        suspiciousDoubleActions.put("KISSLEAVE", new ArrayList<String>());
        suspiciousDoubleActions.put("SLAPCOMPLIMENT", new ArrayList<String>());
        suspiciousDoubleActions.put("INSULTCOMPLIMENT", new ArrayList<String>());
        suspiciousDoubleActions.put("BYELEAVE", new ArrayList<String>());
        suspiciousDoubleActions.put("LEAVEBYE", new ArrayList<String>());
        suspiciousDoubleActions.put("LEAVECOMPLIMENT", new ArrayList<String>());
        suspiciousDoubleActions.put("LEAVEINSULT", new ArrayList<String>());
        suspiciousDoubleActions.put("LEAVESLAP", new ArrayList<String>());
        suspiciousDoubleActions.put("BYESLAP", new ArrayList<String>());
        suspiciousDoubleActions.put("BYECOMPLIMENT", new ArrayList<String>());
        suspiciousDoubleActions.put("SEXSEX", new ArrayList<String>());
        suspiciousDoubleActions.put("SEXCOMPLIMENT", new ArrayList<String>());
        suspiciousDoubleActions.put("BYEBYE", new ArrayList<String>());

        //double subscenes
        suspiciousDoubleSubscenes.put("WITH_ANNE_ON_WAY_TO_GIRL1_HOME AGENT_ALONE_AT_ANNE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_ANNE_AT_ANNE_HOME INTERRUPTED_ALONE_AT_ANNE_HOME", true);
        suspiciousDoubleSubscenes.put("AGENT_ALONE_AT_CINEMA APPROACH_BOYS_AT_CINEMA", true);
        suspiciousDoubleSubscenes.put("AGENT_ALONE_AT_ELSEWHERE INTERRUPTED_ALONE_AT_CLEMENTINE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_BRUNO_ON_WAY_TO_MY_HOME INTERRUPTED_ALONE_AT_ANNE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_BRUNO_ON_WAY_TO_CINEMA AGENT_ALONE_AT_CLEMENTINE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_CLEMENTINE_ON_WAY_TO_GIRL2_HOME WITH_CLEMENTINE_AT_ELSEWHERE", true);
        suspiciousDoubleSubscenes.put("INTERRUPTED_WITH_CLEMENTINE_AT_CLEMENTINE_HOME AGENT_ALONE_AT_ELSEWHERE", true);
        suspiciousDoubleSubscenes.put("INTERRUPTED_ALONE_AT_CLEMENTINE_HOME WITH_ANNE_AT_CLEMENTINE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_CLEMENTINE_AT_ANNE_HOME WITH_CLEMENTINE_AT_ELSEWHERE", true);
        suspiciousDoubleSubscenes.put("WITH_CLEMENTINE_AT_ANNE_HOME WITH_CLEMENTINE_ON_WAY_TO_CINEMA", true);
        suspiciousDoubleSubscenes.put("AGENT_ALONE_AT_ANNE_HOME INTERRUPTED_WITH_BRUNO_AT_ANNE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_BRUNO_AT_ANNE_HOME WITH_BRUNO_ON_WAY_TO_CINEMA", true);
        suspiciousDoubleSubscenes.put("AGENT_ALONE_AT_CLEMENTINE_HOME WITH_ANNE_AT_CLEMENTINE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_ANNE_AT_ELSEWHERE WITH_CLEMENTINE_AT_CINEMA", true);
        suspiciousDoubleSubscenes.put("INTERRUPTED_WITH_BRUNO_AT_ANNE_HOME AGENT_ALONE_AT_ANNE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_ANNE_ON_WAY_TO_GIRL1_HOME INTERRUPTED_WITH_CLEMENTINE_AT_ANNE_HOME", true);
        suspiciousDoubleSubscenes.put("WITH_BRUNO_ON_WAY_TO_CINEMA INTERRUPTED_WITH_BRUNO_ON_WAY_TO_MY_HOME", true);
    }
}
