/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logging;

import info.ActionType;
import java.io.Serializable;

/**
 * This class is used to store one action issued in our scenario.
 *
 * @author Knight
 */
public class ActionLog implements Serializable {

    /**
     * The type of the action.
     */
    public ActionType actionType;

    /**
     * Id of the target agent.
     */
    public int targetId;

    /**
     * Feeling value toward target agent of the action at the time of issueing.
     */
    public double feeling;

    /**
     * Name of target agent of the action.
     */
    public String targetName;

    /**
     * Time of the action.
     */
    public double time;

    /**
     * Duration of the action.
     */
    public double duration;

    /**
     * Complete constructor that initializes all the variables.
     *
     * @param actionType
     * @param targetId
     * @param feeling
     * @param targetName
     * @param time
     * @param duration
     */
    public ActionLog(ActionType actionType, int targetId, double feeling, String targetName, double time, double duration) {
        this.actionType = actionType;
        this.targetId = targetId;
        this.feeling = feeling;
        this.targetName = targetName;
        this.time = time;
        this.duration = duration;
    }

}
