/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package info;

import java.io.Serializable;

/**
 * This class is used to store proposal info. We use this to store proposals we make
 * to someone and also for proposals someone makes to us.
 *
 * Implements serializable, because it is logged!
 * 
 * @author Knight
 */
public class ProposalInfo implements Serializable {

    /** Type of the proposal */
    private ProposalType type;

    /** Either who is this proposal for, or from who is this proposal */
    private int target;

    /** Time we have made/received this proposal */
    private double time;

    /** Time we have responded or when we have got response to this proposal */
    private double proposalResponseTime = 0;

    /** When proposal accepted, ignored, rejected we will generate one event and store the info here */
    private boolean eventGenerated = false;

    /** True if proposal was accepted */
    private boolean proposalAccepted = false;
    /** True if proposal was rejected */
    private boolean proposalRejected = false;
    /** True if proposal was ignored */
    private boolean proposalIgnored = false;

    /**
     * After we have received response to the proposal, we should generate emotional
     * evanet. Here we get if the event was already generated.
     *
     * @return true if the event was generated
     */
    public boolean isEventGenerated() {
        return eventGenerated;
    }

    /**
     * Sets eventGenerated flag.
     *
     * @param eventGenerated input boolean
     */
    public void setEventGenerated(boolean eventGenerated) {
        this.eventGenerated = eventGenerated;
    }

    /**
     * Is proposal accepted?
     *
     * @return
     */
    public boolean isProposalAccepted() {
        return proposalAccepted;
    }

    /**
     * Sets proposal accepted/
     *
     * @param proposalAccepted
     */
    public void setProposalAccepted(boolean proposalAccepted) {
        this.proposalAccepted = proposalAccepted;
    }

    /**
     * Is proposal ignored?
     *
     * @return
     */
    public boolean isProposalIgnored() {
        return proposalIgnored;
    }

    /**
     * Sets proposal ignored.
     *
     * @param proposalIgnored
     */
    public void setProposalIgnored(boolean proposalIgnored) {
        this.proposalIgnored = proposalIgnored;
    }

    /**
     * Is proposal rejected?
     *
     * @return
     */
    public boolean isProposalRejected() {
        return proposalRejected;
    }

    /**
     * Sets proposal rejected flag.
     *
     * @param proposalRejected
     */
    public void setProposalRejected(boolean proposalRejected) {
        this.proposalRejected = proposalRejected;
    }

    /**
     * Gets id of the agent this proposal is for, or id of the agent who made the
     * proposal.
     *
     * @return id of the agent
     */
    public int getTarget() {
        return target;
    }

    /**
     * Sets id of the agent this proposal is for, or who made this proposal to us.
     *
     * @param target id of the agent
     */
    public void setTarget(int target) {
        this.target = target;
    }

    /**
     * Gets time this proposal was created.
     *
     * @return time
     */
    public double getTime() {
        return time;
    }

    /**
     * Sets time this proposal was created.
     *
     * @param time input time
     */
    public void setTime(double time) {
        this.time = time;
    }

    /**
     * Gets time this proposal was responded.
     *
     * @return proposal response time
     */
    public double getProposalResponseTime() {
        return proposalResponseTime;
    }

    /**
     * Sets proposal response time.
     *
     * @param proposalResponseTime input time
     */
    public void setProposalResponseTime(double proposalResponseTime) {
        this.proposalResponseTime = proposalResponseTime;
    }

    /**
     * Gets type of this proposal.
     *
     * @return proposal type
     */
    public ProposalType getType() {
        return type;
    }

    /**
     * Sets type of this proposal.
     *
     * @param type input type
     */
    public void setType(ProposalType type) {
        this.type = type;
    }

    /**
     * Constructor for this class.
     *
     * @param type input proposal type
     * @param target input agent id
     * @param time input proposal time
     */
    public ProposalInfo(ProposalType type, int target, double time ){
        this.type = type;
        this.target = target;
        this.time = time;
    }

    /**
     * Complete constructor for this class.
     *
     * @param type type of the proposal
     * @param target agent id this proposal is from/to
     * @param time time of the proposal
     * @param responseTime response time of the proposal
     * @param accepted was proposal accepted
     * @param rejected was proposal rejected
     * @param ignored was proposal ignored
     */
    public ProposalInfo(ProposalType type, int target, double time, double responseTime, boolean accepted, boolean rejected, boolean ignored ){
        this.type = type;
        this.target = target;
        this.time = time;
        this.proposalResponseTime = responseTime;
        this.proposalAccepted = accepted;
        this.proposalRejected = rejected;
        this.proposalIgnored = ignored;
    }

}
