/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package info;

import java.util.ArrayList;

/**
 * Used by AEventGenerator to generate proper polymorph events (with proper emotional
 * intensity). We are continously decreasing the intensity of emotions that are triggered
 * by repeating events - such as polymorph groaning. We store these events in this class.
 *
 * @author Knight
 */
public class PolymorphEventInfo {

    /** Polymorph agent id */
    private int id;

    /** Last time some repeating event was caused by the polymorph */
    private double lastPolymorphEventTime = -100;

    /** Here we store last x polymorph agent events */
    private ArrayList<Double> eventCounter = new ArrayList<Double>();

    /** Last time this polymorph bite us */
    private double lastBiteTime = 0;

    /**
     * Gets id of the polymorph.
     *
     * @return polymorph id
     */
    public int getId() {
        return id;
    }

    /**
     * Sets id of this polymorph.
     *
     * @param id new id
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * Gets last time the polymorph has caused some event.
     *
     * @return last polymorph event time
     */
    public double getLastPolymorphEventTime() {
        return lastPolymorphEventTime;
    }

    /**
     * Sets last time the polymorph caused some event.
     *
     * @param lastPolymorphEventTime new time
     */
    public void setLastPolymorphEventTime(double lastPolymorphEventTime) {
        this.lastPolymorphEventTime = lastPolymorphEventTime;
    }

    /**
     * Gets event counter object.
     *
     * @return event counter object
     */
    public ArrayList<Double> getEventCounter() {
        return eventCounter;
    }

    /**
     * Gets last time the polymorph has bitten us.
     *
     * @return last polymorph bite time
     */
    public double getLastBiteTime() {
        return lastBiteTime;
    }

    /**
     * Constructor for this class, requires polymorph id.
     *
     * @param id polymorph id
     */
    public PolymorphEventInfo(int id){
        this.id = id;
    }

    /**
     * Updates this class internal variables according to the action the polymorph
     * have made to us. Right now the polymorph just can bite us, nothing else.
     *
     * @param type type of the action
     * @param currentTime time of the action
     */
    public void updateAction(ActionType type, double currentTime) {
        if (type == ActionType.BITE){
            lastBiteTime = currentTime;
        }
    }

}
