/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package info;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * Class holding information about other agents - mainly appearance info, items
 * info, actions info.
 *
 * @author Knight
 */
public class PlayerInfo {

    /** Id of the agent */
    private int id;

    /** Name of the agent */
    private String name;

    /** Last location of the agent */
    private Location lastLocation;

    /** Last rotation of the agent */
    private Rotation lastRotation;

    /** Last time we have seen agent */
    private double lastSeenTime;

    /** First time we have seen agent */
    private double firstSeenTime;

    /**
     * Counter that is used to generate timeTogether event, that the agents been together for some time
     * gets reset after that
     */
    private double timeTogetherCounter = 0;

    /** Time together the agent spent with this agent */
    private double timeTogether = 0;
    /** Last time of lost event */
    private double lastLostEventTime = -100;

    /** Last time we have been at cinema with this agent */
    private double lastAtCinemaTime = 0;

    /** Last time we have been at home with this agent */
    private double lastAtHomeTime = 0;

    /** Last time we have been at park with this agent */
    private double lastAtParkTime = 0;

    /** Last time we have kissed this agent */
    private double lastKissTime = 0;

    /** Last time this agent kissed us */
    private double lastKissByTime = 0;

    /** Last time we have slapped this agent */
    private double lastSlapTime = 0;

    /** Last time we have been slapped by this agent */
    private double lastSlapByTime = 0;

    /** Last time we have kicked this agent */
    private double lastKickTime = 0;

    /** Last time this agent has kicked us */
    private double lastKickByTime = 0;

    /** Last time we have cuddled this agent */
    private double lastCuddleTime = 0;

    /** Last time this agent has cuddled us */
    private double lastCuddleByTime = 0;

    /** Last time we have left this agent */
    private double lastLeaveTime = 0;

    /** Last time this agent has left us */
    private double lastLeaveByTime = 0;

    /** Last time we complimented this agent */
    private double lastComplimentTime = 0;

    /** Last time this agent has complimented us */
    private double lastComplimentByTime = 0;

    /** Last time we said bye and departed from the agent */
    private double lastByeTime = 0;

    /** Last time the agent said bye and departed from us */
    private double lastByeByTime = 0;

    /** Last time we have made insult toward the agent */
    private double lastInsultTime;

    /** Last time the agent made insult to us */
    private double lastInsultByTime;

    /** Last time we made action sex with the agent */
    private double lastSexTime;

    /** Last time the agent made action sex with us */
    private double lastSexByTime;

    /** Last time this agent has ignored our conversation */
    private double lastIgnoreByTime = 0;

    /** Last time this agent has interrupted us */
    private double lastInterruptedTime = 0;

    /** Last time we've did any action towards this agent */
    private double lastActionTime = 0;

    /** Last action type we have did to this agent */
    private ActionType lastActionType;

    /** Last time this agent did any action towards us */
    private double lastActionByTime = 0;

    /** Last action type this agent did to us */
    private ActionType lastActionByType;


    /** Items we have received from the player */
    private HashMap<ScenarioItemType, ArrayList<Double>> receivedItems = new HashMap<ScenarioItemType, ArrayList<Double>>();

    /** Items we have given to the player */
    private HashMap<ScenarioItemType, ArrayList<Double>> givenItems = new HashMap<ScenarioItemType, ArrayList<Double>>();

    /**
     * Gets time together with the agent.
     *
     * @return time together
     */
    public double getTimeTogether() {
        return timeTogether;
    }

    /**
     * Sets time together.
     *
     * @param timeTogether input time
     */
    public void setTimeTogether(double timeTogether) {
        this.timeTogether = timeTogether;
    }

    /**
     * Gets last lost event time.
     *
     * @return lost event time
     */
    public double getLastLostEventTime() {
        return lastLostEventTime;
    }

    /**
     * Sets last lost event time
     *
     * @param lastLostEventTime input time
     */
    public void setLastLostEventTime(double lastLostEventTime) {
        this.lastLostEventTime = lastLostEventTime;
    }

    /**
     * Gets time together counter.
     *
     * @return time together counter
     */
    public double getTimeTogetherCounter() {
        return timeTogetherCounter;
    }

    /**
     * Sets time together counter
     *
     * @param timeTogetherCounter input time
     */
    public void setTimeTogetherCounter(double timeTogetherCounter) {
        this.timeTogetherCounter = timeTogetherCounter;
    }

    /**
     * Gets id of the agent.
     *
     * @return id of the agent
     */
    public int getId() {
        return id;
    }

    /**
     * Sets id of the agent.
     *
     * @param id input id
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * Gets last location of the agent.
     *
     * @return last location
     */
    public Location getLastLocation() {
        return lastLocation;
    }

    /**
     * Sets last location of the agent
     *
     * @param lastLocation input location
     */
    public void setLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation;
    }

    /**
     * Gets last rotation of the agent.
     *
     * @return last rotation
     */
    public Rotation getLastRotation() {
        return lastRotation;
    }

    /**
     * Sets last rotation of the agent.
     *
     * @param lastRotation input rotation
     */
    public void setLastRotation(Rotation lastRotation) {
        this.lastRotation = lastRotation;
    }

    /**
     * Gets first seen time.
     *
     * @return time we have seen the agent for the first time
     */
    public double getFirstSeenTime() {
        return lastSeenTime;
    }

    /**
     * Gets last seen time.
     *
     * @return last time we have seen the agent
     */
    public double getLastSeenTime() {
        return lastSeenTime;
    }

    /**
     * Sets last seen time.
     *
     * @param lastSeenTime input time
     */
    public void setLastSeenTime(double lastSeenTime) {
        this.lastSeenTime = lastSeenTime;
    }

    /**
     * Gets last at cinema time together with the agent.
     *
     * @return last at cinema time
     */
    public double getLastAtCinemaTime() {
        return lastAtCinemaTime;
    }

    /**
     * Sets last at cinema time
     *
     * @param lastAtCinemaTime input time
     */
    public void setLastAtCinemaTime(double lastAtCinemaTime) {
        this.lastAtCinemaTime = lastAtCinemaTime;
    }

    /**
     * Gets last time we have been at park with the agent.
     *
     * @return last time at park
     */
    public double getLastAtParkTime() {
        return lastAtParkTime;
    }

    /**
     * Sets last time at park with the agent.
     *
     * @param lastAtParkTime input time
     */
    public void setLastAtParkTime(double lastAtParkTime) {
        this.lastAtParkTime = lastAtParkTime;
    }

    /**
     * Gets last at home time.
     *
     * @return last at home time
     */
    public double getLastAtHomeTime() {
        return lastAtHomeTime;
    }

    /**
     * Sets last at home time.
     *
     * @param lastAtHomeTime input time
     */
    public void setLastAtHomeTime(double lastAtHomeTime) {
        this.lastAtHomeTime = lastAtHomeTime;
    }

    /**
     * Gets last kiss time.
     *
     * @return last kiss time
     */
    public double getLastKissTime() {
        return lastKissTime;
    }

    /**
     * Sets last kiss time.
     *
     * @param lastKissTime input time
     */
    public void setLastKissTime(double lastKissTime) {
        this.lastKissTime = lastKissTime;
    }

    /**
     * Gets last cuddle time. For animals.
     *
     * @return last cuddle time
     */
    public double getLastCuddleTime() {
        return lastCuddleTime;
    }

    /**
     * Sets last cuddle time. For animals.
     *
     * @param lastCuddleTime input time
     */
    public void setLastCuddleTime(double lastCuddleTime) {
        this.lastCuddleTime = lastCuddleTime;
    }

    /**
     * Gets last kick time - for animals.
     *
     * @return last kick time
     */
    public double getLastKickTime() {
        return lastKickTime;
    }

    /**
     * Sets last kick time - for animals.
     *
     * @param lastKickTime input time
     */
    public void setLastKickTime(double lastKickTime) {
        this.lastKickTime = lastKickTime;
    }

    /**
     * Gets last slap time.
     *
     * @return last slap time
     */
    public double getLastSlapTime() {
        return lastSlapTime;
    }

    /**
     * Sets last slap time
     *
     * @param lastSlapTime input time
     */
    public void setLastSlapTime(double lastSlapTime) {
        this.lastSlapTime = lastSlapTime;
    }

    /**
     * Gets last ignore by time. Agent has ignored us.
     *
     * @return last ignore by time
     */
    public double getLastIgnoreByTime() {
        return lastIgnoreByTime;
    }

    /**
     * Sets last ignore by time - agent has ignored us.
     *
     * @param lastIgnoreByTime input time
     */
    public void setLastIgnoreByTime(double lastIgnoreByTime) {
        this.lastIgnoreByTime = lastIgnoreByTime;
    }

    /**
     * Get last leave time.
     *
     * @return last leave time
     */
    public double getLastLeaveTime() {
        return lastLeaveTime;
    }

    /**
     * Set last leave time.
     *
     * @param lastLeaveTime input time
     */
    public void setLastLeaveTime(double lastLeaveTime) {
        this.lastLeaveTime = lastLeaveTime;
    }

    /**
     * Get last cuddle by time - for animals. This agent has cuddled us.
     *
     * @return last cuddle by time.
     */
    public double getLastCuddleByTime() {
        return lastCuddleByTime;
    }

    /**
     * Sets last cuddle time - for animals.
     *
     * @param lastCuddleByTime input time
     */
    public void setLastCuddleByTime(double lastCuddleByTime) {
        this.lastCuddleByTime = lastCuddleByTime;
    }

    /**
     * Get last kick by time - for animals. This agent has kicked us.
     *
     * @return last kick by time
     */
    public double getLastKickByTime() {
        return lastKickByTime;
    }

    /**
     * Sets last kick by time - for animals.
     *
     * @param lastKickByTime input time
     */
    public void setLastKickByTime(double lastKickByTime) {
        this.lastKickByTime = lastKickByTime;
    }

    /**
     * Get last kiss by time - this agent has kissed us.
     *
     * @return last kiss by time
     */
    public double getLastKissByTime() {
        return lastKissByTime;
    }

    /**
     * Sets last kiss by time.
     *
     * @param lastKissByTime input time
     */
    public void setLastKissByTime(double lastKissByTime) {
        this.lastKissByTime = lastKissByTime;
    }

    /**
     * Gets last leave by time - this agent has left us.
     *
     * @return last leave by time
     */
    public double getLastLeaveByTime() {
        return lastLeaveByTime;
    }

    /**
     * Sets last leave by time.
     *
     * @param lastLeaveByTime input time
     */
    public void setLastLeaveByTime(double lastLeaveByTime) {
        this.lastLeaveByTime = lastLeaveByTime;
    }

    /**
     * Gets last last by time - this agent has slapped us.
     *
     * @return last slap by time
     */
    public double getLastSlapByTime() {
        return lastSlapByTime;
    }

    /**
     * Sets last slap by time.
     *
     * @param lastSlapByTime input time
     */
    public void setLastSlapByTime(double lastSlapByTime) {
        this.lastSlapByTime = lastSlapByTime;
    }

    /**
     * Gets last time this agent said compliment to us.
     *
     * @return last compliment by time
     */
    public double getLastComplimentByTime() {
        return lastComplimentByTime;
    }

    /**
     * Sets last compliment by time.
     *
     * @param lastComplimentByTime input time
     */
    public void setLastComplimentByTime(double lastComplimentByTime) {
        this.lastComplimentByTime = lastComplimentByTime;
    }

    /**
     * Gets last time we have said compliment to this agent.
     *
     * @return last compliment time
     */
    public double getLastComplimentTime() {
        return lastComplimentTime;
    }

    /**
     * Sets last compliment time.
     *
     * @param lastComplimentTime input time
     */
    public void setLastComplimentTime(double lastComplimentTime) {
        this.lastComplimentTime = lastComplimentTime;
    }

    /**
     * Gets last time this agent said bye to us.
     *
     * @return last bye by time
     */
    public double getLastByeByTime() {
        return lastByeByTime;
    }

    /**
     * Sets last bye by time.
     *
     * @param lastByeByTime input time
     */
    public void setLastByeByTime(double lastByeByTime) {
        this.lastByeByTime = lastByeByTime;
    }

    /**
     * Gets last time we have said bye to this agent.
     *
     * @return last bye time
     */
    public double getLastByeTime() {
        return lastByeTime;
    }

    /**
     * Sets last bye time.
     *
     * @param lastByeTime input time
     */
    public void setLastByeTime(double lastByeTime) {
        this.lastByeTime = lastByeTime;
    }

    /**
     * Gets name of this agent.
     *
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets name of this agent.
     *
     * @param name input name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets HashMap containing all items we have given to this agent.
     *
     * @return given items HashMap
     */
    public HashMap<ScenarioItemType, ArrayList<Double>> getGivenItems() {
        return givenItems;
    }

    /**
     * Gets all items in a HashMap we have received from this agent.
     *
     * @return received item HashMap
     */
    public HashMap<ScenarioItemType, ArrayList<Double>> getReceivedItems() {
        return receivedItems;
    }

    /**
     * Inserts new item we have received from this agent into our internals.
     *
     * @param type type of the item
     * @param time time we got the item
     */
    public void insertReceivedItem(ScenarioItemType type, double time){

        if (!receivedItems.containsKey(type)){
            receivedItems.put(type, new ArrayList<Double>());
        }

        receivedItems.get(type).add(time);
    }

    /**
     * Inserts new given item to this agent into our internals.
     *
     * @param type type of the item
     * @param time time we gave the item
     */
    public void insertGivenItem(ScenarioItemType type, double time){
        if (!givenItems.containsKey(type)){
            givenItems.put(type, new ArrayList<Double>());
        }

        givenItems.get(type).add(time);
    }

    /**
     * Gets last time we have received item of desired type from this agent.
     *
     * @param type input item type
     * @return last time we have received input item
     */
    public double getLastReceivedItemTime(ScenarioItemType type) {

        double max;

        max = 0;
        if (receivedItems.containsKey(type)){
            for (double d : receivedItems.get(type)){
                if (d > max){
                 max = d;
                }
            }
        }

        return max;
    }

    /**
     * Gets last time we have given item of desired type to this agent.
     *
     * @param type input item type
     * @return last time we have given item of input type to this agent
     */
    public double getLastGivenItemTime(ScenarioItemType type) {
        double max;

        max = 0;
        if (givenItems.containsKey(type)){
            for (double d : givenItems.get(type)){
                if (d > max){
                 max = d;
                }
            }
        }

        return max;
    }

    /**
     * Main method for action updating. Each time we do some action to this agent or vice
     * versa, this method will be called, will process the action and store it into
     * this class internals.
     *
     * @param type type of the action
     * @param time time of the action
     * @param causedBySelf if the action was caused by OUR agent and not THIS agent (
     * THIS refers to agent stored in this PlayerInfo class)
     */
    public void updateAction(ActionType type, double time, boolean causedBySelf){

        if (type == ActionType.BYE) {
            if (causedBySelf){
                lastByeTime = time;
                lastActionTime = time;
                lastActionType = ActionType.BYE;
            } else {
                lastByeByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.BYE;
            }
        } else if (type == ActionType.COMPLIMENT) {
            if (causedBySelf){
                lastComplimentTime = time;
                lastActionTime = time;
                lastActionType = ActionType.COMPLIMENT;
            } else {
                lastComplimentByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.COMPLIMENT;
            }
        } else if (type == ActionType.CUDDLE) {
            if (causedBySelf){
                lastCuddleTime = time;
                lastActionTime = time;
                lastActionType = ActionType.CUDDLE;
            } else {
                lastCuddleByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.CUDDLE;
            }
        } else if (type == ActionType.KICK) {
            if (causedBySelf){
                lastKickTime = time;
                lastActionTime = time;
                lastActionType = ActionType.KICK;
            } else {
                lastKickByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.KICK;
            }
        } else if (type == ActionType.KISS) {
            if (causedBySelf){
                lastKissTime = time;
                lastActionTime = time;
                lastActionType = ActionType.KISS;
            } else {
                lastKissByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.KISS;
            }
        } else if (type == ActionType.LEAVE) {
            if (causedBySelf){
                lastLeaveTime = time;
                lastActionTime = time;
                lastActionType = ActionType.LEAVE;
            } else {
                lastLeaveByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.LEAVE;
            }
        } else if (type == ActionType.SLAP) {
            if (causedBySelf){
                lastSlapTime = time;
                lastActionTime = time;
                lastActionType = ActionType.SLAP;
            } else {
                lastSlapByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.SLAP;
            }
        } else if (type == ActionType.INSULT) {
            if (causedBySelf){
                lastInsultTime = time;
                lastActionTime = time;
                lastActionType = ActionType.INSULT;
            } else {
                lastInsultByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.INSULT;
            }
        } else if (type == ActionType.SEX) {
            if (causedBySelf){
                lastSexTime = time;
                lastActionTime = time;
                lastActionType = ActionType.SEX;
            } else {
                lastSexByTime = time;
                lastActionByTime = time;
                lastActionByType = ActionType.SEX;
            }
        }

    }

    /**
     * Gets last action the agent has done to us.
     *
     * @return last action time
     */
    public double getLastActionByTime() {
        return lastActionByTime;
    }

    /**
     * Gets last action type the agent has done to us.
     *
     * @return last action type
     */
    public ActionType getLastActionByType() {
        return lastActionByType;
    }

    /**
     * Gets last action time we have done to this agent.
     *
     * @return last action time
     */
    public double getLastActionTime() {
        return lastActionTime;
    }

    /**
     * Gets last action type we have done to this agent.
     *
     * @return last action type
     */
    public ActionType getLastActionType() {
        return lastActionType;
    }

    /**
     * Gets last time this agent has insulted us.
     *
     * @return last insult by time
     */
    public double getLastInsultByTime() {
        return lastInsultByTime;
    }

    /**
     * Gets last time this agent has made love with us.
     *
     * @return last sex by time
     */
    public double getLastSexByTime() {
        return lastSexByTime;
    }

    /**
     * Sets last sex by time.
     *
     * @param lastSexByTime input time
     */
    public void setLastSexByTime(double lastSexByTime) {
        this.lastSexByTime = lastSexByTime;
    }

    /**
     * Gets last time we have made love to this agent.
     *
     * @return last sex time
     */
    public double getLastSexTime() {
        return lastSexTime;
    }

    /**
     * Sets last sex time.
     *
     * @param lastSexTime input time
     */
    public void setLastSexTime(double lastSexTime) {
        this.lastSexTime = lastSexTime;
    }

    /**
     * Sets last insult by time.
     *
     * @param lastInsultByTime input time
     */
    public void setLastInsultByTime(double lastInsultByTime) {
        this.lastInsultByTime = lastInsultByTime;
    }

    /**
     * Gets last time we have insulted this agent.
     *
     * @return last insult time
     */
    public double getLastInsultTime() {
        return lastInsultTime;
    }

    /**
     * Sets last insult time.
     *
     * @param lastInsultTime input time
     */
    public void setLastInsultTime(double lastInsultTime) {
        this.lastInsultTime = lastInsultTime;
    }

    /**
     * Gets last time this agent has interrupted us (caused that we have switched state
     * to state INTERRUPTED).
     *
     * @return last interrupted time
     */
    public double getLastInterruptedTime() {
        return lastInterruptedTime;
    }

    /**
     * Sets last interrupted time.
     *
     * @param lastInterruptedTime input time
     */
    public void setLastInterruptedTime(double lastInterruptedTime) {
        this.lastInterruptedTime = lastInterruptedTime;
    }

    /**
     * Constructor of this class.
     *
     * @param newId id of the agent
     * @param newName name of the agent
     * @param newLoc location of the agent
     * @param newRot rotation of the agent
     * @param newLastSeenTime time we've seen the agent - firstSeenTime in fact
     */
    public PlayerInfo(int newId, String newName, Location newLoc, Rotation newRot, double newLastSeenTime){
        this.id = newId;
        this.name = newName;
        this.lastLocation = newLoc;
        this.lastRotation = newRot;
        this.lastSeenTime = newLastSeenTime;
        this.firstSeenTime = newLastSeenTime;
    }

}
