/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package info;

/**
 * Here we store item requests we have received.
 *
 * @author Knight
 */
public class ItemRequest {

    /** Id of the agent that requested the item */
    private int agentId;

    /** Type of the requested item */
    private ScenarioItemType itemType;

    /** Time we have received the request */
    private double time;

    /**
     * Constructor for this class - requires agent id, item type and time we have
     * received the request.
     *
     * @param agentId agent id
     * @param itemType item type
     * @param time time we have received this request
     */
    public ItemRequest(int agentId, ScenarioItemType itemType, double time) {
        this.agentId = agentId;
        this.itemType = itemType;
        this.time = time;
    }

    /**
     * Gets agent id.
     *
     * @return agent id
     */
    public int getAgentId() {
        return agentId;
    }

    /**
     * Gets item type.
     *
     * @return item type
     */
    public ScenarioItemType getItemType() {
        return itemType;
    }

    /**
     * Gets time we have received this request.
     *
     * @return this request received time
     */
    public double getTime() {
        return time;
    }

}
