/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package info;

import java.util.ArrayList;

/**
 * Class holding information about conversation between us and other agent. We store
 * sent and received proposals here as well.
 * 
 * @author Knight
 */
public class ConversationInfo {

    /** Id of the agent */
    private int agentId;

    /** Gender of the agent - not set or used now */
    private int gender = 0;

    /** Number of messages sent to the agent */
    private int sentMessagesCount = 0;

    /** Number of messages received from the agent */
    private int receivedMessagesCount = 0;

    /** Last time we made proposal to this agent */
    private double lastProposalTime = 0;

    /** Last time we have greeted this agent */
    private double lastGreetingTime = 0;

    /** Last time we have sent some message to the agent */
    private double lastMessageTime = -20;

    /** Last time we have received message from the agent */
    private double lastReceivedMessageTime = 0;

    /** Here we store the last message we have received - we are not using this for
     anything yet */
    private String lastReceivedMessage = "";

    /** Counts number of messages per some period */
    private ArrayList<Double> messageCounter = new ArrayList<Double>();

    /** Here we store all proposals we have sent to this agent */
    private ArrayList<ProposalInfo> sentProposals = new ArrayList<ProposalInfo>();

    /** Here we store all proposal we have received from the agent*/
    private ArrayList<ProposalInfo> receivedProposals = new ArrayList<ProposalInfo>();

    /** Number of joy smilies we have received from this agent */
    private int happyCount = 0;

    /** Number of distress smilies we have received from this agent */
    private int sadCount = 0;

    /** Number of like smilies we have received from this agent */
    private int likeCount = 0;

    /** Number of dislike smilies we have received from this agent */
    private int dislikeCount = 0;

    /** Number of anger smilies we have received from this agent */
    private int angerCount = 0;

    /** Number of fear smilies we have received from this agent */
    private int fearCount = 0;

    /**
     * Gets received proposals.
     *
     * @return received proposals
     */
    public ArrayList<ProposalInfo> getReceivedProposals() {
        return receivedProposals;
    }

    /**
     * Gets sent proposals.
     *
     * @return sent proposals
     */
    public ArrayList<ProposalInfo> getSentProposals() {
        return sentProposals;
    }

    /**
     * Gets agent id.
     *
     * @return agent id
     */
    public int getAgentId() {
        return agentId;
    }

    /**
     * Gets gender information
     *
     * Note: Not used right now.
     *
     * @return gender
     */
    public int getGender() {
        return gender;
    }

    /**
     * Set the agents gender.
     *
     * @param gender input gender
     */
    public void setGender(int gender) {
        this.gender = gender;
    }

    /**
     * Gets received messages count.
     *
     * @return received messages count
     */
    public int getReceivedMessagesCount() {
        return receivedMessagesCount;
    }

    /**
     * Sets received messages count.
     *
     * @param receivedMessagesCount new count
     */
    public void setReceivedMessagesCount(int receivedMessagesCount) {
        this.receivedMessagesCount = receivedMessagesCount;
    }

    /**
     * Gets sent messages count number.
     *
     * @return sent messages count
     */
    public int getSentMessagesCount() {
        return sentMessagesCount;
    }

    /**
     * Sets sent messages count.
     *
     * @param sentMessagesCount new count
     */
    public void setSentMessagesCount(int sentMessagesCount) {
        this.sentMessagesCount = sentMessagesCount;
    }

    /**
     * Gets last time we have greeted this agent.
     *
     * @return last time we have greeted this agent
     */
    public double getLastGreetingTime() {
        return lastGreetingTime;
    }

    /**
     * Sets last greeting time.
     *
     * @param lastGreetingTime new time
     */
    public void setLastGreetingTime(double lastGreetingTime) {
        this.lastGreetingTime = lastGreetingTime;
    }

    /**
     * Gets last time we have sent message to this agent.
     *
     * @return last message time
     */
    public double getLastMessageTime() {
        return lastMessageTime;
    }

    /**
     * Sets last send message time.
     *
     * @param lastMessageTime new time
     */
    public void setLastMessageTime(double lastMessageTime) {
        this.lastMessageTime = lastMessageTime;
    }

    /**
     * Gets last time we have sent proposal to this agent.
     *
     * @return  last proposal time
     */
    public double getLastProposalTime() {
        return lastProposalTime;
    }

    /**
     * Sets last time we have sent a proposal to this agent.
     *
     * @param lastProposalTime new time
     */
    public void setLastProposalTime(double lastProposalTime) {
        this.lastProposalTime = lastProposalTime;
    }

    /**
     * Gets last time we have received message from this agent.
     *
     * @return last received message time
     */
    public double getLastReceivedMessageTime() {
        return lastReceivedMessageTime;
    }

    /**
     * Sets last time we have received message from this agent.
     *
     * @param lastReceivedMessageTime new time
     */
    public void setLastReceivedMessageTime(double lastReceivedMessageTime) {
        this.lastReceivedMessageTime = lastReceivedMessageTime;
    }

    /**
     * Gets last received message text.
     *
     * @return last received message text
     */
    public String getLastReceivedMessage() {
        return lastReceivedMessage;
    }

    /**
     * Sets last received message text.
     *
     * @param lastReceivedMessage new text
     */
    public void setLastReceivedMessage(String lastReceivedMessage) {
        this.lastReceivedMessage = lastReceivedMessage;
    }

    /**
     * This method is used for update when we receive new message from the agent.
     * It sets all needed information into this class internals.
     *
     * @param text text of the message
     * @param currentTime time when the message was received
     */
    public void updateReceivedMessage(String text, double currentTime) {
        this.lastReceivedMessage = text;
        this.lastReceivedMessageTime = currentTime;
        this.receivedMessagesCount++;
    }

    /**
     * Gets number of anger smilies we have received from the agent.
     *
     * @return anger smilies count
     */
    public int getAngerCount() {
        return angerCount;
    }

    /**
     * Sets number of anger smilies we have received from the agent.
     *
     * @param angerCount new count
     */
    public void setAngerCount(int angerCount) {
        this.angerCount = angerCount;
    }

    /**
     * Gets number of dislike smilies we have received from the agent.
     *
     * @return dislike smilies count
     */
    public int getDislikeCount() {
        return dislikeCount;
    }

    /**
     * Sets number of dislike smilies we have received from the agent.
     *
     * @param dislikeCount new count
     */
    public void setDislikeCount(int dislikeCount) {
        this.dislikeCount = dislikeCount;
    }

    /**
     * Gets number of fear smilies we have received from the agent.
     *
     * @return fear smilies count
     */
    public int getFearCount() {
        return fearCount;
    }

    /**
     * Sets number of fear smilies we have received from the agent.
     *
     * @param fearCount new count
     */
    public void setFearCount(int fearCount) {
        this.fearCount = fearCount;
    }

    /**
     * Gets number of joy smilies we have received from the agent.
     *
     * @return number of joy smilies
     */
    public int getHappyCount() {
        return happyCount;
    }

    /**
     * Sets number of joy smilies we have received from the agent.
     *
     * @param happyCount new count
     */
    public void setHappyCount(int happyCount) {
        this.happyCount = happyCount;
    }

    /**
     * Gets number of like smilies we have received from the agent.
     *
     * @return like smilies count
     */
    public int getLikeCount() {
        return likeCount;
    }

    /**
     * Sets number of like smilies we have received from the agent.
     *
     * @param likeCount new count
     */
    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    /**
     * Gets the message counter ArrayList object.
     *
     * @return message counter ArrayList
     */
    public ArrayList<Double> getMessageCounter() {
        return messageCounter;
    }

    /**
     * Gets number of distress smilies we have received from the agent.
     *
     * @return distress smilies count
     */
    public int getSadCount() {
        return sadCount;
    }

    /**
     * Sets number of distress smilies we have received from the agent.
     *
     * @param sadCount new count
     */
    public void setSadCount(int sadCount) {
        this.sadCount = sadCount;
    }

    /**
     * Updates the sent messages history - the time and the message count.
     *
     * @param currentTime time the message was sent
     */
    public void updateSentMessages(double currentTime) {
        this.lastMessageTime = currentTime;
        this.sentMessagesCount++;
    }

    /**
     * Constructor for this class. Requires just agent id parameter.
     *
     * @param id agent id
     */
    public ConversationInfo (int id){
        this.agentId = id;
    }



}
