/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package bot;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.*;
import info.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
 * In this class we will generate all the events our agent can encounter in the scenario.
 * We will send here notifications to emotion model to generate emotional events and 
 * we will also update agent internal state.
 * This class contains number of constants that affects the event generation.
 *
 * Methods with notify word in their name are called by listeners defined in EmotionalBot.java
 * each time new event of certain type arrives. From notify methods we will call
 * process method that will process the message and generate events and update agent
 * internal state.
 *
 * @author Knight
 */
public class EventGenerator {

    /** Pointer to our agent */
    private EmotionalBot myAgent;

    /** helper temp vars */

    /** last agent that talked to us */
    private Player agentTalkingToUs = null;
    /** last agent that talked to agent we accompany somewhere */
    private Player agentTalkingToAgentWith = null;


    /** helper variable - time of last alone event */
    private double lastAloneEventTime = 0;

    /** CONSTANTS - mainly in seconds */
    /** in communication info history we will delete messages older than currentTime - this */
    private double messageHistoryTimerConst = 60;

    /**
     * This means that when we are sent this number per messageHistoryTimerConst, we will
     * reduce emotion intensity significantly! (number_of_message_in_our_window/this const
     * the time window is defined by messageHistoryTimerConst
     */
    private double messageReductionCountConst = 20;

    /** We will reduce the emotional intensity of messages by this number, 2 default */
    private double messageIntensityReductionMultiplier = 2;

    /** How long we will remember polymorph triggered events */
    private double polymorphEventHistoryTimerConst = 90;

    /**
     * This means that when we encountered this number of events per polymorphEventHistoryTimerConst,
     * we will reduce emotion intensity significantly!
     */
    private double polymorphEventReductionCountConst = 5;

    /** consts - in seconds */
    /** We will generate together event every this const seconds */
    private double togetherEventTriggerTimeConst = 60;

    /**
     * If we haven't seen player for this time, we will generate player lost event
     * if also other conditions met
     */
    private double sightLostEventTriggerTimeConst = 10;

    /** We will generate new appear event when we haven't seen player for this const seconds */
    private double reappearEventTriggerTimeConst = 30;

    /** Minimum time between two player lost events */
    private double lostEventsDelayTimeConst = 30;

    /** When we detect we are alone, we will generete alone event every this constant seconds */
    private double aloneEventDelayTimeConst = 90;

    /**
     * If the delay between last response and last message sent to the player is higher then this
     * ignore event will be generated
     */
    private double conversationIgnoreTimeConst = 30;

    /** Delay between two conversation ignore events */
    private double conversationIgnoreDelayConst = 35;

    /** This is the time we need to be together with agentWith to generate ignoreEvent */
    public int conversationIgnoreTogetherTimeConst = 30;

    /** Delay between two leave action events generated */
    private int actionLeaveDelayConst = 30;

    /**
     * After this const seconds when we haven't seen pawn, we will count it as lost
     * sight and stop updating timeTogetherCounter
     */
    private double sightLostConst = 4;

    /**
     * New begin message received.
     *
     * @param beg new begin message
     */
    public void notifyBegin(BeginMessage beg){
        //TODO: Should we put this to EndMessage instead?
        processPlayerHistory();
        checkRepeatingEvents();
    }

    /**
     * New received inventory message received.
     *
     * @param rIM new received inventory message
     */
    public void notifyGotInv(ReceivedInventoryMsg rIM) {
        processGotInvMessage(rIM);
    }

    /**
     * New item picked up message received.
     *
     * @param ipk new item picked up message
     */
    public void notifyPickup(ItemPickedUp ipk){
        processPickup(ipk);
    }

    /**
     * New player message received.
     *
     * @param plr new player message
     */
    public void notifyPlayer(Player plr){
        myAgent.myEmotionState.insertEmotionObject(plr.getId().getId());
        processPlayer(plr);
        updatePlayerHistory(plr);
    }

    /**
     * New global chat message received.
     *
     * @param message new global chat message
     */
    public void notifyTextMessage(GlobalChat message) {
        processTextMessage(message);
    }

    /**
     * New player damage message received (HIT message).
     *
     * @param pldam new player damaged message
     */
    public void notifyPlayerDamaged(PlayerDamaged pldam) {
        processHitMessage(pldam);
    }

    /**
     * New player killed message received (KIL message).
     *
     * @param pk new player killed message
     */
    public void notifyPlayerKilled(PlayerKilled pk) {
        processKillMessage(pk);
    }

    /**
     * New bot damaged message received (DAM message).
     *
     * @param bd new bot damaged message
     */
    public void notifyBotDamaged(BotDamaged bd) {
        processDamMessage(bd);
    }

    /**
     * Here we detect other agents interruptions. Other agents may interrupt our actions by
     * speaking to us while we are doing certain action or by speaking to agent that is accompanying
     * us. Here we will check the conditions and set agentInterrupter if it is necessary.
     *
     * @return true if someone has interrupted us (that doesn't mean our agent will actually
     * switch to interrupted state)
     */
    private boolean detectAgentSpeakingInterruptions() {
        //Someone has talked to our agent while we were doing something with agentWith
        if ((myAgent.agentWith != null) && (agentTalkingToUs != null) && (myAgent.agentWith.getId().getId() != agentTalkingToUs.getId().getId())) {
            myAgent.insertInterrupter(agentTalkingToUs);
            return true;
        } else if ((myAgent.agentWith == null) && (agentTalkingToUs != null)) { //someone talked to us, we are alone
            myAgent.insertInterrupter(agentTalkingToUs);
            return true;            
        }

        //We are also interrupted if someone is talking to our accompanying agent!
        if ((myAgent.agentWith != null) && (agentTalkingToAgentWith != null)){
            myAgent.insertInterrupter(agentTalkingToAgentWith);
            return true;
        }

        return false;
    }

    /**
     * Some agent did action to me. Find out which one it was, notify emotion model
     * and store it into history.
     *
     * @param gc message containing the action towards us
     */
    private void processActionToMe(GlobalChat gc) {

        if (gc.getText().contains("KISS")){
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.KISS, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionKissByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("SEX")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.SEX, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionSexByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("SLAP")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.SLAP, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionSlapByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("CUDDLE")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.CUDDLE, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionCuddleByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("KICK")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.KICK, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionKickByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("COMPLIMENT")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.COMPLIMENT, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionComplimentByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("INSULT")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.INSULT, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionInsultByEvent(gc.getId().getId());
        }
        else if (gc.getText().contains("BYE")) {
            if (myAgent.playersHistory.containsKey(gc.getId().getId()))
                myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.BYE, myAgent.currentTime, false);

            myAgent.myAEGenerator.generateActionByeByEvent(gc.getId().getId());

            //we have to reset agentTalkingToUs to null because detectAgentSpeakingInt... would set him
            //as againWith again immediately
            agentTalkingToUs = null;
            agentTalkingToAgentWith = null;
        }
        else if (gc.getText().contains("LEAVE")){
            if (myAgent.playersHistory.containsKey(gc.getId().getId())){
                PlayerInfo myPlrInfo = myAgent.playersHistory.get(gc.getId().getId());
                if ((myAgent.currentTime - myPlrInfo.getLastLeaveByTime()) > actionLeaveDelayConst ){

                    myAgent.myAEGenerator.generateActionLeaveByEvent(gc.getId().getId());
                    myAgent.playersHistory.get(gc.getId().getId()).updateAction(ActionType.LEAVE, myAgent.currentTime, false);
                }
            }
            
            //we have to reset agentTalkingToUs to null because detectAgentSpeakingInt... would set him
            //as againWith again immediately
            agentTalkingToUs = null;
            agentTalkingToAgentWith = null;
        }

    }

    /**
     * Some agent did some action to other agent. We can be jelaus or happy.
     *
     * @param gc message containing the action towards other
     */
    private void processActionToOther(GlobalChat gc) {
        PlayerInfo result = null;

        for (PlayerInfo pi : myAgent.playersHistory.values()){
            if (gc.getText().contains("To:" + pi.getName())){
                result = pi;
                break;
            }
        }

        if (gc.getText().contains("KISS")){
            myAgent.myAEGenerator.generateActionKissOtherEvent(gc.getId().getId(),result);
        }
        if (gc.getText().contains("SEX")){
            myAgent.myAEGenerator.generateActionSexOtherEvent(gc.getId().getId(),result);
        }
        if (gc.getText().contains("SLAP")){
            myAgent.myAEGenerator.generateActionSlapOtherEvent(gc.getId().getId(),result);
        }
        if (gc.getText().contains("KICK")){
            myAgent.myAEGenerator.generateActionKickOtherEvent(gc.getId().getId(),result);
        }
        if (gc.getText().contains("COMPLIMENT")){
            myAgent.myAEGenerator.generateActionComplimentOtherEvent(gc.getId().getId(),result);
        }
        if (gc.getText().contains("INSULT")){
            myAgent.myAEGenerator.generateActionInsultOtherEvent(gc.getId().getId(),result);
        }
        if (gc.getText().contains("LEAVE")){
            myAgent.myAEGenerator.generateActionLeaveOtherEvent(gc.getId().getId(),result);
            agentTalkingToAgentWith = null;
        }
        if (gc.getText().contains("BYE")){
            myAgent.myAEGenerator.generateActionByeOtherEvent(gc.getId().getId(),result);
            agentTalkingToAgentWith = null;
        }
    }

    /**
     * Process the message and store the corresponding item request to agent internals.
     *
     * @param message message containing the item request
     */
    private void processItemRequestToMe(GlobalChat message) {
        if (message.getText().contains("condom")){
            myAgent.myItemRequests.add(new ItemRequest(message.getId().getId(),ScenarioItemType.CONDOM,myAgent.currentTime));
        } else if (message.getText().contains("flower")){
            myAgent.myItemRequests.add(new ItemRequest(message.getId().getId(),ScenarioItemType.FLOWER,myAgent.currentTime));
        } else if (message.getText().contains("gun")){
            myAgent.myItemRequests.add(new ItemRequest(message.getId().getId(),ScenarioItemType.GUN,myAgent.currentTime));
        }
    }

    /**
     * Player killed message.
     *
     * @todo shouldn't we disable this?
     *
     * @param pk player killed message
     */
    private void processKillMessage(PlayerKilled pk) {
        myAgent.myAEGenerator.generatePlayerKilledEvent(pk);
    }

    /**
     * Process pickup messages. Flowers are MiniHealthVials, condoms are AdrenalinePickups
     * for now. :-)
     *
     * @param ipk
     */
    private void processPickup(ItemPickedUp ipk) {
        
        ScenarioItemType type = ScenarioItemType.OTHER;

        if (ipk.getId().toString().contains("Health")){
            type = ScenarioItemType.FLOWER;
            if (myAgent.myItems.containsKey(type)){
                myAgent.myItems.put(type, myAgent.myItems.get(type));
            } else
                myAgent.myItems.put(type, 1);
        }
        else if (ipk.getId().toString().contains("Adrenaline")) {
            type = ScenarioItemType.CONDOM;
            if (myAgent.myItems.containsKey(type)){
                myAgent.myItems.put(type, myAgent.myItems.get(type));
            } else
                myAgent.myItems.put(type, 1);
        }

        myAgent.myAEGenerator.generatePickupEvent(type);

    }

    /**
     * Here we will generate events - PlayerDissapearedEvent and PlayerTogetherEvent
     */
    private void processPlayerHistory() {

        HashMap<Integer,PlayerInfo> playersHistory = myAgent.getPlayersHistory();

        boolean bSeenSomeoneRecently = false;

        for (PlayerInfo pi : playersHistory.values()) {

            if ((myAgent.currentTime - pi.getLastSeenTime()) < aloneEventDelayTimeConst ){
                bSeenSomeoneRecently = true;
            }

            if (pi.getTimeTogetherCounter() > togetherEventTriggerTimeConst) {

                myAgent.myAEGenerator.generatePlayerTogetherEvent(pi.getId());

                //reset the counter
                pi.setTimeTogetherCounter(0);
            }

            if ( ((myAgent.currentTime - pi.getLastSeenTime()) > sightLostEventTriggerTimeConst) && (pi.getLastSeenTime() > pi.getLastLostEventTime() ) && ((myAgent.currentTime - pi.getLastLostEventTime()) > lostEventsDelayTimeConst) ) {

                pi.setLastLostEventTime(myAgent.currentTime);

                myAgent.myAEGenerator.generatePlayerLostEvent(pi.getId());

            }

        }//end for cyclus

        //generate alone event if we are alone and alone event wasn't generated in last const seconds
        if (!bSeenSomeoneRecently && ((myAgent.currentTime - lastAloneEventTime) > aloneEventDelayTimeConst ) ) {

            myAgent.myAEGenerator.generateAloneEvent();

            //update last alone event time
            lastAloneEventTime = myAgent.currentTime;
        }
    }

    /**
     * Process HIT message and generate appropriate emotion event. Currently just looking
     * if we hit the polymorph.
     *
     * @param pd input HIT message
     */
    private void processHitMessage(PlayerDamaged pd) {

        if (pd.getId().getUnrealId().toString().contains("Nali")) {
            myAgent.myAEGenerator.generateWeHitPolymorphEvent(pd);
        }
    }

    /**
     * Process DAM message and generate appropriate emotion event. Currently just processing
     * polymorph damage event (polymorph bite).
     *
     * @param bd input DAM message
     */
    private void processDamMessage(BotDamaged bd) {

        if (bd.getInstigator() != null) {
            if (bd.getInstigator().getUnrealId().toString().contains("Nali")){
                myAgent.myAEGenerator.generatePolymorphBiteEvent(bd);
                return;
            }
            //else
        }

    }

    /**
     * Process received inventory message (GOT), generates emotional event and store
     * information into agents internals.
     *
     * @param rim input received inventory message
     */
    private void processGotInvMessage(ReceivedInventoryMsg rim) {
        
        ScenarioItemType itemType;
        
        itemType = myAgent.parseItemType(rim.getItemType().toString());
        if (rim.getTo().getId() == myAgent.agentInfo.getId().getId()){
            //we have received the item!
            myAgent.myAEGenerator.generateReceivedItemEvent(itemType,rim.getFrom().getId());
            myAgent.logItemReceived(rim.getFrom().getId(),myAgent.getName(rim.getFrom().getId()), itemType, myAgent.currentTime);

            //TODO: check if we want the item?
            //updates our PlayerInfo
            if (myAgent.playersHistory.containsKey(rim.getFrom().getId())){            
                myAgent.playersHistory.get(rim.getFrom().getId()).insertReceivedItem(itemType, myAgent.currentTime);
            }
            
        } else {
            //someone else had received the item
            if ( (itemType == ScenarioItemType.FLOWER) && (myAgent.myEmotionState.getFeeling(rim.getFrom().getId()) > 0.3)) {
                //if we have some feeling toward the donor we will be a little jelaus
                myAgent.myAEGenerator.generateItemJelausyEvent(itemType,rim.getFrom().getId());
            }
        }
    }

    /**
     * Before the playersHistory is updated this allows us to generate appeared events.
     *
     * @param pl other agent
     */
    private void processPlayer(Player pl) {

        boolean bAppearedFirstTime = false;
        HashMap<Integer,PlayerInfo> playersHistory = myAgent.getPlayersHistory();

        //generate appeared event
        if (!playersHistory.containsKey(pl.getId().getId())) {
            bAppearedFirstTime = true;
            //this will add the player to the history
            myAgent.getPlayerHistory(pl);
        } else if ( (pl.getLastSeenTime() - myAgent.getPlayerHistory(pl).getLastSeenTime()) > reappearEventTriggerTimeConst ) { //if we haven't seem him in last 30 seconds
            bAppearedFirstTime = false;
        } else
            return; //we don't want to generate event, if there is no reason for it

        myAgent.myAEGenerator.generatePlayerAppearedEvent(pl,bAppearedFirstTime);

    }

   /**
    * Here we process proposal sent to our agent. It can be response to our proposal
    * or new proposal from other agent. We will store it in our intenals for future
    * processing.
    *
    * @param message contains the message with proposal to process
    */
    private void processProposalToMe(GlobalChat message) {

        ProposalType proposalType;
        ProposalInfo newProp = null;

        proposalType = myAgent.parseProposalType(message.getText());

        if (message.getText().contains("making")){
            //we've received proposal

            newProp = new ProposalInfo(proposalType,message.getId().getId(),myAgent.currentTime,0,false,false,false);
            myAgent.getConversationHistory(message.getId().getId()).getReceivedProposals().add(newProp);
            myAgent.recentReceivedProposal = newProp;

            myAgent.myAEGenerator.generateReceivedProposalEvent(message, myAgent.parseProposalType(message.getText()),myAgent.agentWith, myAgent.agentInterrupters);
           /* handle proposals here if (checkWantProposal(gc.getId().getId(), proposalType)){

            }*/
        } else {
            //we've received answer to our proposal
            if ((myAgent.recentProposal != null) && (proposalType == myAgent.recentProposal.getType())){

                if (!myAgent.recentProposal.isProposalAccepted() && !myAgent.recentProposal.isProposalIgnored() && !myAgent.recentProposal.isProposalRejected()) {
                    if (message.getText().contains("accepted")) {
                        myAgent.recentProposal.setProposalAccepted(true);
                        myAgent.recentProposal.setProposalResponseTime(myAgent.currentTime);
                        myAgent.myAEGenerator.generateProposalResponseEvent(true, message);
                        
                    } else if (message.getText().contains("rejected")) {
                        myAgent.recentProposal.setProposalRejected(true);
                        myAgent.recentProposal.setProposalResponseTime(myAgent.currentTime);
                        myAgent.myAEGenerator.generateProposalResponseEvent(false, message);
                        
                    }
                }
            }
        }
    }

    /**
     * Some proposal or proposal answer was sent to some other agent.
     *
     * @param message message containing the proposal
     */
    private void processProposalToOther(GlobalChat message) {
        
        boolean bAccepted = false;

        if ( (myAgent.agentWith != null) && (message.getId().getId() == myAgent.agentWith.getId().getId()) ){
            //proposal is from agentWith but it is not to us!
            if (message.getText().contains("making")){
                //agentWith is making proposal to someone and not to us - this is bad for him ;-)
                myAgent.myAEGenerator.generateProposalToOtherByAgentWithEvent(message, myAgent.parseProposalType(message.getText()));

            } else {
                //agentWith is responding to proposal
                if (message.getText().contains("accepted")) 
                    bAccepted = true;
                else
                    bAccepted = false;
                
                myAgent.myAEGenerator.generateProposalResponseToOtherByAgentWithEvent(message, myAgent.parseProposalType(message.getText()), bAccepted);

            }
        } else if ( (myAgent.agentWith != null) && (message.getId().getId() != myAgent.agentWith.getId().getId()) ) {
            //proposal is not from agentWith
            //check if proposal is to agentWith - jelaousy!
            if (message.getText().contains("To:"+myAgent.agentWith.getName())){
                if (message.getText().contains("making")) {
                    myAgent.myAEGenerator.generateProposalByOtherToAgentWithEvent(message, myAgent.parseProposalType(message.getText()));
                }
                //TODO: else branch? if other agent rejects we are a little bit happy?
            }
        } else {
            //AgentWith is null
            if (message.getText().contains("making")){
                //someone is making proposal to someone
                myAgent.myAEGenerator.generateProposalToOtherEvent(message, myAgent.parseProposalType(message.getText()));
            } else {
                //someone is responding to the proposal
                if (message.getText().contains("accepted"))
                    bAccepted = true;
                else
                    bAccepted = false;

                myAgent.myAEGenerator.generateProposalOtherResponseEvent(message, myAgent.parseProposalType(message.getText()), bAccepted);
            }
        }

    }

    /**
     * Here we will determine what kind of a situation this text message corresponds
     * to and call appropriate methods that will process the message further.
     *
     * @param message input text message
     */
    private void processTextMessage(GlobalChat message) {
        //Should we process proposals/continuous actions/actions here?
        //firt determine from who this message is

        //erase temp variables
        agentTalkingToAgentWith = null;
        agentTalkingToUs = null;

        //we will process just messages from agent we can acctualy see!
        Player plr = myAgent.players.getPlayer(message.getId());
        if ((plr == null) || !plr.isVisible())
            return;
        /*
        if (!myAgent.playersHistory.containsKey(message.getId().getId())){
            return;
        } else if (myAgent.currentTime - myAgent.playersHistory.get(message.getId().getId()).getLastSeenTime() > sightLostConst) {
            return;
        }*/

        if (message.getId().getStringId().contains("Nali") || !myAgent.isHuman(message.getId().getId())){
            //it is a polymorph
            processPolymorphTextMessage(message);
        //message is for someone
        } else if (message.getText().contains("To:")) {
            if (message.getText().contains("To:"+myAgent.getMyName())) {
                processTextMessageToMe(message);
            } else {
                processOtherTextMessage(message);
            }
        } else {
            //TODO: check if we are close to agent and the agent is rotated towards us and we see him
            processTextMessageToMe(message);
        }

        //sets the myAgent.agentInterrupter variable if neccessary
        detectAgentSpeakingInterruptions();

    }

    /**
     * Here we will process text message adressed to our agent. And generate all emotion events.
     * Also we will update CommunicationInfo object.
     *
     * @param message input text message
     */
    private void processTextMessageToMe(GlobalChat message) {

        ConversationInfo myInfo;

        int angerCount, fearCount, happyCount, sadCount, likeCount, dislikeCount;

        double temp, reduction = 0.0;

        //emModel.myAgent.getLogger().user().info("+++++++++++++++" + message.toString());

        myInfo = myAgent.getConversationHistory(message.getId().getId());

        //update for detecting interruptions
        agentTalkingToUs = myAgent.players.getPlayer(message.getId());

        if (message.getText().toLowerCase().contains("action"))
            processActionToMe(message);

        if (message.getText().toLowerCase().contains("proposal")) {
            processProposalToMe(message);
            myInfo.setLastProposalTime(myAgent.currentTime);
        }

        if (message.getText().toLowerCase().contains("request")) {
            processItemRequestToMe(message);
        }


        //First we update and clear our MessageCounter in history
        myInfo.getMessageCounter().add(myAgent.currentTime);

        double time;
        Iterator<Double> iterator = myInfo.getMessageCounter().iterator();
        while (iterator.hasNext()) {
            time = iterator.next();
            if ((myAgent.currentTime - time) > messageHistoryTimerConst ) {
                iterator.remove();
            }
        }

        //Count reduction in events intensity
        temp = myInfo.getMessageCounter().size() / messageReductionCountConst;
        if (temp > 0.9)
            temp = 0.9;
        reduction = messageIntensityReductionMultiplier / (1 - temp);

        //Now generate all events
        angerCount = message.getText().split("#!", -1).length - 1;
        fearCount = message.getText().split(":-O", -1).length - 1;

        myAgent.myAEGenerator.generateAngerFearMessageEvent(message.getId().getId(),angerCount - fearCount, reduction);

        happyCount = message.getText().split(":-\\)", -1).length - 1;
        sadCount = message.getText().split(":-\\(", -1).length - 1;

        myAgent.myAEGenerator.generateHappySadMessageEvent(message.getId().getId(),happyCount - sadCount, reduction);

        likeCount =  message.getText().split(":-\\*", -1).length - 1;
        dislikeCount =  message.getText().split("\\>:@", -1).length - 1;

        myAgent.myAEGenerator.generateLikeDislikeMessageEvent(message.getId().getId(),likeCount - dislikeCount, reduction);

        //update communication info again
        myInfo.updateReceivedMessage(message.getText(),myAgent.currentTime);
        myInfo.setAngerCount(myInfo.getAngerCount() + angerCount);
        myInfo.setFearCount(myInfo.getFearCount() + fearCount);
        myInfo.setHappyCount(myInfo.getHappyCount() + happyCount);
        myInfo.setSadCount(myInfo.getSadCount() + sadCount);
        myInfo.setLikeCount(myInfo.getLikeCount() + likeCount);
        myInfo.setDislikeCount(myInfo.getDislikeCount() + dislikeCount);

    }

    /**
     * Process text message sent by someone to other agent.
     *
     * @param message input text message
     */
    private void processOtherTextMessage(GlobalChat message) {
        //TODO: question agent current state where we are, what we are doing, etc.
        //TODO: here we should also detect girl fight if we are boy
        ConversationInfo otherInfo;

        int angerCount, fearCount, happyCount, sadCount, likeCount, dislikeCount;

        double temp, reduction = 0.0;

        //emModel.myAgent.getLogger().user().info("+-+-+-+-+-+-+-+" + message.toString());

        //TODO: here girl fighting detection!

        //message is to someone, but it is not us!
        if (message.getText().contains("To:")) {

            otherInfo = myAgent.getOtherConversationHistory(message.getId().getId());

            otherInfo.getMessageCounter().add(myAgent.currentTime);

            if (message.getText().toLowerCase().contains("action"))
                processActionToOther(message);

            if (message.getText().toLowerCase().contains("proposal")){
                processProposalToOther(message);
                otherInfo.setLastProposalTime(myAgent.currentTime);
            }

            //First we update and clear our MessageCounter in history
            double time;
            Iterator<Double> iterator = otherInfo.getMessageCounter().iterator();
            while (iterator.hasNext()) {
                time = iterator.next();
                if ((myAgent.currentTime - time) > messageHistoryTimerConst ) {
                    iterator.remove();
                }
            }

            //Count reduction in events intensity
            temp = otherInfo.getMessageCounter().size() / messageReductionCountConst;
            if (temp > 0.9)
                temp = 0.9;
            reduction = messageIntensityReductionMultiplier / (1 - temp);

            angerCount = message.getText().split("#!", -1).length - 1;
            fearCount = message.getText().split(":-O", -1).length - 1;

            happyCount = message.getText().split(":-\\)", -1).length - 1;
            sadCount = message.getText().split(":-\\(", -1).length - 1;

            likeCount =  message.getText().split(":-\\*", -1).length - 1;
            dislikeCount =  message.getText().split("\\>:@", -1).length - 1;

            //update communication info again
            otherInfo.updateReceivedMessage(message.getText(), myAgent.currentTime);
            otherInfo.setAngerCount(otherInfo.getAngerCount() + angerCount);
            otherInfo.setFearCount(otherInfo.getFearCount() + fearCount);
            otherInfo.setHappyCount(otherInfo.getHappyCount() + happyCount);
            otherInfo.setSadCount(otherInfo.getSadCount() + sadCount);
            otherInfo.setLikeCount(otherInfo.getLikeCount() + likeCount);
            otherInfo.setDislikeCount(otherInfo.getDislikeCount() + dislikeCount);

            //update internal state vars
            if (myAgent.agentWith != null) {
                if (message.getText().contains("To:"+myAgent.agentWith.getName())){
                    agentTalkingToAgentWith = myAgent.players.getPlayer(message.getId());
                }
            }

            //TODO: generate jelaousy
            if (likeCount > dislikeCount){

                //anger + distress
                myAgent.myAEGenerator.generateMessageToOtherEvent(message, likeCount, dislikeCount, reduction);

            }
        }

    }

    /**
     * Generate fear and disliking or liking depending on the noise the polymorph is
     * making. Then updates the polymorph info so the events are not generated too
     * often.
     *
     * @param message input text message
     */
    private void processPolymorphTextMessage(GlobalChat message) {

        PolymorphEventInfo polInfo = null;
        ConversationInfo convInfo = null;

        double temp, reduction;

        polInfo = myAgent.getPolymorphHistory(message.getId().getId());
        //update also conversation history... - for conversation info...
        convInfo = myAgent.getConversationHistory(message.getId().getId());
        convInfo.updateReceivedMessage(message.getText(), myAgent.currentTime);

        //update for detecting interruptions
        agentTalkingToUs = myAgent.players.getPlayer(message.getId());

        //First we will clear our polymorph event counter in history
		double time;
        Iterator<Double> iterator = polInfo.getEventCounter().iterator();
		while (iterator.hasNext()) {
            time = iterator.next();
            if ((myAgent.currentTime - time) > polymorphEventHistoryTimerConst ) {
                iterator.remove();
            }
        }

        //Count reduction in events intensity
        temp = polInfo.getEventCounter().size() / polymorphEventReductionCountConst;
        if (temp > 0.975)
            temp = 0.975;
        reduction = 1 / (1 - temp);

        if (message.getText().toLowerCase().contains("action")) {
            //see if the polymorph has bitten us
            if (message.getText().contains("BITE")) {
                myAgent.myAEGenerator.generatePolymorphActionBiteEvent(message);
                polInfo.updateAction(ActionType.BITE, myAgent.currentTime);
            }
        } else {
            if (message.getText().contains("RRRRRRRRRR")) {
                //dislike and fear
                myAgent.myAEGenerator.generatePolymorphDislikeFearEvent(message, reduction);

                //update polymorph history
                polInfo.getEventCounter().add(myAgent.currentTime);

            } else if ((message.getText().contains("mrr mrr mrr"))){
                //liking
                myAgent.myAEGenerator.generatePolymorphLikeEvent(message, reduction);

                //update polymorph history
                polInfo.getEventCounter().add(myAgent.currentTime);
            }
        }
    }

    /**
     * Check agent ignore and proposal ignore events and generate them if necessary.
     */
    private void checkRepeatingEvents() {

        //proposal ignore events
        if (myAgent.recentProposal != null){
            if ( !myAgent.recentProposal.isProposalAccepted() && !myAgent.recentProposal.isProposalRejected() &&
                    !myAgent.recentProposal.isProposalIgnored() && ((myAgent.currentTime - myAgent.recentProposal.getTime()) > myAgent.proposalIgnoreTimeConst) ){

                myAgent.recentProposal.setProposalIgnored(true);
                myAgent.recentProposal.setProposalResponseTime(myAgent.currentTime);

                if (!myAgent.recentProposal.isEventGenerated()){
                    myAgent.recentProposal.setEventGenerated(true);

                    myAgent.myAEGenerator.generateProposalIgnoreEvent(myAgent.recentProposal.getTarget());

                }
            }
        }

        //Conversation Ignore event
        if ((myAgent.agentWith != null) && (myAgent.agentInterrupters.isEmpty())) {
            ConversationInfo myInfo = myAgent.getConversationHistory(myAgent.agentWith.getId().getId());

            if ((myInfo.getLastMessageTime() - myInfo.getLastReceivedMessageTime()) > conversationIgnoreTimeConst){
                PlayerInfo myPlrInfo = myAgent.getPlayerHistory(myAgent.agentWith);
                if ((myPlrInfo.getTimeTogetherCounter() > conversationIgnoreTogetherTimeConst ) && ((myAgent.currentTime - myPlrInfo.getLastIgnoreByTime()) > conversationIgnoreDelayConst )){
                    //if we have been recently with the agent at least 20 seconds and he said nothing
                    myAgent.myAEGenerator.generateConversationIgnoreByEvent(myAgent.agentWith);
                    myPlrInfo.setLastIgnoreByTime(myAgent.currentTime);

                }

            }
        }

        //waiting event
        if (myAgent.getState() == StateType.WAIT){
            if ((myAgent.currentTime - myAgent.lastWaitEventTime) > myAgent.waitDurationConst){
                myAgent.lastWaitEventTime = myAgent.currentTime;
                myAgent.myAEGenerator.generateWaitInProgressEvent(myAgent.agentWith);
            }
        }
    }

    /**
     * Called each time we receive some PLR message (from listener). Updates playersHistory
     * information.
     *
     * @param pl
     */
    public void updatePlayerHistory(Player pl) {

            PlayerInfo pi = myAgent.getPlayerHistory(pl);

            if ( ((pl.getLastSeenTime() - pi.getLastSeenTime()) < sightLostConst ) ) {
                //if we have been with the player recently, we'll update timeTogetherCounter
                //and enable future LostEvent
                pi.setTimeTogetherCounter(pi.getTimeTogetherCounter() + (pl.getLastSeenTime() - pi.getLastSeenTime()));
                pi.setTimeTogether(pi.getTimeTogether() + (pl.getLastSeenTime() - pi.getLastSeenTime()));
            } else {
                //otherwise we'll reset the counter
                pi.setTimeTogetherCounter(0);
            }

            pi.setLastLocation(pl.getLocation());
            pi.setLastRotation(pl.getRotation());
            pi.setLastSeenTime(pl.getLastSeenTime());
    }

    /**
     * Only constructor for this class.
     *
     * @param myAgent agent we generate events for
     */
    public EventGenerator(EmotionalBot myAgent) {
        this.myAgent = myAgent;
    }

}
