/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package bot;

import almabasedmodel.AEmotion;
import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import de.affect.emotion.Emotion;
import de.affect.emotion.EmotionType;
import info.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

/**
 * Main class for male emotional bot. Emotional bot is a finite state machine. The
 * state code is triggered by doLogic() method. This method is invoked each time
 * synchronous batch from GameBots arrive (default each 250 ms).
 *
 *
 * @author Knight
 */
@AgentScoped
public class EmotionalMaleBot extends EmotionalBot {

    /**
     * Constructor for this object.
     *
     * @param logger
     * @param worldView
     * @param commandSerializer
     */
    @Inject
	public EmotionalMaleBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
		super(logger, worldView, commandSerializer);
	}

    @Override
	protected void prePrepareBot() {
        myName = "Bruno";
        super.prePrepareBot();
       
    }

    @Override
	protected Initialize createInitializeCommand() {
        Initialize myInit = new Initialize();

        myInit.setName(myName);
        if (!myClassName.isEmpty())
            myInit.setClassName(myClassName);
        if (startLocation != null)
            myInit.setLocation(startLocation);
        if (startRotation != null)
            myInit.setRotation(startRotation);

        //myInit.setSkin(myName);
		return myInit;
	}

    @Override
	protected void doLogic() throws PogamutException {

        logAgentState();
        showEmotions();
        
        //pause the logic, so last action, that cannot be interrupted can finish (can be animations, etc.)
        if ((currentTime - lastActionTime) < lastActionDuration ) {
            if (lastActionType == ActionType.SEX){
                getAct().act(new SendMessage().setText("To:Everyone Uh, ah...").setFadeOut(messageFadeOutConst));
            }
            return;
        }

        //Check whether we've lost interest in doing something together with agentWith
        /* Will do in pickAction!
         if ((agentWith != null) && (myEmotionState.getFeeling(agentWith.getId().getId()) < leaveFeelingConst ) ){
            actionLeave(agentWith);
            agentWith = null;
        }*/

        //getLogger().user().info("!!!!!!! CAN SEE PLAYERS: " + players.canSeePlayers());
        //regular check so our agent is walking all the time
        if (!agentInfo.isWalking())
            getAct().act(new SetWalk(true));

        //setting up scenario
        if (state == StateType.PREPARE_SCENARIO) {statePrepareScenario(); return; }

        if (state == StateType.POLYMORPH_THREAT) {statePolymorphThreat(); return;}

        if (state == StateType.INTERRUPTED) {stateInterrupted(); return;}

        //if (agentLeaving) {stateAgentLeaving(); return;}
        if (state == StateType.FOLLOW_AGENT_WITH) {stateFollowAgentWith(); return;}

        if (state == StateType.GOING_SOMEWHERE_WITH) {stateGoingSomewhereWithSomebody(); return;}

        if (state == StateType.WAIT) {stateWait(); return;}

        if (state == StateType.AGENT_WITH) {stateWithSomebody(); return;}

        if (state == StateType.AGENT_ALONE) {stateAgentAlone(); return;}
    }

    /**
     * Picks item according to our feeling, item possesions and agent internals.
     *
     * @param agent
     * @return
     */
    private ScenarioItemType pickItem(Player agent) {

        if (myEmotionState.getFeeling(agent.getId().getId()) > flowerFeelingConst){

            if (myItems.containsKey(ScenarioItemType.FLOWER) && (myItems.get(ScenarioItemType.FLOWER) >= 1) ){
                // we have at least 1 flower
                PlayerInfo pi = getPlayerHistory(agent);
                if ((currentTime - pi.getLastGivenItemTime(ScenarioItemType.FLOWER) > flowerDelayTimeConst)){
                    return ScenarioItemType.FLOWER;
                }
            }
        }

        return ScenarioItemType.NONE;
    }

    /**
     * This method checks if it is right time to make some proposal. If the time is
     * right and we have required feelings to input agent this method returns suggested
     * proposal we should make.
     *
     * @param agent
     * @return
     */
    private ProposalType pickProposal(Player agent) {

        ConversationInfo myConvInfo = getConversationHistory(agent.getId().getId());
        PlayerInfo myPlrInfo = getPlayerHistory(agent);

        if (
                ((recentProposal == null) && ((currentTime - myConvInfo.getLastProposalTime()) > 10)) ||
                ((recentProposal != null) && ((recentProposal.isProposalIgnored()) || (recentProposal.isProposalRejected())) && ((currentTime - recentProposal.getProposalResponseTime()) > 60))
        ){
            //check if recently there was some conversation between me and agent so we dont propose out of the blue
            if ((myConvInfo.getSentMessagesCount() > 2) && (myConvInfo.getReceivedMessagesCount() > 1) && ((currentTime - myConvInfo.getLastMessageTime()) < 10)){
                if (atHome(agent) && (myEmotionState.getFeeling(agent.getId().getId()) > sexFeelingConst)
                        && (currentTime - myPlrInfo.getLastSexTime() > sexDelayTimeConst) ) {
                    return ProposalType.SEX;
                }
                if ((atHome(agent) || atCinema()) && (myEmotionState.getFeeling(agent.getId().getId()) > kissFeelingConst)
                        && (currentTime - myPlrInfo.getLastKissTime() > kissDelayTimeConst) ) {
                    return ProposalType.KISS;
                }

                if (!atCinema() && (currentTime - myPlrInfo.getLastAtCinemaTime() > cinemaDelayTimeConst) && (myEmotionState.getFeeling(agent.getId().getId()) > cinemaFeelingConst)){
                    return ProposalType.CINEMA;
                }

                if (!atPark() && !atCinema() && !atHome(agent) && (currentTime - myPlrInfo.getLastAtParkTime() > parkDelayTimeConst) && (myEmotionState.getFeeling(agent.getId().getId()) > parkFeelingConst)){
                    return ProposalType.PARK;
                }

                if ((!atHome(agent) && atCinema()) && (myEmotionState.getFeeling(agent.getId().getId()) > homeFeelingConst)){
                    return ProposalType.HOME;
                }

                if (!atHome(agent) &&  (currentTime - myPlrInfo.getLastAtHomeTime() > homeDelayTimeConst) && (myEmotionState.getFeeling(agent.getId().getId()) > homeFeelingConst)){
                    return ProposalType.HOME;
                }
            }
        }
        return ProposalType.NONE;
    }

    /**
     * Choose the player with the biggest feeling toward. Should incorporate gender
     * information (TODO).
     *
     * @param values
     * @return
     * @todo
     */
    private Player pickTargetPlayer(Collection<Player> values) {

        Player myResult = null;
        double tmp,myTargetFeeling = 0;

        for (Player plr : values){
            if (myResult == null){
                tmp = myEmotionState.getFeeling(plr.getId().getId());
                double max = Math.max(Math.max(getPlayerHistory(plr).getLastLeaveByTime(),getPlayerHistory(plr).getLastLeaveTime()),
                            Math.max(getPlayerHistory(plr).getLastByeByTime(),getPlayerHistory(plr).getLastByeTime()));
                //if other agent said bye to us recently, or we said bye to him recently, then we will won't pick him
                if ((currentTime - max > reapproachDelayConst ) && (isOppositeSex(plr) && (tmp > approachFeelingConst))){
                    myResult = plr;
                    myTargetFeeling = tmp;
                }
            }else {
                tmp = myEmotionState.getFeeling(plr.getId().getId());
                if (isOppositeSex(plr) && (tmp > myTargetFeeling)){
                    double max = Math.max(Math.max(getPlayerHistory(plr).getLastLeaveByTime(),getPlayerHistory(plr).getLastLeaveTime()),
                            Math.max(getPlayerHistory(plr).getLastByeByTime(),getPlayerHistory(plr).getLastByeTime()));
                    //if other agent said bye to us recently, or we said bye to him recently, then we will won't pick him
                    if (currentTime - max > reapproachDelayConst ) {
                        myResult = plr;
                        myTargetFeeling = tmp;
                    }
                }
            }
        }

        if ((myResult != null) && (myEmotionState.getFeeling(myResult.getId().getId()) < ignoreFeelingConst )){
            return null;
        }

        return myResult;
    }

    private void stateWait() {
        //we've disliked the agent and he was set to null, stop waiting
        if (agentWith == null){
            goToState(StateType.AGENT_ALONE);
            return;
        }

        //check if waitForAgent is back
        if (agentWith.isVisible() && agentInfo.atLocation(agentWith.getLocation(),communicationRangeConst)){
            if (timerIsRunning(TimerType.WAIT_TIMER) && !timerIsRunning(TimerType.INIT_WAIT_TIMER)){
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + " Not waiting anymore! I am with you again.").setFadeOut(messageFadeOutConst));
                getConversationHistory(agentWith.getId().getId()).updateSentMessages(currentTime);
                goToState(StateType.AGENT_WITH);
                return;
            }
        }

        //look if waiting timer expired
        if (!timerIsRunning(TimerType.WAIT_TIMER)){
            myAEGenerator.generateWaitAgentNotReturnedEvent(agentWith);
            agentWith = null;
            waitForAgent = null;
            goToState(StateType.AGENT_ALONE);
            return;
        }

        //handle interrupters during waiting
        Player agentInterrupter = null;
        if (!agentInterrupters.isEmpty())
            agentInterrupter = pickFocus(agentInterrupters);

        if (agentInterrupter != null){
            if (agentInfo.isMoving())
                getAct().act(new Stop());

            getAct().act(new TurnTo().setTarget(agentInterrupter.getId()));

            //respond to proposals;
            if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ) {
                if (respondToProposal())
                    return;
            }

            doAction(pickAction(agentInterrupter),agentInterrupter);

            conversate(agentInterrupter, ConversationType.WAIT);
        } else {
            //todo: walking as i would be waiting
            getAct().act(new Move().setFirstLocation(agentInfo.getLocation().add(new Location(300,300,0))).setSecondLocation(agentInfo.getLocation()));
            //setAction(null, ActionType.NONE, currentTime, 3);
        }
    }

    /**
     * State handling the situation when our agent is alone. The boy will start to
     * explore the environment trying to find some girls he likes.
     * Also interrupters are handled here by switching to interrupted state.
     *
     */
    private void stateAgentAlone(){

        //interrupters handling
        if (!agentInterrupters.isEmpty()){
            if (agentWith == null) {
                agentWith = pickTargetPlayer(agentInterrupters);
                if (agentWith != null){
                    removeInterrupter(agentWith);
                    goToState(StateType.AGENT_WITH);
                    return; //leave the logic, so we will check in next iteration our feelings toward the agent
                }
            }
            goToState(StateType.INTERRUPTED);
            return;
        }

        //getAct().act(new SendMessage().setText("To: Trying to go to the place").setFadeOut(messageFadeOutConst));
        if (myGoalPlace != PlaceType.NONE){
            //we have some destination set, we will go there
            //set myGoalTarget here.
            myGoalTarget = getDestinationLocation(myGoalPlace);

            if (agentInfo.getLocation().getDistance(myGoalTarget) < 100) {
                if (agentInfo.isMoving())
                    getAct().act(new Stop());
                myGoalPlace = PlaceType.NONE;
            } else {
                goToLocation(myGoalTarget);
                return;
            }
        }

        if (players.canSeePlayers() && ( (myPlrTarget == null) || !myPlrTarget.isVisible() )){
            myPlrTarget = pickTargetPlayer(players.getVisiblePlayers().values());
        }

        if (myPlrTarget != null){
            if (myPlrTarget.getLocation().getDistance(agentInfo.getLocation()) > 200){
               goToLocation(myPlrTarget.getLocation());
            } else {
                agentWith = myPlrTarget;
                myPlrTarget = null;

                if (agentInfo.isMoving()) {
                    getAct().act(new Stop());
                }
                goToState(StateType.AGENT_WITH);
            }
        } else {
            if (myLocTarget == null){
                myPath.clear();
                pathRequested = false;
                pathReceived = false;
                myLocTarget = pickNewLocTarget(); //random movement
            }

            if ((myLocTarget.getLocation().getDistance(agentInfo.getLocation()) < 80)){
                myLocTarget = null;
            } else {
                goToLocation(myLocTarget.getLocation());
            }

        }
    }

    /**
     * We are following agentWith and going to cinema/park or our home.
     *
     */
    private void stateFollowAgentWith() {

        if (agentWith == null){
            goToState(StateType.AGENT_ALONE);
            return;
        }

        if (!agentInterrupters.isEmpty()) {
            goToState(StateType.INTERRUPTED);
            return;
        }

        //respond to proposals
        if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ){
            respondToProposal();
        }


       //Check where we are going and if we are not already there
        if (myGoalPlace == PlaceType.CINEMA) {
            //going to cinema
            if (atCinema()){
                //arrived at cinema
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at cinema.").setFadeOut(messageFadeOutConst));

                //update player history
                getPlayerHistory(agentWith).setLastAtCinemaTime(currentTime);

                timerSet(TimerType.WATCHING_FILM,15); //films duration 15 sec. :-)
                myGoalPlace = PlaceType.NONE;
                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == getAgentHomePlace(agentWith)){
            //going to agentWith home
            if (atHome(agentWith)){
                //arrived at agentWith home
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at your home.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtHomeTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == PlaceType.MY_HOME){
            //going home
            if (atMyHome()){
                //arrived at my home
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at my home.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtHomeTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == PlaceType.PARK){
            //going to park
            if (atPark()){
                //arrived at park
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at park.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtParkTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else {
            //if ((myGoalTarget != null) && ())
                //going at unknown destination - oops
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "Don't know where I am going, oops.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                goToState(StateType.AGENT_WITH);
                return;
        }

        //set myGoalTarget here.
        myGoalTarget = getDestinationLocation(myGoalPlace);

        if (agentInfo.getLocation().getDistance(myGoalTarget) > 300) {
            if (agentWith.getLocation().getDistance(agentInfo.getLocation()) > followAgentDistanceConst){
               getAct().act(new Move().setFirstLocation(agentWith.getLocation()));
            } else {
                getAct().act(new TurnTo().setTarget(agentWith.getId()));

                if (agentInfo.isMoving()) {
                    getAct().act(new Stop());
                }
            }
        } else {
            goToLocation(myGoalTarget);
        }

        conversate(agentWith,ConversationType.CASUAL);
    }

    /**
     * We are leading agentWith somewhere - cinema, park, her home...
     *
     */
    private void stateGoingSomewhereWithSomebody() {

        //check if we still are with the agent
        if ((agentWith == null) || (currentTime - agentWith.getLastSeenTime()) > agentWithDissapearTimeConst){
            goToState(StateType.AGENT_ALONE);
            return;
        }

        if (myGoalPlace == PlaceType.NONE) {
            if (agentWith != null){
                goToState(StateType.AGENT_WITH);
                return;
            } else {
                goToState(StateType.AGENT_ALONE);
                return;
            }            
        }

        //Check where we are going and if we are not already there
        if (myGoalPlace == PlaceType.CINEMA) {
            //going to cinema
            if (atCinema()){
                //arrived at cinema
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at cinema.").setFadeOut(messageFadeOutConst));

                //update player history
                getPlayerHistory(agentWith).setLastAtCinemaTime(currentTime);

                timerSet(TimerType.WATCHING_FILM,15); //films duration 15 sec. :-)
                myGoalPlace = PlaceType.NONE;
                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == getAgentHomePlace(agentWith)){
            //going to agentWith home
            if (atHome(agentWith)){
                //arrived at agentWith home
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at your home.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtHomeTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == PlaceType.MY_HOME){
            //going home
            if (atMyHome()){
                //arrived at my home
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at my home.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtHomeTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == PlaceType.PARK){
            //going to park
            if (atPark()){
                //arrived at park
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at park.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtParkTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else {
            //if ((myGoalTarget != null) && ())
                //going at unknown destination - oops
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "Don't know where I am going, oops.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                goToState(StateType.AGENT_WITH);
                return;            
        }

        if (!agentInterrupters.isEmpty()) {
            goToState(StateType.INTERRUPTED);
            return;
        }

        //set myGoalTarget here.
        myGoalTarget = getDestinationLocation(myGoalPlace);

        if (agentWith.getLocation().getDistance(agentInfo.getLocation()) > 250) {
            getAct().act(new Stop());
            getAct().act(new TurnTo().setTarget(agentWith.getId()));
        } else {
            goToLocation(myGoalTarget);
        }
        conversate(agentWith,ConversationType.CASUAL);        
    }

    /**
     * Here we handle the interrupters. First we check our agentWith, than we pick
     * focus among interrupters. After that we can perform some action or conversation.
     * We can also respond to proposals here - the response may not match the agent
     * we picked as our focus (we can respond to agent1 but our focus will be agent2).
     *
     */
    private void stateInterrupted() {
        //getAct().act(new SendMessage().setText("We've been interrupted!"));

        if (agentWith == null){
            //either we or agentWith has left us during the interrupt, we will try to pick new
            //agentWith
            agentWith = pickTargetPlayer(agentInterrupters);
            if (agentWith != null){
                removeInterrupter(agentWith); //or we would say bye to him immediately
                goToState(StateType.AGENT_WITH);
                return;
            }            
        }

        //check if all interrupters are within range
        ArrayList<Player> tempReachCheckList = new ArrayList<Player>();
        tempReachCheckList.addAll(agentInterrupters);
        Iterator<Player> it = tempReachCheckList.iterator();
        Player plr = null;
        while (it.hasNext()){
            plr = it.next();
            if (!agentInfo.atLocation(plr.getLocation(),communicationRangeConst)){
                actionBye(plr);//will also remove interrupter
            }
        }

        ArrayList<Player> tempAgentList = new ArrayList<Player>();
        tempAgentList.addAll(agentInterrupters);
        if ((agentWith != null) && agentWith.isVisible() && agentInfo.atLocation(agentWith.getLocation(),communicationRangeConst))
            tempAgentList.add(agentWith);

        Player agentInterrupter = pickFocus(tempAgentList);

        if ((agentInterrupter != null) && myEmotionState.getFeeling(agentInterrupter.getId().getId()) < ignoreFeelingConst){
            //actionLeave also removes interrupter from the list sets agentWith to null
            actionLeave(agentInterrupter);
            return;
        }

        //here we check if agentInterrupter has interrupted us recently - if yes, we will say bye to him right away
        if ((agentInterrupter != null) && ((agentWith == null) || (agentWith.getId().getId() != agentInterrupter.getId().getId()) ) ) {
            if ((agentInterrupter != null) && (currentTime - getPlayerHistory(agentInterrupter).getLastInterruptedTime()) < interruptDelayConst ){
                //actionBye also removes interrupter from the list sets
                actionBye(agentInterrupter);
                return;
            }
        }

        //Check if we are still with some agentInterrupters
        if (agentInterrupters.isEmpty()){
            goToState(previousState);
            return;
        }

        if (!timerIsRunning(TimerType.INTERRUPTION_TIMER)){
            //timers up, we are leaving the interrupters
            goToState(previousState);
            return;
        }

        //check if our proposal was accepted 
        if ((agentWith != null) &&  (recentProposal != null) && recentProposal.isProposalAccepted() && (recentProposal.getTarget() == agentWith.getId().getId()) ){
            if (recentProposal.getType() == ProposalType.KISS){
                recentProposal = null;
                actionKiss(agentWith);
                return;
            } else if (recentProposal.getType() == ProposalType.LEAVE){
                recentProposal = null;
                goToState(previousState);
                return;
            } 
        }

        getAct().act(new TurnTo().setTarget(agentInterrupter.getId()));

        //respond to proposals;
        if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ) {
            if (respondToProposal())
                return;
        }

        //make some action
        doAction(pickAction(agentInterrupter),agentInterrupter);

        if (agentInterrupter == null)
            return;

        conversate(agentInterrupter, ConversationType.INTERRUPT);
    }

    /**
     * Not used yet.
     */
    private void statePolymorphThreat() {

        //1) get a gun
        //make sure we have a gun and loaded

        //2) Approach and kill polymorph

        //3) save the girl - lead her to safety (her home)

    }


    /**
     * Main state for handling the interaction with agentWith. Here we will make 
     * proposals to her to go home, to kiss, to have sex...
     * 
     */
    private void stateWithSomebody(){
        
        //check if we still are with the agent
        if ((agentWith == null) || (currentTime - agentWith.getLastSeenTime()) > agentWithDissapearTimeConst){
            agentWith = null;
            goToState(StateType.AGENT_ALONE);
            return;
        }

        //timers/situation handling
        if (timerIsRunning(TimerType.WATCHING_FILM)){
            //TODO: getAct().act(new TurnTo().setTarget(LOOK_TOWARD_MOVIE));
            if (!agentInterrupters.isEmpty()){
                conversate(pickFocus(agentInterrupters), ConversationType.MOVIE);
            }
            else
                conversate(agentWith, ConversationType.MOVIE);
            return;
        }
        
        //here we will look if someone has accepted our proposal and if yes, we will
        //change state according to it, or even perform action according to it - if yes, the 
        //method will return true.
        if (processMyProposal())
            return;

        //respond to proposals;
        if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ) {
            if (respondToProposal())
                return;
        }

        //check scenario conditions
        if (scenario == ScenarioType.SCENARIO_ONE){
            if ((agentWith != null) && atHome(agentWith) && (!agentWith.getName().toLowerCase().equals("clementine") )){
                //find out if we are at home and have proposed sex
                boolean bSexFound = false;
                for (ProposalInfo pi : getConversationHistory(agentWith.getId().getId()).getSentProposals()){
                    if ((pi.getType() == ProposalType.SEX) && (currentTime - pi.getTime() > 15) ) {
                        bSexFound = true;
                        break;
                    }
                }
                //find out if we have been somewhere with clementine
                boolean bWasWithClementine = false;
                for (Player plr : players.getPlayers().values()){
                    if (plr.getName().toLowerCase().equals("clementine")){
                        if (getPlayerHistory(plr).getLastAtCinemaTime() != 0){
                            bWasWithClementine = true;
                            break;
                        } else {
                            bWasWithClementine = false;
                            break;
                        }
                    }
                }
                if (bSexFound && !bWasWithClementine){
                    actionBye(agentWith);
                    goToState(StateType.AGENT_ALONE);
                    myGoalPlace = PlaceType.MEETING_CINEMA_PLACE;
                    return;
                }
            }
        }

        //here we will say bye to the girl after tried to have sex
        if (agentWith != null) {
            //find out if we had sex recently
            boolean bSexFound = false;
            for (ProposalInfo pi : getConversationHistory(agentWith.getId().getId()).getSentProposals()){
                if ((pi.getType() == ProposalType.SEX) && (pi.isProposalAccepted()) && (currentTime - pi.getTime() < 20) ) {// ?
                    bSexFound = true;
                    break;
                }
            }

            if (bSexFound){
                actionBye(agentWith);
                goToState(StateType.AGENT_ALONE);
                return;
            }
        }

        //here we switch to state if we were interrupted by some agent - some agent talked to us
        //depending on our situation we will switch to different states
        if (!agentInterrupters.isEmpty()) {
            goToState(StateType.INTERRUPTED);
            return;
        }
        
        if (agentWith.getLocation().getDistance(agentInfo.getLocation()) > 300){
            goToLocation(agentWith.getLocation());
            return;
        } else if (agentWith.getLocation().getDistance(agentInfo.getLocation()) < 150){
            if (agentInfo.isMoving())
                getAct().act(new Stop());
            getAct().act(new TurnTo().setTarget(agentWith.getId()));
        }

        if (agentInfo.isMoving()) {
            getAct().act(new Stop());
        }

        getAct().act(new TurnTo().setTarget(agentWith.getId()));

        //proposals handling
        ProposalType desiredProposal = pickProposal(agentWith);

        if (desiredProposal != ProposalType.NONE){
            actionMakeProposal(agentWith, desiredProposal);
            return;
        }

        //make some action
        doAction(pickAction(agentWith),agentWith);
        //the action may cause the agentWith to be null!!!
        if (agentWith == null)
            return;

        //handles situation at home
        if (atHome(agentWith)){
            ScenarioItemType desiredItem = pickItem(agentWith);

            if (desiredItem != ScenarioItemType.NONE){
                actionGiveItem(agentWith,desiredItem);                
                //getAct().act(new Jump()); //TODO: erase this, just for debug
            }

            conversate(agentWith, ConversationType.HOME);
            return;
        }
        
        conversate(agentWith, ConversationType.CASUAL);
    }

    /**
     * Called when we entered a new state.
     *
     * @param newState new state entered
     */
    @Override
    public void beginState(StateType newState){
        if (newState == StateType.AGENT_WITH){
            myGoalPlace = PlaceType.NONE;
            clearNavigationVariables();
        } else if (newState == StateType.AGENT_ALONE){
            timerSet(TimerType.WAIT_AT_HOME, 30);
            recentReceivedProposal = null;
            recentProposal = null;
            //myGoalPlace = PlaceType.NONE;
            //agentWith = null;
            removeAllInterrupters();
            clearNavigationVariables();
        } else if (newState == StateType.GOING_SOMEWHERE_WITH){
            clearNavigationVariables();
        } else if (newState == StateType.FOLLOW_AGENT_WITH){
            clearNavigationVariables();
        } else if (newState == StateType.POLYMORPH_THREAT){
            clearNavigationVariables();
        } else if (newState == StateType.INTERRUPTED){
            timerSet(TimerType.INTERRUPTION_TIMER,interruptDurationConst + new Random().nextInt(interruptDurationConst));
        } else if (newState == StateType.WAIT){
            timerSet(TimerType.WAIT_TIMER,waitDurationConst + new Random().nextInt(waitDurationConst)/4);
            lastWaitEventTime = currentTime;
            clearNavigationVariables();
        }
        //logging
        logStateEntered(newState, currentTime);
    }

    /**
     * Called when we left ceratain state.
     *
     * @param endingState state we have left
     */
    @Override
    public void endState(StateType endingState){
        if (endingState == StateType.INTERRUPTED){
            timerErase(TimerType.INTERRUPTION_TIMER);
            if (!agentInterrupters.isEmpty()){
                actionMultipleBye(agentInterrupters);
                removeAllInterrupters();
            }
        } else if (endingState == StateType.WAIT){
            timerErase(TimerType.WAIT_TIMER);
            //say bye to all interrupters after stopped waiting.
            if (!agentInterrupters.isEmpty()){
                actionMultipleBye(agentInterrupters);
                removeAllInterrupters();
            }
        }
        //logging
        logStateLeft(endingState, currentTime);
    }

}
