/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package bot;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import de.affect.emotion.Emotion;
import de.affect.emotion.EmotionType;
import info.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

/**
 * Main class for female emotional bot. Emotional bot is a finite state machine. The
 * state code is triggered by doLogic() method. This method is invoked each time
 * synchronous batch from GameBots arrive (default each 250 ms).
 * 
 * @author Knight
 */
@AgentScoped
public class EmotionalFemaleBot extends EmotionalBot {

    @Inject
	public EmotionalFemaleBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
		super(logger, worldView, commandSerializer);
	}
    
    @Override
	protected void prePrepareBot() {
        
        super.prePrepareBot();          
    }

    @Override
	protected Initialize createInitializeCommand() {
        Initialize myInit = new Initialize();

        myInit.setName(myName);
        if (!myClassName.isEmpty())
            myInit.setClassName(myClassName);
        if (startLocation != null)
            myInit.setLocation(startLocation);
        if (startRotation != null)
            myInit.setRotation(startRotation);

        //myInit.setSkin(mySkin);
        //myInit.setLocation(myLocation);
        //myInit.setSkin(myName);
		return myInit;
	}

    @Override
	protected void doLogic() throws PogamutException {

        logAgentState();
        showEmotions();       

        //pause the logic, so last action, that cannot be interrupted can finish (can be animations, etc.)
        if ((currentTime - lastActionTime) < lastActionDuration ) {
            if (lastActionType == ActionType.SEX){
                getAct().act(new SendMessage().setText("Uh, ah...").setFadeOut(messageFadeOutConst));
            }
            return;
        }

        //Check whether we've lost interest in doing something together with agentWith
        /* Will do in pickAction!
        if ((agentWith != null) && (myEmotionState.getFeeling(agentWith.getId().getId()) < leaveFeelingConst ) ){
            actionLeave(agentWith);
            agentWith = null;
        }*/
        
        //getLogger().user().info("!!!!!!! CAN SEE PLAYERS: " + players.canSeePlayers());
        //regular check so our agent is walking all the time
        if (!agentInfo.isWalking())
            getAct().act(new SetWalk(true));

        //setting up scenario
        if (state == StateType.PREPARE_SCENARIO) {statePrepareScenario(); return; }

        if (state == StateType.POLYMORPH_THREAT) {statePolymorphThreat(); return;}

        if (state == StateType.WAIT) {stateWait(); return;}

        if (state == StateType.INTERRUPTED) {stateInterrupted(); return;}

        //if (agentLeaving) {stateAgentLeaving(); return;}
        if (state == StateType.FOLLOW_AGENT_WITH) {stateFollowAgentWith(); return;}

        if (state == StateType.AGENT_WITH) {stateWithSomebody(); return;}

        if (state == StateType.APPROACH_BOYS) {stateApproachBoys(); return;}

        if (state == StateType.AGENT_ALONE) {stateAgentAlone(); return;}
    }

    /**
     * This method checks if it is right time to make some proposal. If the time is
     * right and we have required feelings to input agent this method returns suggested
     * proposal we should make.
     *
     * @param agent
     * @return
     */
    private ProposalType pickProposal(Player agent) {

        ConversationInfo myConvInfo = getConversationHistory(agent.getId().getId());
        PlayerInfo myPlrInfo = getPlayerHistory(agent);

        if (
                ((recentProposal == null) && ((currentTime - myConvInfo.getLastProposalTime()) > 10)) ||
                ((recentProposal != null) && ((recentProposal.isProposalIgnored()) || (recentProposal.isProposalRejected())) && ((currentTime - recentProposal.getProposalResponseTime()) > 60))
        ){
            //check if recently there was some conversation between me and agent so we dont propose out of the blue
            if ((myConvInfo.getSentMessagesCount() > 2) && (myConvInfo.getReceivedMessagesCount() > 1) && ((currentTime - myConvInfo.getLastMessageTime()) < 10)){
                if ((atHome(agent) || atCinema()) && (myEmotionState.getFeeling(agent.getId().getId()) > kissFeelingConst)
                        && (currentTime - myPlrInfo.getLastKissTime() > 15) ) {
                    return ProposalType.KISS;
                }
            }
        }
        return ProposalType.NONE;
    }

   /**
     * Choose the player with the biggest feeling toward above 0 and opposite sex.
     *
     * @param values
     * @return
     * @todo
     */
    private Player pickTargetPlayer(Collection<Player> values) {

        Player myResult = null;
        double tmp,myTargetFeeling = 0;

        for (Player plr : values){
            if (myResult == null){
                tmp = myEmotionState.getFeeling(plr.getId().getId());
                double max = Math.max(Math.max(getPlayerHistory(plr).getLastLeaveByTime(),getPlayerHistory(plr).getLastLeaveTime()),
                            Math.max(getPlayerHistory(plr).getLastByeByTime(),getPlayerHistory(plr).getLastByeTime()));
                //if other agent said bye to us recently, or we said bye to him recently, then we will won't pick him
                if ((currentTime - max > reapproachDelayConst ) && (isOppositeSex(plr) && (tmp > approachFeelingConst))){
                    myResult = plr;
                    myTargetFeeling = tmp;
                }
            } else {
                tmp = myEmotionState.getFeeling(plr.getId().getId());
                if (isOppositeSex(plr) && (tmp > myTargetFeeling)){
                    double max = Math.max(Math.max(getPlayerHistory(plr).getLastLeaveByTime(),getPlayerHistory(plr).getLastLeaveTime()),
                            Math.max(getPlayerHistory(plr).getLastByeByTime(),getPlayerHistory(plr).getLastByeTime()));
                    //if other agent said bye to us recently, or we said bye to him recently, then we will won't pick him
                    if (currentTime - max > reapproachDelayConst ) {
                        myResult = plr;
                        myTargetFeeling = tmp;
                    }
                }
            }
        }

        //if we ignore him - then won't pick him!
        if ((myResult != null) && (myEmotionState.getFeeling(myResult.getId().getId()) < ignoreFeelingConst )){
            return null;
        }      

        return myResult;
    }

    /**
     * This state handles a situation when the agent is alone in the environment.
     * The girl simply goes to her home, when in this state, where she waits until
     * the timer expires and switch to another state.
     *
     * The interrupter check is done here (if the agent is interrupted, the state
     * will be switched to interrupted state)
     */
    private void stateAgentAlone() {

        //interrupters handling
         if (!agentInterrupters.isEmpty()){
            getAct().act(new SendMessage().setText("To: Interrupter handling").setFadeOut(messageFadeOutConst));
            if (agentWith == null) {
                agentWith = pickTargetPlayer(agentInterrupters);
                if (agentWith != null){
                    removeInterrupter(agentWith);
                    goToState(StateType.AGENT_WITH);
                    return; //leave the logic, so we will check in next iteration our feelings toward the agent
                }
            }
            goToState(StateType.INTERRUPTED);
            return;
        }

        if (!timerIsRunning(TimerType.WAIT_AT_HOME)){
            //getAct().act(new SendMessage().setText("To: Trying to go to the place").setFadeOut(messageFadeOutConst));
            if (myGoalPlace != PlaceType.NONE){
                //we have some destination set, we will go there
                //set myGoalTarget here.
                myGoalTarget = getDestinationLocation(myGoalPlace);

                if (agentInfo.getLocation().getDistance(myGoalTarget) < 100) {
                    if (agentInfo.isMoving())
                        getAct().act(new Stop());
                    myGoalPlace = PlaceType.NONE;

                    if (scenario == ScenarioType.SCENARIO_ONE)
                        goToState(StateType.WAIT);
                    else
                        goToState(StateType.APPROACH_BOYS);
                    return;
                    
                } else {
                    goToLocation(myGoalTarget);
                    return;
                }
            } else {
                goToState(StateType.APPROACH_BOYS);
                return;
            }
        }

        if (!agentInfo.atLocation(getMyHomeLocation(), 120)){
            goToLocation(getMyHomeLocation());
        }

        if (atMyHome() && !timerIsRunning(TimerType.WAIT_AT_HOME)){
            goToState(StateType.APPROACH_BOYS);
        }
        
    }

    @Override
    public void timerFinished(TimerType type){

    }

    /**
     * We are following agentWith and going to cinema/park or our home.
     *
     */
    private void stateFollowAgentWith() {

        if (agentWith == null){
            goToState(StateType.AGENT_ALONE);
            return;
        }

        if (!agentInterrupters.isEmpty()) {
            goToState(StateType.INTERRUPTED);
            return;
        }

        //respond to proposals
        if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ){
            respondToProposal();
        }


       //Check where we are going and if we are not already there
        if (myGoalPlace == PlaceType.CINEMA) {
            //going to cinema
            if (atCinema()){
                //arrived at cinema
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at cinema.").setFadeOut(messageFadeOutConst));

                //update player history
                getPlayerHistory(agentWith).setLastAtCinemaTime(currentTime);

                timerSet(TimerType.WATCHING_FILM,15); //films duration 15 sec. :-)
                myGoalPlace = PlaceType.NONE;
                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == getAgentHomePlace(agentWith)){
            //going to agentWith home
            if (atHome(agentWith)){
                //arrived at agentWith home
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at your home.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtHomeTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == PlaceType.MY_HOME){
            //going home
            if (atMyHome()){
                //arrived at my home
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at my home.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtHomeTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else if (myGoalPlace == PlaceType.PARK){
            //going to park
            if (atPark()){
                //arrived at park
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "We've arrived at park.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                getPlayerHistory(agentWith).setLastAtParkTime(currentTime);

                goToState(StateType.AGENT_WITH);
                return;
            }
        } else {
            //if ((myGoalTarget != null) && ())
                //going at unknown destination - oops
                getAct().act(new Stop());
                getAct().act(new TurnTo().setTarget(agentWith.getId()));
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + "Don't know where I am going, oops.").setFadeOut(messageFadeOutConst));
                myGoalPlace = PlaceType.NONE;

                goToState(StateType.AGENT_WITH);
                return;
        }

        //set myGoalTarget here.
        myGoalTarget = getDestinationLocation(myGoalPlace);

        if (agentInfo.getLocation().getDistance(myGoalTarget) > 300) {
            if (agentWith.getLocation().getDistance(agentInfo.getLocation()) > followAgentDistanceConst){
               getAct().act(new Move().setFirstLocation(agentWith.getLocation()));
            } else {
                getAct().act(new TurnTo().setTarget(agentWith.getId()));

                if (agentInfo.isMoving()) {
                    getAct().act(new Stop());
                }
            }
        } else {
            goToLocation(myGoalTarget);
        }

        conversate(agentWith,ConversationType.CASUAL);
    }

    /**
     * Here we handle interrupters. First we check our agentWith, than we pick the
     * focus among interrupters. After that we can perform actions or conversation.
     *
     * We also respond to proposals here.
     *
     */
    private void stateInterrupted() {
        //getAct().act(new SendMessage().setText("We've been interrupted!"));

        if (agentWith == null){
            //either we or agentWith has left us during the interrupt, we will pick new
            //agentWith or go to agentAlone state - this will end the interupt session
            agentWith = pickTargetPlayer(agentInterrupters);
            if (agentWith != null) {
                removeInterrupter(agentWith); //or we would say bye to him immediately
                goToState(StateType.AGENT_WITH);
                return;
            }
        }

        //check if all interrupters are within range
        ArrayList<Player> tempReachCheckList = new ArrayList<Player>();
        tempReachCheckList.addAll(agentInterrupters);
        Iterator<Player> it = tempReachCheckList.iterator();
        Player plr = null;
        while (it.hasNext()){
            plr = it.next();
            if (!agentInfo.atLocation(plr.getLocation(),communicationRangeConst)){
                actionBye(plr);//will also remove interrupter
            }
        }

        ArrayList<Player> tempAgentList = new ArrayList<Player>();
        tempAgentList.addAll(agentInterrupters);
        if ((agentWith != null) && agentWith.isVisible() && agentInfo.atLocation(agentWith.getLocation(),communicationRangeConst))
            tempAgentList.add(agentWith);

        Player agentInterrupter = pickFocus(tempAgentList);

        //here we check if our feeling isn't too low to actually speak with the agent
        if ((agentInterrupter != null) && myEmotionState.getFeeling(agentInterrupter.getId().getId()) < ignoreFeelingConst){
            //actionLeave also removes interrupter from the list or sets agentWith to null
            actionLeave(agentInterrupter);
            return;
        }

        //here we check if agentInterrupter has interrupted us recently - if yes, we will say bye to him right away
        if ((agentInterrupter != null) && ((agentWith == null) || (agentWith.getId().getId() != agentInterrupter.getId().getId()) ) ) {
            if ((currentTime - getPlayerHistory(agentInterrupter).getLastInterruptedTime()) < interruptDelayConst ){
                //actionBye also removes interrupter from the list 
                actionBye(agentInterrupter);
                return;
            }
        }

        //Check if we are still with some agentInterrupters
        if (agentInterrupters.isEmpty()){
            goToState(previousState);
            return;
        }

        if (!timerIsRunning(TimerType.INTERRUPTION_TIMER)){
            //timers up, we are leaving the interrupters
            goToState(previousState);
            return;
        }

        //check if our proposal was accepted
        if ((agentWith != null) &&  (recentProposal != null) && recentProposal.isProposalAccepted() && (recentProposal.getTarget() == agentWith.getId().getId()) ){
            if (recentProposal.getType() == ProposalType.KISS){
                recentProposal = null;
                actionKiss(agentWith);
                return;
            } else if (recentProposal.getType() == ProposalType.LEAVE){
                recentProposal = null;
                goToState(previousState);
                return;
            }
        }

        getAct().act(new TurnTo().setTarget(agentInterrupter.getId()));

        //respond to proposals;
        if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ) {
            if (respondToProposal())
                return;
        }

        //make some action
        doAction(pickAction(agentInterrupter),agentInterrupter);

        if (agentInterrupter == null)
            return;

        conversate(agentInterrupter, ConversationType.INTERRUPT);
    }

    /**
     * Not yet used.
     *
     */
    private void statePolymorphThreat() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * Our waiting state. We wait for our agentWith, when we are in this state.
     *
     */
    private void stateWait() {

        //we've disliked the agent and he was set to null, stop waiting
        if (agentWith == null){
            goToState(StateType.AGENT_ALONE);
            return;
        }

        //check if waitForAgent is back
        if (agentWith.isVisible() && agentInfo.atLocation(agentWith.getLocation(),communicationRangeConst)){
            if (timerIsRunning(TimerType.WAIT_TIMER) && !timerIsRunning(TimerType.INIT_WAIT_TIMER)){
                getAct().act(new SendMessage().setText("To:" + agentWith.getName() + " Not waiting anymore! I am with you again.").setFadeOut(messageFadeOutConst));
                getConversationHistory(agentWith.getId().getId()).updateSentMessages(currentTime);
                myAEGenerator.generateWaitAgentReturnedEvent(agentWith);
                goToState(StateType.AGENT_WITH);
                return;              
            }
        }

        //look if waiting timer expired
        if (!timerIsRunning(TimerType.WAIT_TIMER)){
            myAEGenerator.generateWaitAgentNotReturnedEvent(agentWith);
            agentWith = null;
            waitForAgent = null;
            goToState(StateType.AGENT_ALONE);
            return;
        }

        //handle interrupters during waiting
        Player agentInterrupter = null;
        if (!agentInterrupters.isEmpty())
            agentInterrupter = pickFocus(agentInterrupters);

        if (agentInterrupter != null){
            if (agentInfo.isMoving())
                getAct().act(new Stop());

            getAct().act(new TurnTo().setTarget(agentInterrupter.getId()));

            //respond to proposals;
            if ((recentReceivedProposal != null) && (currentTime - recentReceivedProposal.getTime() > 1) ) {
                if (respondToProposal())
                    return;
            }

            doAction(pickAction(agentInterrupter),agentInterrupter);

            conversate(agentInterrupter, ConversationType.WAIT);
        } else {
            //TODO: this is hardwire here, we know we will be waiting just in front of the cinema
            getAct().act(new TurnTo().setLocation(cinemaLocation));
            //todo: walking as i would be waiting
            //getAct().act(new Move().setFirstLocation(agentInfo.getLocation().add(new Location(300,300,0))).setSecondLocation(agentInfo.getLocation()));
            //setAction(null, ActionType.NONE, currentTime, 3);
        }
    }

    /**
     * Main state for handling iteraction with agentWith. Here we respond to proposals,
     * make our own and trigger actions toward agentWith when we are alon with him.
     */
    private void stateWithSomebody(){

        //check if we still are with the agent
        if ((agentWith == null) || (currentTime - agentWith.getLastSeenTime()) > agentWithDissapearTimeConst){
            agentWith = null;
            goToState(StateType.AGENT_ALONE);
            return;
        }

        //timers/situation handling
        if (timerIsRunning(TimerType.WATCHING_FILM)){
            //TODO: getAct().act(new TurnTo().setTarget(LOOK_TOWARD_MOVIE));
            if (!agentInterrupters.isEmpty()){
                conversate(pickFocus(agentInterrupters), ConversationType.MOVIE);
            }
            else
                conversate(agentWith, ConversationType.MOVIE);
            return;
        }

        //check if our proposal was accepted by agentWith and perform neccesary actions
        if (processMyProposal()){
            return;
        }

        //respond to proposals
        if (recentReceivedProposal != null) {
            if (respondToProposal())
                return;
        }

        //here we switch to state if we were interrupted by some agent - some agent talked to us
        //depending on our situation we will switch to different states
        if (!agentInterrupters.isEmpty()) {
            goToState(StateType.INTERRUPTED);
            return;
        }

        if (agentWith.getLocation().getDistance(agentInfo.getLocation()) > 200){
            getAct().act(new Move().setFirstLocation(agentWith.getLocation()));
            return;
        }

        if (agentInfo.isMoving()) {
            getAct().act(new Stop());
        }

        getAct().act(new TurnTo().setTarget(agentWith.getId()));

        //make some action - for girl no?
        doAction(pickAction(agentWith),agentWith);
        //the action may cause the agentWith to be null!!!
        if (agentWith == null)
            return;
        //proposals handling
        ProposalType desiredProposal = pickProposal(agentWith);

        if (desiredProposal != ProposalType.NONE){
            actionMakeProposal(agentWith, desiredProposal);
            return;
        }

        //handles situation at home
        if (atHome(agentWith)){
            conversate(agentWith, ConversationType.HOME);
            return;
        }

        conversate(agentWith, ConversationType.CASUAL);
    }


    /**
     * Explore state for our girl. Girl will explore environment and approach any
     * boys she likes.
     *
     */
    private void stateApproachBoys() {        
       if (!agentInterrupters.isEmpty()){
            agentWith = pickTargetPlayer(agentInterrupters);
            if (agentWith != null) {
                removeInterrupter(agentWith);
                goToState(StateType.AGENT_WITH);
                return; //leave the logic, so we will check in next iteration our feelings toward the agent
            } else {
                goToState(StateType.INTERRUPTED);
                return;
            }
        }

        if (players.canSeePlayers() && ( (myPlrTarget == null) || !myPlrTarget.isVisible() )){
            //picks here just opposite sex players and not animals
            myPlrTarget = pickTargetPlayer(players.getVisiblePlayers().values());
        }

        if (myPlrTarget != null){
            if (myPlrTarget.getLocation().getDistance(agentInfo.getLocation()) < 200){
                
                if (agentInfo.isMoving()) {
                    getAct().act(new Stop());
                }
                conversate(myPlrTarget, ConversationType.CASUAL);
                //actionCompliment(myPlrTarget);
                agentWith = myPlrTarget;
                goToState(StateType.AGENT_WITH);
                return;

            } else {
                 goToLocation(myPlrTarget.getLocation());
            }
            
        } else { //random movement            
            if (myLocTarget == null){
                myPath.clear();
                pathRequested = false;
                pathReceived = false;
                myLocTarget = pickNewLocTarget();
            }

            if ((myLocTarget.getLocation().getDistance(agentInfo.getLocation()) < 80)){
                myLocTarget = null;
            } else {
                goToLocation(myLocTarget.getLocation());
            }
        }
    }

    /**
     * Called when we entered some state.
     *
     * @param newState new state
     */
    @Override
    public void beginState(StateType newState){
        if (newState == StateType.AGENT_WITH){
            myGoalPlace = PlaceType.NONE;
            clearNavigationVariables();
        } else if (newState == StateType.AGENT_ALONE){
            timerSet(TimerType.WAIT_AT_HOME, waitAtHomeDurationConst + new Random().nextInt(waitAtHomeDurationConst)/4);
            recentReceivedProposal = null;
            recentProposal = null;
            //myGoalPlace = PlaceType.NONE;
            //agentWith = null;
            removeAllInterrupters();
            clearNavigationVariables();
        } else if (newState == StateType.GOING_SOMEWHERE_WITH){
            clearNavigationVariables();
        } else if (newState == StateType.FOLLOW_AGENT_WITH){
            clearNavigationVariables();
        } else if (newState == StateType.POLYMORPH_THREAT){
            clearNavigationVariables();
        } else if (newState == StateType.INTERRUPTED){
            timerSet(TimerType.INTERRUPTION_TIMER,interruptDurationConst + new Random().nextInt(interruptDurationConst));
        } else if (newState == StateType.WAIT){
            timerSet(TimerType.WAIT_TIMER,waitDurationConst + new Random().nextInt(waitDurationConst)/4);
            lastWaitEventTime = currentTime;
            clearNavigationVariables();
        }
        //logging
        logStateEntered(newState, currentTime);
    }

    /**
     * Called when we are leaving some state.
     *
     * @param endingState state we are leaving
     */
    @Override
    public void endState(StateType endingState){
        if (endingState == StateType.INTERRUPTED){
            timerErase(TimerType.INTERRUPTION_TIMER);
            if (!agentInterrupters.isEmpty()){
                actionMultipleBye(agentInterrupters);
                removeAllInterrupters();
            }
        } else if (endingState == StateType.WAIT){
            timerErase(TimerType.WAIT_TIMER);
            //say bye to all interrupters after stopped waiting.
            if (!agentInterrupters.isEmpty()){
                actionMultipleBye(agentInterrupters);
                removeAllInterrupters();
            }
        }
        //logging
        logStateLeft(endingState, currentTime);
    }

}
