package bot;

//import junit.framework.TestCase;

//import org.junit.Test;
import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.PogamutAgentModule;

import cz.cuni.amis.utils.Job;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import info.ScenarioType;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.Time;
//import static org.junit.Assert.*;

/**
 * This is the main class for running our example scenario. All four IVAs will be 
 * created and set up here - this means they will be created as a new objects and 
 * connection to UT04 will be provided for them. 
 * 
 * Also after scenario ends logging methods will be invoked on the agents (just on
 * human ones, not for polymorph)
 *
 * @author Knight
 */
public class EmotionalBotTestCase {

    /** Scenario duration in miliseconds  */
    public long scenarioDuration = 600000;//600000 = 10 minutes
    /** Scenario start time in miliseconds */
    public long scenarioStart = 0;
    /** Module used to spawn scenario male IVA */
    public PogamutAgentModule moduleMale = new EmotionalMaleBotModule();
    /** Module used to spawn scenario female one IVA */
    public PogamutAgentModule moduleFemaleOne = new EmotionalFemaleBotModule();
    /** Module used to spawn scenario female two IVA */
    public PogamutAgentModule moduleFemaleTwo = new EmotionalFemaleBotModule();
    /** Module used to spawn scenario polymorph IVA */
    public PogamutAgentModule modulePolymorph = new PolymorphBotModule();

    // public IAgentFactory<ISocketConnectionAddress> factory = null;
    /**
     * Main method that will initialize IVAs, create their connection to UT04 and
     * run them.
     */
    public void RunEmotionalBotAtLocalhost() {

        IAgentFactory<ISocketConnectionAddress> factoryMale;
        IAgentFactory<ISocketConnectionAddress> factoryFemaleOne;
        IAgentFactory<ISocketConnectionAddress> factoryFemaleTwo;
        IAgentFactory<ISocketConnectionAddress> factoryPolymorph;

        EmotionalMaleBot agentMale = null;
        EmotionalFemaleBot agentFemaleOne = null;
        EmotionalFemaleBot agentFemaleTwo = null;
        PolymorphBot agentPolymorph = null;

        factoryMale = new GuiceAgentFactory(moduleMale);
        factoryFemaleOne = new GuiceAgentFactory(moduleFemaleOne);
        factoryFemaleTwo = new GuiceAgentFactory(moduleFemaleTwo);
        factoryPolymorph = new GuiceAgentFactory(modulePolymorph);


        //while (true) {

            agentMale = null;
            agentFemaleOne = null;
            agentFemaleTwo = null;
            agentPolymorph = null;

            try {
                agentMale = (EmotionalMaleBot) factoryMale.newAgent(new SocketConnectionAddress("localhost", 3000));
                agentFemaleOne = (EmotionalFemaleBot) factoryFemaleOne.newAgent(new SocketConnectionAddress("localhost", 3000));
                agentFemaleTwo = (EmotionalFemaleBot) factoryFemaleTwo.newAgent(new SocketConnectionAddress("localhost", 3000));
                agentPolymorph = (PolymorphBot) factoryPolymorph.newAgent(new SocketConnectionAddress("localhost", 3000));
            } catch (Exception e) {

                e.printStackTrace();
            //System.err.println(e);


            //fail("Can't create new agent: " + e.getMessage());
            }

            agentMale.getLogger().addConsoleHandlersToAllCategories();
            agentMale.getLogger().setLevel(Level.ALL);

            agentFemaleOne.getLogger().addConsoleHandlersToAllCategories();
            agentFemaleOne.getLogger().setLevel(Level.ALL);

            agentFemaleTwo.getLogger().addConsoleHandlersToAllCategories();
            agentFemaleTwo.getLogger().setLevel(Level.ALL);

            agentPolymorph.getLogger().addConsoleHandlersToAllCategories();
            agentPolymorph.getLogger().setLevel(Level.ALL);

            agentMale.initScenario(ScenarioType.SCENARIO_ONE, "Bruno");
            agentFemaleOne.initScenario(ScenarioType.SCENARIO_ONE, "Anne");
            agentFemaleTwo.initScenario(ScenarioType.SCENARIO_ONE, "Clementine");
            agentPolymorph.initPolymoprh(ScenarioType.SCENARIO_ONE);

            scenarioStart = Time.getTimeInMilis();

            try {
                agentMale.start();
                agentFemaleOne.start();
                agentFemaleTwo.start();
                agentPolymorph.start();
            } catch (Exception e) {
                Logger.getLogger(EmotionalBotTestCase.class.getName()).log(Level.SEVERE, null, e);
            }

            while (scenarioStart + scenarioDuration > Time.getTimeInMilis()) {
                try {
                    Thread.sleep(1500);
                } catch (InterruptedException ex) {
                    Logger.getLogger(EmotionalBotTestCase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            agentMale.bLogEnabled = false;
            agentFemaleOne.bLogEnabled = false;
            agentFemaleTwo.bLogEnabled = false;

            agentMale.shutdown();
            agentFemaleOne.shutdown();
            agentFemaleTwo.shutdown();
            agentPolymorph.shutdown();

            try {
                //we will sleep for 15 seconds, so everything is stored properly.
                Thread.sleep(15000);
            } catch (InterruptedException ex) {
                Logger.getLogger(EmotionalBotTestCase.class.getName()).log(Level.SEVERE, null, ex);
            }

            agentMale.terminate();
            agentFemaleOne.terminate();
            agentFemaleTwo.terminate();
            agentPolymorph.terminate();
            
            try {
                //we will sleep for 15 seconds, so everything is killed properly
                Thread.sleep(15000);
            } catch (InterruptedException ex) {
                Logger.getLogger(EmotionalBotTestCase.class.getName()).log(Level.SEVERE, null, ex);
            }

       // }

    }
    /** Not used right now */
    Flag<Boolean> running = new Flag<Boolean>(true);

    /**
     * Main method, that can be executed.
     *
     * @param args
     */
    public static void main(String args[]) {

        EmotionalBotTestCase test1 = null;
        if (test1 == null) {
            try {
                test1 = new EmotionalBotTestCase();
                test1.RunEmotionalBotAtLocalhost();
//                    test1.bRunAnotherExperiment = false;
            } catch (Exception e) {
                Logger.getLogger(EmotionalBotTestCase.class.getName()).log(Level.SEVERE, null, e);
            }
        }

    }
}
