package bot;

import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import de.affect.xml.AffectInputDocument.AffectInput;
import info.*;
import java.io.FileNotFoundException;
import logging.*;
import utils.*;
import almabasedmodel.*;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.navigation.PathPlannerListener;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTAstar;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.*;

import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.PlayerListObtained;
import de.affect.emotion.Emotion;
import de.affect.emotion.EmotionType;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/**
 * The base class for our emotional agents. Defines sensors and actions for our emotion
 * agents. Also registers all listeners to messages from the environment as well as
 * creates all other objects needed for our agent (ALMA emotion model...). Moreover
 * here are defined the constants which affect the agent behavior. 
 *
 * @author Knight
 */
@AgentScoped
public class EmotionalBot extends SyncUT2004Bot<UT2004SyncLockableWorldView>{

    /** Our agents name */
    protected String myName = "Bruno";
    /** Name of the skin that will be used to visualize our agent, not used if class set */
    public String mySkin = "";
    /** Name of the UT class that will be used for visualizing our agent in the envirnoment */
    public String myClassName = "";

    /** Pointer to ALMA emotion model */
    public PogamutALMA myALMA;
    /** Pointer to class that evaluates events by OCC variables and notifies ALMA */
    public AEventGenerator myAEGenerator;
    /** Pointer to class that generates events according to messages we got from environment */
    public EventGenerator myEGenerator;
    /** Class that counts feeling towards agents and provide simple interface between ALMA*/
    public AEmotionState myEmotionState;

    /** Here we define where the places in the scenario will be */
    /** Cinema location */
    public Location cinemaLocation = new Location(922, 2200, -4556);////TrainingDay: new Location(2000,-900,-80);
    /** This should point in front of the cinema*/
    public Location meetingCinemaLocation = new Location(1400, 3000, -4556);
    /** Boy home location */
    public Location boyHomeLocation = new Location(7066,2707,-4552); //TrainingDay: new Location(2000,-2200,-80);
    /** First girl home location - for Anne. */
    public Location firstGirlHomeLocation = new Location(6091,-437,-4552); //for anne
    /** First girl home location - for Clementine. */
    public Location secondGirlHomeLocation = new Location(-2173,1134,-4556); //for clementine
    /** Park location */
    public Location parkLocation = new Location(1833,168,-4558);

    /** Initial agent location */
    public Location startLocation;
    /** Initial agent rotation */
    public Rotation startRotation;



    /** Path finding variables */

    /** Here we store latest path we got from GameBots */
    public ArrayList<ILocated> myPath = new ArrayList<ILocated>();
    /** True if we have already requested path to our latest goal */
    public boolean pathRequested = false;
    /** True if we have already received path to our latest goal */
    public boolean pathReceived = false;
    /** Time of our last path request */
    public double pathRequestedTime = 0;
    /** If we haven't received path in this time seconds, we will request it again */
    public int pathRerequestDelay = 3;

    /** List of all navpoints in the map - got from MapListObtainedEvent */
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap<UnrealId,NavPoint>();

    /** Here we define places the agent can go, when moving randomly to avoid navigation problems */
    public ArrayList<Location> randomLocationTargets = new ArrayList<Location>();
   
    /** 
     * Agent our agent is with now. Important variable, when null it means our agent
     * hasn't selected anyone to be with yet. With agentWith the agent can go to cinema,
     * park and home.
     */
    public Player agentWith;

    /** For setting the scenario up, this will be our first agentWith. */
    public String initAgentWithName = "";

    /** player we are waiting for in the wait state. Note: Not used! */
    public Player waitForAgent = null;

    /** 
     * Here we hold all agents that spoke to us recently or interrupted us in some
     * other way - so we can react to them (by going to interrupted state or setting
     * one of them as agentWith) or throw them out of this list
     */
    public ArrayList<Player> agentInterrupters = new ArrayList<Player>();

    /** Helper variable. Player I am heading to. */
    public Player myPlrTarget;

    /** Helper variable. Location I am heading to */
    public Location myLocTarget;

    /**
     * This is the point where I am heading to rights now - may be far away, this
     * will be used by state AGENT_GOING_SOMEWHERE_WITH
     */
    public Location myGoalTarget;

    /** This is navigation point closest to our goalTarget */
    public Location nearestNavLocation;

    /**
     * We will check this in our navigation method if our path is still actual
     * if not, we will request a new path
     */
    public Location lastFollowPathLocation;

    /** Here we store which scenario we are currently performing */
    public ScenarioType scenario;

    /** This is my destination place, so I know where I am going to - MY_HOME, CINEMA, etc. */
    public PlaceType myGoalPlace = PlaceType.NONE;

    /** True if bot moving, false otherwise */
    public boolean botMoving = false;

    /** Agent memory/sensory modules */
    /** Information about game */
    public Game game;
    /** Information about agent state */
    public AgentInfo agentInfo;
    /** Information about other agents we can see or have seen */
    public Players players;
    /** Path finding module */
    public UTAstar myPathPlanner;

    /**
     * Some actions need some time to be finished. we will stop decesion making
     * for this time, so the actions can end properly
     */
    /** Time of the last action */
    protected double lastActionTime = 0;
    /** Duration of the last action */
    protected double lastActionDuration = 0;
    /** Type of the last action */
    protected ActionType lastActionType; 

    /** History of our sent proposals */
    public HashMap<Integer,ArrayList<ProposalInfo>> proposalsHistory = new HashMap<Integer,ArrayList<ProposalInfo>>();
    /** Recent proposal we have sent to someone. Used to check if it was accepted. */
    public ProposalInfo recentProposal = null;
    /** Recent proposal we have received from someone - used for responding to such proposal. */
    public ProposalInfo recentReceivedProposal = null;
    /** This helps us to generate player appeared, lost and player together events */
    public HashMap<Integer,PlayerInfo> playersHistory = new HashMap<Integer,PlayerInfo>();
    /** Holds all my scenario items */
    public HashMap<ScenarioItemType,Integer> myItems = new HashMap<ScenarioItemType,Integer>();
    /** Holds all item requests we have received */
    public ArrayList<ItemRequest> myItemRequests = new ArrayList<ItemRequest>();

    /** If true, the logging of the scenario into complex object will be enabled */
    public boolean bLogEnabled = false;
    /** Object we will log into if complex logging enabled */
    public AgentLogging agentLog = null;
    
    /** timers handling */
    /** Trigger times of our timers */
    public HashMap<TimerType,Double> timersTriggerTime = new HashMap<TimerType,Double>();
    /** Duration times of our timers */
    public HashMap<TimerType,Double> timersDelayTime = new HashMap<TimerType,Double>();

    /** Here is the list of events we will generate in the scenario */
    public HashMap<EventId,Boolean> generatedEvents = new HashMap<EventId,Boolean>();

    /** Here we store agents that are ignored by us for some reasons */
    public HashMap<Integer,Player> playersIgnored = new HashMap<Integer,Player>();

    /** Here we store info about last polymorph triggered events, so they don't occur too often */
    public HashMap<Integer,PolymorphEventInfo> polymorphHistory = new HashMap<Integer,PolymorphEventInfo>();

    /**
     * This logs the number of messages we have received from players, so we can
     * adjust emotion events intensity
     */
    public HashMap<Integer,ConversationInfo> myConversationHistory = new HashMap<Integer,ConversationInfo>();

    /** This logs the emotional conversations send to other agents than we are */
    public HashMap<Integer,ConversationInfo> otherConversationHistory = new HashMap<Integer,ConversationInfo>();

    /** Our agent current state */
    protected StateType state = StateType.AGENT_ALONE;

    /** Previous state our agent was in. */
    protected StateType previousState = StateType.NONE;

    /** Here we keep current time in the scenario. Is used by all classes. */
    public double currentTime = 0;

    /** Helper var, here we store feeling decay counter. */
    protected int feelingsDecayCounter = 0;

    /** Last time we have generated wait event */
    protected double lastWaitEventTime = 0;
    
    /** CONSTS */
    /** FEELING CONSTS: */
    /** Feeling value for real love */
    public double loveFeelingConst = 1.8;
    /** Feeling value for proposing/accepting kiss */
    public double kissFeelingConst = 0.9;
    /** Feeling value for going to cinema */
    public double cinemaFeelingConst = 0.4;
    /** Feeling value for going to park */
    public double parkFeelingConst = 0.3;
    /** Feeling value for going home with some agent */
    public double homeFeelingConst = 0.5;
    /** If feeling lower than this, it will reject cinema request (otherwise, it will be just ignored) */
    public double cinemaRejectFeelingConst = 0;
    /** If feeling lower than this, it will reject park request (otherwise, it will be just ignored) */
    public double parkRejectFeelingConst = -0.1;
    /** If feeling lower than this, it will reject home request (otherwise, it will be just ignored) */
    public double homeRejectFeelingConst = 0.1;
    /** Feeling value for willing to slap someone */
    public double slapFeelingConst = -0.5;
    /** Feeling value for leaving actual agentWith */
    public double leaveFeelingConst = -2.1;
    /** Feeling value for refusing to leave target that we are cuddling */
    public double cuddleFeelingConst = 0.5;
    /** We will accept leave proposal, if our feelings are less negative toward the agent than this value */
    public double argumentLeaveFeelingThresholdConst = -0.5;
    /** Feeling value for ignoring agents */
    public double ignoreFeelingConst = -2;
    /** Feeling value for kicking emohawk */
    public double kickEmoFeelingConst = -0.5;
    /** Feeling value when we want to give flowers to target */
    public double flowerFeelingConst = 0.5;
    /** Feeling needed to make compliment to the agent */
    public double complimentFeelingConst = 0.3;
    /** Feeling needed to make an insult to target agent */
    public double insultFeelingConst = -0.2;
    /** Feeling we need to make proposal to have sex and to accept this proposal */
    public double sexFeelingConst = 2;
    /** Feeling we need to approach the player if we see to pass him by */
    public double approachFeelingConst = -0.1;
    /** Intensity we need for anger to perform action slap */
    public double slapAngerConst = 0.1;
    /** Intensity we need for anger to perform action insult */
    public double insultAngerConst = 0;
    /** Intensity we need for joy to perform action compliment */
    public double complimentJoyConst = 0;
    /**
     * When responding to proposal to leave agentWith, the feeling to proposing
     * agent needs to be higher than the agentWith feeling plus this bonus!
     */
    public double stayWithAgentBonusFeelingConst = 0.9;
    /** Feeling we need to wait for the agent */
    public double waitFeelingConst = 0.4;
    /** feeling we need to have to reject wait proposal from agentWith */
    public double waitRejectFeelingConst = - 0.3;

    /** TIME CONSTS: */
    /** Time value after we will accept leave proposal when we are cuddling something */
    public double cuddleTimeConst = 15;
    /** Second between two flower gives */
    public double flowerDelayTimeConst = 90;
    /** When we were at the cinema, we will propose new go to cinema after this time seconds */
    public double cinemaDelayTimeConst = 270;
    /** When we were at park, we will propose new go to park after this time seconds */
    public double parkDelayTimeConst = 320;
    /** After this time when we are not at home we will propose home proposal */
    public int homeDelayTimeConst = 90;
    /** Time after we will try again to approach agent after we have left/been left (by bye or leave) */
    public double reapproachDelayConst = 45;
    /** Minimal time between two actions we can do toward the agent. */
    public double minimalActionDelayConst = 10;
    /** Minimal time between we choose to respond to some other player action */
    public double minimalActionResponseDelayConst = 2;
    /** In seconds how long the text bubbles will stay above the bot. */
    public double messageFadeOutConst = 5;
    /** Delay between two sex proposals */
    public double sexDelayTimeConst = 45;
    /** Delay between two kiss proposals */
    public double kissDelayTimeConst = 20;
    /** Action done max before this time is still taken as recent - used in pickAction() */
    public double recentActionTimeConst = 12;
    /**
     * If someone has interrupted us before this amount of time, we won't let him
     * to interrupt us again (we will say BYE to him immediately)
     */
    public double interruptDelayConst = 15;
    /** When we don't see the agentWith, after this time we will consider him as dissapeared */
    public double agentWithDissapearTimeConst = 10;
    /**
     * This number will be used when setting up interruption timer duration,
     * this + random number up to this value so max interruption duration will be 2 * this number)
     */
    public int interruptDurationConst = 30;
    /** If we were interrupted in last x secs by human agent we won't let him to interrupt us now */
    public int humanInterruptedDelayConst = 20;
    /** 
     * This is the time that has to pass after last polymorph interruption before we let
     * him to interrupt us again
     */
    public int polymorphInterruptedDelayConst = 40;
    /** Delay before we will responed to some message */
    public int messageResponseDelayConst = 4;
    /** Delay before we will send new message if no response was sent to us */
    public int messageSendDelayConst = 9;
    /** If player haven't responded to our proposal in specified time, we will count it as ignored */
    public int proposalIgnoreTimeConst = 30;
    /** How long the walk with other agent will last */
    public int walkDurationTimeConst = 30;
    /**
     * this is default duration const, the timer will be set to this value + random
     * from 0 to this value / 4. after this time, the agent will stop waiting
     * TODO: feeling affects waitDuration?
     */
    public int waitDurationConst = 170;
    /**
     * This is default duration const, the timer will be set to this value + random
     * from 0 to this value / 4. after this time, the agent will stop waiting
     */
    public int waitAtHomeDurationConst = 80;
    /** We will start checking if agent is back after this time */
    public int checkAgentBackDelayTimeConst = 5;
    /** For this time we won't check if the agent is back, so he has chance to leave */
    public int initWaitDurationConst = 10;
    /** We will generate wait emotional event every this value seconds */
    public int generateWaitEventDurationConst = 35;


    /** DISTANCE: */
    /** We will keep this distance between agent and us when we will follow him */
    public int followAgentDistanceConst = 60;
    /** How close the agent should for us to communicate with him or to allow to interrupter us. */
    public int communicationRangeConst = 300;


    /** OBSTACLE AVOIDANCE: */
    private static final double AVOID_OBSTACLE_FUNCTION = 150;
	private static final double AVOID_OBSTACLE_FUNCTION_MULTI = 0.4;
	private static final double AVOID_OBSTACLE_MIN_DISTANCE = 400;
	private static final double AVOID_OBSTACLE_RUN_VECTOR_LENGTH = 100;
	//private static final double AVOID_OBSTACLE_RUN_LENGTH = 100;
	//private static final double AVOID_OBSTACLE_SECOND_RUN_MULTI = 0.5;

    /**
     * Here we will listen to map event and store all nav points in our internals
     */
    public WorldEventListener myMapListObtainedListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {

            MapPointListObtained map;

            map = (MapPointListObtained) event;
            knownNavPoints.putAll(map.getNavPoints());

        }
    };

   /**
    * Listener to SLF message containing information about our agent.
    */
   public WorldObjectEventListener mySlfListener = new WorldObjectEventListener() {

        @Override
        public void notify(Object event) {
            Self slf;

            slf = (Self) event;
            //getLogger().user().info("!!!!!!!!!!!!!!!!!!!!!!!!!" + event.toString());
            if (slf.getVelocity().size() < 10)
                botMoving = false;
            else
                botMoving = true;
        }
    };

   /**
    * Listener to PLR message - information about agents we see.
    */
   public WorldObjectEventListener myPlrListener = new WorldObjectEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof Player) {
                Player plr = null;
                plr = (Player) event;
                myEGenerator.notifyPlayer(plr);
            }
        }
    };

    /** 
     * Listener to Kill Message - should not be used in scenario right now
     */
    public WorldEventListener myPlayerKilledListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof PlayerKilled)
                myEGenerator.notifyPlayerKilled((PlayerKilled) event);
        }
    };

    /**
     * Path listener
     */
    public PathPlannerListener myPathListener = new PathPlannerListener(){

        @Override
        public void pathEvent(List path) {
            myPath = (ArrayList<ILocated>) path;
            pathReceived = true;
        }
    };

    /**
     * Listener to Die Message
     */
    public WorldEventListener myBotDiedListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            //TODO:
        }
    };

    /**
     * Listener to Hit Message
     */
    public WorldEventListener myPlayerDamagedListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof PlayerDamaged)
                myEGenerator.notifyPlayerDamaged((PlayerDamaged) event);
        }
    };

    /**
     * Listener to Dam Message
     */
    public WorldEventListener myBotDamagedListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof BotDamaged)
                myEGenerator.notifyBotDamaged((BotDamaged) event);
        }
    };

    /**
     * Listener to IPK Message
     */
    public WorldEventListener myPickupListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof ItemPickedUp)
                myEGenerator.notifyPickup((ItemPickedUp) event);
        }
    };

    /**
     * Listener to GOT Message
     */
    public WorldEventListener myGotInvListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof ReceivedInventoryMsg)
                myEGenerator.notifyGotInv((ReceivedInventoryMsg) event);
        }
    };

    /**
     * Listener to global chat message - text messages
     */
    public WorldEventListener myTextMessageListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof GlobalChat){
                GlobalChat gc;
                gc = (GlobalChat) event;
                myEGenerator.notifyTextMessage(gc);
                //getLogger().user().info("<<<<<<<<<<<< Received: " + gc.getText());
            }
        }
    };

    /**
     * Listens to End Message
     */
    public WorldEventListener myEndListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {

            myEmotionState.processEmotions();
            myEmotionState.processFeelings();

            if (feelingsDecayCounter > 520){
                myEmotionState.decayFeelings();
                feelingsDecayCounter = 0;
            }

            feelingsDecayCounter++;
            //getLogger().user().warning("---------------------------------------");
            //getLogger().user().warning(myEmotionState.feelingsHistory.toString());
            //getLogger().user().info(myEmotionState.getCurrentEmotions().toString());
        }
    };

    /**
     * Listener to Beg Message
     */
    public WorldEventListener myBegListener = new WorldEventListener() {

        @Override
        public void notify(Object event) {
            if (event instanceof BeginMessage){
                BeginMessage bm = (BeginMessage) event;
                myEGenerator.notifyBegin(bm);
                currentTime = bm.getTime();
                //updates our timers here - need to set currentTime BEFORE this
                timerProcess();
            }
        }
    };


    /**
     * Constructor for our agent.
     *
     * @param logger agent logger we use
     * @param worldView worlview that provides us with information about environment
     * @param commandSerializer serializer that allows us to send command to the environment
     */
	@Inject
	public EmotionalBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
		super(logger, worldView, commandSerializer);
	}

    /**
     * Here we check if the agent specified by id is opposite sex then our agent
     * TODO: Unfinished
     *
     * @param id Id of the agent we are checking.
     * @return true or false
     */
    public boolean isOppositeSex(int id) {
        if (myName.contains("Bruno")){
            if (isHuman(id))
                return true;            
        } else {
            if (playersHistory.containsKey(id)){
                if (playersHistory.get(id).getName().equals("Bruno"))
                    return true;
            }
        }

        return false;
    }

    /**
     * Here we check if the agent specified by id is opposite sex then our agent
     * TODO: Unfinished
     *
     * @param agent the agent we are checking
     * @return true or false
     */
    public boolean isOppositeSex(Player agent) {
        if (myName.contains("Bruno")){
            if (isHuman(agent))
                return true;
        } else {
            if (agent.getName().contains("Bruno"))
                return true;
        }

        return false;
    }

    /**
     * Here we check if the agent specified by id is female. We may ask also about us.
     *
     * @param id Id of the agent we are checking.
     * @return true if agent is female
     */
    public boolean isFemale(int id) {

        if (agentInfo.getId().getId() == id){
            if (agentInfo.getName().toLowerCase().equals("bruno") || agentInfo.getName().toLowerCase().contains("boy"))
                return false;
            else if ((agentInfo.getName().toLowerCase().equals("anne")) || (agentInfo.getName().toLowerCase().equals("clementine"))
                    || (agentInfo.getName().toLowerCase().contains("girl")))
                return true;
        } else {
            if (playersHistory.containsKey(id)){
                if (playersHistory.get(id).getName().toLowerCase().equals("Bruno") || agentInfo.getName().toLowerCase().contains("boy"))
                    return false;
                else if ((agentInfo.getName().toLowerCase().equals("anne")) || (agentInfo.getName().toLowerCase().equals("clementine")))
                    return true;
            }                
        }

        return false;
    }

    /**
     * Here we check if the agent is male. By default if the agent is human, he will
     * be considered as male
     *
     * @param agent the agent we are checking.
     * @return true if agent is male
     */
    public boolean isMale(Player agent) {
        if (agent.getName().toLowerCase().equals("bruno") || agentInfo.getName().toLowerCase().contains("boy"))
            return true;
        else if (agent.getName().toLowerCase().equals("anne") || agent.getName().toLowerCase().equals("clementine"))
            return false;

        if (isHuman(agent.getId().getId()))
            return true;
        else
            return false;
    }

    /**
     * Returns true if input agent is human being and not animal (also comupter
     * controlled agents are human).
     *
     * @param agent input agent check
     * @return whether input agent is a human
     */
    public boolean isHuman(Player agent){
        if ((!agent.getName().toLowerCase().contains("emohawk")) &&
                (!agent.getName().toLowerCase().contains("animal") ))
            return true;

        return false;
    }

    /**
     * Returns true if input id belongs to human being and not animal (also comupter
     * controlled agents are human).
     * 
     * @param id input id to check
     * @return whether input id belongs to a human
     */
    public boolean isHuman(int id) {
        if (playersHistory.containsKey(id)){
            if ((!playersHistory.get(id).getName().toLowerCase().contains("emohawk")) &&
                    (!playersHistory.get(id).getName().toLowerCase().contains("animal") ))
                return true;
        }

        return false;
    }

    /**
     * Logs emotion event.
     *
     * @param ai affect input
     * @param event event id
     */
    public void logEmotionEvent(AffectInput ai, EventId event) {
        if (bLogEnabled && agentLog != null){
            agentLog.insertEmotionEvent(
                event, ai.getBasicEEC().getElicitor(),getName(ai.getBasicEEC().getElicitor()),
                myEmotionState.parseId(ai.getBasicEEC().getElicitor()),
                currentTime, ai.getBasicEEC().getDesirability(), ai.getBasicEEC().getPraiseworthiness(),
                ai.getBasicEEC().getAppealingness(), ai.getBasicEEC().getLikelihood(),
                ai.getBasicEEC().getLiking(), ai.getBasicEEC().getRealization(), ai.getBasicEEC().getAgency().toString()
            );
        }
    }

    /**
     * Called after the bot is set up in the platform, but BEFORE he has body in the
     * environment or before any message from the environment arrives. Is used to set
     * up all objects/tools our agent will use. Here we will register all listeners,
     * create emotion model and other helper classes.
     */
	@Override
	protected void prePrepareBot() {

            //sets the logger level, so we get just our logs
            getLogger().setLevel(Level.WARNING);

            //initialize generated events
            for (EventId event : EventId.values()){
                generatedEvents.put(event, true);
            }

            myALMA = new PogamutALMA(this);

            myEmotionState = new AEmotionState(myALMA, this);

            myAEGenerator = new AEventGenerator(myALMA, myEmotionState, this);

            myEGenerator = new EventGenerator(this);

            this.getWorldView().addUpdatedListener(Self.class, mySlfListener);
            this.getWorldView().addUpdatedListener(Player.class, myPlrListener);

            this.getWorldView().addListener(PlayerKilled.class, myPlayerKilledListener);
            this.getWorldView().addListener(BotKilled.class, myBotDiedListener);
            this.getWorldView().addListener(EndMessage.class, myEndListener);
            this.getWorldView().addListener(BeginMessage.class, myBegListener);
            this.getWorldView().addListener(ItemPickedUp.class, myPickupListener);
            this.getWorldView().addListener(ReceivedInventoryMsg.class, myGotInvListener);
            this.getWorldView().addListener(PlayerDamaged.class, myPlayerDamagedListener);
            this.getWorldView().addListener(BotDamaged.class, myBotDamagedListener);
            this.getWorldView().addListener(GlobalChat.class, myTextMessageListener);
            this.getWorldView().addListener(MapPointListObtained.class, myMapListObtainedListener);
            
            //initialize memory modules
            this.game = new Game(this.getWorldView(),this.getLogger().user());
            this.agentInfo = new AgentInfo(this.getWorldView(), game, this.getLogger().user());
            this.players = new Players(this.getWorldView(), agentInfo, this.getLogger().user());

            this.myPathPlanner = new UTAstar(this.getAct(),this.getWorldView());

            //we will start with one flower in our backpack. :-)
            myItems.put(ScenarioItemType.FLOWER, 1);

            //init allowed locations
            //randomLocationTargets.add(new Location(-1865,2283,-4565));
            randomLocationTargets.add(new Location(-1900,340,-4565));
            randomLocationTargets.add(new Location(1087,2827,-4565));
            randomLocationTargets.add(new Location(4152,2459,-4565));
            randomLocationTargets.add(new Location(5505,1000,-4565));
            //randomLocationTargets.add(new Location(5505,-450,-4565));
            if (bLogEnabled) {
                String fileName = "Scenario_" + getMyName() + Time.now("yyyy.MM.dd_HH.mm.ss") + ".log";
                agentLog = new AgentLogging(this.getMyName(), fileName);
            }
	}

    /**
     * Called after the bot has body in the environment.
     *
     * @param info contains information about current game - location we are in and so.
     */
	@Override
	protected void postPrepareBot(GameInfo info) {

/*
        String fileName = getMyName() + Time.now("yyyy.MM.dd_hh.mm") + ".log";

        try {
            // Create a file handler that write log record to a file called my.log
            FileHandler handler = new FileHandler(fileName);
            // Add to the desired logger
            getLogger().user().addHandler(handler);
        } catch (IOException e) {
            getLogger().user().severe(e.getMessage());
        }
  */
	}

    /**
     * Here we can set up our bot - his name and so. Should not be called here.
     *
     * @return
     */
	@Override
	protected Initialize createInitializeCommand() {
        Initialize myInit = new Initialize();

        myInit.setName(myName);
        //myInit.setLocation(myLocation);
        //myInit.setSkin(myName);
		return myInit;
	}

    /**
     * Called after the bot body is initialized in the environment.
     *
     * @param config
     * @param init
     */
	@Override
	protected void botInitialized(ConfigChange config, InitedMessage init) {
        this.getAct().act(new SetWalk(true));

        if (agentLog != null)
            agentLog.setAgentId(init.getId().getId());
	}

    /**
     * Main method for our bot reasoning. Should NOT be called here.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
	@Override
	protected void doLogic() throws PogamutException {
        
	}

    /**
     * Called each time our agent die in the environment. Usefull for restarting
     * state variables.
     *
     * @param event
     */
	@Override
	protected void botKilled(BotKilled event) {
        clearBotVariables();
	}

    /**
     * We will kiss the agent.
     *
     * @param agent
     */
    protected void actionKiss(Player agent) {
        setAction(agent,ActionType.KISS,currentTime,4);
        getAct().act(new Move().setFirstLocation(agent.getLocation()).setFocusLocation(agent.getLocation()).setSecondLocation(agentInfo.getLocation()));
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action KISS").setFadeOut(messageFadeOutConst));
        //notify AEventGenerator        
        myAEGenerator.generateActionKissEvent(agent.getId().getId());        
    }

    /**
     * We will give target item to targetAgent if we have the item. Also we will update
     * internals here. Will give item to agent instanly whereever he is - we have to
     * check if the agents are in appropriate situation elsewhere.
     *
     * @param targetAgent
     * @param item
     */
    protected void actionGiveItem(Player targetAgent, ScenarioItemType item){
        String itemType="";

        if (myItems.containsKey(item) && (myItems.get(item) >= 1)){
            if (item == ScenarioItemType.FLOWER)
                itemType = "xPickups.MiniHealthPack";
            else if (item == ScenarioItemType.CONDOM)
                itemType = "xPickups.AdrenalinePickup";

            if (!itemType.isEmpty()) {
                getAct().act(new Give().setId(targetAgent.getId()).setItemType(itemType));
                getAct().act(new SendMessage().setText("To:" + targetAgent.getName() + " Take this " + item).setFadeOut(messageFadeOutConst));
                getConversationHistory(targetAgent.getId().getId()).updateSentMessages(currentTime);

                //update our item count
                myItems.put(item, myItems.get(item) - 1);

                //update playerHistory
                getPlayerHistory(targetAgent).insertGivenItem(item, currentTime);

                logItemGiven(targetAgent, item, currentTime);
            }
        }
    }

    /**
     * We will have sex with the agent - should be made after SEX proposal was accepted.
     *
     * @param agent
     */
    protected void actionSex(Player agent) {
        setAction(agent,ActionType.SEX,currentTime,10);
        getAct().act(new Move().setFirstLocation(agent.getLocation()).setFocusLocation(agent.getLocation()).setSecondLocation(agentInfo.getLocation()));
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action SEX").setFadeOut(messageFadeOutConst));

        //it is sex by event, but it doesnt matter - the emotions are the same
        myAEGenerator.generateActionSexByEvent(agent.getId().getId());        
    }

    /**
     * We will slap the agent - should be used for humans.
     *
     * @param agent
     */
    protected void actionSlap(Player agent) {
        setAction(agent,ActionType.SLAP,currentTime,4);
        getAct().act(new Move().setFirstLocation(agent.getLocation()).setFocusLocation(agent.getLocation()).setSecondLocation(agentInfo.getLocation()));
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action SLAP").setFadeOut(messageFadeOutConst));
        //todo: notify AEventGenerator?
        //myAEGenerator.generateSlapEvent(agentWith);        
    }

    /**
     * We will cuddle the agent - should be used for animals.
     *
     * @param agent
     */
    protected void actionCuddle(Player agent) {
        setAction(agent,ActionType.CUDDLE,currentTime,4);
        getAct().act(new Move().setFirstLocation(agent.getLocation()).setFocusLocation(agent.getLocation()).setSecondLocation(agentInfo.getLocation()));
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action CUDDLE").setFadeOut(messageFadeOutConst));
        //todo: notify AEventGenerator?
        //myAEGenerator.generateSlapEvent(agentWith);        
    }

    /**
     * We will compliment the agent - should be used for humans.
     *
     * @param agent
     */
    protected void actionCompliment(Player agent) {
        setAction(agent,ActionType.COMPLIMENT,currentTime,3);
        
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action COMPLIMENT. You look great today!").setFadeOut(messageFadeOutConst));
        getConversationHistory(agent.getId().getId()).updateSentMessages(currentTime);
        //todo: notify AEventGenerator?
        //myAEGenerator.generateSlapEvent(agentWith);        
    }

    /**
     * We will insult the agent - should be used for humans.
     *
     * @param agent
     */
    protected void actionInsult(Player agent) {

        setAction(agent,ActionType.INSULT,currentTime,4);

        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action INSULT. You are nothing more than worthless scum!").setFadeOut(messageFadeOutConst));
        getConversationHistory(agent.getId().getId()).updateSentMessages(currentTime);
        //todo: notify AEventGenerator?
        //myAEGenerator.generateSlapEvent(agentWith);        
    }

    /**
     * We will tell bye to the agent, that means we want to end contact with him for
     * now.
     *
     * @param agent
     */
    protected void actionBye(Player agent) {

        setAction(agent,ActionType.BYE,currentTime,4);

        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action BYE. Goodbye for now!").setFadeOut(messageFadeOutConst));
        getConversationHistory(agent.getId().getId()).updateSentMessages(currentTime);

        if ((agentWith != null) && (agent.getId().getId() == agentWith.getId().getId()))
            agentWith = null;
        if (!agentInterrupters.isEmpty())
            removeInterrupter(agent);
        //todo: notify AEventGenerator?
        //myAEGenerator.generateSlapEvent(agentWith);        
    }
    /**
     * We will send bye to all the input agents (should be used just for agent interrupters).
     *
     * @param values
     */
    protected void actionMultipleBye(Collection<Player> values) {
        String prefix = "";

        for (Player agent : values) {
            prefix = "To:" + agent.getName() + ", ";
            getConversationHistory(agent.getId().getId()).updateSentMessages(currentTime);
            //todo: notify AEventGenerator?
            //myAEGenerator.generateSlapEvent(agentWith);
            setAction(agent,ActionType.BYE,currentTime,4);
        }
        removeAllInterrupters();
        getAct().act(new SendMessage().setText(prefix +" Action BYE. Goodbye for now!").setFadeOut(messageFadeOutConst));
    }


    /**
     * We will kick the agent - should be used for animals.
     *
     * @param agent
     */
    protected void actionKick(Player agent) {
        setAction(agent,ActionType.KICK,currentTime,4);
        getAct().act(new Move().setFirstLocation(agent.getLocation()).setFocusLocation(agent.getLocation()).setSecondLocation(agentInfo.getLocation()));
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action KICK").setFadeOut(messageFadeOutConst));
        //todo: notify AEventGenerator?
        //myAEGenerator.generateSlapEvent(agentWith);
    }

    /**
     * We will leave the agent (leave the state AGENT_WITH) - we are probably angry
     * on the agent, so we leave him at last.
     *
     * @param agent
     */
    protected void actionLeave(Player agent) {
        setAction(agent,ActionType.LEAVE,currentTime,4);
        getAct().act(new SendMessage().setText("To:" + agent.getName() +" Action LEAVE. Don't like you anymore. I take my leave on you.").setFadeOut(messageFadeOutConst));
        getConversationHistory(agent.getId().getId()).updateSentMessages(currentTime);

        if ((agentWith != null) && (agentWith.getId().getId() == agent.getId().getId())){
            agentWith = null;
        }

        if (!agentInterrupters.isEmpty())
            removeInterrupter(agent);       
    }

    /**
     * We will make input proposal to target agent.
     *
     * @param agent
     * @param type
     */
    protected void actionMakeProposal(Player agent, ProposalType type) {
        ConversationInfo myInfo = null;
        ProposalInfo newProp = null;

        setAction(agent,ActionType.PROPOSAL,currentTime,2);
        myInfo = getConversationHistory(agent.getId().getId());

        if (type == ProposalType.NONE)
            return;

        if (type == ProposalType.CINEMA)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal cinema. Would you like to go to the cinema?").setFadeOut(messageFadeOutConst));
        else if (type == ProposalType.KISS)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal kiss. Can I kiss you?").setFadeOut(messageFadeOutConst));
        else if (type == ProposalType.SEX)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal sex. Can I sleep with you?").setFadeOut(messageFadeOutConst));
        else if (type == ProposalType.HOME)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal home. Can I accompany you to your way home?").setFadeOut(messageFadeOutConst));
        else if (type == ProposalType.LEAVE)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal leave. Please leave the agent.").setFadeOut(messageFadeOutConst));
        else if (type == ProposalType.PARK)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal park. Will you go for a walk to the park with me?").setFadeOut(messageFadeOutConst));
        else if (type == ProposalType.WAIT)
            getAct().act(new SendMessage().setText("To:" + agent.getName() +" making proposal wait. Can you wait for me a little while please?").setFadeOut(messageFadeOutConst));

        
        newProp = new ProposalInfo(type, agent.getId().getId(), currentTime);
        myInfo.getSentProposals().add(newProp);
        recentProposal = newProp;

        myInfo.updateSentMessages(currentTime);        
        myInfo.setLastProposalTime(currentTime);
        //TODO: notify AEventGen. ?        

        logProposal(agent, newProp);
    }

    /**
     * Does input action towards target agent.
     *
     * @param type
     * @param agent
     */
    public void doAction(ActionType type, Player agent){
        if (type == ActionType.BYE) {
            actionBye(agent);
        } else if (type == ActionType.COMPLIMENT) {
            actionCompliment(agent);
        } else if (type == ActionType.CUDDLE) {
            actionCuddle(agent);
        } else if (type == ActionType.KICK) {
            actionKick(agent);
        } else if (type == ActionType.KISS) {
            actionKiss(agent);
        } else if (type == ActionType.LEAVE) {
            actionLeave(agent);
        } else if (type == ActionType.SLAP) {
            actionSlap(agent);
        } else if (type == ActionType.INSULT) {
            actionInsult(agent);
        } else if (type == ActionType.SEX) {
            actionSex(agent);
        }
    }

    /**
     * Returns true if we are currently at cinema.
     *
     * @return
     */
    public boolean atCinema(){

        if (agentInfo.atLocation(cinemaLocation, 150))
            return true;

        return false;
    }

    /**
     * Returns true if we are currently at park.
     *
     * @return
     */
    public boolean atPark(){

        if (agentInfo.atLocation(parkLocation, 150))
            return true;

        return false;
    }


    /**
     * Returns true if we are currently at home of input agent.
     *
     * @param agent
     * @return
     * @todo unfinished
     */
    public boolean atHome(Player agent){
        if (agent.getName().contains("Anne")) {
            if (agentInfo.atLocation(firstGirlHomeLocation, 150))
                return true;
        } else if (agent.getName().contains("Clementine")) {
            if (agentInfo.atLocation(secondGirlHomeLocation, 150))
                return true;
        } else {
            //deufalting to boyhome as with getHomeLocation function
            if (agentInfo.atLocation(boyHomeLocation, 150))
                return true;
        }

        return false;
    }

    /**
     * Returns true if we are at our home location.
     *
     * @return
     */
    public boolean atMyHome() {
        if (agentInfo.getName().contains("Anne")) {
            if (agentInfo.atLocation(firstGirlHomeLocation, 150))
                return true;
        } else if (agentInfo.getName().contains("Clementine")) {
            if (agentInfo.atLocation(secondGirlHomeLocation, 150))
                return true;
        } else {
            //deufalting to boyhome as with getHomeLocation function
            if (agentInfo.atLocation(boyHomeLocation, 150))
                return true;
        }

        return false;
    }

    /**
     * Parses item type from input string.
     *
     * @param toString input string we want to parse
     * @return item type
     */
    public ScenarioItemType parseItemType(String toString) {
        if (toString.contains("Adrenaline")){
            return ScenarioItemType.CONDOM;
        }
        if (toString.contains("Health")){
            return ScenarioItemType.FLOWER;
        }
        if (toString.contains("Gun")){
            return ScenarioItemType.GUN;
        }

        return ScenarioItemType.OTHER;
    }

    /**
     * Clear path and recent location goals.
     */
    public void clearNavigationVariables() {
        lastFollowPathLocation = null;
        nearestNavLocation = null;
        myLocTarget = null;
        myGoalTarget = null;
        myPath.clear();
        pathRequested = false;
        pathReceived = false;
    }
 

    /**
     * Sets the bot internals according to the intput scenario.
     * 
     * @param type type of the scenario
     * @param agentName desired agents name
     *
     * @return
     */
    public boolean initScenario(ScenarioType type, String agentName){

        scenario = type;
        myName = agentName;

        if (type == ScenarioType.SCENARIO_ONE){
            state = StateType.PREPARE_SCENARIO;
            if (agentName.toLowerCase().equals("anne")){
                initAgentWithName = "Bruno";
                mySkin = "Tamika";
                myClassName = "GBScenario.ExampleGirl";
                startLocation = new Location(971,2012,-4550);
                startRotation = new Rotation(0,32322,0);
            }
            if (agentName.toLowerCase().equals("bruno")){
                initAgentWithName = "Anne";
                myClassName = "GBScenario.ExampleBoy";
                startLocation = new Location(874,2009,-4550);
                startRotation = new Rotation(0,0,0);
            }
            if (agentName.toLowerCase().equals("clementine")){
                initAgentWithName = "Bruno";
                mySkin = "Ophelia";
                myClassName = "GBScenario.ExampleGirl";
                myGoalPlace = PlaceType.MEETING_CINEMA_PLACE;
                startLocation = new Location(-2173,1134,-4556);
                startRotation = new Rotation(0,0,0);
            }
        } 

        return false;
    }

    /**
     * If our interrupter list does not contaion input agent we will check if he
     * passes all conditions to be added to the interrupter agents list and add him
     * eventually.
     *
     * @param agent
     */
    public void insertInterrupter(Player agent) {
        boolean bFound = false;

        for (Player plr : agentInterrupters){
            if (plr.getId() == agent.getId()){
                bFound = true;
                break;
            }
        }

        //we will generate also interrupted emotion event - in beginState for agentInterrupted
        if (!bFound && myEmotionState.getFeeling(agent.getId().getId()) > ignoreFeelingConst) {
            //interrupter must be visible and reasonably close
            if (agent.isVisible() && agentInfo.atLocation(agent.getLocation(),communicationRangeConst)) {
                if (!isHuman(agent.getId().getId())) {
                    //it is a polymorph, or animal - different interrupt delay...
                    if (currentTime - getPlayerHistory(agent).getLastInterruptedTime() > polymorphInterruptedDelayConst)
                        agentInterrupters.add(agent);

                } else if (currentTime - getPlayerHistory(agent).getLastInterruptedTime() > humanInterruptedDelayConst) //for humans
                    agentInterrupters.add(agent);
            }
        }

    }

    /**
     * Completely resets the bot state - called when bot killed. Emotions and feelings
     * remain the same.
     *
     */
    private void clearBotVariables() {
        
        agentWith = null;
        agentInterrupters.clear();
        recentProposal = null;
        recentReceivedProposal = null;
        myPlrTarget = null;
        myGoalPlace = PlaceType.NONE;
        clearNavigationVariables();

        state = StateType.AGENT_ALONE;
    }

    /**
     * This method switches the bot to new state and notifies the bot - calls
     * BeginState and EndState functions.
     *
     * @param newState state we are going to
     */
    protected void goToState(StateType newState){
        previousState = state;
        endState(previousState);
        state = newState;
        beginState(state);
    }

    /**
     * This method is called when some state ends.
     *
     * @param endingState
     */
    protected void endState(StateType endingState){
        //Should not be called here
    }

    

    /**
     * This method is called when we enter a new state.
     *
     * @param newState
     */
    protected void beginState(StateType newState){
        //Should not be called here
    }

    /**
     * Used by obstacle avoidance code.
     *
     * @param x
     * @param distance
     * @return
     */
    private double forceFunction(double x, double distance) {
		double multi = distance / AVOID_OBSTACLE_MIN_DISTANCE;
		if (x < -AVOID_OBSTACLE_FUNCTION || x > AVOID_OBSTACLE_FUNCTION) return 0;
		if (x < 0) return (-AVOID_OBSTACLE_FUNCTION - x) * multi;
		return (AVOID_OBSTACLE_FUNCTION - x) * multi;
	}

    /**
	 * This will compute new Location to avoid hitting other players.
	 * @param moveLocation
	 * @return
	 */
	private Location[] adjustLocations(Location[] moveLocation) {
		Player player = players.getNearestPlayer(players.getVisiblePlayers().values());
		if (player == null) return moveLocation;
		if (player.getLocation().getPoint3d().distance(agentInfo.getLocation().getPoint3d()) > AVOID_OBSTACLE_MIN_DISTANCE) {
			return moveLocation;
		}
		if (moveLocation[0] == null) return moveLocation;
		Location[] result = new Location[2];

		Location location = agentInfo.getLocation();
		Velocity velocity = new Velocity(moveLocation[0].x - location.x, moveLocation[0].y - location.y, moveLocation[0].z - location.z);
		Vector3d runningVector = velocity.getVector3d();
		runningVector.normalize();
		Point2D force = Algeb.rotate(Algeb.projection(runningVector), Algeb.rad(90));

		Point2D[] forces = new Point2D[2];
		forces[0] = Algeb.multi(Algeb.projection(runningVector), AVOID_OBSTACLE_RUN_VECTOR_LENGTH);
		double distance = Algeb.distanceFromRunningVector(location, velocity, player.getLocation());
		double multi = forceFunction(distance, location.getPoint3d().distance(player.getLocation().getPoint3d()));
		forces[1] = Algeb.multi(force, multi * AVOID_OBSTACLE_FUNCTION_MULTI);

		Point2D sum = Algeb.vectorSum(forces);

		result[0] = new Location(location.getX() + sum.getX(), location.getY() + sum.getY(), location.getZ());
		forces[0] = Algeb.multi(Algeb.projection(runningVector), AVOID_OBSTACLE_RUN_VECTOR_LENGTH*2);
		sum = Algeb.vectorSum(forces);
		result[1] = new Location(location.getX() + sum.getX(), location.getY() + sum.getY(), location.getZ());

		return result;
	}

    /**
     * Goes to target location. Keeps returning true while we are on our way there.
     * If we are at location or some problem encountered, then returns false.
     *
     * @param targetLocation
     * @return
     */
    public boolean goToLocation(Location targetLocation) {

        Location temp = null;

        if (agentInfo.atLocation(targetLocation, 100)){
            //restarting
            nearestNavLocation = null;
            lastFollowPathLocation = null;
            myPath.clear();
            pathReceived = false;
            pathRequested = false;
            return false;
        }

        if (myPath.isEmpty() && !pathRequested){
            nearestNavLocation = getNearestNavLocation(targetLocation);
            lastFollowPathLocation = agentInfo.getLocation();
            try {
                myPathPlanner.addPathListener(myPathListener);
                pathRequestedTime = currentTime;
                myPathPlanner.computePath(agentInfo.getLocation(), nearestNavLocation);                
                pathRequested = true;
                return true;
            } catch (PathNotConstructable ex) {
                Logger.getLogger(EmotionalBot.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }

        //check if we should re-request the path
        if (pathRequested) {
            temp = getNearestNavLocation(targetLocation);
            if ((temp.getDistance(nearestNavLocation) > 80) || (agentInfo.getLocation().getDistance(lastFollowPathLocation) > 250)) {
                //re-request path
                nearestNavLocation = temp;
                lastFollowPathLocation = agentInfo.getLocation();
                myPath.clear();
                pathReceived = false;
                try {
                    pathRequestedTime = currentTime;
                    myPathPlanner.computePath(agentInfo.getLocation(), nearestNavLocation);
                } catch (PathNotConstructable ex) {
                    Logger.getLogger(EmotionalBot.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        }

        //waiting for the path - look how long are we waiting - maybe should re-request
        if (pathRequested && !pathReceived){
            if (currentTime - pathRequestedTime > pathRerequestDelay){
                nearestNavLocation = getNearestNavLocation(targetLocation);
                lastFollowPathLocation = agentInfo.getLocation();
                try {
                    pathRequestedTime = currentTime;
                    myPathPlanner.computePath(agentInfo.getLocation(), nearestNavLocation);
                    pathRequested = true;
                    return true;
                } catch (PathNotConstructable ex) {
                    Logger.getLogger(EmotionalBot.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            } else
                return true;
        }

        //if we are so close we get 0 path, we will add our target location to the path
        if (myPath.isEmpty() && pathReceived){
            myPath.add(targetLocation);
        }

        //throw out points we've been to
        if (myPath.get(0).getLocation().getDistance(agentInfo.getLocation()) < 45 ){
            myPath.remove(0);
        }

        Iterator<ILocated> it = myPath.iterator();
        if (it.hasNext()){
            Location l1 = it.next().getLocation();
            Location[] moveLocation;
            lastFollowPathLocation = agentInfo.getLocation();
            if(it.hasNext()) {
                // there are at least two points in the path
                Location l2 = it.next().getLocation();
                moveLocation = adjustLocations(new Location[]{l1 , l2});
                getAct().act(new Move().setFirstLocation(moveLocation[0]).setSecondLocation(moveLocation[1]));                
                return true;
            } else {
                // there is only one point to go to
                moveLocation = adjustLocations(new Location[]{l1});
                getAct().act(new Move().setFirstLocation(moveLocation[0]));
                return true;
            }
        }

        return false;
    }

    /**
     * Choose the player (human) with the biggest feeling toward. Should incorporate gender
     * information? (TODO).
     *
     * @param values
     * @return
     * @todo
     */
    public Player pickHighestFeelingPlayer(Collection<Player> values) {

        Player myResult = null;
        double tmp, myResultFeeling = 0;

        for (Player plr : values){
            if ((myResult == null) && (isOppositeSex(plr))) {
                myResultFeeling = myEmotionState.getFeeling(plr.getId().getId());
                myResult = plr;
            }else {
                tmp = myEmotionState.getFeeling(plr.getId().getId());
                if ((tmp > myResultFeeling) && (isOppositeSex(plr))){
                    myResult = plr;
                    myResultFeeling = tmp;
                }
            }
        }

        return myResult;
    }
    /**
     * Picks random location where we will head to.
     *
     * @return
     */
    protected Location pickNewLocTarget() {
        Random rand = new Random();
        int i,counter;

        counter = rand.nextInt(randomLocationTargets.size());

        i = 0;
        for (Location loc : randomLocationTargets){
            if (i == counter){
                return loc;
            }
            i++;
        }

        return null;             
    }

    /**
     * Rendomly picks some navigation point to head to.
     * 
     * @return
     */
    protected NavPoint pickNewNavTarget() {
        Random rand = new Random();
        int i,counter;

        counter = rand.nextInt(knownNavPoints.values().size());

        i = 0;
        for (NavPoint nav : knownNavPoints.values()){
            if (i == counter){
                return nav;
            }
            i++;
        }

        return null;
    }

    /**
     * Returns the player we should focus on now. Takes into account recent action,
     * anger emotion and feeling. Does NOT take into account gender and wheter it is
     * an animal.
     *
     * @param values input collection of players
     * @return player with highest sum of emotion anger * 2, feeling and actionBonus
     */
    public Player pickFocus(Collection<Player> values) {
        
        Player result = null;
        double resultAnger = 0, resultFeeling = 0, resultActionBonus = 0, resultConvBonus = 0;
        double newAnger = 0, newFeeling = 0, newActionBonus = 0, newConvBonus = 0;

        PlayerInfo myPlrInfo = null;
        ConversationInfo myConvInfo = null;

        for (Player plr : values) {
            if (plr != null) {//may happen when someone leaves us

                myPlrInfo = getPlayerHistory(plr);
                myConvInfo = getConversationHistory(plr.getId().getId());
                if (result == null) {
                    result = plr;
                    resultAnger = 2 * myEmotionState.getAlmaEmotionIntensity(plr.getId().getId(), EmotionType.Anger);
                    resultFeeling = myEmotionState.getFeeling(plr.getId().getId());

                    if ((currentTime - myPlrInfo.getLastActionByTime() < recentActionTimeConst ) && (myPlrInfo.getLastActionByTime() > myPlrInfo.getLastActionTime()))
                        resultActionBonus = 3;
                    else
                        resultActionBonus = 0;

                    if (myConvInfo.getLastReceivedMessageTime() > myConvInfo.getLastMessageTime())
                        resultConvBonus = 3;
                    else
                        resultConvBonus = 0;

                } else {
                    newAnger = 2 * myEmotionState.getAlmaEmotionIntensity(plr.getId().getId(), EmotionType.Anger);
                    newFeeling = myEmotionState.getFeeling(plr.getId().getId());

                    if ((currentTime - myPlrInfo.getLastActionByTime() < recentActionTimeConst ) && (myPlrInfo.getLastActionByTime() > myPlrInfo.getLastActionTime()))
                        newActionBonus = 3;
                    else
                        newActionBonus = 0;

                    if (myConvInfo.getLastReceivedMessageTime() > myConvInfo.getLastMessageTime())
                        newConvBonus = 3;
                    else
                        newConvBonus = 0;

                    if ( (newAnger + newFeeling + newActionBonus + newConvBonus) > (resultAnger + resultFeeling + resultActionBonus + resultConvBonus) ){
                        result = plr;
                        resultAnger = newAnger;
                        resultFeeling = newFeeling;
                        resultActionBonus = newActionBonus;
                        resultConvBonus = newConvBonus;
                    }
                }
            }
        }

        return result;
    }

    /**
     * Picks some action toward the agent based on the feeligns toward the agent,
     * current agent situation (atCinema, atHome), our agent current state (INTERRUPT..)
     * and last action that the agent did to us.
     *
     * @param agent target agent
     * @return the action we want to make
     */
    protected ActionType pickAction(Player agent){

        PlayerInfo myPlrInfo = getPlayerHistory(agent);

        //first we will look if we shouldn't respond to bye/leave action
        if (((myPlrInfo.getLastActionByType() == ActionType.BYE) || (myPlrInfo.getLastActionByType() == ActionType.LEAVE)) &&
                (currentTime - myPlrInfo.getLastActionByTime() < recentActionTimeConst )){

            if ( ((myPlrInfo.getLastActionType() != ActionType.BYE) && (myPlrInfo.getLastActionType() != ActionType.LEAVE))
                    || (myPlrInfo.getLastActionByTime() > myPlrInfo.getLastActionTime())) {
                //if our last action wasnt bye or leave, or he did it recently

                if (myEmotionState.getFeeling(agent.getId().getId()) < leaveFeelingConst)
                    return ActionType.LEAVE;
                else
                    return ActionType.BYE;
            }
        }

        if (myEmotionState.getFeeling(agent.getId().getId()) < leaveFeelingConst ) {
            actionLeave(agent);
        }

        //look if we should make a response some action
        if ((currentTime - myPlrInfo.getLastActionByTime() > minimalActionResponseDelayConst) && (myPlrInfo.getLastActionByTime() > myPlrInfo.getLastActionTime())){

            if ((myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Anger) > slapAngerConst) &&  ( isMale(agent)|| !isOppositeSex(agent)) && (myPlrInfo.getLastActionByType() == ActionType.SLAP)){
                //the agent is male or same sex
                return ActionType.SLAP;
            } else if ((myPlrInfo.getLastActionByType() == ActionType.SLAP) && (myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Anger) > insultAngerConst) ){
                return ActionType.INSULT;
            }

        }

        if (currentTime - myPlrInfo.getLastActionTime() > minimalActionDelayConst) {

            if (agent.getName().toLowerCase().contains("emohawk")){
                //it is emohawk
                if (myEmotionState.getFeeling(agent.getId().getId()) > cuddleFeelingConst ){
                    return ActionType.CUDDLE;
                }

                if (myEmotionState.getFeeling(agent.getId().getId()) < kickEmoFeelingConst ){
                    return ActionType.KICK;
                }
            } else {
                //it is human - boy or girl
                if (isOppositeSex(agent)){
                    if ((myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Joy) > complimentJoyConst) && (myEmotionState.getFeeling(agent.getId().getId()) > complimentFeelingConst )){
                        return ActionType.COMPLIMENT;
                    }
                    if (isMale(agent) && (myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Anger) > slapAngerConst) && (myEmotionState.getFeeling(agent.getId().getId()) < slapFeelingConst )){
                        return ActionType.SLAP;
                    }
                    if ((myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Anger) > insultAngerConst) && (myEmotionState.getFeeling(agent.getId().getId()) < insultFeelingConst )){
                        return ActionType.INSULT;
                    }
                } else {
                    if ((myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Anger) > slapAngerConst) && (myEmotionState.getFeeling(agent.getId().getId()) < slapFeelingConst )){
                        return ActionType.SLAP;
                    }
                    if ((myEmotionState.getAlmaEmotionIntensity(agent.getId().getId(), EmotionType.Anger) > insultAngerConst) && (myEmotionState.getFeeling(agent.getId().getId()) < insultFeelingConst )){
                        return ActionType.INSULT;
                    }
                }
            }

        }

        //default action is no action
        return ActionType.NONE;
    }

    /**
     * This initial state will set up scenario for us.
     */
    protected void statePrepareScenario() {

        getAct().act(new GetPlayers());

        //set up agent with
        if (!initAgentWithName.isEmpty() && (agentWith == null)){
            for (Player plr : players.getPlayers().values()){
                if (plr.getName().toLowerCase().equals(initAgentWithName.toLowerCase())){
                    agentWith = plr;
                    break;
                }
            }
        }

        if (initAgentWithName.isEmpty() || (!initAgentWithName.isEmpty() && (agentWith != null))){

            if (scenario == ScenarioType.SCENARIO_ONE){
                if (getMyName().toLowerCase().equals("anne") || getMyName().toLowerCase().equals("bruno")){
                    //they are walking from the cinema
                    getPlayerHistory(agentWith).setLastAtCinemaTime(currentTime);
                    getConversationHistory(agentWith.getId().getId()).setLastReceivedMessageTime(currentTime);

                    //init stored emotion liking for the agents
                    HashMap<EmotionType, AEmotion> tmpMap = new HashMap<EmotionType, AEmotion>();

                    int i = agentWith.getId().getId();

                    tmpMap.put(EmotionType.Love, new AEmotion(EmotionType.Love,0,"Id:"+i,i));
                    tmpMap.put(EmotionType.Hate, new AEmotion(EmotionType.Hate,0,"Id:"+i,i));
                    tmpMap.put(EmotionType.Disliking, new AEmotion(EmotionType.Disliking,0,"Id:"+i,i));
                    tmpMap.put(EmotionType.Liking, new AEmotion(EmotionType.Liking,0.9,"Id:"+i,i));

                    myEmotionState.feelingsHistory.put(i, tmpMap);

                    goToState(StateType.AGENT_WITH);
                    return;
                } else if (getMyName().toLowerCase().equals("clementine")){
                    //init stored emotion liking for the agents
                    HashMap<EmotionType, AEmotion> tmpMap = new HashMap<EmotionType, AEmotion>();
                    
                    int i = agentWith.getId().getId();

                    tmpMap.put(EmotionType.Love, new AEmotion(EmotionType.Love,0,"Id:"+i,i));
                    tmpMap.put(EmotionType.Hate, new AEmotion(EmotionType.Hate,0,"Id:"+i,i));
                    tmpMap.put(EmotionType.Disliking, new AEmotion(EmotionType.Disliking,0,"Id:"+i,i));
                    tmpMap.put(EmotionType.Liking, new AEmotion(EmotionType.Liking,0.9,"Id:"+i,i));

                    myEmotionState.feelingsHistory.put(i, tmpMap);
                    
                    goToState(StateType.AGENT_ALONE);
                    myGoalPlace = PlaceType.MEETING_CINEMA_PLACE;
                    timerSet(TimerType.WAIT_AT_HOME, 45);
                    return;
                }
            }          
        }
    }

    /**
     * Sets the action as current action and updates agent internals and player history.
     *
     * @param agent
     * @param type
     * @param time
     * @param duration
     */
    protected void setAction(Player agent, ActionType type, double time, double duration) {
        //stores to agent internals
        this.lastActionType = type;
        this.lastActionDuration = duration;
        this.lastActionTime = time;

        //update player history
        if (agent != null) {
            getPlayerHistory(agent).updateAction(type, time, true);
            logAction(agent, type, time, duration);
        }         
    }

    /**
     * Process the bots current emotions and sets the emotion emitter accordingly.
     *
     */
    public void showEmotions() {
        SetEmotionalEmitter newEmit = new SetEmotionalEmitter();
        AEmotion dominant = null;
        Vector3d color =  new Vector3d();
        Point3d direction =  new Point3d();
        Velocity directVel = null;
        Vector3d size = new Vector3d();

        dominant = myEmotionState.getCurrentDominantEmotion();

        //we need to set this, because for some reason, if we won't set this, the pogamut
        //will send LifeTime 0 effectively disabling our emitter...
        newEmit.setLifeTime(1.6).setVelocityRange(0).setStartVelocity(new Velocity(2,2,2)).setEndVelocity(new Velocity(-4,-4,-4));

        if (dominant == null){
            color.setX(255);
            color.setY(255);
            color.setZ(255);
            //if no emotion - we will disable emitter
            getAct().act(newEmit.setVelocityRange(0).setFirstC(color).setSecondC(color).setSize(new Vector3d(1,1,2)));
            return;
        }

        //set color
        if (dominant.getType() == EmotionType.Anger) {
            //bright red
            color.setX(237);
            color.setY(0);
            color.setZ(20);
        } else if (dominant.getType() == EmotionType.Fear) {
            //dark green
            color.setX(0);
            color.setY(123);
            color.setZ(51);
        } else if (dominant.getType() == EmotionType.Joy) {
            //yellow
            color.setX(237);
            color.setY(237);
            color.setZ(0);
        } else if (dominant.getType() == EmotionType.Distress) {
            //sharp blue
            color.setX(9);
            color.setY(9);
            color.setZ(255);
        } else if (dominant.getType() == EmotionType.Love) {
            //somewhat pink
            color.setX(255);
            color.setY(70);
            color.setZ(164);
        } else if (dominant.getType() == EmotionType.Hate) {
            //black
            color.setX(2);
            color.setY(3);
            color.setZ(2);
        } else if (dominant.getType() == EmotionType.Liking) {
            //viloet
            color.setX(184);
            color.setY(91);
            color.setZ(242);
        } else if (dominant.getType() == EmotionType.Disliking) {
            //brown
            color.setX(80);
            color.setY(58);
            color.setZ(27);
        } else {
            //white default
            color.setX(255);
            color.setY(255);
            color.setZ(255);
           // getLogger().user().warning("name: " + myName + "type: " + dominant.getType());
        }

        newEmit.setFirstC(color).setSecondC(color);
        //set size
        if (dominant.getIntensity() > 0.1){
            size.setX(dominant.getIntensity() * 10);
            size.setY(dominant.getIntensity() * 10);
            size.setZ(dominant.getIntensity() * 20);
            //newEmit.setLifeTime(0.5);            
        } else {
            size.setX(1);
            size.setY(1);
            size.setZ(2);
            //newEmit.setLifeTime(1);
        } 
        newEmit.setSize(size);

        //set direction of the movement
        for (Player plr : players.getVisiblePlayers().values()) {
            if (plr.getId().getId() == dominant.getElicitorId()){
                direction.sub(agentInfo.getLocation().getPoint3d(),plr.getLocation().getPoint3d());

                directVel = new Velocity();
                directVel.x = direction.getX();
                directVel.y = direction.getY();
                directVel.z = direction.getZ();
                directVel = directVel.normalize();

                directVel = directVel.scale(2);
                newEmit.setStartVelocity(directVel);
                directVel = directVel.scale(-2);
                newEmit.setEndVelocity(directVel);
            }
        }

        if (directVel != null) {

        }

        //send command
        getAct().act(newEmit);
    }
    
    /**
     * Method called when the agent will be shutdown - 
     * 
     */
    public void shutdown() {
        myALMA.fAM.stopAll();
        if (agentLog != null){
            agentLog.finish();
        }
       // this.stop();
    }

    /**
     * Parse proposal type from text.
     *
     * @param text
     * @return
     */
    public ProposalType parseProposalType(String text) {

        ProposalType result = ProposalType.NONE;

        if (text.toLowerCase().contains("cinema"))
            result = ProposalType.CINEMA;
        else if (text.toLowerCase().contains("home"))
            result = ProposalType.HOME;
        else if (text.toLowerCase().contains("kiss"))
            result = ProposalType.KISS;
        else if (text.toLowerCase().contains("leave"))
            result = ProposalType.LEAVE;
        else if (text.toLowerCase().contains("sex"))
            result = ProposalType.SEX;
        else if (text.toLowerCase().contains("park"))
            result = ProposalType.PARK;
        else if (text.toLowerCase().contains("wait"))
            result = ProposalType.WAIT;

        return result;
    }

    /**
     * Returns home location for input agent, if don't know, boy home location will
     * be used.
     *
     * @param agent
     * @return
     */
    public Location getAgentHomeLocation(Player agent) {
        if (agent.getName().contains("Anne")) {
            return firstGirlHomeLocation;
        } else if (agent.getName().contains("Clementine")) {
            return secondGirlHomeLocation;
        }
        return boyHomeLocation;
    }

    /**
     * Returns home place for input agent. If we don't know boy home place will be
     * used.
     *
     * @param agent
     * @return
     */
    public PlaceType getAgentHomePlace(Player agent) {
        if (agent.getName().contains("Anne")) {
            return PlaceType.GIRL1_HOME;
        } else if (agent.getName().contains("Clementine")) {
            return PlaceType.GIRL2_HOME;
        }
        return PlaceType.BOY_HOME;
    }

    /**
     * Getter for playersHistory.
     *
     * @return players history
     */
    public HashMap<Integer, PlayerInfo> getPlayersHistory() {
        return playersHistory;
    }

    /**
     * Returns PlayerInfo from playersHistory. If info does not exist, will be created.
     *
     * @param pl
     * @return
     */
    public PlayerInfo getPlayerHistory(Player pl) {
        if (!playersHistory.containsKey(pl.getId().getId()))
            playersHistory.put(pl.getId().getId(), new PlayerInfo(pl.getId().getId(),pl.getName(),pl.getLocation(),pl.getRotation(),pl.getLastSeenTime()));

        return playersHistory.get(pl.getId().getId());
    }

    /**
     * Returns PolymorphInfo for input id. If does not exists, it will be created.
     *
     * @param id id of the polymorph
     * @return
     */
    public PolymorphEventInfo getPolymorphHistory(int id){

        if (!polymorphHistory.containsKey(id)){
            polymorphHistory.put(id, new PolymorphEventInfo(id));
        }

        return polymorphHistory.get(id);
    }

    /**
     * Returns location of our home.
     *
     * @return
     */
    public Location getMyHomeLocation() {
        if (agentInfo.getName().contains("Anne")) {
            return firstGirlHomeLocation;
        } else if (agentInfo.getName().contains("Clementine")) {
            return secondGirlHomeLocation;
        }
        return boyHomeLocation;
    }

    /**
     * Returns actual location that we should head to if we want to reach input
     * goal place!
     * If we doesn't know the place we will go randomly somewhere
     *
     * @param goalPlace
     * @return
     */
    public Location getDestinationLocation(PlaceType goalPlace){

        if (goalPlace == PlaceType.MY_HOME)
            return getMyHomeLocation();
        else if (goalPlace == PlaceType.CINEMA)
            return cinemaLocation;
        else if (goalPlace == PlaceType.BOY_HOME)
            return boyHomeLocation;
        else if (goalPlace == PlaceType.GIRL1_HOME)
            return firstGirlHomeLocation;
        else if (goalPlace == PlaceType.GIRL2_HOME)
            return secondGirlHomeLocation;
        else if (goalPlace == PlaceType.PARK)
            return parkLocation;
        else if (goalPlace == PlaceType.MEETING_CINEMA_PLACE)
            return meetingCinemaLocation;
        else // goes somewhere randomly. :-)
            return pickNewNavTarget().getLocation();

    }


    /**
     * Returns current agent state.
     * 
     * @return current agent state
     */
    public StateType getState() {
        return state;
    }
    /**
     * Returns agents previous state.
     *
     * @return agents previous state
     */
    public StateType getPreviousState() {
        return previousState;
    }

    /**
     * Returns agent name.
     *
     * @return
     */
    public String getMyName() {
        return myName;
    }

    /**
     * Parses agent elicitor name.
     *
     * @param el input string (el for elicitor)
     * @return
     */
    public String getName(String el) {
        int id;

        id = myEmotionState.parseId(el);
        if (id != -1){
            if (playersHistory.containsKey(id))
                return playersHistory.get(id).getName();
        }
        return "";
    }

    /**
     * Called every do doLogic method (in listener to BEG message). Updates our timers
     * (removes finished timers) and call timerFinished method if necessary.
     *
     */
    public void timerProcess(){
        
        TimerType timerType;

        Iterator<TimerType> iterator = timersTriggerTime.keySet().iterator();

        while (iterator.hasNext()) {
            timerType = iterator.next();
            if (timersDelayTime.containsKey(timerType)){
                if ((currentTime - timersTriggerTime.get(timerType)) > timersDelayTime.get(timerType)){
                    timerFinished(timerType);
                    timersDelayTime.remove(timerType);
                    iterator.remove();
                }
            } else {
                timerFinished(timerType);
                iterator.remove();
            }
        }

    }

    /**
     * Gets trigger time of input timer, if none returs -1.
     *
     * @param timer
     * @return
     */
    public double timerGetTriggerTime(TimerType timer){
        if (timersTriggerTime.containsKey(timer)){
            return timersTriggerTime.get(timer);
        } else
            return -1;
    }

    /**
     * Sets the timer in our timer pool, timer starts running. If the timer of that
     * type is already there, it will be reset.
     *
     * @param timer
     * @param timerDelay
     */
    public void timerSet(TimerType timer, double timerDelay){
        timersTriggerTime.put(timer, currentTime);
        timersDelayTime.put(timer, timerDelay);
    }

    /**
     * Returns true if the timer is active and running.
     *
     * @param timer
     * @return
     */
    public boolean timerIsRunning(TimerType timer){

        if (timersTriggerTime.containsKey(timer)){
            if (timersDelayTime.containsKey(timer)){
                if ( (currentTime - timersTriggerTime.get(timer)) < timersDelayTime.get(timer) ){
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * Immediately removes target timer from timers pool. No timerFinished method will
     * be called.
     *
     * @param timer
     */
    public void timerErase(TimerType timer){
        if (timersTriggerTime.containsKey(timer))
            timersTriggerTime.remove(timer);

        if (timersDelayTime.containsKey(timer))
            timersDelayTime.remove(timer);
    }


    /**
     * Returns all currently running timers.
     *
     * @return
     */
    public ArrayList<TimerType> timersGetRunning(){

        ArrayList<TimerType> result = new ArrayList<TimerType>();

        result.addAll(timersTriggerTime.keySet());

        return result;
    }

    /**
     * Called anytime some timer is finished - it is not 100% accurate. Timers are
     * checked everytime doLogic method is executed, which is 4 - 5 times per second.
     *
     * @param timer
     */
    public void timerFinished(TimerType timer){
    
    }
    
    /**
     * Returns conversation history between me and target agent (logs messages sent
     * by the agent to us). Create new if none found.
     * 
     * @param id
     * @return
     */
    public ConversationInfo getConversationHistory(int id) {
        if (!myConversationHistory.containsKey(id))
            myConversationHistory.put(id, new ConversationInfo(id));
        
        return myConversationHistory.get(id);
    }

    /**
     * Returns conversation history for other agent (messages that were sent to him
     * by other agents than we are).
     * 
     * @param id
     * @return
     */
    public ConversationInfo getOtherConversationHistory(int id) {
        if (!otherConversationHistory.containsKey(id))
            otherConversationHistory.put(id, new ConversationInfo(id));

        return otherConversationHistory.get(id);
    }

    /**
     * Basic conversation method.
     * 
     * @param plr
     * @param type
     */
    protected void conversate(Player plr, ConversationType type) {
        ConversationInfo myInfo = null;
        String message;
        double randConst = (new Random().nextDouble() * 2) - 1;

        myInfo = getConversationHistory(plr.getId().getId());

        if (!isHuman(plr)){
            //polymorph
            if ((currentTime - myInfo.getLastMessageTime()) > messageSendDelayConst + randConst){
                //get feelings toward the agent
                message = "To:" + plr.getName() + " " + type + " Ahhh. Little polymorph... " + myEmotionState.getSmiliesString(plr);
                getAct().act(new SendMessage().setText(message).setFadeOut(messageFadeOutConst));
                myInfo.updateSentMessages(currentTime);
            }
            setAction(plr,ActionType.TALK,currentTime,1.5);
            return;
        }

        //Here we should conversate according to our state
        //normal conversation
        if (type == ConversationType.MOVIE){
            if ((myInfo.getLastReceivedMessageTime() > myInfo.getLastMessageTime()) && (currentTime - myInfo.getLastReceivedMessageTime()) > messageResponseDelayConst + randConst) {
                //TODO: process the last received message text
                //Here will be responses to all other agent actions and everything
                getAct().act(new SendMessage().setText("To:" + plr.getName() + " " + type + " Shhh! Watching film.").setFadeOut(messageFadeOutConst));
                myInfo.updateSentMessages(currentTime);
                setAction(plr,ActionType.TALK,currentTime,1.5);
            }
        } else {
            if ( (myInfo.getLastGreetingTime() == 0) || ((currentTime - myInfo.getLastMessageTime() > 90) && (myInfo.getLastMessageTime() > myInfo.getLastGreetingTime())) ){
                //greeting handled here
                getAct().act(new SendMessage().setText("To:" + plr.getName() + " " + type + " Hi " + plr.getName()).setFadeOut(messageFadeOutConst));
                myInfo.setLastGreetingTime(currentTime);
                myInfo.updateSentMessages(currentTime);
                setAction(plr,ActionType.TALK,currentTime,1.5);
            } else if ((myInfo.getLastReceivedMessageTime() > myInfo.getLastMessageTime()) && (currentTime - myInfo.getLastReceivedMessageTime()) > messageResponseDelayConst  + randConst ) {
                //TODO: process the last received message text
                //Here will be responses to all other agent actions and everything
                getAct().act(new SendMessage().setText("To:" + plr.getName() + " " + type + " Response! " + myEmotionState.getSmiliesString(plr)).setFadeOut(messageFadeOutConst));
                myInfo.updateSentMessages(currentTime);
                setAction(plr,ActionType.TALK,currentTime,1.5);
            } else if ((currentTime - myInfo.getLastMessageTime()) > messageSendDelayConst + randConst){
                //get feelings toward the agent
                message = "To:" + plr.getName() + " " + type + " Bla bla bla... " + myEmotionState.getSmiliesString(plr);
                getAct().act(new SendMessage().setText(message).setFadeOut(messageFadeOutConst));
                myInfo.updateSentMessages(currentTime);
                setAction(plr,ActionType.TALK,currentTime,1.5);
            }
        }
    }

    /**
     * Here we check emotions and feelings towards agent. Return true if we want to
     * accept input proposal from the agent.
     *
     * @param plrId agent that is proposing
     * @param type type of the proposal
     * @return true if we want the proposal
     */
    protected boolean checkEmotionsIfWantProposal(int plrId, ProposalType type){

        if (type == ProposalType.SEX) {
            if ( (isOppositeSex(plrId)) && (myEmotionState.getFeeling(plrId) > sexFeelingConst) ){
                return true;
            }
        } else if (type == ProposalType.KISS) {
            if ( (isOppositeSex(plrId)) && (myEmotionState.getFeeling(plrId) > kissFeelingConst) ){
                return true;
            }
        } else if (type == ProposalType.HOME) { //cinema and home
            if ( myEmotionState.getFeeling(plrId) > homeFeelingConst ){
                return true;
            }
        } else if (type == ProposalType.CINEMA) {
            if ( myEmotionState.getFeeling(plrId) > cinemaFeelingConst ){
                return true;
            }
        } else if (type == ProposalType.PARK) {
            if ( myEmotionState.getFeeling(plrId) > parkFeelingConst ){
                return true;
            }
        } else if (type == ProposalType.WAIT) {
            if ( myEmotionState.getFeeling(plrId) > waitFeelingConst ){
                return true;
            }
        } else if (type == ProposalType.LEAVE) {
            if ((agentWith != null) && (agentWith.getId().getId() == plrId)) {
                //proposal is to leave interrupters probably
                if (agentInterrupters.isEmpty())
                    return true;

                if (!agentInterrupters.isEmpty()){
                    int intId = pickHighestFeelingPlayer(agentInterrupters).getId().getId();

                    if ((myEmotionState.getFeeling(intId) > cuddleFeelingConst ) && (getPlayerHistory(pickHighestFeelingPlayer(agentInterrupters)).getTimeTogetherCounter() > cuddleTimeConst)){
                        return true;
                    }
                    if ((myEmotionState.getFeeling(intId) > argumentLeaveFeelingThresholdConst ) && (myEmotionState.getFeeling(intId) < cuddleFeelingConst ) ){
                        return true;
                    }
                }
            } else if ((agentWith != null) && (agentWith.getId().getId() != plrId)) {
                //proposal is to leave agentWith!
                if (myEmotionState.getFeeling(plrId) > (myEmotionState.getFeeling(agentWith.getId().getId()) + stayWithAgentBonusFeelingConst) ){
                    return true;
                }
            }

            if ( myEmotionState.getFeeling(plrId) > loveFeelingConst ){
                return true;
            }
        }

        return false;
    }
    
    /**
     * Here we will check the status of our proposals and set the internal variables
     * and state according to it or even perform actions.
     *
     * @return if the proposal triggered something, we will return true
     */
    protected boolean processMyProposal(){
        if (agentWith == null){
            //we have left our agentWith or vice versa - erasing proposal, cause we
            //propose just to agent with
            recentProposal = null;
            return false;
        } else if ((recentProposal != null) && (agentWith.getId().getId() != recentProposal.getTarget())) {
            //ids of agentWith and proposal not match - erasing proposal
            recentProposal = null;
            return false;
        }
        
        //check if our proposal was accepted by agentWith
        if ( (recentProposal != null) && recentProposal.isProposalAccepted() && (recentProposal.getTarget() == agentWith.getId().getId()) ){
            if (recentProposal.getType() == ProposalType.KISS){
                recentProposal = null;
                actionKiss(agentWith);
                return true;
            } else if (recentProposal.getType() == ProposalType.SEX) {
                recentProposal = null;
                actionSex(agentWith);
                return true;
            } else if (recentProposal.getType() == ProposalType.HOME){
                recentProposal = null;
                myGoalPlace = getAgentHomePlace(agentWith);
                goToState(StateType.GOING_SOMEWHERE_WITH);
                return true;
            } else if (recentProposal.getType() == ProposalType.CINEMA){
                recentProposal = null;
                myGoalPlace = PlaceType.CINEMA;
                goToState(StateType.GOING_SOMEWHERE_WITH);
                return true;
            } else if (recentProposal.getType() == ProposalType.PARK){
                recentProposal = null;
                myGoalPlace = PlaceType.PARK;
                goToState(StateType.GOING_SOMEWHERE_WITH);
                return true;
            }
        }

        if ((recentProposal != null) && (recentProposal.isProposalRejected() || recentProposal.isProposalIgnored()) ){
            recentProposal = null;
            return false;
        }

        return false;
    }

    /**
     * Responds to proposal we've received from other agent and change our internal
     * state accordingly!
     *
     * @todo unfinished...
     * 
     * @return true if we have responded to proposal
     */
    protected boolean respondToProposal() {

        if (recentReceivedProposal == null)
            return false;

        if (currentTime - recentReceivedProposal.getTime() > proposalIgnoreTimeConst){
            //we have waited with the answer too long, erasing!
            recentReceivedProposal = null;
            return false;
        }

        ProposalType propType = recentReceivedProposal.getType();
        int agentId = recentReceivedProposal.getTarget();

        if (propType == ProposalType.SEX){
            if ((agentWith != null) && (agentWith.getId().getId() == agentId) && (atHome(agentWith) || atMyHome()) && (checkEmotionsIfWantProposal(agentId,ProposalType.SEX))) {
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal sex accepted").setFadeOut(messageFadeOutConst));
                setAction(agentWith,ActionType.SEX,currentTime,10);
                recentReceivedProposal = null;
                return true;
            } else {
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal sex rejected").setFadeOut(messageFadeOutConst));
                recentReceivedProposal = null;
                return true;
            }
        } else if (propType == ProposalType.KISS){
            if (checkEmotionsIfWantProposal(agentId,ProposalType.KISS)){
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal kiss accepted").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            } else {
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal kiss rejected").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            }
        } else if (propType == ProposalType.HOME){
            if ((agentWith != null) && (agentWith.getId().getId() == agentId) && (!atHome(agentWith))) {
                if (checkEmotionsIfWantProposal(agentId,ProposalType.HOME)){
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal home accepted").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    myGoalPlace = PlaceType.MY_HOME;
                    goToState(StateType.FOLLOW_AGENT_WITH);
                    recentReceivedProposal = null;
                    return true;
                } else if (myEmotionState.getFeeling(agentId) < homeRejectFeelingConst ) {
                    //we will reject it just if our feelings are lower than this - otherwise we will ignore it. :-)
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal home rejected").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    return true;
                }
            } else {
                //reject if not from agent with or some other major problem
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal home rejected").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            }

        } else if (propType == ProposalType.CINEMA){
            if ((agentWith != null) && (agentWith.getId().getId() == agentId)) {
                if (checkEmotionsIfWantProposal(agentId,ProposalType.CINEMA)){
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal cinema accepted").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    myGoalPlace = PlaceType.CINEMA;
                    goToState(StateType.FOLLOW_AGENT_WITH);
                    recentReceivedProposal = null;
                    return true;
                } else if (myEmotionState.getFeeling(agentId) < cinemaRejectFeelingConst ) {
                    //we will reject it just if our feelings are lower than this - otherwise we will ignore it. :-)
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal cinema rejected").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    return true;
                }
            } else {
                //reject if not from agent with or some other major problem
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal cinema rejected").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            }
        } else if (propType == ProposalType.PARK){
            if ((agentWith != null) && (agentWith.getId().getId() == agentId) && (!atPark())) {
                if (checkEmotionsIfWantProposal(agentId,ProposalType.PARK)){
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal park accepted").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    myGoalPlace = PlaceType.PARK;
                    goToState(StateType.FOLLOW_AGENT_WITH);
                    recentReceivedProposal = null;
                    return true;
                } else if (myEmotionState.getFeeling(agentId) < parkRejectFeelingConst ) {
                    //we will reject it just if our feelings are lower than this - otherwise we will ignore it. :-)
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal park rejected").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    return true;
                }
            } else {
                //reject if not from agent with or some other major problem
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal park rejected").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            }
        } else if (propType == ProposalType.WAIT){
            if ((agentWith != null) && (agentWith.getId().getId() == agentId)) {
                if (checkEmotionsIfWantProposal(agentId,ProposalType.WAIT)){
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal wait accepted").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    waitForAgent = agentWith;
                    //set the timer so we are not immediately switched back to AGENT_WITH state
                    timerSet(TimerType.INIT_WAIT_TIMER,initWaitDurationConst);
                    goToState(StateType.WAIT);
                    recentReceivedProposal = null;
                    return true;
                } else if (myEmotionState.getFeeling(agentId) < waitRejectFeelingConst ) {
                    //we will reject it just if our feelings are lower than this - otherwise we will ignore it. :-)
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal wait rejected").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    return true;
                }
            } else {
                //reject if not from agent with or some other major problem
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal wait rejected").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            }
        } else if (propType == ProposalType.LEAVE){
            if ((agentWith != null) && (agentWith.getId().getId() == agentId)) {
                if (checkEmotionsIfWantProposal(agentId,ProposalType.LEAVE)){
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal leave accepted").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    removeAllInterrupters();
                    return true;
                }
                //here is ignore proposal zone

            } else if ((agentWith != null) && (agentWith.getId().getId() != agentId)) {
                //proposal is to actually leave our agentWith!!
                if (checkEmotionsIfWantProposal(agentId,ProposalType.LEAVE)){
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal leave accepted").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    actionBye(agentWith);
                    return true;
                } else {
                    getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal leave rejected").setFadeOut(messageFadeOutConst));
                    setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                    recentReceivedProposal = null;
                    return true;
                }
            } else {
                //reject...
                getAct().act(new SendMessage().setText("To:"+playersHistory.get(agentId).getName() + " proposal leave rejected").setFadeOut(messageFadeOutConst));
                setAction(null, ActionType.PROPOSAL_RESPONSE,currentTime,2);
                recentReceivedProposal = null;
                return true;
            }
        }
        return false;
    }

    /**
     * Removes from agentInterrupters input agent, if he is there. Updates player history
     * with information about agent last interrupt.
     * 
     * @param agent
     */
    protected void removeInterrupter(Player agent) {
        Player plr;
        Iterator<Player> it = agentInterrupters.iterator();
        while (it.hasNext()){
            plr = it.next();
            if (plr.getId().getId() == agent.getId().getId()){
                getPlayerHistory(plr).setLastInterruptedTime(currentTime);
                it.remove();
                return;
            }
        }
    }
    
    /**
     * Removes all from agentInterrupters. Updates player history
     * with information about agent last interrupt.
     */
    protected void removeAllInterrupters() {
        for (Player plr : agentInterrupters){
            getPlayerHistory(plr).setLastInterruptedTime(currentTime);
        }
                    
        agentInterrupters.clear();
    }

    /**
     * Returns nearest navigation point to input location in the map.
     *
     * @param targetLocation
     * @return
     */
    protected Location getNearestNavLocation(Location targetLocation) {

        NavPoint result = null;

        for (NavPoint nav : knownNavPoints.values()){
            if (result == null){
                result = nav;
            } else {
                if (nav.getLocation().getDistance(targetLocation) < result.getLocation().getDistance(targetLocation)){
                    result = nav;
                }
            }
        }
        return result.getLocation();
    }

    /**
     * Gets agents name from id (if possible).
     *
     * @param id input int id of the agent
     * @return
     */
    public String getName(int id) {
        if (id != -1){
            if (playersHistory.containsKey(id))
                return playersHistory.get(id).getName();
        }
        return "";
    }

    /**
     * Logs input action towards input agent into log file.
     *
     * @param agent
     * @param type
     * @param time
     * @param duration
     */
    private void logAction(Player agent, ActionType type, double time, double duration) {
        String name = "";
        if (agent != null) {
            name = agent.getName();
        } else {
            name = "None";
        }
        String msg = "Action:" + type + ", To:" + name + ", by:" +  getMyName() + ", in State:" + getState() + ", \n";
        msg += "Time:" + time + ", " + "Duration:" + duration + ", ";

        if (agentWith != null)
            msg += "A.WITH:" + agentWith.getName() + ", Feel:" + myEmotionState.getFeeling(agentWith.getId().getId()) + ", ";
        if (myGoalTarget != null)
            msg += "GOALPLACE:" + myGoalPlace + ", ";

        if (!agentInterrupters.isEmpty()){
            msg += " INTERRUPTERS:";
        for (Player plr : agentInterrupters)
            msg += "Name:" + plr.getName() + ", Feel: " +  myEmotionState.getFeeling(plr.getId().getId()) + ", ";
        }
        getLogger().user().warning(msg);

        if (bLogEnabled && agentLog != null) {
            agentLog.insertAction(type, agent.getId().getId(), myEmotionState.getFeeling(agent.getId().getId()), agent.getName(), time, duration);
        }
    }

    /**
     * Logs item given to some agent.
     *
     * @param agent target agent
     * @param item item type
     * @param currentTime time
     */
    private void logItemGiven(Player agent, ScenarioItemType item, double time) {

        if (bLogEnabled && agentLog != null) {
            agentLog.insertItem(item, agent.getId().getId(), agent.getName(), false, myEmotionState.getFeeling(agent.getId().getId()),time);
        }
    }

    /**
     * Logs item received from some agent.
     *
     * @param agentId
     * @param agentName
     * @param item item type
     * @param time
     */
    public void logItemReceived(int agentId, String agentName, ScenarioItemType item, double time) {
        if (bLogEnabled && agentLog != null) {
            agentLog.insertItem(item, agentId, agentName, true, myEmotionState.getFeeling(agentId),time);
        }
    }

    /**
     * Logs input proposal toward input agent to log file.
     *
     * @param agent target agent
     * @param newProp the proposal sent
     */
    private void logProposal(Player agent, ProposalInfo newProp) {
        String msg = "Proposal:" + newProp.getType() + ", To:" + agent.getName() + ", by:" +  getMyName() + ", in State:" + getState() + ", ";
        msg += "Time:" + currentTime + ", ";

        if (agentWith != null)
            msg += "A.WITH:" + agentWith.getName() + ", Feel:" + myEmotionState.getFeeling(agentWith.getId().getId()) + ", ";
        if (myGoalTarget != null)
            msg += "GOALPLACE:" + myGoalPlace + ", ";

        if (!agentInterrupters.isEmpty()){
            msg += " INTERRUPTERS:";
        for (Player plr : agentInterrupters)
            msg += "Name:" + plr.getName() + ", Feel:" +  myEmotionState.getFeeling(plr.getId().getId()) + ", ";
        }

        getLogger().user().warning(msg);

        if (bLogEnabled && agentLog != null) {
            agentLog.insertProposal(agent, newProp);
        }
    }

    /**
     * Logs state entered.
     *
     * @param state
     * @param time
     */
    protected void logStateEntered(StateType state, double time){
        String msg = "StateEntered:" + state + ", by:" +  getMyName() + ", in State:" + getState() + ", ";
        msg += "Time:" + currentTime + ", ";

        if (agentWith != null)
            msg += "A.WITH:" + agentWith.getName() + ", Feel:" + myEmotionState.getFeeling(agentWith.getId().getId()) + ", ";
        if (myGoalTarget != null)
            msg += "GOALPLACE:" + myGoalPlace + ", ";

        if (!agentInterrupters.isEmpty()){
            msg += " INTERRUPTERS:";
        for (Player plr : agentInterrupters)
            msg += "Name:" + plr.getName() + ", Feel:" +  myEmotionState.getFeeling(plr.getId().getId()) + ", ";
        }

        //getLogger().user().warning(msg);
    }

    /**
     * Logs state left.
     * 
     * @param state
     * @param time
     */
    protected void logStateLeft(StateType state, double time){
        String msg = "StateLeft:" + state + ", by:" +  getMyName() + ", in State:" + getState() + ", ";
        msg += "Time:" + currentTime + ", ";

        if (agentWith != null)
            msg += "A.WITH:" + agentWith.getName() + ", Feel:" + myEmotionState.getFeeling(agentWith.getId().getId()) + ", ";
        if (myGoalTarget != null)
            msg += "GOALPLACE:" + myGoalPlace + ", ";

        if (!agentInterrupters.isEmpty()){
            msg += " INTERRUPTERS:";
        for (Player plr : agentInterrupters)
            msg += "Name:" + plr.getName() + ", Feel:" +  myEmotionState.getFeeling(plr.getId().getId()) + ", ";
        }

        //getLogger().user().warning(msg);
    }

    /**
     * Logs current emotions and feelings + agent state.
     *
     */
    protected void logAgentState(){

        //emotions
        String msg = "CurrentEmotions for agent:" + getMyName() + ", Location:" + agentInfo.getLocation().toString() + ", Time:" + currentTime + ", \n";
        for (Emotion em : myALMA.getCurrentEmotions(myName)){
            msg += "Type:" + em.getType() + ", Int.:" + em.getIntensity() + ", Elicitor:" + em.getElicitor() + ", El.Name:" + getName(em.getElicitor().toString()) + ", \n";
        }

        //getLogger().user().warning(msg);

        //feelings
        msg = "CurrentFeelings for agent:" + getMyName() + ", Time:" + currentTime + ", \n";
        for (int i : myEmotionState.feelingsHistory.keySet()){            
            msg += "Id:"+ i + ", Name:" + getName(i) + ", Feel:" + myEmotionState.getFeeling(i) + ", ";
        }

        //getLogger().user().warning(msg);
        if (bLogEnabled && agentLog != null){
            ArrayList<String> interNames = new ArrayList<String>();
            ArrayList<Player> inters = new ArrayList<Player>();
            Player plr;
            Iterator<Player> it = agentInterrupters.iterator();
            while (it.hasNext()){
                plr = it.next();
                interNames.add(plr.getName());
                inters.add(plr);
            }
            String agWithName = "";
            if (agentWith != null)
                agWithName = agentWith.getName();
            agentLog.insertAgentState(currentTime, agWithName, agentWith, myGoalPlace, myGoalTarget, getState(), agentInfo.getLocation(), agentInfo.getRotation(), interNames, inters);

            agentLog.insertEmotions(currentTime, myEmotionState.getCurrentEmotions());

            agentLog.insertMood(currentTime, myEmotionState.getCurrentMood());

            ArrayList<FeelingLog> feelLog = new ArrayList<FeelingLog>();
            for (int id : myEmotionState.feelingsHistory.keySet()){
                feelLog.add(new FeelingLog(currentTime, id, getName(id), myEmotionState.getFeeling(id)));
            }
            agentLog.insertFeelings(feelLog);
        }
    }

    /**
     * This is a bad hack that allows us to run more experiments in a row in really
     * easy way. 
     */
    public void throwExcp() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

}