/*
 * EventGenerator.java
 *
 * Created on 9. bezen 2008, 17:41
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package almabasedmodel;

import bot.EmotionalBot;


import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.*;

import de.affect.xml.AffectInputDocument.AffectInput.BasicEEC;
import info.EventId;
import info.PlayerInfo;
import info.ProposalType;


import info.ScenarioItemType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

/**
 * This class evaluates and generates emotional events for ALMA emotional model. When some
 * event is catched by EventGenerator.java class appropriate method here is called
 * to evaluate the event by OCC variables and send it to emotion model (PogamutALMA.java).
 *
 * One event can lead to more emotions (usually two). The emotions generated depend on
 * the event properties and sometimes also on the feeling we have associated with
 * the agents that caused or are affected by the event.
 *
 * The names of the methods here follow certain logic. If the keyword Action is present
 * it means the event is result of some action. If the proposal keyword is present, it
 * means that the event is associated with proposals somehow and etc. "By" keyword means
 * that the cause of the action wasn't our agent (someone else has done the action). Keyword
 * "Other" means that our agent wasn't involved at all in the event.
 *
 * @author Knight
 */
public class AEventGenerator {

    /** Class holding connection to ALMA emotion model */
    public PogamutALMA emModel = null;
    /** Class holding information about agents emotions and feelings got and computed from ALMA */
    public AEmotionState myEmotionState = null;
    /** Pointer to our agent we generate evets for */
    public EmotionalBot myAgent;
    /** This variable prevents some concurent write exceptions in ALMA model - cause of them yet unknown */
    private int pickupEventId = 0;

    /**
     * Result of Action KISS  we have kissed the agent. Emotions generated depends on the feeling toward other agent.
     * Emotions: joy and love or distress and hate
     *
     * @param agentId agent we have kissed
     */
    public void generateActionKissEvent(int agentId) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling;

        feeling = myEmotionState.getFeeling(agentId);

        if (feeling > 0.5) {
            feeling = 1;
        }

        if (feeling < 0.2) {
            feeling = -1;
        }

        //joy, distress?
        //TODO
        eventEEC.setDesirability(feeling * 1);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + agentId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_KISS_EVENT);

        //love, hate?
        //TODO
        agentEEC.setDesirability(0);
        agentEEC.setPraiseworthiness(feeling * 1);
        agentEEC.setAppealingness(feeling * 1);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + agentId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_KISS_ACT);
    }

    /**
     * Result of Action KISS  someone has kissed other agent in the scenario
     * (our agent wasn't involved). Emotions are dependent on the feeling. We will
     * generate dislike and anger emotions towards kisser - the intensity is as high
     * as we like the opposite sex agent in the couple. 
     * Emotions: disliking and anger
     *
     * @param kisserId the agent who kissed someone
     * @param target the agent who was kissed
     *
     * @todo generate some emotions also for target
     */
    public void generateActionKissOtherEvent(int kisserId, PlayerInfo target) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling = 0;
        double desirability = -0.3;
        double appealingness = -0.3;
        double praiseworthiness = -0.3;

        //Here we get the feeling toward opposite sex agent.
        if (myAgent.isOppositeSex(kisserId)) {
            feeling = myEmotionState.getFeeling(kisserId);
        } else if (target != null) {
            feeling = myEmotionState.getFeeling(target.getId());
        } else {
            feeling = 0.1; // default feeling
        }

        if (feeling > -0.1) {
            desirability -= Math.min(feeling, 0.6);
            praiseworthiness -= Math.min(feeling, 0.6);
            appealingness -= Math.min(feeling, 0.6);
        }

        //TODO: We should generate some negative emotion also to the agent that was
        //kissed

        //We will generate dislike and anger emotions towards kisser - the intensity
        //is as high as we like the opposite sex agent in the couple.

        //disliking
        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(appealingness);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + kisserId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_KISS_OTHER_EVENT);

        //anger
        agentEEC.setDesirability(desirability);
        agentEEC.setPraiseworthiness(praiseworthiness);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.SELF);
        agentEEC.setElicitor("Id:" + kisserId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_KISS_OTHER_ACT);
    }

    /**
     * Result of Action SLAP  we have been slapped by other agent.
     * Emotions are not dependent on the feeling towards agent.
     * Emotions: distress and disliking and anger
     *
     * @param agentId the agent who slapped us
     */
    public void generateActionSlapByEvent(int agentId) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        /* double feeling;

        feeling = myEmotionState.getFeeling(agentId);

        if (feeling >= 0)
        feeling = 1;
        else
        feeling = -1;*/

        //disliking
        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(-1);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + agentId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_SLAP_BY_EVENT);

        //anger
        agentEEC.setDesirability(-1);
        agentEEC.setPraiseworthiness(-1);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + agentId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_SLAP_BY_ACT);
    }

    /**
     * Result of Action SLAP. Someone has slapped other agent. We will generate
     * emotions if the feeling toward the agent slapped exceeds certain threshold.
     * Emotions: (disliking and anger)
     *
     * @param slapperId agent who slapped someone
     * @param target victim - agent that was slapped
     */
    public void generateActionSlapOtherEvent(int slapperId, PlayerInfo target) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling;

        if (target != null) {
            feeling = myEmotionState.getFeeling(target.getId());
        } else {
            feeling = 0;
        }

        if (feeling >= myAgent.complimentFeelingConst) {
            //disliking
            eventEEC.setDesirability(0);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(-1);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + slapperId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_SLAP_OTHER_EVENT);

            //anger
            agentEEC.setDesirability(-1);
            agentEEC.setPraiseworthiness(-1);
            agentEEC.setAppealingness(0);
            agentEEC.setLikelihood(0);
            agentEEC.setLiking(0);
            agentEEC.setRealization(0);
            agentEEC.setAgency(BasicEEC.Agency.OTHER);
            agentEEC.setElicitor("Id:" + slapperId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_SLAP_OTHER_ACT);
        }
    }

    /**
     * Result of Action KICK. Someone has kicked other agent. We will generate
     * emotions if the feeling toward the agent kicked exceeds certain threshold.
     * Emotions: distress and anger
     *
     * @param kickerId the agent who kicked someone
     * @param target victim - agent who was kicked (probably some animal)
     */
    public void generateActionKickOtherEvent(int kickerId, PlayerInfo target) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling;

        if (target != null) {
            feeling = myEmotionState.getFeeling(target.getId());
        } else {
            feeling = 0;
        }

        if (feeling >= myAgent.cuddleFeelingConst) {
            //distress
            eventEEC.setDesirability(-1);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + kickerId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_KICK_OTHER_EVENT);

            //anger
            agentEEC.setDesirability(-1);
            agentEEC.setPraiseworthiness(-1);
            agentEEC.setAppealingness(0);
            agentEEC.setLikelihood(0);
            agentEEC.setLiking(0);
            agentEEC.setRealization(0);
            agentEEC.setAgency(BasicEEC.Agency.OTHER);
            agentEEC.setElicitor("Id:" + kickerId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_KICK_OTHER_ACT);
        }
    }

    /**
     * Result of Action BYE. Some other agent has said bye to us. Emotions depends
     * on the feeling toward agent (if positive or negative).
     * Emotions: joy (if the feeling is negative) or distress (if the feeling is positive)
     *
     * @param id agent that said bye to us
     */
    public void generateActionByeByEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        double feeling = myEmotionState.getFeeling(id);
        double desirability = -0.2;

        if (feeling > 0) {
            desirability = -0.2;
        } else {
            desirability = 0.2;
        }

        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_BYE_BY_EVENT);

    }

    /**
     * Result of Action COMPLIMENT. Someone has said compliment to us. Emotions
     * intensities depend on the feeling toward other agent.
     * Emotions: joy and liking (higher the feeling, higher the emotions)
     *
     * @param id agent that said compliment to us
     */
    public void generateActionComplimentByEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double feeling = myEmotionState.getFeeling(id);
        double appealingness = 0.4;
        double desirability = 0.4;

        if (feeling > 0) {
            appealingness = 0.6;
            desirability = 0.6;
        } else {
            appealingness = 0.3;
            desirability = 0.3;
        }

        //joy
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_COMPLIMENT_BY_EVENT);

        //liking
        actEEC.setDesirability(0);
        actEEC.setPraiseworthiness(0);
        actEEC.setAppealingness(appealingness);
        actEEC.setLikelihood(0);
        actEEC.setLiking(0);
        actEEC.setRealization(0);
        actEEC.setAgency(BasicEEC.Agency.SELF);
        actEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.AGENT_COMPLIMENT_BY_ACT);
    }

    /**
     * Result of Action COMPLIMENT. Someone has said compliment to other agent.
     * Emotions intensities depend on the feeling toward the agent who said the compliment.
     * Emotions: distress and anger (toward the agent who said the compliment)
     *
     * @param id the agent who said the compliment
     * @param target the target of the compliment (not us)
     */
    public void generateActionComplimentOtherEvent(int id, PlayerInfo target) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling, desirability, praiseworthiness;

        if (target != null) {
            feeling = myEmotionState.getFeeling(target.getId());
        } else {
            feeling = 0;
        }

        if (feeling > 1) {
            desirability = -0.3;
            praiseworthiness = -0.3;
        } else if (feeling >= 0) {
            //some jelaousy here
            desirability = -0.2;
            praiseworthiness = -0.2;
        } else { // less than 0 - don't like at all
            desirability = -0.3;
            praiseworthiness = -0.3;
        }

        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_COMPLIMENT_OTHER_EVENT);

        //pride/anger
        agentEEC.setDesirability(desirability);
        agentEEC.setPraiseworthiness(praiseworthiness);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_COMPLIMENT_OTHER_ACT);
    }

    /**
     * 
     *
     * @todo Not implemented yet  just animals should be cuddled, not real agents.
     * @param id
     */
    public void generateActionCuddleByEvent(int id) {
        //TODO: nothing for now, meant for animals
    }

    /**
     * Result of Action INSULT. Other agent has insulted us. Emotions don't depend
     * on the feeling.
     * Emotions: disliking and anger
     *
     * @param id agent who said the insult to us
     */
    public void generateActionInsultByEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling = myEmotionState.getFeeling(id);

        //disliking
        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(-1);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_INSULT_BY_EVENT);

        //anger
        agentEEC.setDesirability(-1);
        agentEEC.setPraiseworthiness(-1);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_INSULT_BY_ACT);

    }

    /**
     * Result of Action INSULT. Someone has insulted other agent. Depends on the
     * feeling toward the agent who was insulted.
     * Emotions: joy and pride (feeling toward the insulted agent is negative) or
     * distress and anger (feeling toward the insulted agent is positive)
     *
     * @param id agent that said the insult
     * @param target victim - the agent the insult was for
     */
    public void generateActionInsultOtherEvent(int id, PlayerInfo target) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling, desirability, praiseworthiness;

        if (target != null) {
            feeling = myEmotionState.getFeeling(target.getId());
        } else {
            feeling = 0;
        }

        if (feeling < 0) {
            desirability = 0.5;
            praiseworthiness = 0.5;
        } else {
            desirability = -0.5;
            praiseworthiness = -0.5;
        }

        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_INSULT_OTHER_EVENT);

        //pride/anger
        agentEEC.setDesirability(desirability);
        agentEEC.setPraiseworthiness(praiseworthiness);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_INSULT_OTHER_ACT);
    }

    /**
     * Not implemented yet. Just animals should be kicked, not agents. Called when someone kicks us.
     *
     * @todo Not implemented yet. Just animals should be kicked, not agents. Called when someone kicks us.
     * @param id
     */
    public void generateActionKickByEvent(int id) {
        //TODO:
    }

    /**
     * Result of Action SEX. We are making love with other agent or vice versa
     * (the method has By in the name, but is used even when WE were the cause of the action).
     * This is the result of accepted proposal sex. The emotions depends on the
     * feeling (for positive emotions the feeling should be higher than sexFeelingConst
     *  this should be true, otherwise we wouldn't accept the proposal anyway).
     * Emotions: liking and love (if the feeling exceeds threshold) or
     * disliking and hate (if the feeling does not exceed threshold)
     * 
     * @param id the agent we are making love to or vice versa
     */
    public void generateActionSexByEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling;

        feeling = myEmotionState.getFeeling(id);

        if (feeling > myAgent.sexFeelingConst) {
            feeling = 1;
        } else {
            feeling = -1;
        }

        //liking/disliking
        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(feeling * 1);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_SEX_BY_EVENT);

        //love, hate
        agentEEC.setDesirability(0);
        agentEEC.setPraiseworthiness(feeling * 1);
        agentEEC.setAppealingness(feeling * 1);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_SEX_BY_ACT);
    }

    /**
     * Result of Action SEX. Someone is making love with other agent. Emotions
     * depend on the feeling toward the agent of opposite sex in the couple.
     * The higher the feeling the higher the intensities of emotions. The emotions
     * here are associated toward tboth of the agents.
     * Emotions: distress and hate (toward both of the agents)
     *
     * @param id agent that is making love to someone
     * @param result target of the love act
     */
    public void generateActionSexOtherEvent(int id, PlayerInfo result) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentOneEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentTwoEEC = BasicEEC.Factory.newInstance();

        int targetId;
        double feeling;
        double desirability = -0.3;
        double praiseworthiness = -0.3;
        double appealingness = -0.3;

        if (result != null) {
            if (myAgent.isOppositeSex(id)) {
                targetId = id;
            } else {
                targetId = result.getId();
            }

            feeling = myEmotionState.getFeeling(targetId);

            if (feeling > 0.3) {
                desirability = -1;
                praiseworthiness = -1;
                appealingness = -1;
            }

            //distress
            eventEEC.setDesirability(desirability);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("SexOtherEvent" + pickupEventId++);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_SEX_OTHER_EVENT);

            //hate
            agentOneEEC.setDesirability(0);
            agentOneEEC.setPraiseworthiness(praiseworthiness);
            agentOneEEC.setAppealingness(appealingness);
            agentOneEEC.setLikelihood(0);
            agentOneEEC.setLiking(0);
            agentOneEEC.setRealization(0);
            agentOneEEC.setAgency(BasicEEC.Agency.OTHER);
            agentOneEEC.setElicitor("Id:" + id);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentOneEEC), EventId.AGENT_SEX_OTHER_ACT);

            //hate
            agentTwoEEC.setDesirability(0);
            agentTwoEEC.setPraiseworthiness(praiseworthiness);
            agentTwoEEC.setAppealingness(appealingness);
            agentTwoEEC.setLikelihood(0);
            agentTwoEEC.setLiking(0);
            agentTwoEEC.setRealization(0);
            agentTwoEEC.setAgency(BasicEEC.Agency.OTHER);
            agentTwoEEC.setElicitor("Id:" + result.getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentTwoEEC), EventId.AGENT_TWO_SEX_OTHER_ACT);
        }

    }

    /**
     * Result of Action KISS. Someone has kissed us. Emotions depend on the feeling
     * toward the agent  the higher the feeling, the bigger positive emotions and vice versa.
     * Emotions: joy and love or distress and hate
     *
     * @todo
     *
     * @param id agent that has kissed us
     */
    public void generateActionKissByEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling;

        feeling = myEmotionState.getFeeling(id);

        if (feeling > 0.5) {
            feeling = 1;
        }

        if (feeling < 0.2) {
            feeling = -1;
        }

        //joy, distress?
        //TODO
        eventEEC.setDesirability(feeling * 1);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_KISS_BY_EVENT);

        //love, hate?
        //TODO
        agentEEC.setDesirability(0);
        agentEEC.setPraiseworthiness(feeling * 1);
        agentEEC.setAppealingness(feeling * 1);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_KISS_BY_ACT);
    }

    /**
     * Result of Action LEAVE. Someone has left us  said bye in a bad way.
     * Emotions depend on the feeling toward the agent.
     * Emotions: joy and gratitude (feeling negative) or distress and anger
     * (feeling positive)
     *
     * @param id agent that has left us
     */
    public void generateActionLeaveByEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        double feeling = myEmotionState.getFeeling(id);
        double desirability = 0.1;

        if (feeling > 0) {
            desirability = -1;
        } else {
            desirability = 0.15;
        }
        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_LEAVE_BY_EVENT);

        //anger todo? what this will be
        agentEEC.setDesirability(desirability);
        agentEEC.setPraiseworthiness(desirability);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_LEAVE_BY_ACT);

    }

    /**
     * Result of Action LEAVE. Someone has left other agent. Emotions depend on
     * the feelings toward both of the agents.
     * Emotions: joy  if someone we don't like left someone we like or else OR
     * distress  if someone we like left someone we like
     *
     * @param id the agent that left someone
     * @param agentLeft the agent that was left by someone
     */
    public void generateActionLeaveOtherEvent(int id, PlayerInfo agentLeft) {
        BasicEEC agentOneEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentTwoEEC = BasicEEC.Factory.newInstance();

        double desirability = 0.1;

        double feelingOne = myEmotionState.getFeeling(id);

        if (agentLeft != null) {
            double feelingTwo = myEmotionState.getFeeling(agentLeft.getId());

            if ((feelingOne > 0) && (feelingTwo < 0)) {
                desirability = 0.4;
            } else if ((feelingOne > 0) && (feelingTwo < 0)) {
                desirability = -0.2;
            }
        }

        //joy/distress
        agentOneEEC.setDesirability(desirability);
        agentOneEEC.setPraiseworthiness(0);
        agentOneEEC.setAppealingness(0);
        agentOneEEC.setLikelihood(0);
        agentOneEEC.setLiking(0);
        agentOneEEC.setRealization(0);
        agentOneEEC.setAgency(BasicEEC.Agency.SELF);
        agentOneEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentOneEEC), EventId.AGENT_LEAVE_OTHER_ACT);

        //joy/distress
        agentTwoEEC.setDesirability(desirability);
        agentTwoEEC.setPraiseworthiness(0);
        agentTwoEEC.setAppealingness(0);
        agentTwoEEC.setLikelihood(0);
        agentTwoEEC.setLiking(0);
        agentTwoEEC.setRealization(0);
        agentTwoEEC.setAgency(BasicEEC.Agency.OTHER);
        agentTwoEEC.setElicitor("Id:" + agentLeft.getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentTwoEEC), EventId.AGENT_LEAVE_OTHER_ACT);
    }

    /**
     * Result of Action BYE. Someone has left other agent. Emotions depend on the
     * feelings toward both of the agents.
     * Emotions: joy  if someone we don't like said bye to someone we like or else OR
     * distress  if someone we like said bye to someone we like
     *
     * @param id the agent that said bye to someone
     * @param agentLeft the agent that was left (the bye was for this agent)
     */
    public void generateActionByeOtherEvent(int id, PlayerInfo agentLeft) {
        BasicEEC agentOneEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentTwoEEC = BasicEEC.Factory.newInstance();

        double desirability = 0.1;

        double feelingOne = myEmotionState.getFeeling(id);

        if (agentLeft != null) {
            double feelingTwo = myEmotionState.getFeeling(agentLeft.getId());

            if ((feelingOne > 0) && (feelingTwo < 0)) {
                desirability = 0.1;
            } else if ((feelingOne > 0) && (feelingTwo > 0)) {
                desirability = -0.2;
            }
        }

        //joy/distress
        agentOneEEC.setDesirability(desirability);
        agentOneEEC.setPraiseworthiness(0);
        agentOneEEC.setAppealingness(0);
        agentOneEEC.setLikelihood(0);
        agentOneEEC.setLiking(0);
        agentOneEEC.setRealization(0);
        agentOneEEC.setAgency(BasicEEC.Agency.SELF);
        agentOneEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentOneEEC), EventId.AGENT_BYE_OTHER_ACT);

        //joy/distress
        agentTwoEEC.setDesirability(desirability);
        agentTwoEEC.setPraiseworthiness(0);
        agentTwoEEC.setAppealingness(0);
        agentTwoEEC.setLikelihood(0);
        agentTwoEEC.setLiking(0);
        agentTwoEEC.setRealization(0);
        agentTwoEEC.setAgency(BasicEEC.Agency.OTHER);
        agentTwoEEC.setElicitor("Id:" + agentLeft.getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentTwoEEC), EventId.AGENT_BYE_OTHER_EVENT);
    }

    /**
     * This event is generated after some time we have spent together with other
     * agent who is not responding to our conversation. When the conditions are
     * met the event will be generated every 35 seconds.
     * Emotions: anger
     *
     * @param agent agent that ignored us
     */
    public void generateConversationIgnoreByEvent(Player agent) {
        //BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        int id = agent.getId().getId();
        double feeling = myEmotionState.getFeeling(id);

        //distress
       /* eventEEC.setDesirability(-0.3);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:"+ id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(),eventEEC),EventId.CONVERSATION_IGNORE_EVENT);
         */
        //anger
        agentEEC.setDesirability(-0.3);
        agentEEC.setPraiseworthiness(-0.3);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.CONVERSATION_IGNORE_ACT);
    }

    /**
     * Generated every x seconds when we are alone (agent doesn't see anyone).
     * Emotions: distress
     */
    public void generateAloneEvent() {
        BasicEEC lostEventEEC = BasicEEC.Factory.newInstance();

        //distress
        lostEventEEC.setDesirability(-0.5);
        lostEventEEC.setPraiseworthiness(0);
        lostEventEEC.setAppealingness(0);
        lostEventEEC.setLikelihood(0);
        lostEventEEC.setLiking(0);
        lostEventEEC.setRealization(0);
        lostEventEEC.setAgency(BasicEEC.Agency.SELF);
        lostEventEEC.setElicitor("AloneEventTime:" + myAgent.currentTime);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), lostEventEEC), EventId.AGENT_ALONE_EVENT);
    }

    /**
     * We have picked up some item  can be flower, condom or gun. Emotions don't
     * depend on the type of the item.
     * Emotions: joy
     *
     * @param type type of the item we have picked up
     */
    public void generatePickupEvent(ScenarioItemType type) {
        BasicEEC lostEventEEC = BasicEEC.Factory.newInstance();

        pickupEventId++;

        lostEventEEC.setDesirability(0.3);
        lostEventEEC.setPraiseworthiness(0);
        lostEventEEC.setAppealingness(0);
        lostEventEEC.setLikelihood(0);
        lostEventEEC.setLiking(0);
        lostEventEEC.setRealization(0);
        lostEventEEC.setAgency(BasicEEC.Agency.SELF);
        lostEventEEC.setElicitor("PickupEvent:" + type.toString() + pickupEventId);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), lostEventEEC), EventId.AGENT_PICKUP_EVENT);
    }

    /**
     * Generated when we have lost sight of other agent (we have stopped seeing
     * him and this state lasts for some time now). Emotions depend on the feeling
     * toward the agent are more intense if the agent is of the opposite sex.
     * Emotions: joy (if the feeling is negative) or distress (if the feeling is positive)
     *
     * @param id the agent we have lost sight to
     */
    public void generatePlayerLostEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        double desirability = 0.2;

        if (myAgent.isOppositeSex(id)) {
            desirability = 1.5 * desirability;
        }

        if (myEmotionState.getFeeling(id) > 0) {
            desirability = - 1 * desirability;
        }

        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PLAYER_LOST_EVENT);
    }

    /**
     * Generated every x seconds we are together with other agent. Emotions depend
     * on the feeling toward the other agent. Emotions are more intense if the agent
     * is of opposite sex.
     * Emotions: joy (if the feeling is positive) or distress (if the feeling is negative)
     *
     * @param id the agent we are together with
     */
    public void generatePlayerTogetherEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        double desirability = 0.4;

        if (myAgent.isOppositeSex(id)) {
            desirability = 1.5 * desirability;
        }

        if (myEmotionState.getFeeling(id) < 0) {
            desirability = - 1 * desirability;
        }

        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PLAYER_TOGETHER_EVENT);
    }

    /**
     * This event is generated when we have spotted the agent for the first time
     * or when we haven't seen the agent for some time and we see him again
     * (emotions are lower in the second case). Emotions depend on the feeling toward
     * the agent. Emotions are more intense if the agent is of opposite sex.
     * Emotions: joy (if the feeling is positive) or distress
     * (if the feeling is negative)
     *
     * @todo We should look which state are we currently in, if we see second girl approaching
     * and we are with the first girl we won't be very happy that we see her.. :-)
     *
     * @param pl agent that has appeared
     * @param firstTime true if we see the agent for the first time
     */
    public void generatePlayerAppearedEvent(Player pl, boolean firstTime) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        double desirability = 0.3;

        if (firstTime) {
            desirability = 0.5;
        }

        if (myAgent.isOppositeSex(pl.getId().getId())) {
            desirability = 1.5 * desirability;
        }

        if (myEmotionState.getFeeling(pl.getId().getId()) < 0) {
            desirability = - 1 * desirability;
        }

        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + pl.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PLAYER_APPEARED_EVENT);
    }

    /**
     * Someone has sent us message that contains anger and/or fear smilies. 
     * We will generate anger or fear emotion toward the agent based on the number
     * of the smilies (more anger smilies = anger and vice versa). The emotion intensity 
     * is affected by the number of messages we got from the agent in last x seconds.
     * The more messages we got the lower the intensity of the emotion. 
     * The intensity of the emotions decrease rapidly. The reduction is sent as a 
     * parameter.
     * Emotions: fear or anger
     *
     * @param id agent who said the message
     * @param smiliesCount number of the smilies - positive means more anger smilies,
     * negative more fear smilies
     * @param reduction number we will reduce the emotion instensity by
     */
    public void generateAngerFearMessageEvent(int id, int smiliesCount, double reduction) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        //generate event just when the signs are biased to one side
        if (smiliesCount != 0) {
            //if more anger signs
            if (smiliesCount > 0) {

                eventEEC.setDesirability(-1 * sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setPraiseworthiness(-1 * sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setAppealingness(0);
                eventEEC.setLikelihood(0);
                eventEEC.setLiking(0);
                eventEEC.setRealization(0);
                eventEEC.setAgency(BasicEEC.Agency.OTHER);
                //TODO
                eventEEC.setElicitor("Id:" + id);

                this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_ANGER_EVENT);

            } else { //more fear signs
                eventEEC.setDesirability(-1 * sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setPraiseworthiness(0);
                eventEEC.setAppealingness(0);
                eventEEC.setLikelihood(sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setLiking(0);
                eventEEC.setRealization(0);
                eventEEC.setAgency(BasicEEC.Agency.SELF);
                //TODO
                eventEEC.setElicitor("Id:" + id);

                this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_FEAR_EVENT);
            }

        }

    }

    /**
     * Someone has sent us message that contains joy and/or distress smilies.
     * We will generate joy or distress emotion toward the agent based on the number
     * of the smilies (more joy smilies = joy and vice versa). The emotion intensity
     * is affected by the number of messages we got from the agent in last x seconds.
     * The more messages we got the lower the intensity of the emotion.
     * The intensity of the emotions decrease rapidly. The reduction is sent as a
     * parameter.
     * Emotions: joy or distress
     *
     * @param id agent who said the message
     * @param smiliesCount number of the smilies - positive means more joy smilies,
     * negative more distress smilies
     * @param reduction number we will reduce the emotion instensity by
     */
    public void generateHappySadMessageEvent(int id, int smiliesCount, double reduction) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        //generate event just when the signs are biased to one side
        if (smiliesCount != 0) {
            //if more happy signs
            if (smiliesCount > 0) {

                eventEEC.setDesirability(sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setPraiseworthiness(0);
                eventEEC.setAppealingness(0);
                eventEEC.setLikelihood(0);
                eventEEC.setLiking(0);
                eventEEC.setRealization(0);
                eventEEC.setAgency(BasicEEC.Agency.SELF);
                //TODO
                eventEEC.setElicitor("Id:" + id);

                this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_HAPPY_EVENT);

            } else { //more sad signs
                eventEEC.setDesirability(-1 * sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setPraiseworthiness(0);
                eventEEC.setAppealingness(0);
                eventEEC.setLikelihood(0);
                eventEEC.setLiking(0);
                eventEEC.setRealization(0);
                eventEEC.setAgency(BasicEEC.Agency.SELF);
                //TODO
                eventEEC.setElicitor("Id:" + id);

                this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_SAD_EVENT);
            }

        }
    }

    /**
     * We are with some other agent and we are doing something with him  speaking
     * or going somewhere  and we are interrupted by other agent or agents 
     * someone is speaking to us, polymorph approached us or else and we want
     * to react to these other agents (we are not ignoring him, he is close
     * enough and etc.). Emotions depend on the feeling toward the agents.
     * Emotions: joy and gratitude (feeling is positive) or distress and anger
     * (feeling is negative)
     *
     * @todo check agentWith and emotions towards him - the bigger feeling, the more unpleasant is interruption
     * @param agentInterrupters list of agents that are interrupting us
     */
    public void generateInterruptedEvent(ArrayList<Player> agentInterrupters) {

        BasicEEC eventEEC = null;
        BasicEEC agentEEC = null;

        double desirability = -0.1, praiseworthiness = -0.1;

        for (Player plr : agentInterrupters) {

            if (myEmotionState.getFeeling(plr.getId().getId()) > 0) {
                desirability = 0.5;
                praiseworthiness = 0.5;
            } else {
                desirability = -0.5;
                praiseworthiness = -0.5;
            }
            eventEEC = BasicEEC.Factory.newInstance();
            agentEEC = BasicEEC.Factory.newInstance();

            //distress/joy
            eventEEC.setDesirability(desirability); //TODO based on feelings?
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + plr.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.AGENT_INTERRUPTED_EVENT);

            //anger/gratitude?
            agentEEC.setDesirability(desirability);
            agentEEC.setPraiseworthiness(praiseworthiness);
            agentEEC.setAppealingness(0);
            agentEEC.setLikelihood(0);
            agentEEC.setLiking(0);
            agentEEC.setRealization(0);
            agentEEC.setAgency(BasicEEC.Agency.OTHER);
            agentEEC.setElicitor("Id:" + plr.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.AGENT_INTERRUPTED_ACT);
        }

    }

    /**
     * Some agent gave item to other agent. We will generate emotions if we have
     * positive feeling to the giver and the item is flower  we will be jelaous.
     * Emotions: distress and anger (if the feeling is positive and item is flower)
     * 
     * @param itemType type of the item that was given to someone
     * @param id id of the agent who gave the item to someone (not us)
     */
    public void generateItemJelausyEvent(ScenarioItemType itemType, int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        //we will generate event just if item is flowers and we have some feeligns toward the agent
        if ((itemType == ScenarioItemType.FLOWER) && (myEmotionState.getFeeling(id) > 0)) {
            //distress
            eventEEC.setDesirability(-0.4); //TODO based on feelings?
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + id);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.ITEM_JELAOUSY_EVENT);

            //anger
            agentEEC.setDesirability(-0.4);
            agentEEC.setPraiseworthiness(-0.4);
            agentEEC.setAppealingness(0);
            agentEEC.setLikelihood(0);
            agentEEC.setLiking(0);
            agentEEC.setRealization(0);
            agentEEC.setAgency(BasicEEC.Agency.OTHER);
            agentEEC.setElicitor("Id:" + id);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.ITEM_JELAOUSY_ACT);
        }
    }

    /**
     * Someone has send message to other agent that contains like and/or dislike smilies.
     * We will generate emotions based on the smilies. We will generate the emotions
     * just in case the feeling toward the agent who said the message is positive.
     * There is big reduction in emotion intensity based on the number of the messages
     * that the agent said to other agent.
     * Emotions: distress and anger (if the message contains more liking smilies) or
     * joy and gratitude (if the message contains more disliking smilies)
     *
     * @param message the message that was sent to some agent
     * @param likeCount number of like smilies in the message
     * @param dislikeCount number of dislike smilies in the message
     * @param reduction number we will reduce the emotion intensity by
     */
    public void generateMessageToOtherEvent(GlobalChat message, int likeCount, int dislikeCount, double reduction) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();

        if (myEmotionState.getFeeling(message.getId().getId()) > 0) {
            //distress
            eventEEC.setDesirability(-1 * sigmoid(likeCount - dislikeCount, 5, 1) / reduction);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_OTHER_EVENT);

            //anger
            agentEEC.setDesirability(-1 * sigmoid(likeCount - dislikeCount, 5, 1) / reduction);
            agentEEC.setPraiseworthiness(-1 * sigmoid(likeCount - dislikeCount, 5, 1) / reduction);
            agentEEC.setAppealingness(0);
            agentEEC.setLikelihood(0);
            agentEEC.setLiking(0);
            agentEEC.setRealization(0);
            agentEEC.setAgency(BasicEEC.Agency.OTHER);
            agentEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.MESSAGE_OTHER_ACT);
        }
    }

    /**
     * Someone has sent us message that contains like and/or dislike smilies.
     * We will generate like or dislike emotion toward the agent based on the number
     * of the smilies (more like smilies = like and vice versa). The emotion intensity
     * is affected by the number of messages we got from the agent in last x seconds.
     * The more messages we got the lower the intensity of the emotion.
     * The intensity of the emotions decrease rapidly. The reduction is sent as a
     * parameter.
     * Emotions: like or dislike
     *
     * @param id agent who said the message
     * @param smiliesCount number of the smilies - positive means more like smilies,
     * negative more dislike smilies
     * @param reduction number we will reduce the emotion instensity by
     */
    public void generateLikeDislikeMessageEvent(int id, int smiliesCount, double reduction) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        //generate event just when the signs are biased to one side
        if (smiliesCount != 0) {
            //if more happy signs
            if (smiliesCount > 0) {

                eventEEC.setDesirability(0);
                eventEEC.setPraiseworthiness(0);
                eventEEC.setAppealingness(sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setLikelihood(0);
                eventEEC.setLiking(0);
                eventEEC.setRealization(0);
                eventEEC.setAgency(BasicEEC.Agency.SELF);
                //TODO
                eventEEC.setElicitor("Id:" + id);

                this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_LIKE_EVENT);

            } else { //more sad signs
                eventEEC.setDesirability(0);
                eventEEC.setPraiseworthiness(0);
                eventEEC.setAppealingness(-1 * sigmoid(smiliesCount, 5, 1) / reduction);
                eventEEC.setLikelihood(0);
                eventEEC.setLiking(0);
                eventEEC.setRealization(0);
                eventEEC.setAgency(BasicEEC.Agency.SELF);
                //TODO
                eventEEC.setElicitor("Id:" + id);

                this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.MESSAGE_DISLIKE_EVENT);
            }

        }
    }

    /**
     * The polymorph has bitten us! We will generate negative emotions.
     * Emotions: fears confirmed and fear
     * Note: Fears confirmed emotion will lead probably to other negative emotiosn such
     * as distress. Otherwise it is not monitored by the agents.
     *
     * @param message message containing the hostile polymorph message
     */
    public void generatePolymorphActionBiteEvent(GlobalChat message) {
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        //fears - confirmed
        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(1.0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("PolymorphFearId:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.POLYMORPH_HOSTILE_FEARS_CONFIRMED_EVENT);

        //fear
        agentEEC.setDesirability(-0.8);
        agentEEC.setPraiseworthiness(0);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0.6);
        agentEEC.setLiking(0);
        agentEEC.setRealization(1.0);
        agentEEC.setAgency(BasicEEC.Agency.SELF);
        agentEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.POLYMORPH_HOSTILE_BITE_ACT);
    }

    /**
     * Someone is making proposal to other agent (and none of them is currently with us).
     * We will generate emotions just in case we have positive feelings toward the
     * agent who is making the proposal. The emotion intensities are dependent on
     * the type of proposal  kiss and sex proposals generate high negative emotions
     * while other proposals just low negative emotions.
     * Emotions: distress and disliking
     *
     * @param message message containing the proposal of some other agent to someone
     * @param type type of the proposal sent
     */
    public void generateProposalToOtherEvent(GlobalChat message, ProposalType type) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.3;
        double appealingness = -0.3;

        if (type == ProposalType.KISS || type == ProposalType.SEX) {
            desirability = -0.7;
            appealingness = -0.7;
        }

        //generate something just if we have feelings toward the agent
        if (myAgent.myEmotionState.getFeeling(message.getId().getId()) > 0) {

            //distress
            eventEEC.setDesirability(desirability);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_TO_OTHER_EVENT);

            //disliking
            actEEC.setDesirability(0);
            actEEC.setPraiseworthiness(0);
            actEEC.setAppealingness(appealingness);
            actEEC.setLikelihood(0);
            actEEC.setLiking(0);
            actEEC.setRealization(0);
            actEEC.setAgency(BasicEEC.Agency.SELF);
            actEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_TO_OTHER_ACT);
        }
    }

    /**
     * Someone is responding to proposal to other agent (and none of them is
     * currently with us). We will generate emotions just in case we have positive
     * feelings toward the agent who is responding to the proposal. If he accepts
     * the proposal we will generate negative emotions and vice versa. The intensity
     * is also dependent on the type of proposal  kiss and sex proposals generate
     * medium positive/negative emotions while other proposals just low
     * positive/negative emotions.
     * Emotions: joy and liking (in case the proposal was rejected) or distress and disliking
     * (in case the proposal was accepted)
     *
     * @param message message containing the proposal response
     * @param type type of the proposal
     * @param bAccepted true if it was accepted, false otherwise
     */
    public void generateProposalOtherResponseEvent(GlobalChat message, ProposalType type, boolean bAccepted) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.1;
        double appealingness = -0.1;

        int agentId = message.getId().getId();

        //we will generate something just if we have positive feeling to the agent
        if (myAgent.myEmotionState.getFeeling(agentId) > 0) {
            if (type == ProposalType.KISS) {
                if (bAccepted) {
                    desirability = -0.5;
                    appealingness = -0.5;
                } else {
                    desirability = 0.3;
                    appealingness = 0.3;
                }
            } else if (type == ProposalType.SEX) {
                if (bAccepted) {
                    desirability = -0.6;
                    appealingness = -0.6;
                } else {
                    desirability = 0.3;
                    appealingness = 0.3;
                }
            } else {
                if (bAccepted) {
                    //
                    desirability = -0.2;
                    appealingness = -0.2;
                } else {
                    desirability = 0.2;
                    appealingness = 0.2;
                }
            }

            eventEEC.setDesirability(desirability);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + agentId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_RESPONSE_TO_OTHER_EVENT);

            actEEC.setDesirability(0);
            actEEC.setPraiseworthiness(0);
            actEEC.setAppealingness(appealingness);
            actEEC.setLikelihood(0);
            actEEC.setLiking(0);
            actEEC.setRealization(0);
            actEEC.setAgency(BasicEEC.Agency.SELF);
            actEEC.setElicitor("Id:" + agentId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_RESPONSE_TO_OTHER_ACT);
        }
    }

    /**
     * The agent we are currently with is responding to proposal made by other agent.
     * This is the same as with generateProposalOtherResponse event above, except
     * the emotion intensities are medium to high.
     * Emotions: joy and liking (in case the proposal was rejected) or distress and
     * disliking (in case the proposal was accepted)
     *
     * @param message message containing the proposal response
     * @param proposalType type of the proposal
     * @param bAccepted true if the proposal was accepted, false otherwise
     */
    public void generateProposalResponseToOtherByAgentWithEvent(GlobalChat message, ProposalType proposalType, boolean bAccepted) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.1;
        double appealingness = -0.1;

        int agentId = message.getId().getId();//in fact agentWith id

        //we will generate something just if we have positive feeling to the agent
        if (myAgent.myEmotionState.getFeeling(agentId) > 0) {
            if (proposalType == ProposalType.KISS) {
                if (bAccepted) {
                    desirability = -0.8;
                    appealingness = -0.8;
                } else {
                    desirability = 0.4;
                    appealingness = 0.4;
                }
            } else if (proposalType == ProposalType.LEAVE) {
                if (bAccepted) {
                    //we've been left by agentWith!!
                    desirability = -0.8;
                    appealingness = -0.8;
                } else {
                    desirability = 0.4;
                    appealingness = 0.4;
                }
            } else {
                if (bAccepted) {
                    //
                    desirability = -0.4;
                    appealingness = -0.4;
                } else {
                    desirability = 0.3;
                    appealingness = 0.3;
                }
            }

            eventEEC.setDesirability(desirability);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + agentId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_RESPONSE_TO_OTHER_EVENT);

            actEEC.setDesirability(0);
            actEEC.setPraiseworthiness(0);
            actEEC.setAppealingness(appealingness);
            actEEC.setLikelihood(0);
            actEEC.setLiking(0);
            actEEC.setRealization(0);
            actEEC.setAgency(BasicEEC.Agency.SELF);
            actEEC.setElicitor("Id:" + agentId);

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_RESPONSE_TO_OTHER_ACT);
        }
    }

    /**
     * The agent we are currently with is making proposal to other agent.
     * This is the same as above with generateProposalOtherMaking, except the
     * emotions generated are slightly higher.
     * Emotions: distress and disliking
     *
     * @param message message containing the proposal from agentWith
     * @param type type of the proposal
     */
    public void generateProposalToOtherByAgentWithEvent(GlobalChat message, ProposalType type) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.3;
        double appealingness = -0.3;

        if (type == ProposalType.KISS || type == ProposalType.SEX) {
            desirability = -0.8;
            appealingness = -0.8;
        }

        //generate something just if we have feelings toward the agent
        if (myAgent.myEmotionState.getFeeling(message.getId().getId()) > 0) {

            eventEEC.setDesirability(desirability);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_TO_OTHER_EVENT);

            actEEC.setDesirability(0);
            actEEC.setPraiseworthiness(0);
            actEEC.setAppealingness(appealingness);
            actEEC.setLikelihood(0);
            actEEC.setLiking(0);
            actEEC.setRealization(0);
            actEEC.setAgency(BasicEEC.Agency.SELF);
            actEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_TO_OTHER_ACT);
        }
    }

    /**
     * Someone is making a proposal toward agent we are currently with! We will
     * generate negative emotions with intensities depending on the type of the
     * proposal. Sex and kiss proposals will trigger emotions with higher intensities.
     * Emotions: distress and disliking
     *
     * @param message message containing the proposal for agentWith
     * @param type type of the proposal
     */
    public void generateProposalByOtherToAgentWithEvent(GlobalChat message, ProposalType type) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.4;
        double appealingness = -0.4;

        if (type == ProposalType.KISS || type == ProposalType.SEX) {
            desirability = -0.8;
            appealingness = -0.8;
        }


        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_BY_OTHER_TO_AGENT_WITH_EVENT);

        actEEC.setDesirability(0);
        actEEC.setPraiseworthiness(0);
        actEEC.setAppealingness(appealingness);
        actEEC.setLikelihood(0);
        actEEC.setLiking(0);
        actEEC.setRealization(0);
        actEEC.setAgency(BasicEEC.Agency.SELF);
        actEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_BY_OTHER_TO_AGENT_WITH_ACT);

    }

    /**
     * Someone has responded to our proposal. If accepted we will generate positive
     * emotions and vice versa. The feeling toward agent is not important here.
     * Emotions: joy and liking (if the proposal was accepted) or distress and disliking
     * (if the proposal was rejected)
     *
     * @param accepted true if the proposal was accepted
     * @param message message containing the proposal response
     */
    public void generateProposalResponseEvent(boolean accepted, GlobalChat message) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        if (accepted) {
            eventEEC.setDesirability(0.5);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_ACCEPTED_EVENT);

            actEEC.setDesirability(0);
            actEEC.setPraiseworthiness(0);
            actEEC.setAppealingness(0.5);
            actEEC.setLikelihood(0);
            actEEC.setLiking(0);
            actEEC.setRealization(0);
            actEEC.setAgency(BasicEEC.Agency.SELF);
            actEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_ACCEPTED_ACT);
        } else {
            eventEEC.setDesirability(-0.5);
            eventEEC.setPraiseworthiness(0);
            eventEEC.setAppealingness(0);
            eventEEC.setLikelihood(0);
            eventEEC.setLiking(0);
            eventEEC.setRealization(0);
            eventEEC.setAgency(BasicEEC.Agency.SELF);
            eventEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_REJECTED_EVENT);

            actEEC.setDesirability(0);
            actEEC.setPraiseworthiness(0);
            actEEC.setAppealingness(-0.5);
            actEEC.setLikelihood(0);
            actEEC.setLiking(0);
            actEEC.setRealization(0);
            actEEC.setAgency(BasicEEC.Agency.SELF);
            actEEC.setElicitor("Id:" + message.getId().getId());

            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.PROPOSAL_REJECTED_ACT);
        }
    }

    /**
     * Someone we have made proposal to is not responding to it (he ignored our proposal).
     * We will be a bit unhappy by this.
     * Emotions: anger
     *
     * @param id agent that ignored our proposal
     */
    public void generateProposalIgnoreEvent(int id) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        eventEEC.setDesirability(-0.2);
        eventEEC.setPraiseworthiness(-0.2);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        //TODO: rewrite as Id: after successfull testing
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_IGNORED_ACT);
    }

    /**
     * We are close to hostile polymorph who is making bad noises. We are afraid
     * of him and don't like him. There is ongoing reduction of intensity based
     * on the number of the negative messages the polymorph has made to us.
     * Emotions: dislike and fear
     *
     * @param message message containing the hostile polymorph message
     * @param reduction we will reduce the emotion intensity by this
     */
    public void generatePolymorphDislikeFearEvent(GlobalChat message, double reduction) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC fearEventEEC = BasicEEC.Factory.newInstance();

        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(-1 / reduction);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.POLYMORPH_HOSTILE_MESSAGE_EVENT);

        fearEventEEC.setDesirability(-1 / reduction);
        fearEventEEC.setPraiseworthiness(0);
        fearEventEEC.setAppealingness(0);
        fearEventEEC.setLikelihood(1 / reduction);
        fearEventEEC.setLiking(0);
        fearEventEEC.setRealization(0);
        fearEventEEC.setAgency(BasicEEC.Agency.SELF);
        fearEventEEC.setElicitor("PolymorphFearId:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), fearEventEEC), EventId.POLYMORPH_HOSTILE_FEAR_EVENT);
    }

    /**
     * The polymorph has damaged us  caused our health to be lower. Not generated
     * right now, will be probably erased and just PolymorphActionBiteEvent will be used.
     * Emotions: fear confirmed and fear
     * 
     * @todo Remove this method? OR Check if it is really the polymorph who damaged us
     *
     * @param bd message containing the information about who damaged us
     */
    public void generatePolymorphBiteEvent(BotDamaged bd) {
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        //fears - confirmed
        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(1.0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("PolymorphFearId:" + bd.getInstigator().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.POLYMORPH_HOSTILE_FEARS_CONFIRMED_EVENT);

        //fear
        agentEEC.setDesirability(-0.8);
        agentEEC.setPraiseworthiness(0);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0.6);
        agentEEC.setLiking(0);
        agentEEC.setRealization(1.0);
        agentEEC.setAgency(BasicEEC.Agency.SELF);
        agentEEC.setElicitor("Id:" + bd.getInstigator().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.POLYMORPH_HOSTILE_BITE_ACT);
    }

    /**
     * We have encountered friendly polymorph and he is making friendly noises toward us.
     * There is ongoing reduction of intensity based on the number of messages
     * the polymorph has made to us.
     * Emotions: liking
     *
     * @param message message containing the friendly polymoprh message
     * @param reduction we will reduce the emotion intensity by this number
     */
    public void generatePolymorphLikeEvent(GlobalChat message, double reduction) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        eventEEC.setDesirability(0);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(1 / reduction);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.POLYMORPH_FRIENDLY_MESSAGE_EVENT);
    }

    /**
     * We were waiting for the agent and the agent didn't come to us in time.
     * Emotions: distress and disliking
     *
     * @param agent agent that we were waiting for
     */
    public void generateWaitAgentNotReturnedEvent(Player agent) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.6;
        double appealingness = -0.6;

        int id = agent.getId().getId();

        //distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.WAIT_AGENT_NOT_RETURNED_EVENT);

        //disliking
        actEEC.setDesirability(0);
        actEEC.setPraiseworthiness(0);
        actEEC.setAppealingness(appealingness);
        actEEC.setLikelihood(0);
        actEEC.setLiking(0);
        actEEC.setRealization(0);
        actEEC.setAgency(BasicEEC.Agency.SELF);
        actEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.WAIT_AGENT_NOT_RETURNED_ACT);
    }

    /**
     * We were waiting for the agent and the agent returned in time.
     * Emotions: joy and liking
     *
     * @param agent agent we were waiting for and now has returned
     */
    public void generateWaitAgentReturnedEvent(Player agent) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = 0.6;
        double appealingness = 0.6;

        int id = agent.getId().getId();

        //joy
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.WAIT_AGENT_RETURNED_EVENT);

        //liking
        actEEC.setDesirability(0);
        actEEC.setPraiseworthiness(0);
        actEEC.setAppealingness(appealingness);
        actEEC.setLikelihood(0);
        actEEC.setLiking(0);
        actEEC.setRealization(0);
        actEEC.setAgency(BasicEEC.Agency.SELF);
        actEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.WAIT_AGENT_RETURNED_ACT);
    }

    /**
     * We are currently waiting on the agent. Every few seconds this event is
     * generated while waiting.
     * Emotions: distress and anger
     *
     * @param agent agent we are waiting for
     */
    public void generateWaitInProgressEvent(Player agent) {
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = -0.3;
        double praiseworthiness = -0.4;

        int id = agent.getId().getId();

        //distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.WAIT_IN_PROGRESS_EVENT);

        //anger
        actEEC.setDesirability(desirability);
        actEEC.setPraiseworthiness(praiseworthiness);
        actEEC.setAppealingness(0);
        actEEC.setLikelihood(0);
        actEEC.setLiking(0);
        actEEC.setRealization(0);
        actEEC.setAgency(BasicEEC.Agency.SELF);
        actEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.WAIT_IN_PROGRESS_ACT);
    }

    /**
     * We have hit the polymorph with the gun  we are proud on ourselves.
     * Emotions: joy and pride
     *
     * @todo some check we hit the polymorph here?
     * @param pd message containing the information about hit we have made
     */
    public void generateWeHitPolymorphEvent(PlayerDamaged pd) {
        BasicEEC agentEEC = BasicEEC.Factory.newInstance();
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        //joy
        eventEEC.setDesirability(0.8);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("PolymorphHitId:" + pd.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.POLYMORPH_HIT_EVENT);

        //pride
        agentEEC.setDesirability(0);
        agentEEC.setPraiseworthiness(0.9);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.SELF);
        agentEEC.setElicitor("PolymorphHitActId:" + pd.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.POLYMORPH_HIT_ACT);
    }

    /**
     * We have received item from someone. We will react based on the feeling
     * toward the giver and on the type of the item. Generally we will be pleased,
     * just if the item is condom, then we will be offended unless the feeling
     * toward the agent is high.
     * Emotions: joy and liking (medium for flower or condom and feeling high) or
     * distress and disliking (condom and feeling low)
     * 
     * @param itemType type of the item we have received
     * @param id agent who gave us the item
     */
    public void generateReceivedItemEvent(ScenarioItemType itemType, int id) {

        BasicEEC eventEEC = BasicEEC.Factory.newInstance();
        BasicEEC actEEC = BasicEEC.Factory.newInstance();

        double desirability = 0.1;
        double appealingness = 0.1;

        if (itemType == ScenarioItemType.FLOWER) {
            desirability = 0.5;
            appealingness = 0.5;
        //TODO feeling
        } else if (itemType == ScenarioItemType.CONDOM) {
            if (myEmotionState.getFeeling(id) > 0.8) {
                desirability = 0.5;
                appealingness = 0.5;
            } else {
                desirability = -0.5;
                appealingness = -0.5;
            }
        } else {
            desirability = 0.1;
            appealingness = 0.1;
        }

        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.ITEM_RECEIVED_EVENT);

        //liking/disliking
        actEEC.setDesirability(0);
        actEEC.setPraiseworthiness(0);
        actEEC.setAppealingness(appealingness);
        actEEC.setLikelihood(0);
        actEEC.setLiking(0);
        actEEC.setRealization(0);
        actEEC.setAgency(BasicEEC.Agency.SELF);
        actEEC.setElicitor("Id:" + id);

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), actEEC), EventId.ITEM_RECEIVED_ACT);
    }

    /**
     * Someone has made proposal to us. We will react based on the feelings toward
     * the other agent. If the proposal will be accepted we are happy, if we will
     * reject it we will be offended by kiss or sex proposals. If we don't like the
     * agent (feeling negative) we will be offended a little by any proposal and vice
     * versa (except the kiss and sex proposals, that are handled separately).
     * Emotions: joy and gratitude or distress and anger
     * 
     * @param message message containing the proposal from other agent
     * @param type type of the proposal
     * @param agentWith the agent who made the proposal
     * @param agentInterrupters list of all agent interrupters if the proposal is
     * proposal leave we will check if we  want to leave the agents - if we like
     * them too much we will be unhappy that someone is asking us to leave
     */
    public void generateReceivedProposalEvent(GlobalChat message, ProposalType type, Player agentWith, Collection<Player> agentInterrupters) {

        BasicEEC agentEEC = BasicEEC.Factory.newInstance();
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        double desirability = 0.1;
        double praiseworthiness = 0.1;

        if ((type == ProposalType.SEX) && (myEmotionState.getFeeling(message.getId().getId()) < myAgent.sexFeelingConst)) {
            desirability = -0.3;
            praiseworthiness = -0.3;
        } else if (type == ProposalType.SEX) {
            //we like the agent - feeling higher than kissFeelingconst
            desirability = 0.5;
            praiseworthiness = 0.5;
        }

        if ((type == ProposalType.KISS) && (myEmotionState.getFeeling(message.getId().getId()) < myAgent.kissFeelingConst)) {
            desirability = -0.1;
            praiseworthiness = -0.1;
        } else if (type == ProposalType.KISS) {
            //we like the agent - feeling higher than kissFeelingconst
            desirability = 0.4;
            praiseworthiness = 0.4;
        }

        if (myEmotionState.getFeeling(message.getId().getId()) < 0) {
            //dont like proposals from people we dont like
            desirability = -0.2;
            praiseworthiness = -0.2;
        }

        if ((type != ProposalType.KISS) && (type != ProposalType.LEAVE) && (myEmotionState.getFeeling(message.getId().getId()) > 0)) {
            //like proposals from people we like
            desirability = 0.2;
            praiseworthiness = 0.2;
        }

        //if agentWith is asking to leave our beloved thing
        if (agentWith != null) {
            if (message.getId().getId() == agentWith.getId().getId()) {
                //the proposal is from agentWith
                if ((type == ProposalType.LEAVE) && (!agentInterrupters.isEmpty()) && (myEmotionState.getFeeling(myAgent.pickHighestFeelingPlayer(agentInterrupters).getId().getId()) > myAgent.cuddleFeelingConst)) {
                    desirability = -0.5;
                    praiseworthiness = -0.5;
                }
            }
        }

        //anger/gratitude - TODO - changed, wasn't here
        agentEEC.setDesirability(desirability);
        agentEEC.setPraiseworthiness(praiseworthiness);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);
        agentEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.PROPOSAL_RECEIVED_ACT);

        //joy/distress
        eventEEC.setDesirability(desirability);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.SELF);
        eventEEC.setElicitor("Id:" + message.getId().getId());

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PROPOSAL_RECEIVED_EVENT);
    }

    /**
     * Shouldn't happen in the scenario. Left from previous implementations.
     *
     * @param pk message containing the info about player killed
     */
    public void generatePlayerKilledEvent(PlayerKilled pk) {

        BasicEEC agentEEC = BasicEEC.Factory.newInstance();
        BasicEEC eventEEC = BasicEEC.Factory.newInstance();

        agentEEC.setDesirability(0);
        agentEEC.setPraiseworthiness(-0.4);
        agentEEC.setAppealingness(0);
        agentEEC.setLikelihood(0);
        agentEEC.setLiking(0);
        agentEEC.setRealization(0);
        agentEEC.setAgency(BasicEEC.Agency.OTHER);

        //We will send agentEEC just when we know who did it.
        if (pk.getKiller().getId() != 0) {
            agentEEC.setElicitor("Id:" + pk.getKiller().getId());
            this.myEmotionState.insertEmotionObject(pk.getKiller().getId());
            this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), agentEEC), EventId.PLAYER_KILLED_ACT);
        }

        eventEEC.setDesirability(-0.4);
        eventEEC.setPraiseworthiness(0);
        eventEEC.setAppealingness(0);
        eventEEC.setLikelihood(0);
        eventEEC.setLiking(0);
        eventEEC.setRealization(0);
        eventEEC.setAgency(BasicEEC.Agency.OTHER);
        eventEEC.setElicitor("PlayerKilledEvent");

        this.emModel.processAffectInput(emModel.createAffectInput(myAgent.getMyName(), eventEEC), EventId.PLAYER_KILLED_EVENT);


    }

    /**
     * Calculates S-curve for point x in the interval 0 .. normV
     *
     * @param x input coordinate
     * @param normV scale value which corresponds to 1.0 if x is normalized
     * @param sharpness adjusts steepness of curve (value of 1 equals undistorted sigmoid)
     *
     * @return sigmoid for point X
     */
    public double sigmoid(double x, double normV, double sharpness) {
        x = (x / normV * 2 - 1) * 5 * sharpness;
        return 1.0 / (1.0 + Math.exp(-x));
    }

    /**
     * Only constructor for this class. Requires several other objects.
     *
     * @param inputModel emotion model we are using (ALMA)
     * @param myEmState class that holds emotion and feeling information
     * @param myAgent the agent we are generating emotion events for
     */
    public AEventGenerator(PogamutALMA inputModel, AEmotionState myEmState, EmotionalBot myAgent) {
        this.myAgent = myAgent;
        this.emModel = inputModel;
        this.myEmotionState = myEmState;
    }
}
