/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package almabasedmodel;

import bot.EmotionalBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import de.affect.emotion.Emotion;
import de.affect.emotion.EmotionType;
import de.affect.mood.Mood;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.List;

/**
 * This class is used to count and store the feeling toward other agents in the scenario
 * and provides interface between ALMA and our agent.
 * 
 * Feeling is counted from the emotions that are caused by other agents in the scenario.
 * These emotions are used for counting the feeling: love, hate, liking, disliking,
 * joy, distress, anger and gratitude. Love, hate, liking and disliking creates fixed 
 * feeling part - these emotions are remebered and can change a little during the scenario.
 * The second, dynamic part of the feeling is counted from emotions joy, distress, anger and
 * gratitude. These emotions are not remembered and in ALMA they decay over time. 
 *
 *
 * @author Knight
 */
public class AEmotionState {

    /** Pointer toward ALMA emotion model */
    public PogamutALMA myALMA;

    /** Pointer toward our agent */
    public EmotionalBot myAgent;
    /** Here we store current mood of the agent - not used right now */
    public AMood currentMood = new AMood();

    /** Here we store mood history of the agent - not used right now */
    public ArrayList<AMood> moodHistory = new ArrayList<AMood>();

    /** Here the fixed part of the feeling is stored for all agents. */
    public HashMap<Integer, HashMap<EmotionType,AEmotion>> feelingsHistory = new HashMap<Integer, HashMap<EmotionType,AEmotion>>();

    /** Here we store ids of all agents in the scenario, so we can get emotions towards them from ALMA*/
    public ArrayList<Integer> emotionObjects = new ArrayList<Integer>();

    /**
     * Only constructor for this class, requires few other objects.
     *
     * @param alma our ALMA emotion model
     * @param myAgent our agent
     */
    public AEmotionState(PogamutALMA alma, EmotionalBot myAgent)
    {
        myALMA = alma;
        this.myAgent = myAgent;
    }

    /**
     * Decay all our stored emotions by some const.
     */
    public void decayFeelings() {
        
        for ( HashMap<EmotionType,AEmotion> tempMap : feelingsHistory.values()){
            for (AEmotion aem : tempMap.values()){
                aem.setIntensity(aem.getIntensity() * 0.95);
            }
        }
        
    }

    /**
     * Updates our feelingsHistory, so we have emotions we felt to all objects
     */
    public void processFeelings() {

        Emotion almaEm = null;
        AEmotion oppositeEmotion = null;
        AEmotion aem = null;
        double tempIntensity = 0;

        //Iterate through all objects that caused some emotion event
        for (int i : emotionObjects){

            if (!feelingsHistory.containsKey(i)){
                feelingsHistory.put(i, new HashMap<EmotionType,AEmotion>());
                //add four monitored emotions
                feelingsHistory.get(i).put(EmotionType.Love, new AEmotion(EmotionType.Love,0,"Id:"+i,i));
                feelingsHistory.get(i).put(EmotionType.Hate, new AEmotion(EmotionType.Hate,0,"Id:"+i,i));
                feelingsHistory.get(i).put(EmotionType.Liking, new AEmotion(EmotionType.Liking,0,"Id:"+i,i));
                feelingsHistory.get(i).put(EmotionType.Disliking, new AEmotion(EmotionType.Disliking,0,"Id:"+i,i));
            }

            //update four monitored emotions
            almaEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+i, EmotionType.Love);
            if (almaEm != null){
                aem = feelingsHistory.get(i).get(almaEm.getType());                
                if (aem.getIntensity() < almaEm.getIntensity()){
                    aem.setIntensity(almaEm.getIntensity());
                    oppositeEmotion = feelingsHistory.get(i).get(EmotionType.Hate);
                    tempIntensity = oppositeEmotion.getIntensity();
                    if (tempIntensity > (aem.getIntensity()/2)){
                        oppositeEmotion.setIntensity(tempIntensity - (aem.getIntensity()/2));
                    } else
                        oppositeEmotion.setIntensity(0);
                }
            }
            
            almaEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+i, EmotionType.Hate);
            if (almaEm != null){
                aem = feelingsHistory.get(i).get(almaEm.getType());
                if (aem.getIntensity() < almaEm.getIntensity()){
                    aem.setIntensity(almaEm.getIntensity());
                    oppositeEmotion = feelingsHistory.get(i).get(EmotionType.Love);
                    tempIntensity = oppositeEmotion.getIntensity();
                    if (tempIntensity > (aem.getIntensity()/2)){
                        oppositeEmotion.setIntensity(tempIntensity - (aem.getIntensity()/2));
                    } else
                        oppositeEmotion.setIntensity(0);
                }
            }

            almaEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+i, EmotionType.Liking);
            if (almaEm != null){
                aem = feelingsHistory.get(i).get(almaEm.getType());
                if (aem.getIntensity() < almaEm.getIntensity()){
                    aem.setIntensity(almaEm.getIntensity());
                    oppositeEmotion = feelingsHistory.get(i).get(EmotionType.Disliking);
                    tempIntensity = oppositeEmotion.getIntensity();
                    if (tempIntensity > (aem.getIntensity()/2)){
                        oppositeEmotion.setIntensity(tempIntensity - (aem.getIntensity()/2));
                    } else
                        oppositeEmotion.setIntensity(0);
                }
            }

            almaEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+i, EmotionType.Disliking);
            if (almaEm != null){
                aem = feelingsHistory.get(i).get(almaEm.getType());
                if (aem.getIntensity() < almaEm.getIntensity()){
                    aem.setIntensity(almaEm.getIntensity());
                    oppositeEmotion = feelingsHistory.get(i).get(EmotionType.Liking);
                    tempIntensity = oppositeEmotion.getIntensity();
                    if (tempIntensity > (aem.getIntensity()/2)){
                        oppositeEmotion.setIntensity(tempIntensity - (aem.getIntensity()/2));
                    } else
                        oppositeEmotion.setIntensity(0);
                }
            }
        }        
    }

    /**
     * Updates current emotions and mood
     */
    public void processEmotions() {

        Mood almaMood;

        //Update mood
        almaMood = myALMA.getCurrentMood(myAgent.getMyName());
        moodHistory.add(currentMood);

        //Keep mood history size at 20
        if (moodHistory.size() > 20){
            moodHistory.remove(0);
        }

        currentMood = new AMood(almaMood.getPleasure(), almaMood.getArousal(), almaMood.getDominance());
    }

    /**
     * Returns the list of ALMA current emotions for our agent.
     *
     * @return list of current emotions from ALMA
     */
    public ArrayList<AEmotion> getCurrentEmotions(){

        ArrayList<AEmotion> result = new ArrayList<AEmotion>();

        for (Emotion em : myALMA.getCurrentEmotions(myAgent.getMyName())){
            result.add(new AEmotion(em.getType(), em.getIntensity(), em.getElicitor().toString(),  parseId(em.getElicitor().toString())));
        }

        return result;
    }

    /**
     * Returns the current dominant emotion from ALMA.
     *
     * @return current dominant emotion
     */
    public AEmotion getCurrentDominantEmotion()
    {
        AEmotion winner = null;

        for (Emotion em : myALMA.getCurrentEmotions(myAgent.getMyName())){

            if (winner == null){
                winner = new AEmotion(em.getType(), em.getIntensity(), em.getElicitor().toString(),  parseId(em.getElicitor().toString()));
            } else {
                if (winner.getIntensity() < em.getIntensity()){
                    winner = new AEmotion(em.getType(), em.getIntensity(), em.getElicitor().toString(),  parseId(em.getElicitor().toString()));
                }
            }
        }

        return winner;
    }


    /**
     * Returns intensity of emotion towards elicitor of input type.
     *
     * @param id agent the emotion is associated with
     * @param type type of the emotion
     * @return emotion intensity
     */
    public double getAlmaEmotionIntensity(int id, EmotionType type) {
        Emotion emTemp = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+id, type);
        if (emTemp != null)
            return emTemp.getIntensity();
        else
            return 0;
    }

    /**
     * Returns agent current mood.
     *
     * @return agent current mood
     */
    public AMood getCurrentMood(){
        return currentMood;
    }
    
    /**
     * Here we get a feeling toward agent - either positive or negative. Feeling is counted
     * from these emotions: + gratitude/2, - anger * 2, + joy, - distress, + love * 1.5,
     * - hate * 1.5, + liking, - disliking.
     *
     * @param id agent that the feeling is associated with
     * @return feeling intensity (Max feeling is 4, min feeling is -5.5 (2.5 and -2.5 for "fixed" feeling))
     */
    public double getFeeling(int id) {        
        double result = 0.0;
        Emotion tempEm = null;

        //max = 4, min = -5.5 (2.5 and -2.5 for "hard" feelings)
        if (feelingsHistory.containsKey(id)) {

            tempEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+id, EmotionType.Gratitude);
            if (tempEm != null)
                result += tempEm.getIntensity() / 2;

            tempEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+id, EmotionType.Anger);
            if (tempEm != null)
                result -= tempEm.getIntensity() * 2;
            
            tempEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+id, EmotionType.Joy);
            if (tempEm != null)
                result += tempEm.getIntensity();

            tempEm = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+id, EmotionType.Distress);
            if (tempEm != null)
                result -= tempEm.getIntensity();

            HashMap<EmotionType,AEmotion> tempMap = feelingsHistory.get(id);
            if (tempMap.containsKey(EmotionType.Love))
                result += tempMap.get(EmotionType.Love).getIntensity() * 1.5;

            if (tempMap.containsKey(EmotionType.Hate))
                result -= tempMap.get(EmotionType.Hate).getIntensity() * 1.5;

            if (tempMap.containsKey(EmotionType.Liking))
                result += tempMap.get(EmotionType.Liking).getIntensity();

            if (tempMap.containsKey(EmotionType.Disliking))
                result -= tempMap.get(EmotionType.Disliking).getIntensity();

        }

        return result;
    }

    /**
     * Here we will process our feelings and emotions and generate appropriate 
     * smilies string that will be used in our agent messages.
     *
     * @param plr agent we want to generate smilies string for
     * @return string containing the smilies for the agent (reflecting our feeling)
     */
    public String getSmiliesString(Player plr){

        double AngerFearRatio, LikingDislikingRatio, JoyDistressRatio;
        int smiliesCount, kissesCount, angerCount;
        String resultMessage = "";
        HashMap<EmotionType, AEmotion> playerEmotions = null;
        Emotion emTemp;

        if (feelingsHistory.containsKey(plr.getId().getId())){

            playerEmotions = feelingsHistory.get(plr.getId().getId());

            AngerFearRatio = 0;
            LikingDislikingRatio = 0;
            JoyDistressRatio = 0;


            LikingDislikingRatio = getFeeling(plr.getId().getId());

            emTemp = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+plr.getId().getId(), EmotionType.Joy);
            if (emTemp != null){
                JoyDistressRatio += emTemp.getIntensity();
            }

            emTemp = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+plr.getId().getId(), EmotionType.Distress);
            if (emTemp != null){
                JoyDistressRatio -= emTemp.getIntensity();
            }

            emTemp = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+plr.getId().getId(), EmotionType.Anger);
            if (emTemp != null){
                AngerFearRatio += emTemp.getIntensity();
            }

            emTemp = myALMA.getEmotionForElicitor(myAgent.getMyName(), "Id:"+plr.getId().getId(), EmotionType.Fear);
            if (emTemp != null){
                AngerFearRatio -= emTemp.getIntensity();
            }

            
            if (LikingDislikingRatio > 0) {
                kissesCount = (int) Math.round(LikingDislikingRatio * 1.375);
            } else {
                kissesCount = (int) Math.round(LikingDislikingRatio);
            }

            kissesCount = Math.min(kissesCount, 5);
            kissesCount = Math.max(kissesCount, -5);
            if (kissesCount > 0){
                for (int i = 0; i < kissesCount; i++){
                    resultMessage = resultMessage + ":-* ";
                }
            } else {
                for (int i = 0; i < Math.abs(kissesCount); i++){
                    resultMessage = resultMessage + ">:@ ";
                }
            }
            
            smiliesCount = (int) Math.round(JoyDistressRatio * 5);

            smiliesCount = Math.min(smiliesCount, 5);
            smiliesCount = Math.max(smiliesCount, -5);

            if (smiliesCount > 0){
                for (int i = 0; i < smiliesCount; i++){
                    resultMessage = resultMessage + ":-) ";
                }
            } else {
                for (int i = 0; i < Math.abs(smiliesCount); i++){
                    resultMessage = resultMessage + ":-( ";
                }
            }

            angerCount = (int) Math.round(AngerFearRatio * 5);

            angerCount = Math.min(angerCount, 5);
            angerCount = Math.max(angerCount, -5);
            if (angerCount > 0){
                for (int i = 0; i < angerCount; i++){
                    resultMessage = resultMessage + "#! ";
                }
            } else {
                for (int i = 0; i < Math.abs(angerCount); i++){
                    resultMessage = resultMessage + ":-O ";
                }
            }

           // getLogger().user().warning("Smilies " + smiliesCount + "JoyDistress " + JoyDistressRatio + "Result message: " + resultMessage);

            return resultMessage;
        }

        return "";
    }

    /**
     * Parses elicitor (in string format) for int UnrealId
     *
     * @param stringId - string to parse
     * @return parsed unreal id, or -1
     */
    public int parseId(String stringId) {

        String[] tmpArray;
        String tmp;

        //myALMA.myAgent.getLogger().user().info("!!!!!!!!!!!!!!!!!!!111:"+stringId);

        if ((stringId != null) && stringId.contains("Id:")) {
            tmpArray = stringId.split("Id:");
            tmp = tmpArray[tmpArray.length - 1];
            return Integer.valueOf(tmp).intValue();
        } else
            return -1;
    }

    /**
     * Checks if emotionObjects already contains the id we want to add. If not, we will add it.
     *
     * @param newId - id to add
     */
    public void insertEmotionObject(int newId){
        boolean bFound = false;

        for (int id : this.emotionObjects) {
            if (id == newId) {
                bFound = true;
                break;
            }
        }
        if (!bFound){
            this.emotionObjects.add(newId);
        }
    }

}
