/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package almabasedmodel;

import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import de.affect.emotion.EmotionType;
import java.io.Serializable;

/**
 * This class is used to store ALMA emotions outside ALMA.
 *
 * Implements serializable, because it is logged!
 *
 * @author Knight
 */
public class AEmotion implements Serializable {

    /** Type of the emotion - EmotionType defined in ALMA */
    private EmotionType type = EmotionType.Undefined;

    /** Intensity of the emotion, ranges from 0 to 1 */
    private Double intensity = 0.0;

    /** Elicitor of the emotion - who have caused this emotion to be felt? */
    private String elicitor = "";

    /** If elicitor is an agent, his id will be here, -1 otherwise */
    private int elicitorId = -1;

    /**
     * Gets emotion type.
     *
     * @return emotion type
     */
    public EmotionType getType()
    {
        return type;
    }

    /**
     * Gets emotion intensity.
     *
     * @return emotion intensity
     */
    public double getIntensity()
    {
        return intensity;
    }

    /**
     * Gets emotion elicitor - the cause of the emotion.
     *
     * @return emotion elicitor
     */
    public String getElicitor()
    {
        return elicitor;
    }

    /**
     * If elicitor is an agent, his id can be got by this method.
     *
     * @return agent id - if the elicitor is an agent
     */
    public int getElicitorId()
    {
        return elicitorId;
    }

    /**
     * Sets type of the emotion.
     *
     * @param newType emotion type
     */
    public void setType(EmotionType newType)
    {
        type = newType;
    }

    /**
     * Sets the intensity of the emotion. Ranges from 0 to 1.
     *
     * @param newInt new intensity
     */
    public void setIntensity(double newInt)
    {
        intensity = newInt;
    }

    /**
     * Sets the elicitor - the emotion cause - for the emotion.
     *
     * @param newElicitor new elicitor
     */
    public void setElicitor(String newElicitor)
    {
        elicitor = newElicitor;
    }

    /**
     * Sets elicitor id.
     *
     * @param newId new id.
     */
    public void setElicitorId(int newId)
    {
        elicitorId = newId;
    }

    /**
     * toString method define the way we want our object to be printed in the console,
     * and/or transfered to String.
     *
     * @return string serialization of this object
     */
    @Override
    public String toString(){

        //String tmp;

        //tmp = intensity.toString().substring(0, intensity.toString().indexOf(".")) + intensity.toString().substring(intensity.toString().indexOf("."),intensity.toString().indexOf(".")+4);


        return type.toString() + " I.: " + intensity + " Elicitor: " + elicitor + " ElicitorId: " + elicitorId + "\n";
    }

    /**
     * Constructor for this class. Requires type of the emotion, its intensity, elicitor
     * and elicitor id if the elicitor is an agent.
     *
     * @param type type of the emotion
     * @param intensity intensity of the emotion
     * @param elicitor elicitor of the emotion
     * @param id elicitor id - if it is an agent
     */
    public AEmotion(EmotionType type, double intensity, String elicitor, int id){
        this.type = type;
        this.intensity = intensity;
        this.elicitor = elicitor;
        this.elicitorId = id;
    }



}
