package cz.cuni.amis.pogamut.ut2004.server.commands;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Map;

import javax.swing.JOptionPane;

import cz.cuni.amis.pogamut.base.server.commands.dialog.DialogListenerAdapter;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogButton;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogOption;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogOptionList;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogPanel;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogText;
import cz.cuni.amis.utils.Dimension2D_Double;

public class TestCase01_PlayerCommunicationTest extends ServerTest {

	PlayerCommunication pc;

	public static void main(String[] args) {
		ServerTest test = new TestCase01_PlayerCommunicationTest();
		test.doTest();
	}

	
	public TestCase01_PlayerCommunicationTest() {
		pc = new PlayerCommunication(server, logger);
	}

	@Override
	public void doTest() {
		Dialog dialog = new Dialog();
		dialog.addListener(new TestListener());
		DialogPanel main = new DialogPanel();
		main.setBgColor(new Color(128, 128, 255));
		main.setPosition(new Point2D.Double(0.25, 0.25));
		main.setSize(new Dimension2D_Double(0.5, 0.5));
		dialog.setMainPanel(main);
		DialogText text = new DialogText();
		text.setText("This is a dialog");
		text.setTextSize(DialogText.TextSize.BIG);
		text.setPosition(new Point2D.Double(0.1, 0.1));
		text.setSize(new Dimension2D_Double(0.8, 0.2));
		main.addComponent(text);
		DialogOption opt1 = new DialogOption("a");
		opt1.setText("Option a");
		DialogOption opt2 = new DialogOption("b");
		opt2.setText("Option b");
		DialogOption opt3 = new DialogOption("c");
		opt3.setText("Option c");
		DialogOptionList olist = new DialogOptionList("x");
		olist.addOption(opt1);
		olist.addOption(opt2);
		olist.addOption(opt3);
		olist.setMode(DialogOptionList.Mode.SINGLE);
		olist.setPosition(new Point2D.Double(0.1, 0.3));
		olist.setSize(new Dimension2D_Double(0.8, 0.4));
		main.addComponent(olist);
		DialogButton submit = new DialogButton();
		submit.setText("Submit");
		submit.setBgColor(new Color(0, 255, 0));
		submit.setBorder(new Color(255, 255, 255));
		submit.setPosition(new Point2D.Double(0.15, 0.8));
		submit.setSize(new Dimension2D_Double(0.3, 0.1));
		submit.setAction("SUBMIT");
		main.addComponent(submit);
		DialogButton command = new DialogButton();
		command.setText("Another menu");
		command.setBgColor(new Color(255, 255, 0));
		command.setBorder(new Color(255, 255, 255));
		command.setPosition(new Point2D.Double(0.5, 0.8));
		command.setSize(new Dimension2D_Double(0.4, 0.1));
		command.setAction("PRIKAZ");
		main.addComponent(command);
		dialog.setTargetPlayer("Flavius");
		pc.showDialog(dialog);
	}
	
	private class TestListener extends DialogListenerAdapter {
		@Override
		public void dialogSubmitted(IDialog dialog, Map<String, String> data) {
			JOptionPane.showMessageDialog(null, "Sent:" + data.toString());
		}
		
		@Override
		public void dialogCommand(IDialog d, String command, Map<String, String> data) {
			Dialog dialog = new Dialog();
			DialogPanel main = new DialogPanel();
			main.setBgColor(new Color(255, 255, 0));
			main.setPosition(new Point2D.Double(0.4, 0.4));
			main.setSize(new Dimension2D_Double(0.2, 0.2));
			dialog.setMainPanel(main);
			DialogButton cancel = new DialogButton();
			cancel.setText("Cancel");
			cancel.setBgColor(new Color(255, 0, 0));
			cancel.setBorder(new Color(255, 255, 255));
			cancel.setPosition(new Point2D.Double(0.2, 0.2));
			cancel.setSize(new Dimension2D_Double(0.6, 0.6));
			cancel.setAction("CANCEL");
			main.addComponent(cancel);
			dialog.setTargetPlayer("Flavius");
			pc.showDialog(dialog);
		}
	}
}
