package cz.cuni.amis.pogamut.ut2004.server.commands;

import java.util.logging.Level;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.testbase.ServerTestBase;

public abstract class ServerTest extends ServerTestBase {

	protected Logger logger;
	protected UT2004Server server = null;
	
	public ServerTest() {
		logger = Logger.getAnonymousLogger();
		UT2004ServerModule module = new UT2004ServerModule();
		IAgentFactory<ISocketConnectionAddress> factory = new GuiceAgentFactory<ISocketConnectionAddress>(
				module);

		try {
			server = (UT2004Server) factory
					.newAgent(new SocketConnectionAddress("localhost", 3001));
		} catch (PogamutException e) {
			logger.severe("Can't create server.");
		}

		server.getLogger().addConsoleHandlersToAllCategories();
        server.getLogger().setLevel(Level.ALL);
		
		try {
			server.start();
		} catch (PogamutException e) {
			logger.severe("Can't start the server.");
		}
	}
	
	public abstract void doTest();
}
