package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasAlign;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasText;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Class describing simple text written on the dialog
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogText extends DialogLayerContainer implements IHasText, IHasAlign {

	protected String text;
	protected Color textColor;
	protected String align;
	protected TextSize textSize = TextSize.DEFAULT;

	public TextSize getTextSize() {
		return textSize;
	}

	public void setTextSize(TextSize textSize) {
		this.textSize = textSize;
	}

	public DialogText() {
		super();
	}
	
	public DialogText(String id) {
		super(id);
	}
	
	@Override
	public void addLayer(DialogLayer layer) {
		throw new UnsupportedOperationException("Text has fixed layer.");
	}

	@Override
	public void removeLayer(DialogLayer layer) {
		throw new UnsupportedOperationException("Text has fixed layer.");
	}
	
	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("TEXT");
		myItem.setText(text);
		myItem.setTextColor(textColor);
		myItem.setTextAlign(align);
		switch (textSize) {
		case SMALL:
			myItem.setTextSize("SMALL");
			break;
		case MEDIUM:
			myItem.setTextSize("MEDIUM");
			break;
		case BIG:
			myItem.setTextSize("BIG");
			break;
		//case DEFAULT: don't set it
		}
		return myItem;
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		return list;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public Color getTextColor() {
		return textColor;
	}

	public void setTextColor(Color textColor) {
		this.textColor = textColor;
	}

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

}
