package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

public class DialogPathLayer extends DialogLayer {
	protected Color color;
	protected double width;
	protected List<Point2D> points = new ArrayList<Point2D>();
	
	@Override
	public DialogItem createItemCommand() {
		DialogItem myItem = super.createItemCommand();
		myItem.setType("PATHLAYER");
		myItem.setPathWidth(width);
		myItem.setPathColor(color);
		myItem.setPathPoints(getPoints());
		return myItem;
	}
	
	public void addPoint(Point2D point) {
		points.add(point);
	}
	
	public void clearPoints() {
		points.clear();
	}
	
	public String getPoints() {
		StringBuilder sb = new StringBuilder();
		for (Point2D point: points) {
			sb.append(point.getX());
			sb.append(',');
			sb.append(point.getY());
			sb.append(',');
		}
		sb.deleteCharAt(sb.length() - 1);
		return sb.toString();
	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public double getWidth() {
		return width;
	}

	public void setWidth(double width) {
		this.width = width;
	}
}
