package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogComponent;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogPanel;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Framed component that can nest more other components. This is used also as
 * the ground component for dialog, so some panel should be always in the dialog
 * (see setMainPanel method in Dialog class). This creates DialogItem type=PANEL
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogPanel extends DialogFramedComponent implements IDialogPanel {

	protected List<DialogComponent> components = new LinkedList<DialogComponent>();
	protected List<DialogComponent> dead = new LinkedList<DialogComponent>();

	public DialogPanel() {
		super();
	}

	public DialogPanel(String id) {
		super(id);
	}

	/**
	 * Adds a new component to this panel
	 * 
	 * @param component
	 */
	@Override
	public void addComponent(IDialogComponent component) {
		components.add((DialogComponent)component);
		component.setParent(this);
	}

	/**
	 * Removes a component from this panel. The component IS DESTROYED after
	 * it's removal - don't use it again, create another one.
	 * 
	 * @param component
	 */
	@Override
	public void removeComponent(IDialogComponent component) {
		if (components.remove((DialogComponent)component)) {
			((DialogComponent)component).setState(DialogComponent.State.DEAD);
			dead.add((DialogComponent)component);
		}
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new ArrayList<DialogItem>();
		list.add(myItemCommand());
		for (DialogComponent component : components) {
			List<DialogItem> items = component.createItemCommands();
			list.addAll(items);
		}
		for (DialogComponent component : dead) {
			List<DialogItem> items = component.createItemCommands();
			list.addAll(items);
		}
		dead.clear();
		return list;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("PANEL");
		return myItem;
	}

	@Override
	public DialogComponent findComponent(String id) {
		DialogComponent dc = super.findComponent(id);
		if (dc != null) {
			return dc;
		}
		for (DialogComponent c : components) {
			dc = c.findComponent(id);
			if (dc != null) {
				return dc;
			}
		}
		return null;
	}

	@Override
	public void setState(State state) {
		super.setState(state);
		if (state == State.DEAD) {
			for (DialogComponent component : components) {
				component.setState(state);
			}
		}
	}

}
